# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pkiviewer',
 'pkiviewer.model',
 'pkiviewer.model.extension',
 'pkiviewer.model.public_key',
 'pkiviewer.oid',
 'pkiviewer.utils',
 'pkiviewer.view',
 'pkiviewer.view.display',
 'pkiviewer.view.display.extension',
 'pkiviewer.view.display.public_key']

package_data = \
{'': ['*']}

modules = \
['py']
install_requires = \
['click>=8.1.3,<9.0.0',
 'cryptography>=37.0.4,<38.0.0',
 'rich>=12.5.1,<13.0.0',
 'tomli>=2.0.1,<3.0.0']

entry_points = \
{'console_scripts': ['pkiviewer = pkiviewer.__main__:run']}

setup_kwargs = {
    'name': 'pkiviewer',
    'version': '0.1.1',
    'description': 'PKI file viewer',
    'long_description': '# PKI Viewer\n\nDisplays information in the terminal from the following PKI file types\n\n- Certificates\n- PKCS#12 files\n- Certificate Signing Request (Coming Soon™)\n- Certificate Revocation List (Coming Soon™)\n\nAlso Coming Soon™ is Certificate Transparency information.\n\n## Features\n\n1. Files can be in either PEM or DER formats\n\n1. If a URL is passed a certificate will be downloaded automatically\n\n1. The certificate information can be output to the terminal, an SVG file or an HTML file.\n\n1. The information that is displayed can be configured (either hidden, displayed dim or highlighted)\n\n1. The colors can be configured\n\n1. Uses [rich](https://rich.readthedocs.io/en/latest/) for the\n   fancy output/SVG & HTML generation and\n   [cryptography](https://cryptography.io/en/latest/) for the low level parsing.\n\n1. It stcks fairly closely to the output from the `openssl` binary\n\nDER format certificates should have the extension \'.cer\' and PKCS#12 \'.p12\'\n\n## PKCS#12 Files\n\nIf the PKCS#12 file is encrypted you will be prompted to enter the passsword\n\n## Usage\n\nOutput certificate information to the terminal\n\n```\npkiviewer testcert.pem   OR   pkiviewer https://bbc.com\n```\n\nFor example\n\n```\npkiviewer https://bbc.com\n```\n\nproduces the following output\n\n```\nCertificate: https://bbc.com\n    Data:\n        Version: 1 (0x0)\n        Serial Number:\n            3e:55:35:3c:c9:9b:cb:59:6e:be:fc:64\n        Signature Algorithm: RSA with SHA256\n        Issuer: C = BE, O = GlobalSign nv-sa, CN = GlobalSign RSA OV SSL CA 2018\n        Validity:\n            Not Before: Mar 04 13:51:12 2022 UTC\n            Not After:  Apr 05 13:51:11 2023 UTC\n        Subject:\n            C = GB, ST = London, L = London, O = BRITISH BROADCASTING CORPORATION, CN = www.bbc.com\n        Subject Public Key Info:\n            Public Key Algorithm: RSA\n                RSA Public-Key (2048 bit)\n                Modulus:\n                    c1:91:f9:55:15:2b:77:96:e3:a5:62:2b:1c:4b:2e:8f:e3:c9:f9:76:bd:91:d4:96:\n                    28:7e:2e:b4:a9:6a:62:71:50:74:8e:d9:ef:5d:8d:ab:fc:d9:b8:1a:f8:30:01:82:\n                    30:45:15:32:e0:f8:64:53:5d:c2:92:0b:44:29:81:5b:b0:83:bf:df:c5:b4:56:e3:\n                    7b:af:54:cf:4c:1f:6c:46:ca:b7:21:ae:bc:f5:48:93:ff:ef:f0:37:7c:16:b3:92:\n                    c1:be:36:54:78:e0:06:86:64:c1:74:4d:39:c7:79:2d:1f:e4:99:bd:fc:1b:5e:29:\n                    bc:c4:ce:8c:aa:76:81:e0:c6:30:08:ea:21:e1:b9:81:1e:08:ea:7d:31:f3:3f:b3:\n                    77:98:71:53:00:45:a6:97:a3:54:f5:25:87:eb:81:97:86:45:ef:47:3d:3e:a4:14:\n                    2c:06:9d:18:a2:4e:26:5c:bd:b8:c5:a6:53:5d:65:7b:e9:02:52:77:26:10:b5:44:\n                    e1:e0:79:a2:ef:29:d3:1b:37:46:27:67:ef:bb:5e:78:58:05:94:5b:3d:82:d8:4d:\n                    d8:28:32:b9:e8:e2:5e:65:58:f8:fc:b0:79:f8:fc:23:4f:6a:33:ff:b8:60:96:9a:\n                    bc:9b:8c:46:24:8d:fc:5d:13:19:32:ac:ff:a4:f8:91\n                Exponent 65537 (0x10001)\n                Fingerprint (SHA256):\n                    66:dd:b2:a9:e1:f4:52:2f:3b:06:e3:de:6a:76:b3:f0:18:b8:3a:e5:54:7e:71:15:\n                    83:68:5c:d7:6a:3d:17:84\n        X509v3 Extensions:\n            Authority Key Identifier:\n                keyIdentifier:\n                    f8:ef:7f:f2:cd:78:67:a8:de:6f:8f:24:8d:88:f1:87:03:02:b3:eb\n            Subject Key Identifier:\n                7c:48:b3:b1:0d:48:93:a2:d2:f0:ac:f4:f6:13:ef:75:94:cf:80:97\n            Key Usage: critical\n                Digital Signature, Key Encipherment\n            Certificate Policies:\n                Policy:\n                    GlobalSign Certificate Policy\n                    https://www.globalsign.com/en/repository\n                Policy:\n                    CA/Browser Forum organization-validated\n            Subject Alternative Name:\n                DNS:www.bbc.com, DNS:www.bbc.co.uk, DNS:bbc.co.uk, DNS:bbcrussian.com,\n                DNS:*.bbc.com, DNS:*.bbcrussian.com, DNS:bbc.com\n            Basic Constraints:\n                cA:FALSE\n            Extended Key Usage:\n                TLS Web Server Authentication, TLS Web Client Authentication\n            CRL Distribution Points:\n                Full Name:\n                    URI:http://crl.globalsign.com/gsrsaovsslca2018.crl\n            Authority Information Access:\n                CA Issuers - URI:http://secure.globalsign.com/cacert/gsrsaovsslca2018.crt\n                OCSP - URI:http://ocsp.globalsign.com/gsrsaovsslca2018\n            CT Precertificate SCTs:\n                Signed Certificate Timestamp:\n                    Version: 1 (0x0)\n                    Log ID:\n                        e8:3e:d0:da:3e:f5:06:35:32:e7:57:28:bc:89:6b:c9:\n                        03:d3:cb:d1:11:6b:ec:eb:69:e1:77:7d:6d:06:bd:6e\n                    Timestamp: Mar 04 13:51:14 2022 UTC\n                Signed Certificate Timestamp:\n                    Version: 1 (0x0)\n                    Log ID:\n                        6f:53:76:ac:31:f0:31:19:d8:99:00:a4:51:15:ff:77:\n                        15:1c:11:d9:02:c1:00:29:06:8d:b2:08:9a:37:d9:13\n                    Timestamp: Mar 04 13:51:13 2022 UTC\n                Signed Certificate Timestamp:\n                    Version: 1 (0x0)\n                    Log ID:\n                        55:81:d4:c2:16:90:36:01:4a:ea:0b:9b:57:3c:53:f0:\n                        c0:e4:38:78:70:25:08:17:2f:a3:aa:1d:07:13:d3:0c\n                    Timestamp: Mar 04 13:51:13 2022 UTC\n    Signature: RSA with SHA256\n        14:40:09:bd:42:2d:bc:29:4d:da:58:55:87:05:dc:8b:1e:1c:e9:1a:77:c4:cb:b2:\n        35:fd:b1:3b:ee:5c:97:ef:c9:b0:bb:c4:3a:9c:88:81:ff:e9:02:9e:91:9e:0e:85:\n        5d:32:4e:d5:7f:1c:cd:7b:bc:0b:7b:00:c6:07:3e:b2:c0:0a:eb:9d:f1:a5:28:cf:\n        eb:9f:12:d0:da:75:6e:f3:da:74:36:e5:6c:8a:75:41:13:4b:2b:ed:83:24:d1:d1:\n        e6:6d:85:60:86:22:b2:c7:ff:61:0d:0d:91:1c:b9:ff:18:00:ed:16:09:5d:74:dd:\n        cb:bd:85:ca:5a:46:38:f6:86:07:74:21:24:dd:be:5b:6f:43:e8:64:79:70:65:c7:\n        79:0f:44:b2:08:6f:a6:1e:73:4e:9a:e2:6f:0a:5c:ae:99:bf:f9:b3:ef:b2:f4:e6:\n        bb:1d:52:92:fd:03:14:00:24:47:0c:00:bb:3b:33:f4:2f:d9:1c:00:fc:e2:57:8d:\n        a4:bf:2f:bf:5d:94:c2:ab:48:3e:24:00:39:1f:68:29:f2:e1:ba:24:9f:96:9c:24:\n        d1:82:5d:49:70:9a:5f:56:1a:2d:14:c2:6b:02:ab:9f:f1:6b:87:c2:e9:2e:46:c1:\n        7a:08:95:94:7c:b4:3a:07:c1:c7:fe:0b:df:c3:48:68\n```\n\nOutput the certificate to an SVG file\n\n```\npkiviewer --save-svg=cert.svg testcert.pem\n```\n\nOutput the certificate to an HTML file\n\n```bash\n$ pkiviewer --save-html=cert.html testcert.pem\n```\n\nFor SVG and HTML output the number of columns to output can be set with the `--width` option\n\n## Display Configuration\n\n`pkiviewer` looks for a `pkiviewer.toml` in the current directory. See\n`pkiviewer.toml.sample` for all the options.\n\nThis file can configure what information is output and the colors.\n\n### Colors\n\nThe default colors are\n\n```toml\n[theme]\ndefault = "white"\nerror = "red"\nwarning = "yellow"\ninfo = "green"\nkey = "blue"\nvalue = "white"\nextension_critical = "yellow"\n```\n\n### Information Visibility\n\nThe following items control what is output.\n\n```toml\n[visibility]\n".Header" = "normal"                                           # Header text depending on the file type\n".Header.Filename" = "normal"                                  # The filename\n".Data" = "normal"                                             # The Data block visibility\n".Data.Version" = "normal"                                     # Certiificate version\n".Data.SerialNumber" = "normal"                                # Certificate serial number\n".Data.Issuer" = "normal"                                      # The name of the org that issued the certificate\n".Data.Fingerprint" = "normal"                                 # Fingerprint of the certificate\n".Data.Validity" = "normal"                                    # The Validity block\n".Data.Validity.Before" = "normal"                             # Date and time from which the certificate is valid\n".Data.Validity.After" = "normal"                              # Date and time after which the certificate is invalid\n".Data.Subject" = "normal"                                     # Visibility of the certificate subject block\n".Data.Subject.Name" = "normal"                                # The subject\'s name\n".Data.Subject.PublicKey" = "normal"                           # The public key\n".Data.Subject.PublicKey.Algorithm" = "normal"                 # The public key algorithm\n\n".Data.Extensions" = "normal"                                  # Visibility for all extensions\n".Data.Extension.Critical" = "normal"                          # Whether the extension is critical\n".Data.Extension.Value" = "normal"                             # Visibility of the value for all extensions\n\n# Individual extension information\n".Data.Extension.AuthorityKeyIdentifier" = "normal"\n".Data.Extension.AuthorityKeyIdentifier.Value" = "normal"\n".Data.Extension.SubjectKeyIdentifier" = "normal"\n".Data.Extension.SubjectKeyIdentifier.Value" = "normal"\n".Data.Extension.KeyUsage" = "normal"\n".Data.Extension.KeyUsage.Value" = "normal"\n".Data.Extension.CertificatePolicies" = "normal"\n".Data.Extension.CertificatePolicies.Value" = "normal"\n".Data.Extension.SubjectAlternativeName" = "normal"\n".Data.Extension.SubjectAlternativeName.Value" = "normal"\n".Data.Extension.IssuerAlternativeName" = "normal"\n".Data.Extension.IssuerAlternativeName.Value" = "normal"\n".Data.Extension.BasicConstraints" = "normal"\n".Data.Extension.BasicConstraints.Value" = "normal"\n".Data.Extension.NameConstraints" = "normal"\n".Data.Extension.NameConstraints.Value" = "normal"\n".Data.Extension.ExtendedKeyUsage" = "normal"\n".Data.Extension.ExtendedKeyUsage.Value" = "normal"\n".Data.Extension.CRLDistributionPoints" = "normal"\n".Data.Extension.CRLDistributionPoints.Value" = "normal"\n".Data.Extension.InhibitAnyPolicy" = "normal"\n".Data.Extension.InhibitAnyPolicy.Value" = "normal"\n".Data.Extension.AuthorityInformationAccess" = "normal"\n".Data.Extension.AuthorityInformationAccess.Value" = "normal"\n".Data.Extension.SubjectInformationAccess" = "normal"\n".Data.Extension.SubjectInformationAccess.Value" = "normal"\n".Data.Extension.CertificateSCTs" = "normal"\n".Data.Extension.CertificateSCTs.Value" = "normal"\n".Data.Extension.PreCertificateSCTs" = "normal"\n".Data.Extension.PreCertificateSCTs.Value" = "normal"\n\n# Signature Information\n".Signature" = "normal"                                        # The signature block (alogrithm + value)\n".Signature.Algorithm" = "normal"                              # The signature algorithm\n".Signature.Value" = "normal"                                  # The signature value\n```\n',
    'author': 'Simon Kennedy',
    'author_email': 'sffjunkie+code@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
