# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthKeyArgs', 'FusionAuthKey']

@pulumi.input_type
class FusionAuthKeyArgs:
    def __init__(__self__, *,
                 algorithm: pulumi.Input[str],
                 key_id: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthKey resource.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[int] length: The length of the RSA or EC certificate. This field is required when generating RSA key types.
        :param pulumi.Input[str] name: The name of the Key.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Input[str]:
        """
        The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: pulumi.Input[str]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new key. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the RSA or EC certificate. This field is required when generating RSA key types.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FusionAuthKeyState:
    def __init__(__self__, *,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 kid: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthKey resources.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] kid: The id used in the JWT header to identify the key used to generate the signature
        :param pulumi.Input[int] length: The length of the RSA or EC certificate. This field is required when generating RSA key types.
        :param pulumi.Input[str] name: The name of the Key.
        """
        if algorithm is not None:
            pulumi.set(__self__, "algorithm", algorithm)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if kid is not None:
            pulumi.set(__self__, "kid", kid)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        """
        return pulumi.get(self, "algorithm")

    @algorithm.setter
    def algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new key. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def kid(self) -> Optional[pulumi.Input[str]]:
        """
        The id used in the JWT header to identify the key used to generate the signature
        """
        return pulumi.get(self, "kid")

    @kid.setter
    def kid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kid", value)

    @property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[int]]:
        """
        The length of the RSA or EC certificate. This field is required when generating RSA key types.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "length", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Key.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


class FusionAuthKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Key Resource

        Cryptographic keys are used in signing and verifying JWTs and verifying responses for third party identity providers. It is more likely you will interact with keys using the FusionAuth UI in the Key Master menu.

        [Keys API](https://fusionauth.io/docs/v1/tech/apis/keys)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        admin_id = fusionauth.FusionAuthKey("adminId",
            algorithm="RS256",
            length=2048)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[int] length: The length of the RSA or EC certificate. This field is required when generating RSA key types.
        :param pulumi.Input[str] name: The name of the Key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Key Resource

        Cryptographic keys are used in signing and verifying JWTs and verifying responses for third party identity providers. It is more likely you will interact with keys using the FusionAuth UI in the Key Master menu.

        [Keys API](https://fusionauth.io/docs/v1/tech/apis/keys)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        admin_id = fusionauth.FusionAuthKey("adminId",
            algorithm="RS256",
            length=2048)
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 length: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthKeyArgs.__new__(FusionAuthKeyArgs)

            if algorithm is None and not opts.urn:
                raise TypeError("Missing required property 'algorithm'")
            __props__.__dict__["algorithm"] = algorithm
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["length"] = length
            __props__.__dict__["name"] = name
            __props__.__dict__["kid"] = None
        super(FusionAuthKey, __self__).__init__(
            'fusionauth:index/fusionAuthKey:FusionAuthKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm: Optional[pulumi.Input[str]] = None,
            key_id: Optional[pulumi.Input[str]] = None,
            kid: Optional[pulumi.Input[str]] = None,
            length: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None) -> 'FusionAuthKey':
        """
        Get an existing FusionAuthKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm: The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        :param pulumi.Input[str] key_id: The Id to use for the new key. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] kid: The id used in the JWT header to identify the key used to generate the signature
        :param pulumi.Input[int] length: The length of the RSA or EC certificate. This field is required when generating RSA key types.
        :param pulumi.Input[str] name: The name of the Key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthKeyState.__new__(_FusionAuthKeyState)

        __props__.__dict__["algorithm"] = algorithm
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["kid"] = kid
        __props__.__dict__["length"] = length
        __props__.__dict__["name"] = name
        return FusionAuthKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def algorithm(self) -> pulumi.Output[str]:
        """
        The algorithm used to encrypt the Key. The following values represent algorithms supported by FusionAuth:
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[str]:
        """
        The Id to use for the new key. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def kid(self) -> pulumi.Output[str]:
        """
        The id used in the JWT header to identify the key used to generate the signature
        """
        return pulumi.get(self, "kid")

    @property
    @pulumi.getter
    def length(self) -> pulumi.Output[Optional[int]]:
        """
        The length of the RSA or EC certificate. This field is required when generating RSA key types.
        """
        return pulumi.get(self, "length")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Key.
        """
        return pulumi.get(self, "name")

