# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pygharar']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.25.1,<3.0.0']

setup_kwargs = {
    'name': 'pygharar',
    'version': '0.0.1',
    'description': 'Gharar client in python',
    'long_description': '# Gharar Python Client\n\nThis is a python adaptor for interact with \n[Gharar](https://http://gharar.ir) service.\n\n# Installation\n\nYou can easily install the package via command line below:\n\n```commandline\npip install pygharar\n```\n\n# Usage\n\n```jupyterpython\nIn[1]:\nfrom pygharar import Gharar\n\nIn[2]: my_gharar = Gharar(\n    service_url="https://gharar.ir/",\n    authorization_token="PUT YOUR OWN TOKEN HERE", \n    max_retry=3\n)\n\nIn[3]: my_gharar.create_room(name="yazdan", is_private=True)\nOut[3]:\n{\'name\': \'yazdan\',\n \'address\': \'6bedda4b-80ce-4f17-bec9-204709964161\',\n \'is_private\': True,\n \'has_live\': False,\n \'live_address\': None,\n \'is_beta_enabled\': False,\n \'live_stream_url\': None,\n \'is_active\': True,\n \'record_enabled\': False,\n \'transcription_enabled\': False,\n \'auto_record\': False,\n \'incoming_call_enabled\': False,\n \'call_pin\': \'74761137\'}\n\nIn[4]: my_gharar.create_room(name="sobhan", is_private=False)\nOut[4]:\n{\'name\': \'sobhan\',\n \'address\': \'8f297726-fa6c-4246-a1de-8a96b3cf589d\',\n \'is_private\': False,\n \'has_live\': False,\n \'live_address\': None,\n \'is_beta_enabled\': False,\n \'live_stream_url\': None,\n \'is_active\': True,\n \'record_enabled\': False,\n \'transcription_enabled\': False,\n \'auto_record\': False,\n \'incoming_call_enabled\': False,\n \'call_pin\': \'56177610\'}\n\nIn[5]: my_gharar.get_rooms_list()\nOut[5]:\n[{\'name\': \'yazdan\',\n  \'address\': \'6bedda4b-80ce-4f17-bec9-204709964161\',\n  \'is_private\': True,\n  \'has_live\': False,\n  \'live_address\': None,\n  \'is_beta_enabled\': False,\n  \'live_stream_url\': None,\n  \'is_active\': True,\n  \'record_enabled\': False,\n  \'transcription_enabled\': False,\n  \'auto_record\': False,\n  \'incoming_call_enabled\': False,\n  \'call_pin\': \'74761137\'},\n {\'name\': \'sobhan\',\n  \'address\': \'8f297726-fa6c-4246-a1de-8a96b3cf589d\',\n  \'is_private\': False,\n  \'has_live\': False,\n  \'live_address\': None,\n  \'is_beta_enabled\': False,\n  \'live_stream_url\': None,\n  \'is_active\': True,\n  \'record_enabled\': False,\n  \'transcription_enabled\': False,\n  \'auto_record\': False,\n  \'incoming_call_enabled\': False,\n  \'call_pin\': \'56177610\'}]\n\nIn[6]: my_gharar.update_room(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    name="yazdan-edited", \n    is_private=False, \n    is_active=False\n)\nOut[6]:\n{\'name\': \'yazdan-edited\',\n \'address\': \'6bedda4b-80ce-4f17-bec9-204709964161\',\n \'is_private\': False,\n \'has_live\': False,\n \'live_address\': None,\n \'is_beta_enabled\': False,\n \'live_stream_url\': None,\n \'is_active\': False,\n \'record_enabled\': False,\n \'transcription_enabled\': False,\n \'auto_record\': False,\n \'incoming_call_enabled\': False,\n \'call_pin\': \'74761137\'}\n\nIn[7]: my_gharar.update_room(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    name="yazdan", \n    is_private=True, \n    is_active=True,\n    record_enabled=True\n)\nOut[7]:\n{\'name\': \'yazdan\',\n \'address\': \'6bedda4b-80ce-4f17-bec9-204709964161\',\n \'is_private\': True,\n \'has_live\': False,\n \'live_address\': None,\n \'is_beta_enabled\': False,\n \'live_stream_url\': None,\n \'is_active\': True,\n \'record_enabled\': True,\n \'transcription_enabled\': False,\n \'auto_record\': False,\n \'incoming_call_enabled\': False,\n \'call_pin\': \'74761137\'}\n\nIn[8]: my_gharar.get_room(room_address="8f297726-fa6c-4246-a1de-8a96b3cf589d")\nOut[8]:\n{\'name\': \'sobhan\',\n \'address\': \'8f297726-fa6c-4246-a1de-8a96b3cf589d\',\n \'is_private\': False,\n \'has_live\': False,\n \'live_address\': None,\n \'is_beta_enabled\': False,\n \'live_stream_url\': None,\n \'is_active\': True,\n \'record_enabled\': False,\n \'transcription_enabled\': False,\n \'auto_record\': False,\n \'incoming_call_enabled\': False,\n \'call_pin\': \'56177610\'}\n\nIn[9]: my_gharar.delete_room(room_address="8f297726-fa6c-4246-a1de-8a96b3cf589d")\nOut[9]: True\n\nIn[10]: my_gharar.get_rooms_list()\nOut[10]:\n[{\'name\': \'yazdan\',\n  \'address\': \'6bedda4b-80ce-4f17-bec9-204709964161\',\n  \'is_private\': True,\n  \'has_live\': False,\n  \'live_address\': None,\n  \'is_beta_enabled\': False,\n  \'live_stream_url\': None,\n  \'is_active\': True,\n  \'record_enabled\': True,\n  \'transcription_enabled\': False,\n  \'auto_record\': False,\n  \'incoming_call_enabled\': False,\n  \'call_pin\': \'74761137\'}]\n\nIn[11]: my_gharar.get_room_users(room_address="6bedda4b-80ce-4f17-bec9-204709964161")\nOut[11]: []\n\nIn[12]: my_gharar.add_user_to_room(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    phone_number="09355070766", \n    is_admin=True\n)\nOut[12]: {\'phone\': \'09355070766\', \'is_admin\': True}\n\nIn[13]: my_gharar.add_user_to_room(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    phone_number="09373985131", \n    is_admin=False\n)\nOut[13]: {\'phone\': \'09373985131\', \'is_admin\': False}\n\nIn[14]: my_gharar.get_room_users(room_address="6bedda4b-80ce-4f17-bec9-204709964161")\nOut[14]:\n[{\'phone\': \'09355070766\', \'name\': \'\', \'is_admin\': True},\n {\'phone\': \'09373985131\', \'name\': \'\', \'is_admin\': False}]\n\nIn[15]: my_gharar.get_room_user_details(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    phone_number="09355070766"\n)\nOut[15]: {\'phone\': \'09355070766\', \'name\': \'\', \'is_admin\': True}\n\nIn[16]: my_gharar.update_room_user(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    phone_number="09373985131", \n    is_admin=True\n)\nOut[16]: {\'phone\': \'09373985131\', \'is_admin\': True}\n\nIn[17]: my_gharar.delete_user_from_room(\n    room_address="6bedda4b-80ce-4f17-bec9-204709964161",\n    phone_number="09355070766"\n)\nOut[17]: True\n```\n',
    'author': 'Yazdan Ranjbar',
    'author_email': 'Yazdan_ra@icloud.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
