"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTeam = exports.toJson_Member = exports.toJson_CfnTeamProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnTeamProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnTeamProps(obj) {
    var _b;
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Description': obj.description,
        'Members': (_b = obj.members) === null || _b === void 0 ? void 0 : _b.map(y => toJson_Member(y)),
        'OpsgenieApiKey': obj.opsgenieApiKey,
        'OpsgenieApiEndpoint': obj.opsgenieApiEndpoint,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnTeamProps = toJson_CfnTeamProps;
/**
 * Converts an object of type 'Member' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Member(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'UserId': obj.userId,
        'Role': obj.role,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Member = toJson_Member;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Atlassian::Opsgenie::Team`
 *
 * @cloudformationResource Atlassian::Opsgenie::Team
 * @stability external
 * @link https://github.com/opsgenie/opsgenie-cloudformation-resources
 */
class CfnTeam extends cdk.CfnResource {
    /**
     * Create a new `Atlassian::Opsgenie::Team`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTeam.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnTeamProps(props) });
        this.props = props;
        this.attrTeamId = cdk.Token.asString(this.getAtt('TeamId'));
    }
}
exports.CfnTeam = CfnTeam;
_a = JSII_RTTI_SYMBOL_1;
CfnTeam[_a] = { fqn: "@cdk-cloudformation/atlassian-opsgenie-team.CfnTeam", version: "1.0.1-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnTeam.CFN_RESOURCE_TYPE_NAME = "Atlassian::Opsgenie::Team";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwwQkFBMEI7QUFDMUIsbUNBQW1DO0FBOENuQzs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixtQkFBbUIsQ0FBQyxHQUE2Qjs7SUFDL0QsSUFBSSxHQUFHLEtBQUssU0FBUyxFQUFFO1FBQUUsT0FBTyxTQUFTLENBQUM7S0FBRTtJQUM1QyxNQUFNLE1BQU0sR0FBRztRQUNiLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtRQUNoQixhQUFhLEVBQUUsR0FBRyxDQUFDLFdBQVc7UUFDOUIsU0FBUyxRQUFFLEdBQUcsQ0FBQyxPQUFPLDBDQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNsRCxnQkFBZ0IsRUFBRSxHQUFHLENBQUMsY0FBYztRQUNwQyxxQkFBcUIsRUFBRSxHQUFHLENBQUMsbUJBQW1CO0tBQy9DLENBQUM7SUFDRiwwQkFBMEI7SUFDMUIsT0FBTyxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7QUFDMUcsQ0FBQztBQVhELGtEQVdDO0FBbUJEOztHQUVHO0FBQ0gseUNBQXlDO0FBQ3pDLFNBQWdCLGFBQWEsQ0FBQyxHQUF1QjtJQUNuRCxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsUUFBUSxFQUFFLEdBQUcsQ0FBQyxNQUFNO1FBQ3BCLE1BQU0sRUFBRSxHQUFHLENBQUMsSUFBSTtLQUNqQixDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFSRCxzQ0FRQztBQUNELHdDQUF3QztBQUd4Qzs7Ozs7O0dBTUc7QUFDSCxNQUFhLE9BQVEsU0FBUSxHQUFHLENBQUMsV0FBVztJQWlCMUM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUEyQixFQUFFLEVBQVUsRUFBRSxLQUFtQjtRQUN0RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxPQUFPLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLG1CQUFtQixDQUFDLEtBQUssQ0FBRSxFQUFFLENBQUMsQ0FBQztRQUVwRyxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUVuQixJQUFJLENBQUMsVUFBVSxHQUFHLEdBQUcsQ0FBQyxLQUFLLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUM5RCxDQUFDOztBQTlCSCwwQkErQkM7OztBQTlCQzs7RUFFRTtBQUNxQiw4QkFBc0IsR0FBRywyQkFBMkIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIEdlbmVyYXRlZCBieSBjZGstaW1wb3J0XG5pbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0ICogYXMgY29uc3RydWN0cyBmcm9tICdjb25zdHJ1Y3RzJztcblxuLyoqXG4gKiBPcHNnZW5pZSBUZWFtIHJlc291cmNlIHNjaGVtYVxuICpcbiAqIEBzY2hlbWEgQ2ZuVGVhbVByb3BzXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2ZuVGVhbVByb3BzIHtcbiAgLyoqXG4gICAqIFRlYW0gbmFtZVxuICAgKlxuICAgKiBAc2NoZW1hIENmblRlYW1Qcm9wcyNOYW1lXG4gICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRlYW0gZGVzY3JpcHRpb25cbiAgICpcbiAgICogQHNjaGVtYSBDZm5UZWFtUHJvcHMjRGVzY3JpcHRpb25cbiAgICovXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBBcnJheSBvZiBtZW1iZXJzXG4gICAqXG4gICAqIEBzY2hlbWEgQ2ZuVGVhbVByb3BzI01lbWJlcnNcbiAgICovXG4gIHJlYWRvbmx5IG1lbWJlcnM/OiBNZW1iZXJbXTtcblxuICAvKipcbiAgICogQXBpIEtleVxuICAgKlxuICAgKiBAc2NoZW1hIENmblRlYW1Qcm9wcyNPcHNnZW5pZUFwaUtleVxuICAgKi9cbiAgcmVhZG9ubHkgb3BzZ2VuaWVBcGlLZXk/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEFwaSBlbmRwb2ludFxuICAgKlxuICAgKiBAc2NoZW1hIENmblRlYW1Qcm9wcyNPcHNnZW5pZUFwaUVuZHBvaW50XG4gICAqL1xuICByZWFkb25seSBvcHNnZW5pZUFwaUVuZHBvaW50Pzogc3RyaW5nO1xuXG59XG5cbi8qKlxuICogQ29udmVydHMgYW4gb2JqZWN0IG9mIHR5cGUgJ0NmblRlYW1Qcm9wcycgdG8gSlNPTiByZXByZXNlbnRhdGlvbi5cbiAqL1xuLyogZXNsaW50LWRpc2FibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cbmV4cG9ydCBmdW5jdGlvbiB0b0pzb25fQ2ZuVGVhbVByb3BzKG9iajogQ2ZuVGVhbVByb3BzIHwgdW5kZWZpbmVkKTogUmVjb3JkPHN0cmluZywgYW55PiB8IHVuZGVmaW5lZCB7XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCkgeyByZXR1cm4gdW5kZWZpbmVkOyB9XG4gIGNvbnN0IHJlc3VsdCA9IHtcbiAgICAnTmFtZSc6IG9iai5uYW1lLFxuICAgICdEZXNjcmlwdGlvbic6IG9iai5kZXNjcmlwdGlvbixcbiAgICAnTWVtYmVycyc6IG9iai5tZW1iZXJzPy5tYXAoeSA9PiB0b0pzb25fTWVtYmVyKHkpKSxcbiAgICAnT3BzZ2VuaWVBcGlLZXknOiBvYmoub3BzZ2VuaWVBcGlLZXksXG4gICAgJ09wc2dlbmllQXBpRW5kcG9pbnQnOiBvYmoub3BzZ2VuaWVBcGlFbmRwb2ludCxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuLyoqXG4gKiBAc2NoZW1hIE1lbWJlclxuICovXG5leHBvcnQgaW50ZXJmYWNlIE1lbWJlciB7XG4gIC8qKlxuICAgKiBAc2NoZW1hIE1lbWJlciNVc2VySWRcbiAgICovXG4gIHJlYWRvbmx5IHVzZXJJZD86IHN0cmluZztcblxuICAvKipcbiAgICogQHNjaGVtYSBNZW1iZXIjUm9sZVxuICAgKi9cbiAgcmVhZG9ubHkgcm9sZT86IHN0cmluZztcblxufVxuXG4vKipcbiAqIENvbnZlcnRzIGFuIG9iamVjdCBvZiB0eXBlICdNZW1iZXInIHRvIEpTT04gcmVwcmVzZW50YXRpb24uXG4gKi9cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4sIHF1b3RlLXByb3BzICovXG5leHBvcnQgZnVuY3Rpb24gdG9Kc29uX01lbWJlcihvYmo6IE1lbWJlciB8IHVuZGVmaW5lZCk6IFJlY29yZDxzdHJpbmcsIGFueT4gfCB1bmRlZmluZWQge1xuICBpZiAob2JqID09PSB1bmRlZmluZWQpIHsgcmV0dXJuIHVuZGVmaW5lZDsgfVxuICBjb25zdCByZXN1bHQgPSB7XG4gICAgJ1VzZXJJZCc6IG9iai51c2VySWQsXG4gICAgJ1JvbGUnOiBvYmoucm9sZSxcbiAgfTtcbiAgLy8gZmlsdGVyIHVuZGVmaW5lZCB2YWx1ZXNcbiAgcmV0dXJuIE9iamVjdC5lbnRyaWVzKHJlc3VsdCkucmVkdWNlKChyLCBpKSA9PiAoaVsxXSA9PT0gdW5kZWZpbmVkKSA/IHIgOiAoeyAuLi5yLCBbaVswXV06IGlbMV0gfSksIHt9KTtcbn1cbi8qIGVzbGludC1lbmFibGUgbWF4LWxlbiwgcXVvdGUtcHJvcHMgKi9cblxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEF0bGFzc2lhbjo6T3BzZ2VuaWU6OlRlYW1gXG4gKlxuICogQGNsb3VkZm9ybWF0aW9uUmVzb3VyY2UgQXRsYXNzaWFuOjpPcHNnZW5pZTo6VGVhbVxuICogQHN0YWJpbGl0eSBleHRlcm5hbFxuICogQGxpbmsgaHR0cHM6Ly9naXRodWIuY29tL29wc2dlbmllL29wc2dlbmllLWNsb3VkZm9ybWF0aW9uLXJlc291cmNlc1xuICovXG5leHBvcnQgY2xhc3MgQ2ZuVGVhbSBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSB7XG4gIC8qKlxuICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSA9IFwiQXRsYXNzaWFuOjpPcHNnZW5pZTo6VGVhbVwiO1xuXG4gIC8qKlxuICAgKiBSZXNvdXJjZSBwcm9wcy5cbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBwcm9wczogQ2ZuVGVhbVByb3BzO1xuXG4gIC8qKlxuICAgKiBBdHRyaWJ1dGUgYEF0bGFzc2lhbjo6T3BzZ2VuaWU6OlRlYW0uVGVhbUlkYFxuICAgKiBAbGluayBodHRwczovL2dpdGh1Yi5jb20vb3BzZ2VuaWUvb3BzZ2VuaWUtY2xvdWRmb3JtYXRpb24tcmVzb3VyY2VzXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0clRlYW1JZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDcmVhdGUgYSBuZXcgYEF0bGFzc2lhbjo6T3BzZ2VuaWU6OlRlYW1gLlxuICAgKlxuICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogY29uc3RydWN0cy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5UZWFtUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuVGVhbS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiB0b0pzb25fQ2ZuVGVhbVByb3BzKHByb3BzKSEgfSk7XG5cbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG5cbiAgICB0aGlzLmF0dHJUZWFtSWQgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ1RlYW1JZCcpKTtcbiAgfVxufSJdfQ==