/**
 * Credentials for the Datadog API.
 *
 * @stability stable
 */
export interface DatadogCredentials {
    /**
     * Datadog API key.
     *
     * @stability stable
     */
    readonly apiKey: string;
    /**
     * Datadog application key.
     *
     * @stability stable
     */
    readonly applicationKey: string;
    /**
     * Datadog API URL (defaults to https://api.datadoghq.com) Use https://api.datadoghq.eu for EU accounts.
     *
     * @stability stable
     */
    readonly apiURL?: string;
}
/**
 * The type of the monitor.
 *
 * @stability stable
 */
export declare enum MonitorType {
    /**
     * @stability stable
     */
    COMPOSITE = "composite",
    /**
     * @stability stable
     */
    EVENT_ALERT = "event alert",
    /**
     * @stability stable
     */
    LOG_ALERT = "log alert",
    /**
     * @stability stable
     */
    METRIC_ALERT = "metric alert",
    /**
     * @stability stable
     */
    PROCESS_ALERT = "process alert",
    /**
     * @stability stable
     */
    QUERY_ALERT = "query alert",
    /**
     * @stability stable
     */
    SERVICE_CHECK = "service check",
    /**
     * @stability stable
     */
    SYNTHETICS_ALERT = "synthetics alert",
    /**
     * @stability stable
     */
    TRACE_ANALYTICS_ALERT = "trace-analytics alert"
}
/**
 * @stability stable
 */
export interface MonitorOptions {
    /**
     * Whether or not to include a sample of the logs.
     *
     * @stability stable
     */
    readonly enableLogsSample?: boolean;
    /**
     * Message to include with a re-notification when renotify_interval is set.
     *
     * @stability stable
     */
    readonly escalationMessage?: string;
    /**
     * Time in seconds to delay evaluation.
     *
     * @stability stable
     */
    readonly evaluationDelay?: number;
    /**
     * Whether or not to include triggering tags into notification title.
     *
     * @stability stable
     */
    readonly includeTags?: boolean;
    /**
     * Whether or not changes to this monitor should be restricted to the creator or admins.
     *
     * @stability stable
     */
    readonly locked?: boolean;
    /**
     * Number of locations allowed to fail before triggering alert.
     *
     * @stability stable
     */
    readonly minLocationFailed?: number;
    /**
     * Time in seconds to allow a host to start reporting data before starting the evaluation of monitor results.
     *
     * @stability stable
     */
    readonly newHostDelay?: number;
    /**
     * Number of minutes data stopped reporting before notifying.
     *
     * @stability stable
     */
    readonly noDataTimeframe?: number;
    /**
     * Whether or not to notify tagged users when changes are made to the monitor.
     *
     * @stability stable
     */
    readonly notifyAudit?: boolean;
    /**
     * Whether or not to notify when data stops reporting.
     *
     * @stability stable
     */
    readonly notifyNoData?: boolean;
    /**
     * Number of minutes after the last notification before the monitor re-notifies on the current status.
     *
     * @stability stable
     */
    readonly renotifyInterval?: number;
    /**
     * Whether or not the monitor requires a full window of data before it is evaluated.
     *
     * @stability stable
     */
    readonly requireFullWindow?: boolean;
    /**
     * ID of the corresponding synthetics check.
     *
     * @stability stable
     */
    readonly syntheticsCheckID?: number;
    /**
     * The threshold definitions.
     *
     * @stability stable
     */
    readonly thresholds?: MonitorThresholds;
    /**
     * The threshold window definitions.
     *
     * @stability stable
     */
    readonly thresholdWindows?: MonitorThresholdWindows;
    /**
     * Number of hours of the monitor not reporting data before it automatically resolves.
     *
     * @stability stable
     */
    readonly timeoutH?: number;
}
/**
 * @stability stable
 */
export interface MonitorThresholds {
    /**
     * Threshold value for triggering an alert.
     *
     * @stability stable
     */
    readonly critical?: number;
    /**
     * Threshold value for recovering from an alert state.
     *
     * @stability stable
     */
    readonly criticalRecovery?: number;
    /**
     * Threshold value for recovering from an alert state.
     *
     * @stability stable
     */
    readonly oK?: number;
    /**
     * Threshold value for triggering a warning.
     *
     * @stability stable
     */
    readonly warning?: number;
    /**
     * Threshold value for recovering from a warning state.
     *
     * @stability stable
     */
    readonly warningRecovery?: number;
}
/**
 * @stability stable
 */
export interface MonitorThresholdWindows {
    /**
     * How long a metric must be anomalous before triggering an alert.
     *
     * @stability stable
     */
    readonly triggerWindow?: string;
    /**
     * How long an anomalous metric must be normal before recovering from an alert state.
     *
     * @stability stable
     */
    readonly recoveryWindow?: string;
}
