"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirewallRuleGroup = exports.DnsBlockResponse = exports.FirewallRuleAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const firewall_rule_group_association_1 = require("./firewall-rule-group-association");
const route53resolver_generated_1 = require("./route53resolver.generated");
/**
 * A Firewall Rule
 */
class FirewallRuleAction {
    /**
     * Permit the request to go through
     */
    static allow() {
        return { action: 'ALLOW' };
    }
    /**
     * Permit the request to go through but send an alert to the logs
     */
    static alert() {
        return { action: 'ALERT' };
    }
    /**
     * Disallow the request
     *
     * @param [response=DnsBlockResponse.noData()] The way that you want DNS Firewall to block the request
     */
    static block(response) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_DnsBlockResponse(response);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.block);
            }
            throw error;
        }
        return {
            action: 'BLOCK',
            blockResponse: response ?? DnsBlockResponse.noData(),
        };
    }
}
exports.FirewallRuleAction = FirewallRuleAction;
_a = JSII_RTTI_SYMBOL_1;
FirewallRuleAction[_a] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleAction", version: "1.196.0" };
/**
 * The way that you want DNS Firewall to block the request
 */
class DnsBlockResponse {
    /**
     * Respond indicating that the query was successful, but no
     * response is available for it.
     */
    static noData() {
        return { blockResponse: 'NODATA' };
    }
    /**
     * Respond indicating that the domain name that's in the query
     * doesn't exist.
     */
    static nxDomain() {
        return { blockResponse: 'NXDOMAIN' };
    }
    /**
     * Provides a custom override response to the query
     *
     * @param domain The custom DNS record to send back in response to the query
     * @param [ttl=0] The recommended amount of time for the DNS resolver or
     *   web browser to cache the provided override record
     */
    static override(domain, ttl) {
        return {
            blockResponse: 'OVERRIDE',
            blockOverrideDnsType: 'CNAME',
            blockOverrideDomain: domain,
            blockOverrideTtl: ttl ?? core_1.Duration.seconds(0),
        };
    }
}
exports.DnsBlockResponse = DnsBlockResponse;
_b = JSII_RTTI_SYMBOL_1;
DnsBlockResponse[_b] = { fqn: "@aws-cdk/aws-route53resolver.DnsBlockResponse", version: "1.196.0" };
/**
 * A Firewall Rule Group
 */
class FirewallRuleGroup extends core_1.Resource {
    constructor(scope, id, props = {}) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FirewallRuleGroup);
            }
            throw error;
        }
        this.rules = props.rules ?? [];
        const ruleGroup = new route53resolver_generated_1.CfnFirewallRuleGroup(this, 'Resource', {
            name: props.name,
            firewallRules: core_1.Lazy.any({ produce: () => this.rules.map(renderRule) }),
        });
        this.firewallRuleGroupId = ruleGroup.attrId;
        this.firewallRuleGroupArn = ruleGroup.attrArn;
        this.firewallRuleGroupCreationTime = ruleGroup.attrCreationTime;
        this.firewallRuleGroupCreatorRequestId = ruleGroup.attrCreatorRequestId;
        this.firewallRuleGroupModificationTime = ruleGroup.attrModificationTime;
        this.firewallRuleGroupOwnerId = ruleGroup.attrOwnerId;
        this.firewallRuleGroupRuleCount = ruleGroup.attrRuleCount;
        this.firewallRuleGroupShareStatus = ruleGroup.attrShareStatus;
        this.firewallRuleGroupStatus = ruleGroup.attrStatus;
        this.firewallRuleGroupStatusMessage = ruleGroup.attrStatusMessage;
    }
    /**
     * Import an existing Firewall Rule Group
     */
    static fromFirewallRuleGroupId(scope, id, firewallRuleGroupId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.firewallRuleGroupId = firewallRuleGroupId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Adds a rule to this group
     */
    addRule(rule) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRule(rule);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRule);
            }
            throw error;
        }
        this.rules.push(rule);
        return this;
    }
    /**
     * Associates this Firewall Rule Group with a VPC
     */
    associate(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_route53resolver_FirewallRuleGroupAssociationOptions(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.associate);
            }
            throw error;
        }
        return new firewall_rule_group_association_1.FirewallRuleGroupAssociation(this, id, {
            ...props,
            firewallRuleGroup: this,
        });
    }
}
exports.FirewallRuleGroup = FirewallRuleGroup;
_c = JSII_RTTI_SYMBOL_1;
FirewallRuleGroup[_c] = { fqn: "@aws-cdk/aws-route53resolver.FirewallRuleGroup", version: "1.196.0" };
function renderRule(rule) {
    return {
        action: rule.action.action,
        firewallDomainListId: rule.firewallDomainList.firewallDomainListId,
        priority: rule.priority,
        blockOverrideDnsType: rule.action.blockResponse?.blockOverrideDnsType,
        blockOverrideDomain: rule.action.blockResponse?.blockOverrideDomain,
        blockOverrideTtl: rule.action.blockResponse?.blockOverrideTtl?.toSeconds(),
        blockResponse: rule.action.blockResponse?.blockResponse,
    };
}
//# sourceMappingURL=data:application/json;base64,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