## SS58

The library allows encoding/deconding in SS58 format (2-byte checksum), used by Substrate.

**Code example**

    import binascii
    from bip_utils import SS58Decoder, SS58Encoder

    data_bytes = binascii.unhexlify(b"e92b4b43a62fa66293f315486d66a67076e860e2aad76acb8e54f9bb7c925cd9")

    # Encode
    enc = SS58Encoder.Encode(data_bytes, ss58_format=0)
    # Decode
    ss58_format, dec = SS58Decoder.Decode(enc)
