# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DesktopArgs', 'Desktop']

@pulumi.input_type
class DesktopArgs:
    def __init__(__self__, *,
                 flavor_id: pulumi.Input[str],
                 image_id: pulumi.Input[str],
                 image_type: pulumi.Input[str],
                 root_volume: pulumi.Input['DesktopRootVolumeArgs'],
                 user_email: pulumi.Input[str],
                 user_group: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]]] = None,
                 delete_user: Optional[pulumi.Input[bool]] = None,
                 email_notification: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Desktop resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of desktop.
        :param pulumi.Input[str] image_id: Specifies the image ID to create the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] image_type: Specifies the image type. The valid values are as follows:
               + **market**: The market image.
               + **gold**: The public image.
               + **private**: The private image.
        :param pulumi.Input['DesktopRootVolumeArgs'] root_volume: Specifies the configuration of system volume.
               The object structure is documented below.
        :param pulumi.Input[str] user_email: Specifies the user email.
               Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_group: Specifies the user group to which the desktop belongs.
               The valid values are as follows:
               + **sudo**: Linux administrator group.
               + **default**: Linux default user group.
               + **administrators**: Windows administrator group.
               + **users**: Windows standard user group.
        :param pulumi.Input[str] user_name: Specifies the user name to which the desktop belongs.
               The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the desktop belongs.
               Changing this will create a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the desktop is located.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]] data_volumes: Specifies the configuration of data volumes.
               The object structure is documented below.
        :param pulumi.Input[bool] delete_user: Specifies whether to delete user associated with this desktop after deleting it.
               The user can only be successfully deleted if the user has no other desktops.
        :param pulumi.Input[bool] email_notification: Specifies whether to send emails to user mailbox during important
               operations. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the desktop name.
               The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter or digit and cannot end with a hyphen.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]] nics: Specifies the NIC information corresponding to the desktop.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the Workspace desktop resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies the ID list of security groups.
               In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs of the desktop.
               Changing this will create a new resource.
        """
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_type", image_type)
        pulumi.set(__self__, "root_volume", root_volume)
        pulumi.set(__self__, "user_email", user_email)
        pulumi.set(__self__, "user_group", user_group)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if delete_user is not None:
            pulumi.set(__self__, "delete_user", delete_user)
        if email_notification is not None:
            pulumi.set(__self__, "email_notification", email_notification)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[str]:
        """
        Specifies the flavor ID of desktop.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[str]:
        """
        Specifies the image ID to create the desktop.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Input[str]:
        """
        Specifies the image type. The valid values are as follows:
        + **market**: The market image.
        + **gold**: The public image.
        + **private**: The private image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Input['DesktopRootVolumeArgs']:
        """
        Specifies the configuration of system volume.
        The object structure is documented below.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: pulumi.Input['DesktopRootVolumeArgs']):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Input[str]:
        """
        Specifies the user email.
        Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_email", value)

    @property
    @pulumi.getter(name="userGroup")
    def user_group(self) -> pulumi.Input[str]:
        """
        Specifies the user group to which the desktop belongs.
        The valid values are as follows:
        + **sudo**: Linux administrator group.
        + **default**: Linux default user group.
        + **administrators**: Windows administrator group.
        + **users**: Windows standard user group.
        """
        return pulumi.get(self, "user_group")

    @user_group.setter
    def user_group(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_group", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        Specifies the user name to which the desktop belongs.
        The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        The name must start with a letter. Changing this will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID to which the desktop belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone where the desktop is located.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]]]:
        """
        Specifies the configuration of data volumes.
        The object structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="deleteUser")
    def delete_user(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to delete user associated with this desktop after deleting it.
        The user can only be successfully deleted if the user has no other desktops.
        """
        return pulumi.get(self, "delete_user")

    @delete_user.setter
    def delete_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_user", value)

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send emails to user mailbox during important
        operations. Changing this will create a new resource.
        """
        return pulumi.get(self, "email_notification")

    @email_notification.setter
    def email_notification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_notification", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the desktop name.
        The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter or digit and cannot end with a hyphen.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]]]:
        """
        Specifies the NIC information corresponding to the desktop.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the Workspace desktop resource.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the ID list of security groups.
        In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs of the desktop.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DesktopState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]]] = None,
                 delete_user: Optional[pulumi.Input[bool]] = None,
                 email_notification: Optional[pulumi.Input[bool]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input['DesktopRootVolumeArgs']] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_group: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Desktop resources.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the desktop is located.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]] data_volumes: Specifies the configuration of data volumes.
               The object structure is documented below.
        :param pulumi.Input[bool] delete_user: Specifies whether to delete user associated with this desktop after deleting it.
               The user can only be successfully deleted if the user has no other desktops.
        :param pulumi.Input[bool] email_notification: Specifies whether to send emails to user mailbox during important
               operations. Changing this will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of desktop.
        :param pulumi.Input[str] image_id: Specifies the image ID to create the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] image_type: Specifies the image type. The valid values are as follows:
               + **market**: The market image.
               + **gold**: The public image.
               + **private**: The private image.
        :param pulumi.Input[str] name: Specifies the desktop name.
               The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter or digit and cannot end with a hyphen.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]] nics: Specifies the NIC information corresponding to the desktop.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the Workspace desktop resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input['DesktopRootVolumeArgs'] root_volume: Specifies the configuration of system volume.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies the ID list of security groups.
               In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs of the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_email: Specifies the user email.
               Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_group: Specifies the user group to which the desktop belongs.
               The valid values are as follows:
               + **sudo**: Linux administrator group.
               + **default**: Linux default user group.
               + **administrators**: Windows administrator group.
               + **users**: Windows standard user group.
        :param pulumi.Input[str] user_name: Specifies the user name to which the desktop belongs.
               The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the desktop belongs.
               Changing this will create a new resource.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if data_volumes is not None:
            pulumi.set(__self__, "data_volumes", data_volumes)
        if delete_user is not None:
            pulumi.set(__self__, "delete_user", delete_user)
        if email_notification is not None:
            pulumi.set(__self__, "email_notification", email_notification)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nics is not None:
            pulumi.set(__self__, "nics", nics)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volume is not None:
            pulumi.set(__self__, "root_volume", root_volume)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)
        if user_group is not None:
            pulumi.set(__self__, "user_group", user_group)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone where the desktop is located.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]]]:
        """
        Specifies the configuration of data volumes.
        The object structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @data_volumes.setter
    def data_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopDataVolumeArgs']]]]):
        pulumi.set(self, "data_volumes", value)

    @property
    @pulumi.getter(name="deleteUser")
    def delete_user(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to delete user associated with this desktop after deleting it.
        The user can only be successfully deleted if the user has no other desktops.
        """
        return pulumi.get(self, "delete_user")

    @delete_user.setter
    def delete_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_user", value)

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to send emails to user mailbox during important
        operations. Changing this will create a new resource.
        """
        return pulumi.get(self, "email_notification")

    @email_notification.setter
    def email_notification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "email_notification", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor ID of desktop.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image ID to create the desktop.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_id", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image type. The valid values are as follows:
        + **market**: The market image.
        + **gold**: The public image.
        + **private**: The private image.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the desktop name.
        The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter or digit and cannot end with a hyphen.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]]]:
        """
        Specifies the NIC information corresponding to the desktop.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "nics")

    @nics.setter
    def nics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DesktopNicArgs']]]]):
        pulumi.set(self, "nics", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the Workspace desktop resource.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> Optional[pulumi.Input['DesktopRootVolumeArgs']]:
        """
        Specifies the configuration of system volume.
        The object structure is documented below.
        """
        return pulumi.get(self, "root_volume")

    @root_volume.setter
    def root_volume(self, value: Optional[pulumi.Input['DesktopRootVolumeArgs']]):
        pulumi.set(self, "root_volume", value)

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the ID list of security groups.
        In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_groups", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs of the desktop.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user email.
        Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)

    @property
    @pulumi.getter(name="userGroup")
    def user_group(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user group to which the desktop belongs.
        The valid values are as follows:
        + **sudo**: Linux administrator group.
        + **default**: Linux default user group.
        + **administrators**: Windows administrator group.
        + **users**: Windows standard user group.
        """
        return pulumi.get(self, "user_group")

    @user_group.setter
    def user_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_group", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user name to which the desktop belongs.
        The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        The name must start with a letter. Changing this will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID to which the desktop belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Desktop(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopDataVolumeArgs']]]]] = None,
                 delete_user: Optional[pulumi.Input[bool]] = None,
                 email_notification: Optional[pulumi.Input[bool]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopNicArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['DesktopRootVolumeArgs']]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_group: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Workspace desktop resource within HuaweiCloud.

        ## Example Usage

        ## Import

        Desktops can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Workspace/desktop:Desktop test 339d2539-e945-4090-a08d-c16badc0c6bb
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response. The missing attributes include`nic` and `user_email`. It is generally recommended running `terraform plan` after importing a desktop. You can then decide if changes should be applied to the desktop, or the resource definition should be updated to align with the desktop. Also you can ignore changes as below. resource "huaweicloud_workspace_desktop" "test" {

         ...

         lifecycle {

         ignore_changes = [

         user_email, nic,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the desktop is located.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopDataVolumeArgs']]]] data_volumes: Specifies the configuration of data volumes.
               The object structure is documented below.
        :param pulumi.Input[bool] delete_user: Specifies whether to delete user associated with this desktop after deleting it.
               The user can only be successfully deleted if the user has no other desktops.
        :param pulumi.Input[bool] email_notification: Specifies whether to send emails to user mailbox during important
               operations. Changing this will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of desktop.
        :param pulumi.Input[str] image_id: Specifies the image ID to create the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] image_type: Specifies the image type. The valid values are as follows:
               + **market**: The market image.
               + **gold**: The public image.
               + **private**: The private image.
        :param pulumi.Input[str] name: Specifies the desktop name.
               The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter or digit and cannot end with a hyphen.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopNicArgs']]]] nics: Specifies the NIC information corresponding to the desktop.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the Workspace desktop resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[pulumi.InputType['DesktopRootVolumeArgs']] root_volume: Specifies the configuration of system volume.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies the ID list of security groups.
               In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs of the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_email: Specifies the user email.
               Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_group: Specifies the user group to which the desktop belongs.
               The valid values are as follows:
               + **sudo**: Linux administrator group.
               + **default**: Linux default user group.
               + **administrators**: Windows administrator group.
               + **users**: Windows standard user group.
        :param pulumi.Input[str] user_name: Specifies the user name to which the desktop belongs.
               The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the desktop belongs.
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DesktopArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Workspace desktop resource within HuaweiCloud.

        ## Example Usage

        ## Import

        Desktops can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Workspace/desktop:Desktop test 339d2539-e945-4090-a08d-c16badc0c6bb
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response. The missing attributes include`nic` and `user_email`. It is generally recommended running `terraform plan` after importing a desktop. You can then decide if changes should be applied to the desktop, or the resource definition should be updated to align with the desktop. Also you can ignore changes as below. resource "huaweicloud_workspace_desktop" "test" {

         ...

         lifecycle {

         ignore_changes = [

         user_email, nic,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param DesktopArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DesktopArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopDataVolumeArgs']]]]] = None,
                 delete_user: Optional[pulumi.Input[bool]] = None,
                 email_notification: Optional[pulumi.Input[bool]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 image_id: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopNicArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume: Optional[pulumi.Input[pulumi.InputType['DesktopRootVolumeArgs']]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 user_email: Optional[pulumi.Input[str]] = None,
                 user_group: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DesktopArgs.__new__(DesktopArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["data_volumes"] = data_volumes
            __props__.__dict__["delete_user"] = delete_user
            __props__.__dict__["email_notification"] = email_notification
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            if image_type is None and not opts.urn:
                raise TypeError("Missing required property 'image_type'")
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["name"] = name
            __props__.__dict__["nics"] = nics
            __props__.__dict__["region"] = region
            if root_volume is None and not opts.urn:
                raise TypeError("Missing required property 'root_volume'")
            __props__.__dict__["root_volume"] = root_volume
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["tags"] = tags
            if user_email is None and not opts.urn:
                raise TypeError("Missing required property 'user_email'")
            __props__.__dict__["user_email"] = user_email
            if user_group is None and not opts.urn:
                raise TypeError("Missing required property 'user_group'")
            __props__.__dict__["user_group"] = user_group
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(Desktop, __self__).__init__(
            'huaweicloud:Workspace/desktop:Desktop',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            data_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopDataVolumeArgs']]]]] = None,
            delete_user: Optional[pulumi.Input[bool]] = None,
            email_notification: Optional[pulumi.Input[bool]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            image_id: Optional[pulumi.Input[str]] = None,
            image_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopNicArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            root_volume: Optional[pulumi.Input[pulumi.InputType['DesktopRootVolumeArgs']]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            user_email: Optional[pulumi.Input[str]] = None,
            user_group: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Desktop':
        """
        Get an existing Desktop resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone where the desktop is located.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopDataVolumeArgs']]]] data_volumes: Specifies the configuration of data volumes.
               The object structure is documented below.
        :param pulumi.Input[bool] delete_user: Specifies whether to delete user associated with this desktop after deleting it.
               The user can only be successfully deleted if the user has no other desktops.
        :param pulumi.Input[bool] email_notification: Specifies whether to send emails to user mailbox during important
               operations. Changing this will create a new resource.
        :param pulumi.Input[str] flavor_id: Specifies the flavor ID of desktop.
        :param pulumi.Input[str] image_id: Specifies the image ID to create the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] image_type: Specifies the image type. The valid values are as follows:
               + **market**: The market image.
               + **gold**: The public image.
               + **private**: The private image.
        :param pulumi.Input[str] name: Specifies the desktop name.
               The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter or digit and cannot end with a hyphen.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DesktopNicArgs']]]] nics: Specifies the NIC information corresponding to the desktop.
               The object structure is documented below. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the Workspace desktop resource.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[pulumi.InputType['DesktopRootVolumeArgs']] root_volume: Specifies the configuration of system volume.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_groups: Specifies the ID list of security groups.
               In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: Specifies the key/value pairs of the desktop.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_email: Specifies the user email.
               Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_group: Specifies the user group to which the desktop belongs.
               The valid values are as follows:
               + **sudo**: Linux administrator group.
               + **default**: Linux default user group.
               + **administrators**: Windows administrator group.
               + **users**: Windows standard user group.
        :param pulumi.Input[str] user_name: Specifies the user name to which the desktop belongs.
               The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the desktop belongs.
               Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DesktopState.__new__(_DesktopState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["data_volumes"] = data_volumes
        __props__.__dict__["delete_user"] = delete_user
        __props__.__dict__["email_notification"] = email_notification
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["name"] = name
        __props__.__dict__["nics"] = nics
        __props__.__dict__["region"] = region
        __props__.__dict__["root_volume"] = root_volume
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_email"] = user_email
        __props__.__dict__["user_group"] = user_group
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        return Desktop(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone where the desktop is located.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> pulumi.Output[Sequence['outputs.DesktopDataVolume']]:
        """
        Specifies the configuration of data volumes.
        The object structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="deleteUser")
    def delete_user(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to delete user associated with this desktop after deleting it.
        The user can only be successfully deleted if the user has no other desktops.
        """
        return pulumi.get(self, "delete_user")

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to send emails to user mailbox during important
        operations. Changing this will create a new resource.
        """
        return pulumi.get(self, "email_notification")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        Specifies the flavor ID of desktop.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[str]:
        """
        Specifies the image ID to create the desktop.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[str]:
        """
        Specifies the image type. The valid values are as follows:
        + **market**: The market image.
        + **gold**: The public image.
        + **private**: The private image.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the desktop name.
        The name can contain `1` to `15` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter or digit and cannot end with a hyphen.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nics(self) -> pulumi.Output[Optional[Sequence['outputs.DesktopNic']]]:
        """
        Specifies the NIC information corresponding to the desktop.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "nics")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the Workspace desktop resource.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolume")
    def root_volume(self) -> pulumi.Output['outputs.DesktopRootVolume']:
        """
        Specifies the configuration of system volume.
        The object structure is documented below.
        """
        return pulumi.get(self, "root_volume")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the ID list of security groups.
        In addition to the custom security group, it must also contain a security group called **WorkspaceUserSecurityGroup**.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs of the desktop.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[str]:
        """
        Specifies the user email.
        Some operations on the desktop (such as creation, deletion) will notify the user by sending an email.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "user_email")

    @property
    @pulumi.getter(name="userGroup")
    def user_group(self) -> pulumi.Output[str]:
        """
        Specifies the user group to which the desktop belongs.
        The valid values are as follows:
        + **sudo**: Linux administrator group.
        + **default**: Linux default user group.
        + **administrators**: Windows administrator group.
        + **users**: Windows standard user group.
        """
        return pulumi.get(self, "user_group")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Specifies the user name to which the desktop belongs.
        The name can contain `1` to `20` characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        The name must start with a letter. Changing this will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID to which the desktop belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

