# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RuleWebTamperProtectionArgs', 'RuleWebTamperProtection']

@pulumi.input_type
class RuleWebTamperProtectionArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 path: pulumi.Input[str],
                 policy_id: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RuleWebTamperProtection resource.
        :param pulumi.Input[str] domain: Specifies the domain name. Changing this creates a new rule.
        :param pulumi.Input[str] path: Specifies the URL protected by the web tamper protection rule, excluding a
               domain name. Changing this creates a new rule.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF web tamper protection rules resource. If
               omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "policy_id", policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        Specifies the domain name. Changing this creates a new rule.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the URL protected by the web tamper protection rule, excluding a
        domain name. Changing this creates a new rule.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF web tamper protection rules resource. If
        omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RuleWebTamperProtectionState:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RuleWebTamperProtection resources.
        :param pulumi.Input[str] domain: Specifies the domain name. Changing this creates a new rule.
        :param pulumi.Input[str] path: Specifies the URL protected by the web tamper protection rule, excluding a
               domain name. Changing this creates a new rule.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF web tamper protection rules resource. If
               omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the domain name. Changing this creates a new rule.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the URL protected by the web tamper protection rule, excluding a
        domain name. Changing this creates a new rule.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF web tamper protection rules resource. If
        omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class RuleWebTamperProtection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a WAF web tamper protection rule resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The web tamper protection rule resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1")
        rule1 = huaweicloud.waf.RuleWebTamperProtection("rule1",
            policy_id=policy1.id,
            domain="www.your-domain.com",
            path="/payment")
        ```

        ## Import

        Web Tamper Protection Rules can be imported using the policy ID and rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/ruleWebTamperProtection:RuleWebTamperProtection rule_1 840c6dfdd5604c1781eea033eae2004f/c6dbc13bb7e74788ae53ecc9254b3ea8
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: Specifies the domain name. Changing this creates a new rule.
        :param pulumi.Input[str] path: Specifies the URL protected by the web tamper protection rule, excluding a
               domain name. Changing this creates a new rule.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF web tamper protection rules resource. If
               omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleWebTamperProtectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF web tamper protection rule resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The web tamper protection rule resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1")
        rule1 = huaweicloud.waf.RuleWebTamperProtection("rule1",
            policy_id=policy1.id,
            domain="www.your-domain.com",
            path="/payment")
        ```

        ## Import

        Web Tamper Protection Rules can be imported using the policy ID and rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/ruleWebTamperProtection:RuleWebTamperProtection rule_1 840c6dfdd5604c1781eea033eae2004f/c6dbc13bb7e74788ae53ecc9254b3ea8
        ```

        :param str resource_name: The name of the resource.
        :param RuleWebTamperProtectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleWebTamperProtectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleWebTamperProtectionArgs.__new__(RuleWebTamperProtectionArgs)

            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["region"] = region
        super(RuleWebTamperProtection, __self__).__init__(
            'huaweicloud:Waf/ruleWebTamperProtection:RuleWebTamperProtection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            domain: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'RuleWebTamperProtection':
        """
        Get an existing RuleWebTamperProtection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain: Specifies the domain name. Changing this creates a new rule.
        :param pulumi.Input[str] path: Specifies the URL protected by the web tamper protection rule, excluding a
               domain name. Changing this creates a new rule.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule.
        :param pulumi.Input[str] region: The region in which to create the WAF web tamper protection rules resource. If
               omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleWebTamperProtectionState.__new__(_RuleWebTamperProtectionState)

        __props__.__dict__["domain"] = domain
        __props__.__dict__["path"] = path
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["region"] = region
        return RuleWebTamperProtection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Specifies the domain name. Changing this creates a new rule.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Specifies the URL protected by the web tamper protection rule, excluding a
        domain name. Changing this creates a new rule.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF web tamper protection rules resource. If
        omitted, the provider-level region will be used. Changing this creates a new rule.
        """
        return pulumi.get(self, "region")

