# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RuleBlacklistArgs', 'RuleBlacklist']

@pulumi.input_type
class RuleBlacklistArgs:
    def __init__(__self__, *,
                 ip_address: pulumi.Input[str],
                 policy_id: pulumi.Input[str],
                 action: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RuleBlacklist resource.
        :param pulumi.Input[str] ip_address: Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule. Please make
               sure that the region which the policy belongs to be consistent with the `region`.
        :param pulumi.Input[int] action: Specifies the protective action. Defaults is `0`. The value can be:
               + `0`: block the request.
               + `1`: allow the request.
               + `2`: log the request only.
        :param pulumi.Input[str] region: The region in which to create the WAF blacklist and whitelist rule resource.
               If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "policy_id", policy_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Input[str]:
        """
        Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule. Please make
        sure that the region which the policy belongs to be consistent with the `region`.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the protective action. Defaults is `0`. The value can be:
        + `0`: block the request.
        + `1`: allow the request.
        + `2`: log the request only.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF blacklist and whitelist rule resource.
        If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RuleBlacklistState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RuleBlacklist resources.
        :param pulumi.Input[int] action: Specifies the protective action. Defaults is `0`. The value can be:
               + `0`: block the request.
               + `1`: allow the request.
               + `2`: log the request only.
        :param pulumi.Input[str] ip_address: Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule. Please make
               sure that the region which the policy belongs to be consistent with the `region`.
        :param pulumi.Input[str] region: The region in which to create the WAF blacklist and whitelist rule resource.
               If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the protective action. Defaults is `0`. The value can be:
        + `0`: block the request.
        + `1`: allow the request.
        + `2`: log the request only.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule. Please make
        sure that the region which the policy belongs to be consistent with the `region`.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF blacklist and whitelist rule resource.
        If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class RuleBlacklist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a WAF blacklist and whitelist rule resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The blacklist and whitelist rule resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1")
        rule1 = huaweicloud.waf.RuleBlacklist("rule1",
            policy_id=policy1.id,
            ip_address="192.168.0.0/24",
            action=0)
        ```

        ## Import

        Blacklist and Whiltelist Rules can be imported using the policy ID and rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/ruleBlacklist:RuleBlacklist rule_1 d78b439fd5e54ea08886e5f63ee7b3f5/ac01a092d50e4e6ba3cd622c1128ba2c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] action: Specifies the protective action. Defaults is `0`. The value can be:
               + `0`: block the request.
               + `1`: allow the request.
               + `2`: log the request only.
        :param pulumi.Input[str] ip_address: Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule. Please make
               sure that the region which the policy belongs to be consistent with the `region`.
        :param pulumi.Input[str] region: The region in which to create the WAF blacklist and whitelist rule resource.
               If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleBlacklistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF blacklist and whitelist rule resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The blacklist and whitelist rule resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1")
        rule1 = huaweicloud.waf.RuleBlacklist("rule1",
            policy_id=policy1.id,
            ip_address="192.168.0.0/24",
            action=0)
        ```

        ## Import

        Blacklist and Whiltelist Rules can be imported using the policy ID and rule ID separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/ruleBlacklist:RuleBlacklist rule_1 d78b439fd5e54ea08886e5f63ee7b3f5/ac01a092d50e4e6ba3cd622c1128ba2c
        ```

        :param str resource_name: The name of the resource.
        :param RuleBlacklistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleBlacklistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[int]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleBlacklistArgs.__new__(RuleBlacklistArgs)

            __props__.__dict__["action"] = action
            if ip_address is None and not opts.urn:
                raise TypeError("Missing required property 'ip_address'")
            __props__.__dict__["ip_address"] = ip_address
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["region"] = region
        super(RuleBlacklist, __self__).__init__(
            'huaweicloud:Waf/ruleBlacklist:RuleBlacklist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[int]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'RuleBlacklist':
        """
        Get an existing RuleBlacklist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] action: Specifies the protective action. Defaults is `0`. The value can be:
               + `0`: block the request.
               + `1`: allow the request.
               + `2`: log the request only.
        :param pulumi.Input[str] ip_address: Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        :param pulumi.Input[str] policy_id: Specifies the WAF policy ID. Changing this creates a new rule. Please make
               sure that the region which the policy belongs to be consistent with the `region`.
        :param pulumi.Input[str] region: The region in which to create the WAF blacklist and whitelist rule resource.
               If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleBlacklistState.__new__(_RuleBlacklistState)

        __props__.__dict__["action"] = action
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["region"] = region
        return RuleBlacklist(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the protective action. Defaults is `0`. The value can be:
        + `0`: block the request.
        + `1`: allow the request.
        + `2`: log the request only.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        Specifies the IP address or range. For example, 192.168.0.125 or 192.168.0.0/24.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        Specifies the WAF policy ID. Changing this creates a new rule. Please make
        sure that the region which the policy belongs to be consistent with the `region`.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF blacklist and whitelist rule resource.
        If omitted, the provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

