# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[int] level: Specifies the protection level. Defaults to `2`. Valid values are:
               + `1`: low
               + `2`: medium
               + `3`: high
        :param pulumi.Input[str] name: Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
               underscores(_), and hyphens(-) are allowed.
        :param pulumi.Input[str] protection_mode: Specifies the protective action after a rule is matched. Defaults to `log`.
               Valid values are:
               + `block`: WAF blocks and logs detected attacks.
               + `log`: WAF logs detected attacks only.
        :param pulumi.Input[str] region: The region in which to create the WAF policy resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the protection level. Defaults to `2`. Valid values are:
        + `1`: low
        + `2`: medium
        + `3`: high
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
        underscores(_), and hyphens(-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protective action after a rule is matched. Defaults to `log`.
        Valid values are:
        + `block`: WAF blocks and logs detected attacks.
        + `log`: WAF logs detected attacks only.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF policy resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 full_detection: Optional[pulumi.Input[bool]] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyOptionArgs']]]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[bool] full_detection: The detection mode in Precise Protection.
               + `true`: full detection, Full detection finishes all threat detections before blocking requests that meet Precise
               Protection specified conditions.
               + `false`: instant detection. Instant detection immediately ends threat detection after blocking a request that
               meets Precise Protection specified conditions.
        :param pulumi.Input[int] level: Specifies the protection level. Defaults to `2`. Valid values are:
               + `1`: low
               + `2`: medium
               + `3`: high
        :param pulumi.Input[str] name: Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
               underscores(_), and hyphens(-) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['PolicyOptionArgs']]] options: The protection switches. The options object structure is documented below.
        :param pulumi.Input[str] protection_mode: Specifies the protective action after a rule is matched. Defaults to `log`.
               Valid values are:
               + `block`: WAF blocks and logs detected attacks.
               + `log`: WAF logs detected attacks only.
        :param pulumi.Input[str] region: The region in which to create the WAF policy resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        if full_detection is not None:
            pulumi.set(__self__, "full_detection", full_detection)
        if level is not None:
            pulumi.set(__self__, "level", level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="fullDetection")
    def full_detection(self) -> Optional[pulumi.Input[bool]]:
        """
        The detection mode in Precise Protection.
        + `true`: full detection, Full detection finishes all threat detections before blocking requests that meet Precise
        Protection specified conditions.
        + `false`: instant detection. Instant detection immediately ends threat detection after blocking a request that
        meets Precise Protection specified conditions.
        """
        return pulumi.get(self, "full_detection")

    @full_detection.setter
    def full_detection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "full_detection", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the protection level. Defaults to `2`. Valid values are:
        + `1`: low
        + `2`: medium
        + `3`: high
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "level", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
        underscores(_), and hyphens(-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PolicyOptionArgs']]]]:
        """
        The protection switches. The options object structure is documented below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PolicyOptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protective action after a rule is matched. Defaults to `log`.
        Valid values are:
        + `block`: WAF blocks and logs detected attacks.
        + `log`: WAF logs detected attacks only.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF policy resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a WAF policy resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The policy resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1",
            level=2,
            protection_mode="log")
        ```

        ## Import

        Policies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/policy:Policy policy_2 25e1df831bea4022a6e22bebe678915a
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] level: Specifies the protection level. Defaults to `2`. Valid values are:
               + `1`: low
               + `2`: medium
               + `3`: high
        :param pulumi.Input[str] name: Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
               underscores(_), and hyphens(-) are allowed.
        :param pulumi.Input[str] protection_mode: Specifies the protective action after a rule is matched. Defaults to `log`.
               Valid values are:
               + `block`: WAF blocks and logs detected attacks.
               + `log`: WAF logs detected attacks only.
        :param pulumi.Input[str] region: The region in which to create the WAF policy resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF policy resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The policy resource can be used in Cloud Mode, Dedicated Mode and ELB Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        policy1 = huaweicloud.waf.Policy("policy1",
            level=2,
            protection_mode="log")
        ```

        ## Import

        Policies can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/policy:Policy policy_2 25e1df831bea4022a6e22bebe678915a
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 level: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["level"] = level
            __props__.__dict__["name"] = name
            __props__.__dict__["protection_mode"] = protection_mode
            __props__.__dict__["region"] = region
            __props__.__dict__["full_detection"] = None
            __props__.__dict__["options"] = None
        super(Policy, __self__).__init__(
            'huaweicloud:Waf/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            full_detection: Optional[pulumi.Input[bool]] = None,
            level: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PolicyOptionArgs']]]]] = None,
            protection_mode: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] full_detection: The detection mode in Precise Protection.
               + `true`: full detection, Full detection finishes all threat detections before blocking requests that meet Precise
               Protection specified conditions.
               + `false`: instant detection. Instant detection immediately ends threat detection after blocking a request that
               meets Precise Protection specified conditions.
        :param pulumi.Input[int] level: Specifies the protection level. Defaults to `2`. Valid values are:
               + `1`: low
               + `2`: medium
               + `3`: high
        :param pulumi.Input[str] name: Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
               underscores(_), and hyphens(-) are allowed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PolicyOptionArgs']]]] options: The protection switches. The options object structure is documented below.
        :param pulumi.Input[str] protection_mode: Specifies the protective action after a rule is matched. Defaults to `log`.
               Valid values are:
               + `block`: WAF blocks and logs detected attacks.
               + `log`: WAF logs detected attacks only.
        :param pulumi.Input[str] region: The region in which to create the WAF policy resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["full_detection"] = full_detection
        __props__.__dict__["level"] = level
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["protection_mode"] = protection_mode
        __props__.__dict__["region"] = region
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="fullDetection")
    def full_detection(self) -> pulumi.Output[bool]:
        """
        The detection mode in Precise Protection.
        + `true`: full detection, Full detection finishes all threat detections before blocking requests that meet Precise
        Protection specified conditions.
        + `false`: instant detection. Instant detection immediately ends threat detection after blocking a request that
        meets Precise Protection specified conditions.
        """
        return pulumi.get(self, "full_detection")

    @property
    @pulumi.getter
    def level(self) -> pulumi.Output[int]:
        """
        Specifies the protection level. Defaults to `2`. Valid values are:
        + `1`: low
        + `2`: medium
        + `3`: high
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the policy name. The maximum length is 256 characters. Only digits, letters,
        underscores(_), and hyphens(-) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Sequence['outputs.PolicyOption']]:
        """
        The protection switches. The options object structure is documented below.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Output[str]:
        """
        Specifies the protective action after a rule is matched. Defaults to `log`.
        Valid values are:
        + `block`: WAF blocks and logs detected attacks.
        + `log`: WAF logs detected attacks only.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF policy resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

