# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DedicatedDomainServer',
    'DomainServer',
    'PolicyOption',
    'GetDedicatedInstancesInstanceResult',
    'GetInstanceGroupsGroupResult',
    'GetInstanceGroupsGroupDedicatedInstanceResult',
    'GetInstanceGroupsGroupDomainNameResult',
    'GetPoliciesPolicyResult',
    'GetPoliciesPolicyOptionResult',
    'GetReferenceTablesTableResult',
]

@pulumi.output_type
class DedicatedDomainServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientProtocol":
            suggest = "client_protocol"
        elif key == "serverProtocol":
            suggest = "server_protocol"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DedicatedDomainServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DedicatedDomainServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DedicatedDomainServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 client_protocol: str,
                 port: int,
                 server_protocol: str,
                 type: str,
                 vpc_id: str):
        """
        :param str address: IP address or domain name of the web server that the client accesses. For
               example, 192.168.1.1 or www.example.com. Changing this creates a new service.
        :param str client_protocol: Protocol type of the client. The options include `HTTP` and `HTTPS`.
               Changing this creates a new service.
        :param int port: Port number used by the web server. The value ranges from 0 to 65535. Changing this
               creates a new service.
        :param str server_protocol: Protocol used by WAF to forward client requests to the server. The
               options include `HTTP` and `HTTPS`. Changing this creates a new service.
        :param str type: Server network type, IPv4 or IPv6. Valid values are: `ipv4` and `ipv6`. Changing
               this creates a new service.
        :param str vpc_id: The id of the vpc used by the server. Changing this creates a service.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "client_protocol", client_protocol)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_protocol", server_protocol)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        IP address or domain name of the web server that the client accesses. For
        example, 192.168.1.1 or www.example.com. Changing this creates a new service.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> str:
        """
        Protocol type of the client. The options include `HTTP` and `HTTPS`.
        Changing this creates a new service.
        """
        return pulumi.get(self, "client_protocol")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number used by the web server. The value ranges from 0 to 65535. Changing this
        creates a new service.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverProtocol")
    def server_protocol(self) -> str:
        """
        Protocol used by WAF to forward client requests to the server. The
        options include `HTTP` and `HTTPS`. Changing this creates a new service.
        """
        return pulumi.get(self, "server_protocol")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Server network type, IPv4 or IPv6. Valid values are: `ipv4` and `ipv6`. Changing
        this creates a new service.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The id of the vpc used by the server. Changing this creates a service.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class DomainServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientProtocol":
            suggest = "client_protocol"
        elif key == "serverProtocol":
            suggest = "server_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 client_protocol: str,
                 port: int,
                 server_protocol: str):
        """
        :param str address: IP address or domain name of the web server that the client accesses. For example,
               192.168.1.1 or www.a.com.
        :param str client_protocol: Protocol type of the client. The options include `HTTP` and `HTTPS`.
        :param int port: Port number used by the web server. The value ranges from 0 to 65535, for example, 8080.
        :param str server_protocol: Protocol used by WAF to forward client requests to the server. The options
               include `HTTP` and `HTTPS`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "client_protocol", client_protocol)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "server_protocol", server_protocol)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        IP address or domain name of the web server that the client accesses. For example,
        192.168.1.1 or www.a.com.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="clientProtocol")
    def client_protocol(self) -> str:
        """
        Protocol type of the client. The options include `HTTP` and `HTTPS`.
        """
        return pulumi.get(self, "client_protocol")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port number used by the web server. The value ranges from 0 to 65535, for example, 8080.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="serverProtocol")
    def server_protocol(self) -> str:
        """
        Protocol used by WAF to forward client requests to the server. The options
        include `HTTP` and `HTTPS`.
        """
        return pulumi.get(self, "server_protocol")


@pulumi.output_type
class PolicyOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicWebProtection":
            suggest = "basic_web_protection"
        elif key == "ccAttackProtection":
            suggest = "cc_attack_protection"
        elif key == "crawlerEngine":
            suggest = "crawler_engine"
        elif key == "crawlerOther":
            suggest = "crawler_other"
        elif key == "crawlerScanner":
            suggest = "crawler_scanner"
        elif key == "crawlerScript":
            suggest = "crawler_script"
        elif key == "dataMasking":
            suggest = "data_masking"
        elif key == "falseAlarmMasking":
            suggest = "false_alarm_masking"
        elif key == "generalCheck":
            suggest = "general_check"
        elif key == "preciseProtection":
            suggest = "precise_protection"
        elif key == "webTamperProtection":
            suggest = "web_tamper_protection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PolicyOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PolicyOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PolicyOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_web_protection: Optional[bool] = None,
                 blacklist: Optional[bool] = None,
                 cc_attack_protection: Optional[bool] = None,
                 crawler: Optional[bool] = None,
                 crawler_engine: Optional[bool] = None,
                 crawler_other: Optional[bool] = None,
                 crawler_scanner: Optional[bool] = None,
                 crawler_script: Optional[bool] = None,
                 data_masking: Optional[bool] = None,
                 false_alarm_masking: Optional[bool] = None,
                 general_check: Optional[bool] = None,
                 precise_protection: Optional[bool] = None,
                 web_tamper_protection: Optional[bool] = None,
                 webshell: Optional[bool] = None):
        """
        :param bool basic_web_protection: Indicates whether Basic Web Protection is enabled.
        :param bool blacklist: Indicates whether Blacklist and Whitelist is enabled.
        :param bool cc_attack_protection: Indicates whether CC Attack Protection is enabled.
        :param bool crawler: Indicates whether the master crawler detection switch in Basic Web Protection is enabled.
        :param bool crawler_engine: Indicates whether the Search Engine switch in Basic Web Protection is enabled.
        :param bool crawler_other: Indicates whether detection of other crawlers in Basic Web Protection is enabled.
        :param bool crawler_scanner: Indicates whether the Scanner switch in Basic Web Protection is enabled.
        :param bool crawler_script: Indicates whether the Script Tool switch in Basic Web Protection is enabled.
        :param bool data_masking: Indicates whether Data Masking is enabled.
        :param bool false_alarm_masking: Indicates whether False Alarm Masking is enabled.
        :param bool general_check: Indicates whether General Check in Basic Web Protection is enabled.
        :param bool precise_protection: Indicates whether Precise Protection is enabled.
        :param bool web_tamper_protection: Indicates whether Web Tamper Protection is enabled.
        :param bool webshell: Indicates whether webshell detection in Basic Web Protection is enabled.
        """
        if basic_web_protection is not None:
            pulumi.set(__self__, "basic_web_protection", basic_web_protection)
        if blacklist is not None:
            pulumi.set(__self__, "blacklist", blacklist)
        if cc_attack_protection is not None:
            pulumi.set(__self__, "cc_attack_protection", cc_attack_protection)
        if crawler is not None:
            pulumi.set(__self__, "crawler", crawler)
        if crawler_engine is not None:
            pulumi.set(__self__, "crawler_engine", crawler_engine)
        if crawler_other is not None:
            pulumi.set(__self__, "crawler_other", crawler_other)
        if crawler_scanner is not None:
            pulumi.set(__self__, "crawler_scanner", crawler_scanner)
        if crawler_script is not None:
            pulumi.set(__self__, "crawler_script", crawler_script)
        if data_masking is not None:
            pulumi.set(__self__, "data_masking", data_masking)
        if false_alarm_masking is not None:
            pulumi.set(__self__, "false_alarm_masking", false_alarm_masking)
        if general_check is not None:
            pulumi.set(__self__, "general_check", general_check)
        if precise_protection is not None:
            pulumi.set(__self__, "precise_protection", precise_protection)
        if web_tamper_protection is not None:
            pulumi.set(__self__, "web_tamper_protection", web_tamper_protection)
        if webshell is not None:
            pulumi.set(__self__, "webshell", webshell)

    @property
    @pulumi.getter(name="basicWebProtection")
    def basic_web_protection(self) -> Optional[bool]:
        """
        Indicates whether Basic Web Protection is enabled.
        """
        return pulumi.get(self, "basic_web_protection")

    @property
    @pulumi.getter
    def blacklist(self) -> Optional[bool]:
        """
        Indicates whether Blacklist and Whitelist is enabled.
        """
        return pulumi.get(self, "blacklist")

    @property
    @pulumi.getter(name="ccAttackProtection")
    def cc_attack_protection(self) -> Optional[bool]:
        """
        Indicates whether CC Attack Protection is enabled.
        """
        return pulumi.get(self, "cc_attack_protection")

    @property
    @pulumi.getter
    def crawler(self) -> Optional[bool]:
        """
        Indicates whether the master crawler detection switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler")

    @property
    @pulumi.getter(name="crawlerEngine")
    def crawler_engine(self) -> Optional[bool]:
        """
        Indicates whether the Search Engine switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_engine")

    @property
    @pulumi.getter(name="crawlerOther")
    def crawler_other(self) -> Optional[bool]:
        """
        Indicates whether detection of other crawlers in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_other")

    @property
    @pulumi.getter(name="crawlerScanner")
    def crawler_scanner(self) -> Optional[bool]:
        """
        Indicates whether the Scanner switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_scanner")

    @property
    @pulumi.getter(name="crawlerScript")
    def crawler_script(self) -> Optional[bool]:
        """
        Indicates whether the Script Tool switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_script")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> Optional[bool]:
        """
        Indicates whether Data Masking is enabled.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="falseAlarmMasking")
    def false_alarm_masking(self) -> Optional[bool]:
        """
        Indicates whether False Alarm Masking is enabled.
        """
        return pulumi.get(self, "false_alarm_masking")

    @property
    @pulumi.getter(name="generalCheck")
    def general_check(self) -> Optional[bool]:
        """
        Indicates whether General Check in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "general_check")

    @property
    @pulumi.getter(name="preciseProtection")
    def precise_protection(self) -> Optional[bool]:
        """
        Indicates whether Precise Protection is enabled.
        """
        return pulumi.get(self, "precise_protection")

    @property
    @pulumi.getter(name="webTamperProtection")
    def web_tamper_protection(self) -> Optional[bool]:
        """
        Indicates whether Web Tamper Protection is enabled.
        """
        return pulumi.get(self, "web_tamper_protection")

    @property
    @pulumi.getter
    def webshell(self) -> Optional[bool]:
        """
        Indicates whether webshell detection in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "webshell")


@pulumi.output_type
class GetDedicatedInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 access_status: int,
                 available_zone: str,
                 cpu_architecture: str,
                 cpu_flavor: str,
                 group_id: str,
                 id: str,
                 name: str,
                 run_status: int,
                 security_groups: Sequence[str],
                 server_id: str,
                 service_ip: str,
                 subnet_id: str,
                 upgradable: int,
                 vpc_id: str):
        """
        :param int access_status: The access status of the instance. `0`: inaccessible, `1`: accessible.
        :param str available_zone: The available zone names for the WAF dedicated instances.
        :param str cpu_architecture: The ECS cpu architecture of WAF dedicated instance.
        :param str group_id: The instance group ID used by the WAF dedicated instance in ELB mode.
        :param str id: The id of WAF dedicated instance.
        :param str name: The name of WAF dedicated instance.
        :param int run_status: The running status of the instance. Values are:
        :param Sequence[str] security_groups: The security group of the instance. This is an array of security group ids.
        :param str server_id: The service of the instance.
        :param str service_ip: The service ip of the instance.
        :param str subnet_id: The subnet id of WAF dedicated instance VPC.
        :param int upgradable: The instance is to support upgrades. `0`: Cannot be upgraded, `1`: Can be upgraded.
        :param str vpc_id: The VPC id of WAF dedicated instance.
        """
        pulumi.set(__self__, "access_status", access_status)
        pulumi.set(__self__, "available_zone", available_zone)
        pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        pulumi.set(__self__, "cpu_flavor", cpu_flavor)
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "run_status", run_status)
        pulumi.set(__self__, "security_groups", security_groups)
        pulumi.set(__self__, "server_id", server_id)
        pulumi.set(__self__, "service_ip", service_ip)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "upgradable", upgradable)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> int:
        """
        The access status of the instance. `0`: inaccessible, `1`: accessible.
        """
        return pulumi.get(self, "access_status")

    @property
    @pulumi.getter(name="availableZone")
    def available_zone(self) -> str:
        """
        The available zone names for the WAF dedicated instances.
        """
        return pulumi.get(self, "available_zone")

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> str:
        """
        The ECS cpu architecture of WAF dedicated instance.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter(name="cpuFlavor")
    def cpu_flavor(self) -> str:
        return pulumi.get(self, "cpu_flavor")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> str:
        """
        The instance group ID used by the WAF dedicated instance in ELB mode.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of WAF dedicated instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of WAF dedicated instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="runStatus")
    def run_status(self) -> int:
        """
        The running status of the instance. Values are:
        """
        return pulumi.get(self, "run_status")

    @property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Sequence[str]:
        """
        The security group of the instance. This is an array of security group ids.
        """
        return pulumi.get(self, "security_groups")

    @property
    @pulumi.getter(name="serverId")
    def server_id(self) -> str:
        """
        The service of the instance.
        """
        return pulumi.get(self, "server_id")

    @property
    @pulumi.getter(name="serviceIp")
    def service_ip(self) -> str:
        """
        The service ip of the instance.
        """
        return pulumi.get(self, "service_ip")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet id of WAF dedicated instance VPC.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def upgradable(self) -> int:
        """
        The instance is to support upgrades. `0`: Cannot be upgraded, `1`: Can be upgraded.
        """
        return pulumi.get(self, "upgradable")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The VPC id of WAF dedicated instance.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetInstanceGroupsGroupResult(dict):
    def __init__(__self__, *,
                 body_limit: int,
                 connection_timeout: int,
                 dedicated_instances: Sequence['outputs.GetInstanceGroupsGroupDedicatedInstanceResult'],
                 description: str,
                 domain_names: Sequence['outputs.GetInstanceGroupsGroupDomainNameResult'],
                 header_limit: int,
                 load_balancers: Sequence[str],
                 name: str,
                 read_timeout: int,
                 region: str,
                 vpc_id: str,
                 write_timeout: int):
        """
        :param int body_limit: The body limit of the forwarding policy.
        :param int connection_timeout: The time for connection timeout in the forwarding policy.
        :param str description: Description of the instance group.
        :param int header_limit: The header limit of the forwarding policy.
        :param Sequence[str] load_balancers: The IDs of the ELB instances that has been bound to the instance group.
        :param str name: The name of WAF instance group used for matching.
               The value is not case-sensitive and supports fuzzy matching.
        :param int read_timeout: The time for reading timeout in the forwarding policy.
        :param str region: The region in which to obtain the WAF instance groups.
               If omitted, the provider-level region will be used.
        :param str vpc_id: The id of the VPC that the WAF dedicated instances belongs to.
        :param int write_timeout: The time for writing timeout in the forwarding policy.
        """
        pulumi.set(__self__, "body_limit", body_limit)
        pulumi.set(__self__, "connection_timeout", connection_timeout)
        pulumi.set(__self__, "dedicated_instances", dedicated_instances)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "domain_names", domain_names)
        pulumi.set(__self__, "header_limit", header_limit)
        pulumi.set(__self__, "load_balancers", load_balancers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_timeout", read_timeout)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "write_timeout", write_timeout)

    @property
    @pulumi.getter(name="bodyLimit")
    def body_limit(self) -> int:
        """
        The body limit of the forwarding policy.
        """
        return pulumi.get(self, "body_limit")

    @property
    @pulumi.getter(name="connectionTimeout")
    def connection_timeout(self) -> int:
        """
        The time for connection timeout in the forwarding policy.
        """
        return pulumi.get(self, "connection_timeout")

    @property
    @pulumi.getter(name="dedicatedInstances")
    def dedicated_instances(self) -> Sequence['outputs.GetInstanceGroupsGroupDedicatedInstanceResult']:
        return pulumi.get(self, "dedicated_instances")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the instance group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Sequence['outputs.GetInstanceGroupsGroupDomainNameResult']:
        return pulumi.get(self, "domain_names")

    @property
    @pulumi.getter(name="headerLimit")
    def header_limit(self) -> int:
        """
        The header limit of the forwarding policy.
        """
        return pulumi.get(self, "header_limit")

    @property
    @pulumi.getter(name="loadBalancers")
    def load_balancers(self) -> Sequence[str]:
        """
        The IDs of the ELB instances that has been bound to the instance group.
        """
        return pulumi.get(self, "load_balancers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of WAF instance group used for matching.
        The value is not case-sensitive and supports fuzzy matching.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readTimeout")
    def read_timeout(self) -> int:
        """
        The time for reading timeout in the forwarding policy.
        """
        return pulumi.get(self, "read_timeout")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the WAF instance groups.
        If omitted, the provider-level region will be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The id of the VPC that the WAF dedicated instances belongs to.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="writeTimeout")
    def write_timeout(self) -> int:
        """
        The time for writing timeout in the forwarding policy.
        """
        return pulumi.get(self, "write_timeout")


@pulumi.output_type
class GetInstanceGroupsGroupDedicatedInstanceResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str name: The name of WAF instance group used for matching.
               The value is not case-sensitive and supports fuzzy matching.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of WAF instance group used for matching.
        The value is not case-sensitive and supports fuzzy matching.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetInstanceGroupsGroupDomainNameResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str name: The name of WAF instance group used for matching.
               The value is not case-sensitive and supports fuzzy matching.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of WAF instance group used for matching.
        The value is not case-sensitive and supports fuzzy matching.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPoliciesPolicyResult(dict):
    def __init__(__self__, *,
                 full_detection: bool,
                 id: str,
                 level: int,
                 name: str,
                 options: Sequence['outputs.GetPoliciesPolicyOptionResult'],
                 protection_mode: str):
        """
        :param bool full_detection: The detection mode in Precise Protection.
               + `true`: full detection. Full detection finishes all threat detections before blocking requests that meet Precise
               Protection specified conditions.
               + `false`: instant detection. Instant detection immediately ends threat detection after blocking a request that
               meets Precise Protection specified conditions.
        :param str id: The WAF Policy ID.
        :param int level: Specifies the protection level. Valid values are:
               + `1`: low
               + `2`: medium
               + `3`: high
        :param str name: Policy name used for matching. The value is case sensitive and supports fuzzy matching.
        :param Sequence['GetPoliciesPolicyOptionArgs'] options: The protection switches. The options object structure is documented below.
        :param str protection_mode: Specifies the protective action after a rule is matched. Valid values are:
               + `block`: WAF blocks and logs detected attacks.
               + `log`: WAF logs detected attacks only.
        """
        pulumi.set(__self__, "full_detection", full_detection)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "protection_mode", protection_mode)

    @property
    @pulumi.getter(name="fullDetection")
    def full_detection(self) -> bool:
        """
        The detection mode in Precise Protection.
        + `true`: full detection. Full detection finishes all threat detections before blocking requests that meet Precise
        Protection specified conditions.
        + `false`: instant detection. Instant detection immediately ends threat detection after blocking a request that
        meets Precise Protection specified conditions.
        """
        return pulumi.get(self, "full_detection")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The WAF Policy ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def level(self) -> int:
        """
        Specifies the protection level. Valid values are:
        + `1`: low
        + `2`: medium
        + `3`: high
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Policy name used for matching. The value is case sensitive and supports fuzzy matching.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetPoliciesPolicyOptionResult']:
        """
        The protection switches. The options object structure is documented below.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> str:
        """
        Specifies the protective action after a rule is matched. Valid values are:
        + `block`: WAF blocks and logs detected attacks.
        + `log`: WAF logs detected attacks only.
        """
        return pulumi.get(self, "protection_mode")


@pulumi.output_type
class GetPoliciesPolicyOptionResult(dict):
    def __init__(__self__, *,
                 basic_web_protection: bool,
                 blacklist: bool,
                 cc_attack_protection: bool,
                 crawler: bool,
                 crawler_engine: bool,
                 crawler_other: bool,
                 crawler_scanner: bool,
                 crawler_script: bool,
                 data_masking: bool,
                 false_alarm_masking: bool,
                 general_check: bool,
                 precise_protection: bool,
                 web_tamper_protection: bool,
                 webshell: bool):
        """
        :param bool basic_web_protection: Indicates whether Basic Web Protection is enabled.
        :param bool blacklist: Indicates whether Blacklist and Whitelist is enabled.
        :param bool cc_attack_protection: Indicates whether CC Attack Protection is enabled.
        :param bool crawler: Indicates whether the master crawler detection switch in Basic Web Protection is enabled.
        :param bool crawler_engine: Indicates whether the Search Engine switch in Basic Web Protection is enabled.
        :param bool crawler_other: Indicates whether detection of other crawlers in Basic Web Protection is enabled.
        :param bool crawler_scanner: Indicates whether the Scanner switch in Basic Web Protection is enabled.
        :param bool crawler_script: Indicates whether the Script Tool switch in Basic Web Protection is enabled.
        :param bool data_masking: Indicates whether Data Masking is enabled.
        :param bool false_alarm_masking: Indicates whether False Alarm Masking is enabled.
        :param bool general_check: Indicates whether General Check in Basic Web Protection is enabled.
        :param bool precise_protection: Indicates whether Precise Protection is enabled.
        :param bool web_tamper_protection: Indicates whether Web Tamper Protection is enabled.
        :param bool webshell: Indicates whether webshell detection in Basic Web Protection is enabled.
        """
        pulumi.set(__self__, "basic_web_protection", basic_web_protection)
        pulumi.set(__self__, "blacklist", blacklist)
        pulumi.set(__self__, "cc_attack_protection", cc_attack_protection)
        pulumi.set(__self__, "crawler", crawler)
        pulumi.set(__self__, "crawler_engine", crawler_engine)
        pulumi.set(__self__, "crawler_other", crawler_other)
        pulumi.set(__self__, "crawler_scanner", crawler_scanner)
        pulumi.set(__self__, "crawler_script", crawler_script)
        pulumi.set(__self__, "data_masking", data_masking)
        pulumi.set(__self__, "false_alarm_masking", false_alarm_masking)
        pulumi.set(__self__, "general_check", general_check)
        pulumi.set(__self__, "precise_protection", precise_protection)
        pulumi.set(__self__, "web_tamper_protection", web_tamper_protection)
        pulumi.set(__self__, "webshell", webshell)

    @property
    @pulumi.getter(name="basicWebProtection")
    def basic_web_protection(self) -> bool:
        """
        Indicates whether Basic Web Protection is enabled.
        """
        return pulumi.get(self, "basic_web_protection")

    @property
    @pulumi.getter
    def blacklist(self) -> bool:
        """
        Indicates whether Blacklist and Whitelist is enabled.
        """
        return pulumi.get(self, "blacklist")

    @property
    @pulumi.getter(name="ccAttackProtection")
    def cc_attack_protection(self) -> bool:
        """
        Indicates whether CC Attack Protection is enabled.
        """
        return pulumi.get(self, "cc_attack_protection")

    @property
    @pulumi.getter
    def crawler(self) -> bool:
        """
        Indicates whether the master crawler detection switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler")

    @property
    @pulumi.getter(name="crawlerEngine")
    def crawler_engine(self) -> bool:
        """
        Indicates whether the Search Engine switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_engine")

    @property
    @pulumi.getter(name="crawlerOther")
    def crawler_other(self) -> bool:
        """
        Indicates whether detection of other crawlers in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_other")

    @property
    @pulumi.getter(name="crawlerScanner")
    def crawler_scanner(self) -> bool:
        """
        Indicates whether the Scanner switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_scanner")

    @property
    @pulumi.getter(name="crawlerScript")
    def crawler_script(self) -> bool:
        """
        Indicates whether the Script Tool switch in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "crawler_script")

    @property
    @pulumi.getter(name="dataMasking")
    def data_masking(self) -> bool:
        """
        Indicates whether Data Masking is enabled.
        """
        return pulumi.get(self, "data_masking")

    @property
    @pulumi.getter(name="falseAlarmMasking")
    def false_alarm_masking(self) -> bool:
        """
        Indicates whether False Alarm Masking is enabled.
        """
        return pulumi.get(self, "false_alarm_masking")

    @property
    @pulumi.getter(name="generalCheck")
    def general_check(self) -> bool:
        """
        Indicates whether General Check in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "general_check")

    @property
    @pulumi.getter(name="preciseProtection")
    def precise_protection(self) -> bool:
        """
        Indicates whether Precise Protection is enabled.
        """
        return pulumi.get(self, "precise_protection")

    @property
    @pulumi.getter(name="webTamperProtection")
    def web_tamper_protection(self) -> bool:
        """
        Indicates whether Web Tamper Protection is enabled.
        """
        return pulumi.get(self, "web_tamper_protection")

    @property
    @pulumi.getter
    def webshell(self) -> bool:
        """
        Indicates whether webshell detection in Basic Web Protection is enabled.
        """
        return pulumi.get(self, "webshell")


@pulumi.output_type
class GetReferenceTablesTableResult(dict):
    def __init__(__self__, *,
                 conditions: Sequence[str],
                 creation_time: str,
                 description: str,
                 id: str,
                 name: str,
                 type: str):
        """
        :param Sequence[str] conditions: The conditions of the reference table.
        :param str creation_time: The server time when reference table was created.
        :param str description: The description of the reference table.
        :param str id: The id of the reference table.
        :param str name: The name of the reference table. The value is case sensitive and matches exactly.
        :param str type: The type of the reference table, The options are: `url`, `user-agent`, `ip`, `params`, `cookie`, `referer`
               and `header`.
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence[str]:
        """
        The conditions of the reference table.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The server time when reference table was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the reference table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the reference table.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the reference table. The value is case sensitive and matches exactly.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the reference table, The options are: `url`, `user-agent`, `ip`, `params`, `cookie`, `referer`
        and `header`.
        """
        return pulumi.get(self, "type")


