# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainArgs', 'Domain']

@pulumi.input_type
class DomainArgs:
    def __init__(__self__, *,
                 domain: pulumi.Input[str],
                 servers: pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]],
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 keep_policy: Optional[pulumi.Input[bool]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 proxy: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Domain resource.
        :param pulumi.Input[str] domain: Specifies the domain name to be protected. For example, www.example.com or
               *.example.com. Changing this creates a new domain.
        :param pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]] servers: Specifies an array of origin web servers. The object structure is documented below.
        :param pulumi.Input[str] certificate_id: Specifies the certificate ID. This parameter is mandatory when `client_protocol`
               is set to HTTPS.
        :param pulumi.Input[str] certificate_name: Specifies the certificate name. This parameter is mandatory
               when `client_protocol` is set to HTTPS.
        :param pulumi.Input[bool] keep_policy: Specifies whether to retain the policy when deleting a domain name.
               Defaults to true.
        :param pulumi.Input[str] policy_id: Specifies the policy ID associated with the domain. If not specified, a new
               policy will be created automatically. Changing this create a new domain.
        :param pulumi.Input[bool] proxy: Specifies whether a proxy is configured.
        :param pulumi.Input[str] region: The region in which to create the WAF domain resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "servers", servers)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if keep_policy is not None:
            pulumi.set(__self__, "keep_policy", keep_policy)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Input[str]:
        """
        Specifies the domain name to be protected. For example, www.example.com or
        *.example.com. Changing this creates a new domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]]:
        """
        Specifies an array of origin web servers. The object structure is documented below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]]):
        pulumi.set(self, "servers", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate ID. This parameter is mandatory when `client_protocol`
        is set to HTTPS.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate name. This parameter is mandatory
        when `client_protocol` is set to HTTPS.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="keepPolicy")
    def keep_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to retain the policy when deleting a domain name.
        Defaults to true.
        """
        return pulumi.get(self, "keep_policy")

    @keep_policy.setter
    def keep_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_policy", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy ID associated with the domain. If not specified, a new
        policy will be created automatically. Changing this create a new domain.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a proxy is configured.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF domain resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DomainState:
    def __init__(__self__, *,
                 access_status: Optional[pulumi.Input[int]] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 keep_policy: Optional[pulumi.Input[bool]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 protect_status: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 proxy: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]]] = None):
        """
        Input properties used for looking up and filtering Domain resources.
        :param pulumi.Input[int] access_status: Whether a domain name is connected to WAF. 0: The domain name is not connected to WAF, 1: The domain
               name is connected to WAF.
        :param pulumi.Input[str] certificate_id: Specifies the certificate ID. This parameter is mandatory when `client_protocol`
               is set to HTTPS.
        :param pulumi.Input[str] certificate_name: Specifies the certificate name. This parameter is mandatory
               when `client_protocol` is set to HTTPS.
        :param pulumi.Input[str] domain: Specifies the domain name to be protected. For example, www.example.com or
               *.example.com. Changing this creates a new domain.
        :param pulumi.Input[bool] keep_policy: Specifies whether to retain the policy when deleting a domain name.
               Defaults to true.
        :param pulumi.Input[str] policy_id: Specifies the policy ID associated with the domain. If not specified, a new
               policy will be created automatically. Changing this create a new domain.
        :param pulumi.Input[int] protect_status: The WAF mode. -1: bypassed, 0: disabled, 1: enabled.
        :param pulumi.Input[str] protocol: The protocol type of the client. The options are HTTP, HTTPS, and HTTP&HTTPS.
        :param pulumi.Input[bool] proxy: Specifies whether a proxy is configured.
        :param pulumi.Input[str] region: The region in which to create the WAF domain resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]] servers: Specifies an array of origin web servers. The object structure is documented below.
        """
        if access_status is not None:
            pulumi.set(__self__, "access_status", access_status)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if keep_policy is not None:
            pulumi.set(__self__, "keep_policy", keep_policy)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if protect_status is not None:
            pulumi.set(__self__, "protect_status", protect_status)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if servers is not None:
            pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> Optional[pulumi.Input[int]]:
        """
        Whether a domain name is connected to WAF. 0: The domain name is not connected to WAF, 1: The domain
        name is connected to WAF.
        """
        return pulumi.get(self, "access_status")

    @access_status.setter
    def access_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_status", value)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate ID. This parameter is mandatory when `client_protocol`
        is set to HTTPS.
        """
        return pulumi.get(self, "certificate_id")

    @certificate_id.setter
    def certificate_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_id", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the certificate name. This parameter is mandatory
        when `client_protocol` is set to HTTPS.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the domain name to be protected. For example, www.example.com or
        *.example.com. Changing this creates a new domain.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="keepPolicy")
    def keep_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to retain the policy when deleting a domain name.
        Defaults to true.
        """
        return pulumi.get(self, "keep_policy")

    @keep_policy.setter
    def keep_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "keep_policy", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy ID associated with the domain. If not specified, a new
        policy will be created automatically. Changing this create a new domain.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="protectStatus")
    def protect_status(self) -> Optional[pulumi.Input[int]]:
        """
        The WAF mode. -1: bypassed, 0: disabled, 1: enabled.
        """
        return pulumi.get(self, "protect_status")

    @protect_status.setter
    def protect_status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protect_status", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol type of the client. The options are HTTP, HTTPS, and HTTP&HTTPS.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether a proxy is configured.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the WAF domain resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]]]:
        """
        Specifies an array of origin web servers. The object structure is documented below.
        """
        return pulumi.get(self, "servers")

    @servers.setter
    def servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainServerArgs']]]]):
        pulumi.set(self, "servers", value)


class Domain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 keep_policy: Optional[pulumi.Input[bool]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 proxy: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainServerArgs']]]]] = None,
                 __props__=None):
        """
        Manages a WAF domain resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The domain name resource can be used in Cloud Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate1 = huaweicloud.waf.Certificate("certificate1",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIIFmQl5dh2QUAeo39TIKtadgAgh4zHx09kSgayS9Wph9LEqq7MA+2042L3J9aOa
        DAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQUR+SosWwALt6PkP0J9iOIxA6RW8gVsLwq
        ...
        +HhDvD/VeOHytX3RAs2GeTOtxyAV5XpKY5r+PkyUqPJj04t3d0Fopi0gNtLpMF=
        -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"-----BEGIN PRIVATE KEY-----
        MIIJwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAM
        ATAwMC4GCCsGAQUFBwIBFiJodHRwOi8vY3BzLnJvb3QteDEubGV0c2VuY3J5cHQu
        ...
        he8Y4IWS6wY7bCkjCWDcRQJMEhg76fsO3txE+FiYruq9RUWhiF1myv4Q6W+CyBFC
        1qoJFlcDyqSMo5iHq3HLjs
        -----END PRIVATE KEY-----
        \"\"\")
        domain1 = huaweicloud.waf.Domain("domain1",
            domain="www.example.com",
            certificate_id=certificate1.id,
            certificate_name=certificate1.name,
            proxy=True,
            servers=[huaweicloud.waf.DomainServerArgs(
                client_protocol="HTTPS",
                server_protocol="HTTP",
                address="119.8.0.13",
                port=8080,
            )])
        ```

        ## Import

        Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/domain:Domain domain_2 7902bd9e01104cb794dcb668f235e0c5
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_id: Specifies the certificate ID. This parameter is mandatory when `client_protocol`
               is set to HTTPS.
        :param pulumi.Input[str] certificate_name: Specifies the certificate name. This parameter is mandatory
               when `client_protocol` is set to HTTPS.
        :param pulumi.Input[str] domain: Specifies the domain name to be protected. For example, www.example.com or
               *.example.com. Changing this creates a new domain.
        :param pulumi.Input[bool] keep_policy: Specifies whether to retain the policy when deleting a domain name.
               Defaults to true.
        :param pulumi.Input[str] policy_id: Specifies the policy ID associated with the domain. If not specified, a new
               policy will be created automatically. Changing this create a new domain.
        :param pulumi.Input[bool] proxy: Specifies whether a proxy is configured.
        :param pulumi.Input[str] region: The region in which to create the WAF domain resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainServerArgs']]]] servers: Specifies an array of origin web servers. The object structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a WAF domain resource within HuaweiCloud.

        > **NOTE:** All WAF resources depend on WAF instances, and the WAF instances need to be purchased before they can be
        used. The domain name resource can be used in Cloud Mode.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        certificate1 = huaweicloud.waf.Certificate("certificate1",
            certificate=\"\"\"-----BEGIN CERTIFICATE-----
        MIIFmQl5dh2QUAeo39TIKtadgAgh4zHx09kSgayS9Wph9LEqq7MA+2042L3J9aOa
        DAYDVR0TAQH/BAIwADAdBgNVHQ4EFgQUR+SosWwALt6PkP0J9iOIxA6RW8gVsLwq
        ...
        +HhDvD/VeOHytX3RAs2GeTOtxyAV5XpKY5r+PkyUqPJj04t3d0Fopi0gNtLpMF=
        -----END CERTIFICATE-----
        \"\"\",
            private_key=\"\"\"-----BEGIN PRIVATE KEY-----
        MIIJwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAM
        ATAwMC4GCCsGAQUFBwIBFiJodHRwOi8vY3BzLnJvb3QteDEubGV0c2VuY3J5cHQu
        ...
        he8Y4IWS6wY7bCkjCWDcRQJMEhg76fsO3txE+FiYruq9RUWhiF1myv4Q6W+CyBFC
        1qoJFlcDyqSMo5iHq3HLjs
        -----END PRIVATE KEY-----
        \"\"\")
        domain1 = huaweicloud.waf.Domain("domain1",
            domain="www.example.com",
            certificate_id=certificate1.id,
            certificate_name=certificate1.name,
            proxy=True,
            servers=[huaweicloud.waf.DomainServerArgs(
                client_protocol="HTTPS",
                server_protocol="HTTP",
                address="119.8.0.13",
                port=8080,
            )])
        ```

        ## Import

        Domains can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Waf/domain:Domain domain_2 7902bd9e01104cb794dcb668f235e0c5
        ```

        :param str resource_name: The name of the resource.
        :param DomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_id: Optional[pulumi.Input[str]] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 keep_policy: Optional[pulumi.Input[bool]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 proxy: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainServerArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainArgs.__new__(DomainArgs)

            __props__.__dict__["certificate_id"] = certificate_id
            __props__.__dict__["certificate_name"] = certificate_name
            if domain is None and not opts.urn:
                raise TypeError("Missing required property 'domain'")
            __props__.__dict__["domain"] = domain
            __props__.__dict__["keep_policy"] = keep_policy
            __props__.__dict__["policy_id"] = policy_id
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["region"] = region
            if servers is None and not opts.urn:
                raise TypeError("Missing required property 'servers'")
            __props__.__dict__["servers"] = servers
            __props__.__dict__["access_status"] = None
            __props__.__dict__["protect_status"] = None
            __props__.__dict__["protocol"] = None
        super(Domain, __self__).__init__(
            'huaweicloud:Waf/domain:Domain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_status: Optional[pulumi.Input[int]] = None,
            certificate_id: Optional[pulumi.Input[str]] = None,
            certificate_name: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            keep_policy: Optional[pulumi.Input[bool]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            protect_status: Optional[pulumi.Input[int]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            proxy: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            servers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainServerArgs']]]]] = None) -> 'Domain':
        """
        Get an existing Domain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_status: Whether a domain name is connected to WAF. 0: The domain name is not connected to WAF, 1: The domain
               name is connected to WAF.
        :param pulumi.Input[str] certificate_id: Specifies the certificate ID. This parameter is mandatory when `client_protocol`
               is set to HTTPS.
        :param pulumi.Input[str] certificate_name: Specifies the certificate name. This parameter is mandatory
               when `client_protocol` is set to HTTPS.
        :param pulumi.Input[str] domain: Specifies the domain name to be protected. For example, www.example.com or
               *.example.com. Changing this creates a new domain.
        :param pulumi.Input[bool] keep_policy: Specifies whether to retain the policy when deleting a domain name.
               Defaults to true.
        :param pulumi.Input[str] policy_id: Specifies the policy ID associated with the domain. If not specified, a new
               policy will be created automatically. Changing this create a new domain.
        :param pulumi.Input[int] protect_status: The WAF mode. -1: bypassed, 0: disabled, 1: enabled.
        :param pulumi.Input[str] protocol: The protocol type of the client. The options are HTTP, HTTPS, and HTTP&HTTPS.
        :param pulumi.Input[bool] proxy: Specifies whether a proxy is configured.
        :param pulumi.Input[str] region: The region in which to create the WAF domain resource. If omitted, the
               provider-level region will be used. Changing this setting will push a new certificate.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainServerArgs']]]] servers: Specifies an array of origin web servers. The object structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainState.__new__(_DomainState)

        __props__.__dict__["access_status"] = access_status
        __props__.__dict__["certificate_id"] = certificate_id
        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["keep_policy"] = keep_policy
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["protect_status"] = protect_status
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["region"] = region
        __props__.__dict__["servers"] = servers
        return Domain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessStatus")
    def access_status(self) -> pulumi.Output[int]:
        """
        Whether a domain name is connected to WAF. 0: The domain name is not connected to WAF, 1: The domain
        name is connected to WAF.
        """
        return pulumi.get(self, "access_status")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the certificate ID. This parameter is mandatory when `client_protocol`
        is set to HTTPS.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the certificate name. This parameter is mandatory
        when `client_protocol` is set to HTTPS.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        Specifies the domain name to be protected. For example, www.example.com or
        *.example.com. Changing this creates a new domain.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="keepPolicy")
    def keep_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to retain the policy when deleting a domain name.
        Defaults to true.
        """
        return pulumi.get(self, "keep_policy")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        Specifies the policy ID associated with the domain. If not specified, a new
        policy will be created automatically. Changing this create a new domain.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="protectStatus")
    def protect_status(self) -> pulumi.Output[int]:
        """
        The WAF mode. -1: bypassed, 0: disabled, 1: enabled.
        """
        return pulumi.get(self, "protect_status")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol type of the client. The options are HTTP, HTTPS, and HTTP&HTTPS.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether a proxy is configured.
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the WAF domain resource. If omitted, the
        provider-level region will be used. Changing this setting will push a new certificate.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def servers(self) -> pulumi.Output[Sequence['outputs.DomainServer']]:
        """
        Specifies an array of origin web servers. The object structure is documented below.
        """
        return pulumi.get(self, "servers")

