# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApprovalArgs', 'Approval']

@pulumi.input_type
class ApprovalArgs:
    def __init__(__self__, *,
                 endpoints: pulumi.Input[Sequence[pulumi.Input[str]]],
                 service_id: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Approval resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
               service. The VPC endpoints will be rejected when the resource was destroyed.
        :param pulumi.Input[str] service_id: - Specifies the ID of the VPC endpoint service. Changing this creates a new
               resource.
        :param pulumi.Input[str] region: The region in which to obtain the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "service_id", service_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
        service. The VPC endpoints will be rejected when the resource was destroyed.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Input[str]:
        """
        - Specifies the ID of the VPC endpoint service. Changing this creates a new
        resource.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ApprovalState:
    def __init__(__self__, *,
                 connections: Optional[pulumi.Input[Sequence[pulumi.Input['ApprovalConnectionArgs']]]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Approval resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApprovalConnectionArgs']]] connections: An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
               service. The VPC endpoints will be rejected when the resource was destroyed.
        :param pulumi.Input[str] region: The region in which to obtain the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] service_id: - Specifies the ID of the VPC endpoint service. Changing this creates a new
               resource.
        """
        if connections is not None:
            pulumi.set(__self__, "connections", connections)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter
    def connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApprovalConnectionArgs']]]]:
        """
        An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        """
        return pulumi.get(self, "connections")

    @connections.setter
    def connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApprovalConnectionArgs']]]]):
        pulumi.set(self, "connections", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
        service. The VPC endpoints will be rejected when the resource was destroyed.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the ID of the VPC endpoint service. Changing this creates a new
        resource.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)


class Approval(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage the VPC endpoint connections.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        service_vpc_id = config.require_object("serviceVpcId")
        vm_port = config.require_object("vmPort")
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        demo_service = huaweicloud.vpcep.Service("demoService",
            server_type="VM",
            vpc_id=service_vpc_id,
            port_id=vm_port,
            approval=True,
            port_mappings=[huaweicloud.vpcep.ServicePortMappingArgs(
                service_port=8080,
                terminal_port=80,
            )])
        demo_endpoint = huaweicloud.vpcep.Endpoint("demoEndpoint",
            service_id=demo_service.id,
            vpc_id=vpc_id,
            network_id=network_id,
            enable_dns=True)
        approval = huaweicloud.vpcep.Approval("approval",
            service_id=demo_service.id,
            endpoints=[demo_endpoint.id])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
               service. The VPC endpoints will be rejected when the resource was destroyed.
        :param pulumi.Input[str] region: The region in which to obtain the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] service_id: - Specifies the ID of the VPC endpoint service. Changing this creates a new
               resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApprovalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage the VPC endpoint connections.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        service_vpc_id = config.require_object("serviceVpcId")
        vm_port = config.require_object("vmPort")
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        demo_service = huaweicloud.vpcep.Service("demoService",
            server_type="VM",
            vpc_id=service_vpc_id,
            port_id=vm_port,
            approval=True,
            port_mappings=[huaweicloud.vpcep.ServicePortMappingArgs(
                service_port=8080,
                terminal_port=80,
            )])
        demo_endpoint = huaweicloud.vpcep.Endpoint("demoEndpoint",
            service_id=demo_service.id,
            vpc_id=vpc_id,
            network_id=network_id,
            enable_dns=True)
        approval = huaweicloud.vpcep.Approval("approval",
            service_id=demo_service.id,
            endpoints=[demo_endpoint.id])
        ```

        :param str resource_name: The name of the resource.
        :param ApprovalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApprovalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApprovalArgs.__new__(ApprovalArgs)

            if endpoints is None and not opts.urn:
                raise TypeError("Missing required property 'endpoints'")
            __props__.__dict__["endpoints"] = endpoints
            __props__.__dict__["region"] = region
            if service_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_id'")
            __props__.__dict__["service_id"] = service_id
            __props__.__dict__["connections"] = None
        super(Approval, __self__).__init__(
            'huaweicloud:Vpcep/approval:Approval',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connections: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApprovalConnectionArgs']]]]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_id: Optional[pulumi.Input[str]] = None) -> 'Approval':
        """
        Get an existing Approval resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ApprovalConnectionArgs']]]] connections: An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] endpoints: - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
               service. The VPC endpoints will be rejected when the resource was destroyed.
        :param pulumi.Input[str] region: The region in which to obtain the VPC endpoint service. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] service_id: - Specifies the ID of the VPC endpoint service. Changing this creates a new
               resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApprovalState.__new__(_ApprovalState)

        __props__.__dict__["connections"] = connections
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["region"] = region
        __props__.__dict__["service_id"] = service_id
        return Approval(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def connections(self) -> pulumi.Output[Sequence['outputs.ApprovalConnection']]:
        """
        An array of VPC endpoints connect to the VPC endpoint service. Structure is documented below.
        """
        return pulumi.get(self, "connections")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence[str]]:
        """
        - Specifies the list of VPC endpoint IDs which accepted to connect to VPC endpoint
        service. The VPC endpoints will be rejected when the resource was destroyed.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the VPC endpoint service. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> pulumi.Output[str]:
        """
        - Specifies the ID of the VPC endpoint service. Changing this creates a new
        resource.
        """
        return pulumi.get(self, "service_id")

