# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteTableArgs', 'RouteTable']

@pulumi.input_type
class RouteTableArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a RouteTable resource.
        :param pulumi.Input[str] vpc_id: - Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        :param pulumi.Input[str] description: - Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: - Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]] routes: - Specifies the route object list. The route object
               is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: - Specifies an array of one or more subnets associating with the route table.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        - Specifies the VPC ID for which a route table is to be added.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the route table name. The value is a string of no more than
        64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the vpc route table.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]:
        """
        - Specifies the route object list. The route object
        is documented below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies an array of one or more subnets associating with the route table.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _RouteTableState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RouteTable resources.
        :param pulumi.Input[str] description: - Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: - Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]] routes: - Specifies the route object list. The route object
               is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: - Specifies an array of one or more subnets associating with the route table.
        :param pulumi.Input[str] vpc_id: - Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the route table name. The value is a string of no more than
        64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the vpc route table.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]:
        """
        - Specifies the route object list. The route object
        is documented below.
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouteTableRouteArgs']]]]):
        pulumi.set(self, "routes", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        - Specifies an array of one or more subnets associating with the route table.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        - Specifies the VPC ID for which a route table is to be added.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class RouteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteTableRouteArgs']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VPC custom route table resource within HuaweiCloud.

        > **NOTE:** To use a custom route table, you need to submit a service ticket to increase quota.

        ## Example Usage
        ### Basic Custom Route Table

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        demo = huaweicloud.vpc.RouteTable("demo",
            vpc_id=vpc_id,
            description="a custom route table demo",
            routes=[huaweicloud.vpc.RouteTableRouteArgs(
                destination="172.16.0.0/16",
                type="peering",
                nexthop=vpc_peering_id,
            )])
        ```
        ### Associating Subnets with a Route Table

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        subnet_ids = huaweicloud.Vpc.get_subnet_ids(vpc_id=vpc_id)
        demo = huaweicloud.vpc.RouteTable("demo",
            vpc_id=vpc_id,
            subnets=subnet_ids.ids,
            routes=[
                huaweicloud.vpc.RouteTableRouteArgs(
                    destination="172.16.0.0/16",
                    type="peering",
                    nexthop=vpc_peering_id,
                ),
                huaweicloud.vpc.RouteTableRouteArgs(
                    destination="192.168.100.0/24",
                    type="vip",
                    nexthop="192.168.10.200",
                ),
            ])
        ```

        ## Import

        vpc route tables can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/routeTable:RouteTable demo e1b3208a-544b-42a7-84e6-5d70371dd982
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: - Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: - Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteTableRouteArgs']]]] routes: - Specifies the route object list. The route object
               is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: - Specifies an array of one or more subnets associating with the route table.
        :param pulumi.Input[str] vpc_id: - Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC custom route table resource within HuaweiCloud.

        > **NOTE:** To use a custom route table, you need to submit a service ticket to increase quota.

        ## Example Usage
        ### Basic Custom Route Table

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        demo = huaweicloud.vpc.RouteTable("demo",
            vpc_id=vpc_id,
            description="a custom route table demo",
            routes=[huaweicloud.vpc.RouteTableRouteArgs(
                destination="172.16.0.0/16",
                type="peering",
                nexthop=vpc_peering_id,
            )])
        ```
        ### Associating Subnets with a Route Table

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        vpc_peering_id = config.require_object("vpcPeeringId")
        subnet_ids = huaweicloud.Vpc.get_subnet_ids(vpc_id=vpc_id)
        demo = huaweicloud.vpc.RouteTable("demo",
            vpc_id=vpc_id,
            subnets=subnet_ids.ids,
            routes=[
                huaweicloud.vpc.RouteTableRouteArgs(
                    destination="172.16.0.0/16",
                    type="peering",
                    nexthop=vpc_peering_id,
                ),
                huaweicloud.vpc.RouteTableRouteArgs(
                    destination="192.168.100.0/24",
                    type="vip",
                    nexthop="192.168.10.200",
                ),
            ])
        ```

        ## Import

        vpc route tables can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vpc/routeTable:RouteTable demo e1b3208a-544b-42a7-84e6-5d70371dd982
        ```

        :param str resource_name: The name of the resource.
        :param RouteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteTableRouteArgs']]]]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteTableArgs.__new__(RouteTableArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["routes"] = routes
            __props__.__dict__["subnets"] = subnets
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(RouteTable, __self__).__init__(
            'huaweicloud:Vpc/routeTable:RouteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteTableRouteArgs']]]]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'RouteTable':
        """
        Get an existing RouteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: - Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] name: - Specifies the route table name. The value is a string of no more than
               64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[str] region: The region in which to create the vpc route table.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouteTableRouteArgs']]]] routes: - Specifies the route object list. The route object
               is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: - Specifies an array of one or more subnets associating with the route table.
        :param pulumi.Input[str] vpc_id: - Specifies the VPC ID for which a route table is to be added.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteTableState.__new__(_RouteTableState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["routes"] = routes
        __props__.__dict__["subnets"] = subnets
        __props__.__dict__["vpc_id"] = vpc_id
        return RouteTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        - Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        - Specifies the route table name. The value is a string of no more than
        64 characters that can contain letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the vpc route table.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Sequence['outputs.RouteTableRoute']]:
        """
        - Specifies the route object list. The route object
        is documented below.
        """
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        - Specifies an array of one or more subnets associating with the route table.
        """
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        - Specifies the VPC ID for which a route table is to be added.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vpc_id")

