# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BandwidthPublicip',
    'EipBandwidth',
    'EipPublicip',
    'PortAllowedAddressPair',
    'PortExtraDhcpOption',
    'PortFixedIp',
    'RouteTableRoute',
    'SecgroupRule',
    'VpcRoute',
    'GetRouteTableRouteResult',
    'GetSecgroupRuleResult',
    'GetSecgroupsSecurityGroupResult',
    'GetSubnetsSubnetResult',
    'GetVpcRouteResult',
    'GetVpcsVpcResult',
]

@pulumi.output_type
class BandwidthPublicip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipVersion":
            suggest = "ip_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthPublicip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthPublicip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthPublicip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 ip_version: Optional[int] = None,
                 type: Optional[str] = None):
        """
        :param str id: The ID of the EIP or IPv6 port that uses the bandwidth.
        :param str ip_address: The IPv4 or IPv6 address.
        :param int ip_version: The IP version, either 4 or 6.
        :param str type: The EIP type. Possible values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP).
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[int]:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The EIP type. Possible values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class EipBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareType":
            suggest = "share_type"
        elif key == "chargeMode":
            suggest = "charge_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EipBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EipBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EipBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_type: str,
                 charge_mode: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 size: Optional[int] = None):
        """
        :param str share_type: Whether the bandwidth is dedicated or shared. Changing this creates a new
               resource. Possible values are as follows:
               + **PER**: Dedicated bandwidth
               + **WHOLE**: Shared bandwidth
        :param str charge_mode: Specifies whether the bandwidth is billed by traffic or by bandwidth
               size. The value can be *traffic* or *bandwidth*. Changing this creates a new resource.
        :param str id: The shared bandwidth id. This parameter is mandatory when
               `share_type` is set to **WHOLE**. Changing this creates a new resource.
        :param str name: The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
               underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        :param int size: The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
               when `share_type` is set to **PER**.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> str:
        """
        Whether the bandwidth is dedicated or shared. Changing this creates a new
        resource. Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[str]:
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be *traffic* or *bandwidth*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charge_mode")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The shared bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The bandwidth name, which is a string of 1 to 64 characters that contain letters, digits,
        underscores (_), and hyphens (-). This parameter is mandatory when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        """
        The bandwidth size. The value ranges from 1 to 300 Mbit/s. This parameter is mandatory
        when `share_type` is set to **PER**.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class EipPublicip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "portId":
            suggest = "port_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EipPublicip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EipPublicip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EipPublicip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 ip_version: Optional[int] = None,
                 port_id: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str ip_address: Specifies the EIP to be assigned. The value must be a valid **IPv4**
               address in the available IP address range. The system automatically assigns an EIP if you do not specify it.
               Changing this creates a new resource.
        :param int ip_version: Specifies the IP version, either 4 (default) or 6.
        :param str port_id: The port ID which the EIP associated with.
        :param str type: Specifies the EIP type. Possible values are *5_bgp* (dynamic BGP)
               and *5_sbgp* (static BGP), the default value is *5_bgp*. Changing this creates a new resource.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Specifies the EIP to be assigned. The value must be a valid **IPv4**
        address in the available IP address range. The system automatically assigns an EIP if you do not specify it.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[int]:
        """
        Specifies the IP version, either 4 (default) or 6.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[str]:
        """
        The port ID which the EIP associated with.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the EIP type. Possible values are *5_bgp* (dynamic BGP)
        and *5_sbgp* (static BGP), the default value is *5_bgp*. Changing this creates a new resource.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class PortAllowedAddressPair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "macAddress":
            suggest = "mac_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortAllowedAddressPair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortAllowedAddressPair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortAllowedAddressPair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: str,
                 mac_address: Optional[str] = None):
        pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        return pulumi.get(self, "mac_address")


@pulumi.output_type
class PortExtraDhcpOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipVersion":
            suggest = "ip_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortExtraDhcpOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortExtraDhcpOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortExtraDhcpOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 value: str,
                 ip_version: Optional[int] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[int]:
        return pulumi.get(self, "ip_version")


@pulumi.output_type
class PortFixedIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ipAddress":
            suggest = "ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PortFixedIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PortFixedIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PortFixedIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 ip_address: Optional[str] = None):
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")


@pulumi.output_type
class RouteTableRoute(dict):
    def __init__(__self__, *,
                 destination: str,
                 nexthop: str,
                 type: str,
                 description: Optional[str] = None):
        """
        :param str destination: - Specifies the destination address in the CIDR notation format,
               for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
               with any subnet in the VPC.
        :param str nexthop: - Specifies the next hop.
               + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
               + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
               + If the route type is **vip**, the value is a virtual IP address.
               + If the route type is **nat**, the value is a VPN gateway ID.
               + If the route type is **peering**, the value is a VPC peering connection ID.
               + If the route type is **vpn**, the value is a VPN gateway ID.
               + If the route type is **dc**, the value is a Direct Connect gateway ID.
               + If the route type is **cc**, the value is a Cloud Connection ID.
        :param str type: - Specifies the route type. Currently, the value can be:
               **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        :param str description: - Specifies the supplementary information about the route.
               The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        - Specifies the destination address in the CIDR notation format,
        for example, 192.168.200.0/24. The destination of each route must be unique and cannot overlap
        with any subnet in the VPC.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def nexthop(self) -> str:
        """
        - Specifies the next hop.
        + If the route type is **ecs**, the value is an ECS instance ID in the VPC.
        + If the route type is **eni**, the value is the extension NIC of an ECS in the VPC.
        + If the route type is **vip**, the value is a virtual IP address.
        + If the route type is **nat**, the value is a VPN gateway ID.
        + If the route type is **peering**, the value is a VPC peering connection ID.
        + If the route type is **vpn**, the value is a VPN gateway ID.
        + If the route type is **dc**, the value is a Direct Connect gateway ID.
        + If the route type is **cc**, the value is a Cloud Connection ID.
        """
        return pulumi.get(self, "nexthop")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        - Specifies the route type. Currently, the value can be:
        **ecs**, **eni**, **vip**, **nat**, **peering**, **vpn**, **dc** and **cc**.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        - Specifies the supplementary information about the route.
        The value is a string of no more than 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class SecgroupRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portRangeMax":
            suggest = "port_range_max"
        elif key == "portRangeMin":
            suggest = "port_range_min"
        elif key == "remoteAddressGroupId":
            suggest = "remote_address_group_id"
        elif key == "remoteGroupId":
            suggest = "remote_group_id"
        elif key == "remoteIpPrefix":
            suggest = "remote_ip_prefix"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecgroupRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecgroupRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecgroupRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 description: Optional[str] = None,
                 direction: Optional[str] = None,
                 ethertype: Optional[str] = None,
                 id: Optional[str] = None,
                 port_range_max: Optional[int] = None,
                 port_range_min: Optional[int] = None,
                 ports: Optional[str] = None,
                 priority: Optional[int] = None,
                 protocol: Optional[str] = None,
                 remote_address_group_id: Optional[str] = None,
                 remote_group_id: Optional[str] = None,
                 remote_ip_prefix: Optional[str] = None):
        """
        :param str action: The effective policy.
        :param str description: Specifies the description for the security group.
        :param str direction: The direction of the rule. The value can be *egress* or *ingress*.
        :param str ethertype: The IP protocol version. The value can be *IPv4* or *IPv6*.
        :param str id: The security group rule ID.
        :param str ports: The port value range.
        :param int priority: The priority number.
        :param str protocol: The protocol type.
        :param str remote_address_group_id: The ID of the remote address group.
        :param str remote_group_id: The ID of the peer security group.
        :param str remote_ip_prefix: The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if ethertype is not None:
            pulumi.set(__self__, "ethertype", ethertype)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if port_range_max is not None:
            pulumi.set(__self__, "port_range_max", port_range_max)
        if port_range_min is not None:
            pulumi.set(__self__, "port_range_min", port_range_min)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if remote_address_group_id is not None:
            pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        if remote_group_id is not None:
            pulumi.set(__self__, "remote_group_id", remote_group_id)
        if remote_ip_prefix is not None:
            pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The effective policy.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description for the security group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def ethertype(self) -> Optional[str]:
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        return pulumi.get(self, "ethertype")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> Optional[int]:
        return pulumi.get(self, "port_range_max")

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> Optional[int]:
        return pulumi.get(self, "port_range_min")

    @property
    @pulumi.getter
    def ports(self) -> Optional[str]:
        """
        The port value range.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def priority(self) -> Optional[int]:
        """
        The priority number.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[str]:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> Optional[str]:
        """
        The ID of the remote address group.
        """
        return pulumi.get(self, "remote_address_group_id")

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> Optional[str]:
        """
        The ID of the peer security group.
        """
        return pulumi.get(self, "remote_group_id")

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> Optional[str]:
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        return pulumi.get(self, "remote_ip_prefix")


@pulumi.output_type
class VpcRoute(dict):
    def __init__(__self__, *,
                 destination: Optional[str] = None,
                 nexthop: Optional[str] = None):
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if nexthop is not None:
            pulumi.set(__self__, "nexthop", nexthop)

    @property
    @pulumi.getter
    def destination(self) -> Optional[str]:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def nexthop(self) -> Optional[str]:
        return pulumi.get(self, "nexthop")


@pulumi.output_type
class GetRouteTableRouteResult(dict):
    def __init__(__self__, *,
                 description: str,
                 destination: str,
                 nexthop: str,
                 type: str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def nexthop(self) -> str:
        return pulumi.get(self, "nexthop")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSecgroupRuleResult(dict):
    def __init__(__self__, *,
                 action: str,
                 description: str,
                 direction: str,
                 ethertype: str,
                 id: str,
                 port_range_max: int,
                 port_range_min: int,
                 ports: str,
                 priority: int,
                 protocol: str,
                 remote_address_group_id: str,
                 remote_group_id: str,
                 remote_ip_prefix: str):
        """
        :param str action: The effective policy.
        :param str description: The supplementary information about the security group rule.
        :param str direction: The direction of the rule. The value can be *egress* or *ingress*.
        :param str ethertype: The IP protocol version. The value can be *IPv4* or *IPv6*.
        :param str id: The security group rule ID.
        :param str ports: The port value range.
        :param int priority: The priority number.
        :param str protocol: The protocol type.
        :param str remote_address_group_id: The ID of the remote address group.
        :param str remote_group_id: The ID of the peer security group.
        :param str remote_ip_prefix: The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "ethertype", ethertype)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "port_range_max", port_range_max)
        pulumi.set(__self__, "port_range_min", port_range_min)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "remote_address_group_id", remote_address_group_id)
        pulumi.set(__self__, "remote_group_id", remote_group_id)
        pulumi.set(__self__, "remote_ip_prefix", remote_ip_prefix)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        The effective policy.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The supplementary information about the security group rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> str:
        """
        The direction of the rule. The value can be *egress* or *ingress*.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter
    def ethertype(self) -> str:
        """
        The IP protocol version. The value can be *IPv4* or *IPv6*.
        """
        return pulumi.get(self, "ethertype")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The security group rule ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="portRangeMax")
    def port_range_max(self) -> int:
        return pulumi.get(self, "port_range_max")

    @property
    @pulumi.getter(name="portRangeMin")
    def port_range_min(self) -> int:
        return pulumi.get(self, "port_range_min")

    @property
    @pulumi.getter
    def ports(self) -> str:
        """
        The port value range.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        The priority number.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol type.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="remoteAddressGroupId")
    def remote_address_group_id(self) -> str:
        """
        The ID of the remote address group.
        """
        return pulumi.get(self, "remote_address_group_id")

    @property
    @pulumi.getter(name="remoteGroupId")
    def remote_group_id(self) -> str:
        """
        The ID of the peer security group.
        """
        return pulumi.get(self, "remote_group_id")

    @property
    @pulumi.getter(name="remoteIpPrefix")
    def remote_ip_prefix(self) -> str:
        """
        The remote IP address. The value can be in the CIDR format or IP addresses.
        """
        return pulumi.get(self, "remote_ip_prefix")


@pulumi.output_type
class GetSecgroupsSecurityGroupResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 description: str,
                 enterprise_project_id: str,
                 id: str,
                 name: str,
                 updated_at: str):
        """
        :param str created_at: The creation time, in UTC format.
        :param str description: Specifies the description of the security group. The security groups can be
               filtered by keywords in the description.
        :param str enterprise_project_id: Specifies the enterprise project ID of the security group.
        :param str id: The security group ID.
        :param str name: Specifies the name of the security group.
        :param str updated_at: The last update time, in UTC format.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Specifies the description of the security group. The security groups can be
        filtered by keywords in the description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Specifies the enterprise project ID of the security group.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The security group ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the security group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetSubnetsSubnetResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 cidr: str,
                 description: str,
                 dhcp_enable: bool,
                 dns_lists: Sequence[str],
                 gateway_ip: str,
                 id: str,
                 ipv4_subnet_id: str,
                 ipv6_cidr: str,
                 ipv6_enable: bool,
                 ipv6_gateway: str,
                 ipv6_subnet_id: str,
                 name: str,
                 primary_dns: str,
                 secondary_dns: str,
                 status: str,
                 subnet_id: str,
                 tags: Mapping[str, str],
                 vpc_id: str):
        """
        :param str availability_zone: Specifies the availability zone (AZ) to which the desired subnet belongs to.
        :param str cidr: Specifies the network segment of desired subnet. The value must be in CIDR format.
        :param str gateway_ip: Specifies the subnet gateway address of desired subnet.
        :param str id: - Specifies the id of the desired subnet.
        :param str name: Specifies the name of the desired subnet.
        :param str primary_dns: Specifies the IP address of DNS server 1 on the desired subnet.
        :param str secondary_dns: Specifies the IP address of DNS server 2 on the desired subnet.
        :param str status: Specifies the current status of the desired subnet.
               the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
        :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired subnet.
        :param str vpc_id: Specifies the id of the VPC that the desired subnet belongs to.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dhcp_enable", dhcp_enable)
        pulumi.set(__self__, "dns_lists", dns_lists)
        pulumi.set(__self__, "gateway_ip", gateway_ip)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ipv4_subnet_id", ipv4_subnet_id)
        pulumi.set(__self__, "ipv6_cidr", ipv6_cidr)
        pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        pulumi.set(__self__, "ipv6_gateway", ipv6_gateway)
        pulumi.set(__self__, "ipv6_subnet_id", ipv6_subnet_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary_dns", primary_dns)
        pulumi.set(__self__, "secondary_dns", secondary_dns)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Specifies the availability zone (AZ) to which the desired subnet belongs to.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        Specifies the network segment of desired subnet. The value must be in CIDR format.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dhcpEnable")
    def dhcp_enable(self) -> bool:
        return pulumi.get(self, "dhcp_enable")

    @property
    @pulumi.getter(name="dnsLists")
    def dns_lists(self) -> Sequence[str]:
        return pulumi.get(self, "dns_lists")

    @property
    @pulumi.getter(name="gatewayIp")
    def gateway_ip(self) -> str:
        """
        Specifies the subnet gateway address of desired subnet.
        """
        return pulumi.get(self, "gateway_ip")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        - Specifies the id of the desired subnet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipv4SubnetId")
    def ipv4_subnet_id(self) -> str:
        return pulumi.get(self, "ipv4_subnet_id")

    @property
    @pulumi.getter(name="ipv6Cidr")
    def ipv6_cidr(self) -> str:
        return pulumi.get(self, "ipv6_cidr")

    @property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> bool:
        return pulumi.get(self, "ipv6_enable")

    @property
    @pulumi.getter(name="ipv6Gateway")
    def ipv6_gateway(self) -> str:
        return pulumi.get(self, "ipv6_gateway")

    @property
    @pulumi.getter(name="ipv6SubnetId")
    def ipv6_subnet_id(self) -> str:
        return pulumi.get(self, "ipv6_subnet_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the desired subnet.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryDns")
    def primary_dns(self) -> str:
        """
        Specifies the IP address of DNS server 1 on the desired subnet.
        """
        return pulumi.get(self, "primary_dns")

    @property
    @pulumi.getter(name="secondaryDns")
    def secondary_dns(self) -> str:
        """
        Specifies the IP address of DNS server 2 on the desired subnet.
        """
        return pulumi.get(self, "secondary_dns")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the current status of the desired subnet.
        the value can be ACTIVE, DOWN, UNKNOWN, or ERROR.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Specifies the included key/value pairs which associated with the desired subnet.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the id of the VPC that the desired subnet belongs to.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetVpcRouteResult(dict):
    def __init__(__self__, *,
                 destination: str,
                 nexthop: str):
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "nexthop", nexthop)

    @property
    @pulumi.getter
    def destination(self) -> str:
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def nexthop(self) -> str:
        return pulumi.get(self, "nexthop")


@pulumi.output_type
class GetVpcsVpcResult(dict):
    def __init__(__self__, *,
                 cidr: str,
                 description: str,
                 enterprise_project_id: str,
                 id: str,
                 name: str,
                 status: str,
                 tags: Mapping[str, str]):
        """
        :param str cidr: Specifies the cidr block of the desired VPC.
        :param str description: Indicates the description of the VPC.
        :param str enterprise_project_id: Specifies the enterprise project ID which the desired VPC belongs to.
        :param str id: Specifies the id of the desired VPC.
        :param str name: Specifies the name of the desired VPC. The value is a string of no more than 64 characters
               and can contain digits, letters, underscores (_) and hyphens (-).
        :param str status: Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
        :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired VPC.
        """
        pulumi.set(__self__, "cidr", cidr)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        Specifies the cidr block of the desired VPC.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Indicates the description of the VPC.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Specifies the enterprise project ID which the desired VPC belongs to.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the id of the desired VPC.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the desired VPC. The value is a string of no more than 64 characters
        and can contain digits, letters, underscores (_) and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Specifies the current status of the desired VPC. The value can be CREATING, OK or ERROR.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Specifies the included key/value pairs which associated with the desired VPC.
        """
        return pulumi.get(self, "tags")


