# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetRouteTableResult',
    'AwaitableGetRouteTableResult',
    'get_route_table',
    'get_route_table_output',
]

@pulumi.output_type
class GetRouteTableResult:
    """
    A collection of values returned by getRouteTable.
    """
    def __init__(__self__, default=None, description=None, id=None, name=None, region=None, routes=None, subnets=None, vpc_id=None):
        if default and not isinstance(default, bool):
            raise TypeError("Expected argument 'default' to be a bool")
        pulumi.set(__self__, "default", default)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if routes and not isinstance(routes, list):
            raise TypeError("Expected argument 'routes' to be a list")
        pulumi.set(__self__, "routes", routes)
        if subnets and not isinstance(subnets, list):
            raise TypeError("Expected argument 'subnets' to be a list")
        pulumi.set(__self__, "subnets", subnets)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def default(self) -> bool:
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetRouteTableRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter
    def subnets(self) -> Sequence[str]:
        return pulumi.get(self, "subnets")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetRouteTableResult(GetRouteTableResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRouteTableResult(
            default=self.default,
            description=self.description,
            id=self.id,
            name=self.name,
            region=self.region,
            routes=self.routes,
            subnets=self.subnets,
            vpc_id=self.vpc_id)


def get_route_table(id: Optional[str] = None,
                    name: Optional[str] = None,
                    region: Optional[str] = None,
                    vpc_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRouteTableResult:
    """
    Provides details about a specific VPC route table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    vpc_id = config.require_object("vpcId")
    default = huaweicloud.Vpc.get_route_table(vpc_id=vpc_id)
    custom = huaweicloud.Vpc.get_route_table(vpc_id=vpc_id,
        name="demo")
    ```


    :param str id: - Specifies the ID of the route table.
    :param str name: - Specifies the name of the route table.
    :param str region: The region in which to query the vpc route table.
           If omitted, the provider-level region will be used.
    :param str vpc_id: - Specifies the VPC ID where the route table resides.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['region'] = region
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Vpc/getRouteTable:getRouteTable', __args__, opts=opts, typ=GetRouteTableResult).value

    return AwaitableGetRouteTableResult(
        default=__ret__.default,
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        routes=__ret__.routes,
        subnets=__ret__.subnets,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_route_table)
def get_route_table_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           region: Optional[pulumi.Input[Optional[str]]] = None,
                           vpc_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRouteTableResult]:
    """
    Provides details about a specific VPC route table.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    vpc_id = config.require_object("vpcId")
    default = huaweicloud.Vpc.get_route_table(vpc_id=vpc_id)
    custom = huaweicloud.Vpc.get_route_table(vpc_id=vpc_id,
        name="demo")
    ```


    :param str id: - Specifies the ID of the route table.
    :param str name: - Specifies the name of the route table.
    :param str region: The region in which to query the vpc route table.
           If omitted, the provider-level region will be used.
    :param str vpc_id: - Specifies the VPC ID where the route table resides.
    """
    ...
