# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['WatermarkTemplateArgs', 'WatermarkTemplate']

@pulumi.input_type
class WatermarkTemplateArgs:
    def __init__(__self__, *,
                 image_file: pulumi.Input[str],
                 image_type: pulumi.Input[str],
                 height: Optional[pulumi.Input[str]] = None,
                 horizontal_offset: Optional[pulumi.Input[str]] = None,
                 image_process: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeline_duration: Optional[pulumi.Input[str]] = None,
                 timeline_start: Optional[pulumi.Input[str]] = None,
                 vertical_offset: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a WatermarkTemplate resource.
        :param pulumi.Input[str] image_file: Specifies the image file name, e.g. './test.png'.
               Changing this creates a new resource.
        :param pulumi.Input[str] image_type: Specifies the image file type. The valid values are **PNG**, **JPG**
               and **JPEG**. Changing this creates a new resource.
        :param pulumi.Input[str] height: Specifies height ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        :param pulumi.Input[str] horizontal_offset: Specifies horizontal offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] image_process: Specifies the image process. The valid values are:  
               + **TRANSPARENT**: make the background color transparent.
               + **ORIGINAL**: only simple scaling, no other processing.
               + **GRAYED**: make the color image grayed.
        :param pulumi.Input[str] name: Specifies the template name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] position: Specifies the location of the watermark. The valid values are **TOPRIGHT**,
               **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] timeline_duration: Specifies the watermark duration (Unit: second). The value is a digit
               greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        :param pulumi.Input[str] timeline_start: Specifies the watermark start time (Unit: second). The value is a digit
               greater than or equal to **0**. Defaults to: **0**.
        :param pulumi.Input[str] vertical_offset: Specifies vertical offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] width: Specifies width ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        """
        pulumi.set(__self__, "image_file", image_file)
        pulumi.set(__self__, "image_type", image_type)
        if height is not None:
            pulumi.set(__self__, "height", height)
        if horizontal_offset is not None:
            pulumi.set(__self__, "horizontal_offset", horizontal_offset)
        if image_process is not None:
            pulumi.set(__self__, "image_process", image_process)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeline_duration is not None:
            pulumi.set(__self__, "timeline_duration", timeline_duration)
        if timeline_start is not None:
            pulumi.set(__self__, "timeline_start", timeline_start)
        if vertical_offset is not None:
            pulumi.set(__self__, "vertical_offset", vertical_offset)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter(name="imageFile")
    def image_file(self) -> pulumi.Input[str]:
        """
        Specifies the image file name, e.g. './test.png'.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "image_file")

    @image_file.setter
    def image_file(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_file", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Input[str]:
        """
        Specifies the image file type. The valid values are **PNG**, **JPG**
        and **JPEG**. Changing this creates a new resource.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies height ratio of the watermark image relative to the output video.
        The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0.01**.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter(name="horizontalOffset")
    def horizontal_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies horizontal offset ratio of the watermark image relative to the
        output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0**.
        """
        return pulumi.get(self, "horizontal_offset")

    @horizontal_offset.setter
    def horizontal_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "horizontal_offset", value)

    @property
    @pulumi.getter(name="imageProcess")
    def image_process(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image process. The valid values are:  
        + **TRANSPARENT**: make the background color transparent.
        + **ORIGINAL**: only simple scaling, no other processing.
        + **GRAYED**: make the color image grayed.
        """
        return pulumi.get(self, "image_process")

    @image_process.setter
    def image_process(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_process", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the template name, which contains a maximum of 128 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the watermark. The valid values are **TOPRIGHT**,
        **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="timelineDuration")
    def timeline_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the watermark duration (Unit: second). The value is a digit
        greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        """
        return pulumi.get(self, "timeline_duration")

    @timeline_duration.setter
    def timeline_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeline_duration", value)

    @property
    @pulumi.getter(name="timelineStart")
    def timeline_start(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the watermark start time (Unit: second). The value is a digit
        greater than or equal to **0**. Defaults to: **0**.
        """
        return pulumi.get(self, "timeline_start")

    @timeline_start.setter
    def timeline_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeline_start", value)

    @property
    @pulumi.getter(name="verticalOffset")
    def vertical_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies vertical offset ratio of the watermark image relative to the
        output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0**.
        """
        return pulumi.get(self, "vertical_offset")

    @vertical_offset.setter
    def vertical_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vertical_offset", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies width ratio of the watermark image relative to the output video.
        The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0.01**.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


@pulumi.input_type
class _WatermarkTemplateState:
    def __init__(__self__, *,
                 height: Optional[pulumi.Input[str]] = None,
                 horizontal_offset: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None,
                 image_process: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeline_duration: Optional[pulumi.Input[str]] = None,
                 timeline_start: Optional[pulumi.Input[str]] = None,
                 vertical_offset: Optional[pulumi.Input[str]] = None,
                 watermark_type: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering WatermarkTemplate resources.
        :param pulumi.Input[str] height: Specifies height ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        :param pulumi.Input[str] horizontal_offset: Specifies horizontal offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] image_file: Specifies the image file name, e.g. './test.png'.
               Changing this creates a new resource.
        :param pulumi.Input[str] image_process: Specifies the image process. The valid values are:  
               + **TRANSPARENT**: make the background color transparent.
               + **ORIGINAL**: only simple scaling, no other processing.
               + **GRAYED**: make the color image grayed.
        :param pulumi.Input[str] image_type: Specifies the image file type. The valid values are **PNG**, **JPG**
               and **JPEG**. Changing this creates a new resource.
        :param pulumi.Input[str] image_url: The watermark image URL.
        :param pulumi.Input[str] name: Specifies the template name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] position: Specifies the location of the watermark. The valid values are **TOPRIGHT**,
               **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] timeline_duration: Specifies the watermark duration (Unit: second). The value is a digit
               greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        :param pulumi.Input[str] timeline_start: Specifies the watermark start time (Unit: second). The value is a digit
               greater than or equal to **0**. Defaults to: **0**.
        :param pulumi.Input[str] vertical_offset: Specifies vertical offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] watermark_type: The watermark type.
        :param pulumi.Input[str] width: Specifies width ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        """
        if height is not None:
            pulumi.set(__self__, "height", height)
        if horizontal_offset is not None:
            pulumi.set(__self__, "horizontal_offset", horizontal_offset)
        if image_file is not None:
            pulumi.set(__self__, "image_file", image_file)
        if image_process is not None:
            pulumi.set(__self__, "image_process", image_process)
        if image_type is not None:
            pulumi.set(__self__, "image_type", image_type)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timeline_duration is not None:
            pulumi.set(__self__, "timeline_duration", timeline_duration)
        if timeline_start is not None:
            pulumi.set(__self__, "timeline_start", timeline_start)
        if vertical_offset is not None:
            pulumi.set(__self__, "vertical_offset", vertical_offset)
        if watermark_type is not None:
            pulumi.set(__self__, "watermark_type", watermark_type)
        if width is not None:
            pulumi.set(__self__, "width", width)

    @property
    @pulumi.getter
    def height(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies height ratio of the watermark image relative to the output video.
        The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0.01**.
        """
        return pulumi.get(self, "height")

    @height.setter
    def height(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "height", value)

    @property
    @pulumi.getter(name="horizontalOffset")
    def horizontal_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies horizontal offset ratio of the watermark image relative to the
        output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0**.
        """
        return pulumi.get(self, "horizontal_offset")

    @horizontal_offset.setter
    def horizontal_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "horizontal_offset", value)

    @property
    @pulumi.getter(name="imageFile")
    def image_file(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image file name, e.g. './test.png'.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "image_file")

    @image_file.setter
    def image_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_file", value)

    @property
    @pulumi.getter(name="imageProcess")
    def image_process(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image process. The valid values are:  
        + **TRANSPARENT**: make the background color transparent.
        + **ORIGINAL**: only simple scaling, no other processing.
        + **GRAYED**: make the color image grayed.
        """
        return pulumi.get(self, "image_process")

    @image_process.setter
    def image_process(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_process", value)

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the image file type. The valid values are **PNG**, **JPG**
        and **JPEG**. Changing this creates a new resource.
        """
        return pulumi.get(self, "image_type")

    @image_type.setter
    def image_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_type", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The watermark image URL.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the template name, which contains a maximum of 128 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the location of the watermark. The valid values are **TOPRIGHT**,
        **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="timelineDuration")
    def timeline_duration(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the watermark duration (Unit: second). The value is a digit
        greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        """
        return pulumi.get(self, "timeline_duration")

    @timeline_duration.setter
    def timeline_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeline_duration", value)

    @property
    @pulumi.getter(name="timelineStart")
    def timeline_start(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the watermark start time (Unit: second). The value is a digit
        greater than or equal to **0**. Defaults to: **0**.
        """
        return pulumi.get(self, "timeline_start")

    @timeline_start.setter
    def timeline_start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeline_start", value)

    @property
    @pulumi.getter(name="verticalOffset")
    def vertical_offset(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies vertical offset ratio of the watermark image relative to the
        output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0**.
        """
        return pulumi.get(self, "vertical_offset")

    @vertical_offset.setter
    def vertical_offset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vertical_offset", value)

    @property
    @pulumi.getter(name="watermarkType")
    def watermark_type(self) -> Optional[pulumi.Input[str]]:
        """
        The watermark type.
        """
        return pulumi.get(self, "watermark_type")

    @watermark_type.setter
    def watermark_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "watermark_type", value)

    @property
    @pulumi.getter
    def width(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies width ratio of the watermark image relative to the output video.
        The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0.01**.
        """
        return pulumi.get(self, "width")

    @width.setter
    def width(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "width", value)


class WatermarkTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 height: Optional[pulumi.Input[str]] = None,
                 horizontal_offset: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None,
                 image_process: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeline_duration: Optional[pulumi.Input[str]] = None,
                 timeline_start: Optional[pulumi.Input[str]] = None,
                 vertical_offset: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VOD watermark template resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vod.WatermarkTemplate("test",
            height="0.1",
            horizontal_offset="0.05",
            image_file="./test.PNG",
            image_process="ORIGINAL",
            image_type="PNG",
            position="TOPLEFT",
            vertical_offset="0.05",
            width="0.1")
        ```

        ## Import

        The template can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/watermarkTemplate:WatermarkTemplate test 81ac58796e25842ee2e90a904aa8a719
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`image_file`. It is generally recommended running `terraform plan` after importing a watermark template. You can then decide if changes should be applied to the watermark template, or the resource definition should be updated to align with the watermark template. Also you can ignore changes as below. resource "huaweicloud_vod_watermark_template" "test" {

         ...

         lifecycle {

         ignore_changes = [

         image_file,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] height: Specifies height ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        :param pulumi.Input[str] horizontal_offset: Specifies horizontal offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] image_file: Specifies the image file name, e.g. './test.png'.
               Changing this creates a new resource.
        :param pulumi.Input[str] image_process: Specifies the image process. The valid values are:  
               + **TRANSPARENT**: make the background color transparent.
               + **ORIGINAL**: only simple scaling, no other processing.
               + **GRAYED**: make the color image grayed.
        :param pulumi.Input[str] image_type: Specifies the image file type. The valid values are **PNG**, **JPG**
               and **JPEG**. Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the template name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] position: Specifies the location of the watermark. The valid values are **TOPRIGHT**,
               **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] timeline_duration: Specifies the watermark duration (Unit: second). The value is a digit
               greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        :param pulumi.Input[str] timeline_start: Specifies the watermark start time (Unit: second). The value is a digit
               greater than or equal to **0**. Defaults to: **0**.
        :param pulumi.Input[str] vertical_offset: Specifies vertical offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] width: Specifies width ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WatermarkTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VOD watermark template resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.vod.WatermarkTemplate("test",
            height="0.1",
            horizontal_offset="0.05",
            image_file="./test.PNG",
            image_process="ORIGINAL",
            image_type="PNG",
            position="TOPLEFT",
            vertical_offset="0.05",
            width="0.1")
        ```

        ## Import

        The template can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/watermarkTemplate:WatermarkTemplate test 81ac58796e25842ee2e90a904aa8a719
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`image_file`. It is generally recommended running `terraform plan` after importing a watermark template. You can then decide if changes should be applied to the watermark template, or the resource definition should be updated to align with the watermark template. Also you can ignore changes as below. resource "huaweicloud_vod_watermark_template" "test" {

         ...

         lifecycle {

         ignore_changes = [

         image_file,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param WatermarkTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WatermarkTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 height: Optional[pulumi.Input[str]] = None,
                 horizontal_offset: Optional[pulumi.Input[str]] = None,
                 image_file: Optional[pulumi.Input[str]] = None,
                 image_process: Optional[pulumi.Input[str]] = None,
                 image_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 position: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 timeline_duration: Optional[pulumi.Input[str]] = None,
                 timeline_start: Optional[pulumi.Input[str]] = None,
                 vertical_offset: Optional[pulumi.Input[str]] = None,
                 width: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WatermarkTemplateArgs.__new__(WatermarkTemplateArgs)

            __props__.__dict__["height"] = height
            __props__.__dict__["horizontal_offset"] = horizontal_offset
            if image_file is None and not opts.urn:
                raise TypeError("Missing required property 'image_file'")
            __props__.__dict__["image_file"] = image_file
            __props__.__dict__["image_process"] = image_process
            if image_type is None and not opts.urn:
                raise TypeError("Missing required property 'image_type'")
            __props__.__dict__["image_type"] = image_type
            __props__.__dict__["name"] = name
            __props__.__dict__["position"] = position
            __props__.__dict__["region"] = region
            __props__.__dict__["timeline_duration"] = timeline_duration
            __props__.__dict__["timeline_start"] = timeline_start
            __props__.__dict__["vertical_offset"] = vertical_offset
            __props__.__dict__["width"] = width
            __props__.__dict__["image_url"] = None
            __props__.__dict__["watermark_type"] = None
        super(WatermarkTemplate, __self__).__init__(
            'huaweicloud:Vod/watermarkTemplate:WatermarkTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            height: Optional[pulumi.Input[str]] = None,
            horizontal_offset: Optional[pulumi.Input[str]] = None,
            image_file: Optional[pulumi.Input[str]] = None,
            image_process: Optional[pulumi.Input[str]] = None,
            image_type: Optional[pulumi.Input[str]] = None,
            image_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            position: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            timeline_duration: Optional[pulumi.Input[str]] = None,
            timeline_start: Optional[pulumi.Input[str]] = None,
            vertical_offset: Optional[pulumi.Input[str]] = None,
            watermark_type: Optional[pulumi.Input[str]] = None,
            width: Optional[pulumi.Input[str]] = None) -> 'WatermarkTemplate':
        """
        Get an existing WatermarkTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] height: Specifies height ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        :param pulumi.Input[str] horizontal_offset: Specifies horizontal offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] image_file: Specifies the image file name, e.g. './test.png'.
               Changing this creates a new resource.
        :param pulumi.Input[str] image_process: Specifies the image process. The valid values are:  
               + **TRANSPARENT**: make the background color transparent.
               + **ORIGINAL**: only simple scaling, no other processing.
               + **GRAYED**: make the color image grayed.
        :param pulumi.Input[str] image_type: Specifies the image file type. The valid values are **PNG**, **JPG**
               and **JPEG**. Changing this creates a new resource.
        :param pulumi.Input[str] image_url: The watermark image URL.
        :param pulumi.Input[str] name: Specifies the template name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] position: Specifies the location of the watermark. The valid values are **TOPRIGHT**,
               **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] timeline_duration: Specifies the watermark duration (Unit: second). The value is a digit
               greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        :param pulumi.Input[str] timeline_start: Specifies the watermark start time (Unit: second). The value is a digit
               greater than or equal to **0**. Defaults to: **0**.
        :param pulumi.Input[str] vertical_offset: Specifies vertical offset ratio of the watermark image relative to the
               output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0**.
        :param pulumi.Input[str] watermark_type: The watermark type.
        :param pulumi.Input[str] width: Specifies width ratio of the watermark image relative to the output video.
               The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
               automatically discarded. Defaults to: **0.01**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WatermarkTemplateState.__new__(_WatermarkTemplateState)

        __props__.__dict__["height"] = height
        __props__.__dict__["horizontal_offset"] = horizontal_offset
        __props__.__dict__["image_file"] = image_file
        __props__.__dict__["image_process"] = image_process
        __props__.__dict__["image_type"] = image_type
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["name"] = name
        __props__.__dict__["position"] = position
        __props__.__dict__["region"] = region
        __props__.__dict__["timeline_duration"] = timeline_duration
        __props__.__dict__["timeline_start"] = timeline_start
        __props__.__dict__["vertical_offset"] = vertical_offset
        __props__.__dict__["watermark_type"] = watermark_type
        __props__.__dict__["width"] = width
        return WatermarkTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def height(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies height ratio of the watermark image relative to the output video.
        The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0.01**.
        """
        return pulumi.get(self, "height")

    @property
    @pulumi.getter(name="horizontalOffset")
    def horizontal_offset(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies horizontal offset ratio of the watermark image relative to the
        output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0**.
        """
        return pulumi.get(self, "horizontal_offset")

    @property
    @pulumi.getter(name="imageFile")
    def image_file(self) -> pulumi.Output[str]:
        """
        Specifies the image file name, e.g. './test.png'.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "image_file")

    @property
    @pulumi.getter(name="imageProcess")
    def image_process(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the image process. The valid values are:  
        + **TRANSPARENT**: make the background color transparent.
        + **ORIGINAL**: only simple scaling, no other processing.
        + **GRAYED**: make the color image grayed.
        """
        return pulumi.get(self, "image_process")

    @property
    @pulumi.getter(name="imageType")
    def image_type(self) -> pulumi.Output[str]:
        """
        Specifies the image file type. The valid values are **PNG**, **JPG**
        and **JPEG**. Changing this creates a new resource.
        """
        return pulumi.get(self, "image_type")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[str]:
        """
        The watermark image URL.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the template name, which contains a maximum of 128 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def position(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the location of the watermark. The valid values are **TOPRIGHT**,
        **TOPLEFT**, **BOTTOMRIGHT** and **BOTTOMLEFT**. Defaults to: **TOPRIGHT**.
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="timelineDuration")
    def timeline_duration(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the watermark duration (Unit: second). The value is a digit
        greater than or equal to **0**. By default, the watermark lasts until the end of the video.
        """
        return pulumi.get(self, "timeline_duration")

    @property
    @pulumi.getter(name="timelineStart")
    def timeline_start(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the watermark start time (Unit: second). The value is a digit
        greater than or equal to **0**. Defaults to: **0**.
        """
        return pulumi.get(self, "timeline_start")

    @property
    @pulumi.getter(name="verticalOffset")
    def vertical_offset(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies vertical offset ratio of the watermark image relative to the
        output video. The value range is [0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0**.
        """
        return pulumi.get(self, "vertical_offset")

    @property
    @pulumi.getter(name="watermarkType")
    def watermark_type(self) -> pulumi.Output[str]:
        """
        The watermark type.
        """
        return pulumi.get(self, "watermark_type")

    @property
    @pulumi.getter
    def width(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies width ratio of the watermark image relative to the output video.
        The value range is (0, 1). It supports 4 decimal places, e.g. 0.9999, the excess will be
        automatically discarded. Defaults to: **0.01**.
        """
        return pulumi.get(self, "width")

