# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MediaAssetArgs', 'MediaAsset']

@pulumi.input_type
class MediaAssetArgs:
    def __init__(__self__, *,
                 media_type: pulumi.Input[str],
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 auto_preload: Optional[pulumi.Input[bool]] = None,
                 category_id: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_bucket: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_bucket: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 review_template_id: Optional[pulumi.Input[str]] = None,
                 storage_mode: Optional[pulumi.Input[int]] = None,
                 template_group_name: Optional[pulumi.Input[str]] = None,
                 thumbnail: Optional[pulumi.Input['MediaAssetThumbnailArgs']] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MediaAsset resource.
        :param pulumi.Input[str] media_type: Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
               **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
               **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
               **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt the media. If set to **true**,
               `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[bool] auto_preload: Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[int] category_id: Specifies the category ID of the media asset. Default to: **-1**, which means the media
               asset will be categorized into the 'Other' category of system presets.
        :param pulumi.Input[str] description: Specifies the media asset description, which contains a maximum of 1024 characters.
        :param pulumi.Input[str] input_bucket: Specifies the OBS bucket name of media source file.
               Either this field or `url` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] input_path: Specifies the media source file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] labels: Specifies the labels of the media asset, which contains a maximum of 16 labels
               separated by commas.
        :param pulumi.Input[str] name: Specifies the media asset name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] output_bucket: Specifies the output OBS bucket name.
               Changing this creates a new resource.
        :param pulumi.Input[str] output_path: Specifies the output file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[bool] publish: Specifies whether to publish the media. Defaults to: **false**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] review_template_id: Specifies the review template ID. Changing this creates a new resource.
        :param pulumi.Input[int] storage_mode: Specifies the storage mode. The value can be:
               + **0**: copy the media file to VOD bucket.
               + **1**: save the media file in user bucket.
        :param pulumi.Input[str] template_group_name: Specifies the transcoding template group name. If not empty,
               the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        :param pulumi.Input['MediaAssetThumbnailArgs'] thumbnail: Specifies the review thumbnail configurations.
               The object structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[str] url: Specifies the URL of media source file. Currently only http and https protocols
               are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] workflow_name: Specifies the workflow name. If not empty, the uploaded media will be
               processed with the specified workflow. Changing this creates a new resource.
        """
        pulumi.set(__self__, "media_type", media_type)
        if auto_encrypt is not None:
            pulumi.set(__self__, "auto_encrypt", auto_encrypt)
        if auto_preload is not None:
            pulumi.set(__self__, "auto_preload", auto_preload)
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if input_bucket is not None:
            pulumi.set(__self__, "input_bucket", input_bucket)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_bucket is not None:
            pulumi.set(__self__, "output_bucket", output_bucket)
        if output_path is not None:
            pulumi.set(__self__, "output_path", output_path)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if review_template_id is not None:
            pulumi.set(__self__, "review_template_id", review_template_id)
        if storage_mode is not None:
            pulumi.set(__self__, "storage_mode", storage_mode)
        if template_group_name is not None:
            pulumi.set(__self__, "template_group_name", template_group_name)
        if thumbnail is not None:
            pulumi.set(__self__, "thumbnail", thumbnail)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workflow_name is not None:
            pulumi.set(__self__, "workflow_name", workflow_name)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> pulumi.Input[str]:
        """
        Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
        **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
        **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
        **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "media_type", value)

    @property
    @pulumi.getter(name="autoEncrypt")
    def auto_encrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically encrypt the media. If set to **true**,
        `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_encrypt")

    @auto_encrypt.setter
    def auto_encrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_encrypt", value)

    @property
    @pulumi.getter(name="autoPreload")
    def auto_preload(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_preload")

    @auto_preload.setter
    def auto_preload(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_preload", value)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the category ID of the media asset. Default to: **-1**, which means the media
        asset will be categorized into the 'Other' category of system presets.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "category_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media asset description, which contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inputBucket")
    def input_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS bucket name of media source file.
        Either this field or `url` must be specified. Changing this creates a new resource.
        """
        return pulumi.get(self, "input_bucket")

    @input_bucket.setter
    def input_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_bucket", value)

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media source file path in the OBS bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "input_path")

    @input_path.setter
    def input_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_path", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the labels of the media asset, which contains a maximum of 16 labels
        separated by commas.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media asset name, which contains a maximum of 128 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputBucket")
    def output_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output OBS bucket name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "output_bucket")

    @output_bucket.setter
    def output_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_bucket", value)

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output file path in the OBS bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "output_path")

    @output_path.setter
    def output_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_path", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to publish the media. Defaults to: **false**.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reviewTemplateId")
    def review_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the review template ID. Changing this creates a new resource.
        """
        return pulumi.get(self, "review_template_id")

    @review_template_id.setter
    def review_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "review_template_id", value)

    @property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the storage mode. The value can be:
        + **0**: copy the media file to VOD bucket.
        + **1**: save the media file in user bucket.
        """
        return pulumi.get(self, "storage_mode")

    @storage_mode.setter
    def storage_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_mode", value)

    @property
    @pulumi.getter(name="templateGroupName")
    def template_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the transcoding template group name. If not empty,
        the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        """
        return pulumi.get(self, "template_group_name")

    @template_group_name.setter
    def template_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_group_name", value)

    @property
    @pulumi.getter
    def thumbnail(self) -> Optional[pulumi.Input['MediaAssetThumbnailArgs']]:
        """
        Specifies the review thumbnail configurations.
        The object structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "thumbnail")

    @thumbnail.setter
    def thumbnail(self, value: Optional[pulumi.Input['MediaAssetThumbnailArgs']]):
        pulumi.set(self, "thumbnail", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the URL of media source file. Currently only http and https protocols
        are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the workflow name. If not empty, the uploaded media will be
        processed with the specified workflow. Changing this creates a new resource.
        """
        return pulumi.get(self, "workflow_name")

    @workflow_name.setter
    def workflow_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_name", value)


@pulumi.input_type
class _MediaAssetState:
    def __init__(__self__, *,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 auto_preload: Optional[pulumi.Input[bool]] = None,
                 category_id: Optional[pulumi.Input[int]] = None,
                 category_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_bucket: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[str]] = None,
                 media_name: Optional[pulumi.Input[str]] = None,
                 media_type: Optional[pulumi.Input[str]] = None,
                 media_url: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_bucket: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 review_template_id: Optional[pulumi.Input[str]] = None,
                 storage_mode: Optional[pulumi.Input[int]] = None,
                 template_group_name: Optional[pulumi.Input[str]] = None,
                 thumbnail: Optional[pulumi.Input['MediaAssetThumbnailArgs']] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MediaAsset resources.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt the media. If set to **true**,
               `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[bool] auto_preload: Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[int] category_id: Specifies the category ID of the media asset. Default to: **-1**, which means the media
               asset will be categorized into the 'Other' category of system presets.
        :param pulumi.Input[str] category_name: The category name of the media asset.
        :param pulumi.Input[str] description: Specifies the media asset description, which contains a maximum of 1024 characters.
        :param pulumi.Input[str] input_bucket: Specifies the OBS bucket name of media source file.
               Either this field or `url` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] input_path: Specifies the media source file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] labels: Specifies the labels of the media asset, which contains a maximum of 16 labels
               separated by commas.
        :param pulumi.Input[str] media_name: The name of the media file.
        :param pulumi.Input[str] media_type: Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
               **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
               **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
               **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        :param pulumi.Input[str] media_url: The URL of original media file.
        :param pulumi.Input[str] name: Specifies the media asset name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] output_bucket: Specifies the output OBS bucket name.
               Changing this creates a new resource.
        :param pulumi.Input[str] output_path: Specifies the output file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[bool] publish: Specifies whether to publish the media. Defaults to: **false**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] review_template_id: Specifies the review template ID. Changing this creates a new resource.
        :param pulumi.Input[int] storage_mode: Specifies the storage mode. The value can be:
               + **0**: copy the media file to VOD bucket.
               + **1**: save the media file in user bucket.
        :param pulumi.Input[str] template_group_name: Specifies the transcoding template group name. If not empty,
               the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        :param pulumi.Input['MediaAssetThumbnailArgs'] thumbnail: Specifies the review thumbnail configurations.
               The object structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[str] url: Specifies the URL of media source file. Currently only http and https protocols
               are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] workflow_name: Specifies the workflow name. If not empty, the uploaded media will be
               processed with the specified workflow. Changing this creates a new resource.
        """
        if auto_encrypt is not None:
            pulumi.set(__self__, "auto_encrypt", auto_encrypt)
        if auto_preload is not None:
            pulumi.set(__self__, "auto_preload", auto_preload)
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if category_name is not None:
            pulumi.set(__self__, "category_name", category_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if input_bucket is not None:
            pulumi.set(__self__, "input_bucket", input_bucket)
        if input_path is not None:
            pulumi.set(__self__, "input_path", input_path)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if media_name is not None:
            pulumi.set(__self__, "media_name", media_name)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)
        if media_url is not None:
            pulumi.set(__self__, "media_url", media_url)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_bucket is not None:
            pulumi.set(__self__, "output_bucket", output_bucket)
        if output_path is not None:
            pulumi.set(__self__, "output_path", output_path)
        if publish is not None:
            pulumi.set(__self__, "publish", publish)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if review_template_id is not None:
            pulumi.set(__self__, "review_template_id", review_template_id)
        if storage_mode is not None:
            pulumi.set(__self__, "storage_mode", storage_mode)
        if template_group_name is not None:
            pulumi.set(__self__, "template_group_name", template_group_name)
        if thumbnail is not None:
            pulumi.set(__self__, "thumbnail", thumbnail)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workflow_name is not None:
            pulumi.set(__self__, "workflow_name", workflow_name)

    @property
    @pulumi.getter(name="autoEncrypt")
    def auto_encrypt(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically encrypt the media. If set to **true**,
        `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_encrypt")

    @auto_encrypt.setter
    def auto_encrypt(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_encrypt", value)

    @property
    @pulumi.getter(name="autoPreload")
    def auto_preload(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_preload")

    @auto_preload.setter
    def auto_preload(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_preload", value)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the category ID of the media asset. Default to: **-1**, which means the media
        asset will be categorized into the 'Other' category of system presets.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "category_id", value)

    @property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> Optional[pulumi.Input[str]]:
        """
        The category name of the media asset.
        """
        return pulumi.get(self, "category_name")

    @category_name.setter
    def category_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media asset description, which contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inputBucket")
    def input_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS bucket name of media source file.
        Either this field or `url` must be specified. Changing this creates a new resource.
        """
        return pulumi.get(self, "input_bucket")

    @input_bucket.setter
    def input_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_bucket", value)

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media source file path in the OBS bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "input_path")

    @input_path.setter
    def input_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "input_path", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the labels of the media asset, which contains a maximum of 16 labels
        separated by commas.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="mediaName")
    def media_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the media file.
        """
        return pulumi.get(self, "media_name")

    @media_name.setter
    def media_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_name", value)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
        **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
        **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
        **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_type", value)

    @property
    @pulumi.getter(name="mediaUrl")
    def media_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of original media file.
        """
        return pulumi.get(self, "media_url")

    @media_url.setter
    def media_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_url", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the media asset name, which contains a maximum of 128 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputBucket")
    def output_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output OBS bucket name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "output_bucket")

    @output_bucket.setter
    def output_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_bucket", value)

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the output file path in the OBS bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "output_path")

    @output_path.setter
    def output_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_path", value)

    @property
    @pulumi.getter
    def publish(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to publish the media. Defaults to: **false**.
        """
        return pulumi.get(self, "publish")

    @publish.setter
    def publish(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "publish", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="reviewTemplateId")
    def review_template_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the review template ID. Changing this creates a new resource.
        """
        return pulumi.get(self, "review_template_id")

    @review_template_id.setter
    def review_template_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "review_template_id", value)

    @property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the storage mode. The value can be:
        + **0**: copy the media file to VOD bucket.
        + **1**: save the media file in user bucket.
        """
        return pulumi.get(self, "storage_mode")

    @storage_mode.setter
    def storage_mode(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_mode", value)

    @property
    @pulumi.getter(name="templateGroupName")
    def template_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the transcoding template group name. If not empty,
        the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        """
        return pulumi.get(self, "template_group_name")

    @template_group_name.setter
    def template_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_group_name", value)

    @property
    @pulumi.getter
    def thumbnail(self) -> Optional[pulumi.Input['MediaAssetThumbnailArgs']]:
        """
        Specifies the review thumbnail configurations.
        The object structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "thumbnail")

    @thumbnail.setter
    def thumbnail(self, value: Optional[pulumi.Input['MediaAssetThumbnailArgs']]):
        pulumi.set(self, "thumbnail", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the URL of media source file. Currently only http and https protocols
        are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the workflow name. If not empty, the uploaded media will be
        processed with the specified workflow. Changing this creates a new resource.
        """
        return pulumi.get(self, "workflow_name")

    @workflow_name.setter
    def workflow_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workflow_name", value)


class MediaAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 auto_preload: Optional[pulumi.Input[bool]] = None,
                 category_id: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_bucket: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[str]] = None,
                 media_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_bucket: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 review_template_id: Optional[pulumi.Input[str]] = None,
                 storage_mode: Optional[pulumi.Input[int]] = None,
                 template_group_name: Optional[pulumi.Input[str]] = None,
                 thumbnail: Optional[pulumi.Input[pulumi.InputType['MediaAssetThumbnailArgs']]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VOD media asset resource within HuaweiCloud.

        ## Example Usage
        ### Upload media asset from OBS

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        bucket_name = config.require_object("bucketName")
        object_path = config.require_object("objectPath")
        test = huaweicloud.vod.MediaAsset("test",
            media_type="MP4",
            input_bucket=bucket_name,
            input_path=object_path,
            description="test video",
            labels="test_label_1,test_lable_2,test_label_3",
            thumbnail=huaweicloud.vod.MediaAssetThumbnailArgs(
                type="time",
                time=1,
            ))
        ```
        ### Upload media asset by URL

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        media_url = config.require_object("mediaUrl")
        test = huaweicloud.vod.MediaAsset("test",
            media_type="MP4",
            url=media_url,
            description="test video",
            labels="test_label_1,test_lable_2,test_label_3",
            thumbnail=huaweicloud.vod.MediaAssetThumbnailArgs(
                type="time",
                time=1,
            ))
        ```

        ## Import

        The media asset can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/mediaAsset:MediaAsset test 8754976729b8a2ba745d01036edded2b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`url`, `input_bucket`, `input_path`, `output_bucket`, `output_path`, `storage_mode`, `template_group_name`, `workflow_name`, `publish`, `auto_encrypt`, `auto_preload`, `review_template_id`, `thumbnail`. It is generally recommended running `terraform plan` after importing a media asset. You can then decide if changes should be applied to the media asset, or the resource definition should be updated to align with the media asset. Also you can ignore changes as below. resource "huaweicloud_vod_media_asset" "test" {

         ...

         lifecycle {

         ignore_changes = [

         url, input_bucket, input_path, output_bucket, output_path, storage_mode, template_group_name,

         workflow_name, publish, auto_encrypt, auto_preload, review_template_id, thumbnail,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt the media. If set to **true**,
               `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[bool] auto_preload: Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[int] category_id: Specifies the category ID of the media asset. Default to: **-1**, which means the media
               asset will be categorized into the 'Other' category of system presets.
        :param pulumi.Input[str] description: Specifies the media asset description, which contains a maximum of 1024 characters.
        :param pulumi.Input[str] input_bucket: Specifies the OBS bucket name of media source file.
               Either this field or `url` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] input_path: Specifies the media source file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] labels: Specifies the labels of the media asset, which contains a maximum of 16 labels
               separated by commas.
        :param pulumi.Input[str] media_type: Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
               **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
               **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
               **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the media asset name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] output_bucket: Specifies the output OBS bucket name.
               Changing this creates a new resource.
        :param pulumi.Input[str] output_path: Specifies the output file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[bool] publish: Specifies whether to publish the media. Defaults to: **false**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] review_template_id: Specifies the review template ID. Changing this creates a new resource.
        :param pulumi.Input[int] storage_mode: Specifies the storage mode. The value can be:
               + **0**: copy the media file to VOD bucket.
               + **1**: save the media file in user bucket.
        :param pulumi.Input[str] template_group_name: Specifies the transcoding template group name. If not empty,
               the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MediaAssetThumbnailArgs']] thumbnail: Specifies the review thumbnail configurations.
               The object structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[str] url: Specifies the URL of media source file. Currently only http and https protocols
               are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] workflow_name: Specifies the workflow name. If not empty, the uploaded media will be
               processed with the specified workflow. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MediaAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VOD media asset resource within HuaweiCloud.

        ## Example Usage
        ### Upload media asset from OBS

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        bucket_name = config.require_object("bucketName")
        object_path = config.require_object("objectPath")
        test = huaweicloud.vod.MediaAsset("test",
            media_type="MP4",
            input_bucket=bucket_name,
            input_path=object_path,
            description="test video",
            labels="test_label_1,test_lable_2,test_label_3",
            thumbnail=huaweicloud.vod.MediaAssetThumbnailArgs(
                type="time",
                time=1,
            ))
        ```
        ### Upload media asset by URL

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        media_url = config.require_object("mediaUrl")
        test = huaweicloud.vod.MediaAsset("test",
            media_type="MP4",
            url=media_url,
            description="test video",
            labels="test_label_1,test_lable_2,test_label_3",
            thumbnail=huaweicloud.vod.MediaAssetThumbnailArgs(
                type="time",
                time=1,
            ))
        ```

        ## Import

        The media asset can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Vod/mediaAsset:MediaAsset test 8754976729b8a2ba745d01036edded2b
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`url`, `input_bucket`, `input_path`, `output_bucket`, `output_path`, `storage_mode`, `template_group_name`, `workflow_name`, `publish`, `auto_encrypt`, `auto_preload`, `review_template_id`, `thumbnail`. It is generally recommended running `terraform plan` after importing a media asset. You can then decide if changes should be applied to the media asset, or the resource definition should be updated to align with the media asset. Also you can ignore changes as below. resource "huaweicloud_vod_media_asset" "test" {

         ...

         lifecycle {

         ignore_changes = [

         url, input_bucket, input_path, output_bucket, output_path, storage_mode, template_group_name,

         workflow_name, publish, auto_encrypt, auto_preload, review_template_id, thumbnail,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param MediaAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MediaAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_encrypt: Optional[pulumi.Input[bool]] = None,
                 auto_preload: Optional[pulumi.Input[bool]] = None,
                 category_id: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 input_bucket: Optional[pulumi.Input[str]] = None,
                 input_path: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[str]] = None,
                 media_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_bucket: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 publish: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 review_template_id: Optional[pulumi.Input[str]] = None,
                 storage_mode: Optional[pulumi.Input[int]] = None,
                 template_group_name: Optional[pulumi.Input[str]] = None,
                 thumbnail: Optional[pulumi.Input[pulumi.InputType['MediaAssetThumbnailArgs']]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 workflow_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MediaAssetArgs.__new__(MediaAssetArgs)

            __props__.__dict__["auto_encrypt"] = auto_encrypt
            __props__.__dict__["auto_preload"] = auto_preload
            __props__.__dict__["category_id"] = category_id
            __props__.__dict__["description"] = description
            __props__.__dict__["input_bucket"] = input_bucket
            __props__.__dict__["input_path"] = input_path
            __props__.__dict__["labels"] = labels
            if media_type is None and not opts.urn:
                raise TypeError("Missing required property 'media_type'")
            __props__.__dict__["media_type"] = media_type
            __props__.__dict__["name"] = name
            __props__.__dict__["output_bucket"] = output_bucket
            __props__.__dict__["output_path"] = output_path
            __props__.__dict__["publish"] = publish
            __props__.__dict__["region"] = region
            __props__.__dict__["review_template_id"] = review_template_id
            __props__.__dict__["storage_mode"] = storage_mode
            __props__.__dict__["template_group_name"] = template_group_name
            __props__.__dict__["thumbnail"] = thumbnail
            __props__.__dict__["url"] = url
            __props__.__dict__["workflow_name"] = workflow_name
            __props__.__dict__["category_name"] = None
            __props__.__dict__["media_name"] = None
            __props__.__dict__["media_url"] = None
        super(MediaAsset, __self__).__init__(
            'huaweicloud:Vod/mediaAsset:MediaAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_encrypt: Optional[pulumi.Input[bool]] = None,
            auto_preload: Optional[pulumi.Input[bool]] = None,
            category_id: Optional[pulumi.Input[int]] = None,
            category_name: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            input_bucket: Optional[pulumi.Input[str]] = None,
            input_path: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[str]] = None,
            media_name: Optional[pulumi.Input[str]] = None,
            media_type: Optional[pulumi.Input[str]] = None,
            media_url: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_bucket: Optional[pulumi.Input[str]] = None,
            output_path: Optional[pulumi.Input[str]] = None,
            publish: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[str]] = None,
            review_template_id: Optional[pulumi.Input[str]] = None,
            storage_mode: Optional[pulumi.Input[int]] = None,
            template_group_name: Optional[pulumi.Input[str]] = None,
            thumbnail: Optional[pulumi.Input[pulumi.InputType['MediaAssetThumbnailArgs']]] = None,
            url: Optional[pulumi.Input[str]] = None,
            workflow_name: Optional[pulumi.Input[str]] = None) -> 'MediaAsset':
        """
        Get an existing MediaAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] auto_encrypt: Specifies whether to automatically encrypt the media. If set to **true**,
               `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[bool] auto_preload: Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
               Changing this creates a new resource.
        :param pulumi.Input[int] category_id: Specifies the category ID of the media asset. Default to: **-1**, which means the media
               asset will be categorized into the 'Other' category of system presets.
        :param pulumi.Input[str] category_name: The category name of the media asset.
        :param pulumi.Input[str] description: Specifies the media asset description, which contains a maximum of 1024 characters.
        :param pulumi.Input[str] input_bucket: Specifies the OBS bucket name of media source file.
               Either this field or `url` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] input_path: Specifies the media source file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[str] labels: Specifies the labels of the media asset, which contains a maximum of 16 labels
               separated by commas.
        :param pulumi.Input[str] media_name: The name of the media file.
        :param pulumi.Input[str] media_type: Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
               **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
               **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
               **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        :param pulumi.Input[str] media_url: The URL of original media file.
        :param pulumi.Input[str] name: Specifies the media asset name, which contains a maximum of 128 characters.
        :param pulumi.Input[str] output_bucket: Specifies the output OBS bucket name.
               Changing this creates a new resource.
        :param pulumi.Input[str] output_path: Specifies the output file path in the OBS bucket.
               Changing this creates a new resource.
        :param pulumi.Input[bool] publish: Specifies whether to publish the media. Defaults to: **false**.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] review_template_id: Specifies the review template ID. Changing this creates a new resource.
        :param pulumi.Input[int] storage_mode: Specifies the storage mode. The value can be:
               + **0**: copy the media file to VOD bucket.
               + **1**: save the media file in user bucket.
        :param pulumi.Input[str] template_group_name: Specifies the transcoding template group name. If not empty,
               the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        :param pulumi.Input[pulumi.InputType['MediaAssetThumbnailArgs']] thumbnail: Specifies the review thumbnail configurations.
               The object structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[str] url: Specifies the URL of media source file. Currently only http and https protocols
               are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        :param pulumi.Input[str] workflow_name: Specifies the workflow name. If not empty, the uploaded media will be
               processed with the specified workflow. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MediaAssetState.__new__(_MediaAssetState)

        __props__.__dict__["auto_encrypt"] = auto_encrypt
        __props__.__dict__["auto_preload"] = auto_preload
        __props__.__dict__["category_id"] = category_id
        __props__.__dict__["category_name"] = category_name
        __props__.__dict__["description"] = description
        __props__.__dict__["input_bucket"] = input_bucket
        __props__.__dict__["input_path"] = input_path
        __props__.__dict__["labels"] = labels
        __props__.__dict__["media_name"] = media_name
        __props__.__dict__["media_type"] = media_type
        __props__.__dict__["media_url"] = media_url
        __props__.__dict__["name"] = name
        __props__.__dict__["output_bucket"] = output_bucket
        __props__.__dict__["output_path"] = output_path
        __props__.__dict__["publish"] = publish
        __props__.__dict__["region"] = region
        __props__.__dict__["review_template_id"] = review_template_id
        __props__.__dict__["storage_mode"] = storage_mode
        __props__.__dict__["template_group_name"] = template_group_name
        __props__.__dict__["thumbnail"] = thumbnail
        __props__.__dict__["url"] = url
        __props__.__dict__["workflow_name"] = workflow_name
        return MediaAsset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoEncrypt")
    def auto_encrypt(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically encrypt the media. If set to **true**,
        `template_group_name` must be specified, and the output format of transcoding is **HLS**. Defaults to: **false**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_encrypt")

    @property
    @pulumi.getter(name="autoPreload")
    def auto_preload(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to automatically warm up the media to CDN. Defaults to: **false**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "auto_preload")

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> pulumi.Output[int]:
        """
        Specifies the category ID of the media asset. Default to: **-1**, which means the media
        asset will be categorized into the 'Other' category of system presets.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter(name="categoryName")
    def category_name(self) -> pulumi.Output[str]:
        """
        The category name of the media asset.
        """
        return pulumi.get(self, "category_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the media asset description, which contains a maximum of 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="inputBucket")
    def input_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the OBS bucket name of media source file.
        Either this field or `url` must be specified. Changing this creates a new resource.
        """
        return pulumi.get(self, "input_bucket")

    @property
    @pulumi.getter(name="inputPath")
    def input_path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the media source file path in the OBS bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "input_path")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the labels of the media asset, which contains a maximum of 16 labels
        separated by commas.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="mediaName")
    def media_name(self) -> pulumi.Output[str]:
        """
        The name of the media file.
        """
        return pulumi.get(self, "media_name")

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> pulumi.Output[str]:
        """
        Specifies the media type. Valid values are: **MP4**, **TS**, **MOV**,
        **MXF**, **MPG**, **FLV**, **WMV**, **AVI**, **M4V**, **F4V**, **MPEG**, **3GP**, **ASF**, **MKV**, **HLS**,
        **M3U8**, **MP3**, **OGG**, **WAV**, **WMA**, **APE**, **FLAC**, **AAC**, **AC3**, **MMF**, **AMR**, **M4A**,
        **M4R**, **WV**, **MP2**. Changing this creates a new resource.
        """
        return pulumi.get(self, "media_type")

    @property
    @pulumi.getter(name="mediaUrl")
    def media_url(self) -> pulumi.Output[str]:
        """
        The URL of original media file.
        """
        return pulumi.get(self, "media_url")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the media asset name, which contains a maximum of 128 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputBucket")
    def output_bucket(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the output OBS bucket name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "output_bucket")

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the output file path in the OBS bucket.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "output_path")

    @property
    @pulumi.getter
    def publish(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to publish the media. Defaults to: **false**.
        """
        return pulumi.get(self, "publish")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="reviewTemplateId")
    def review_template_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the review template ID. Changing this creates a new resource.
        """
        return pulumi.get(self, "review_template_id")

    @property
    @pulumi.getter(name="storageMode")
    def storage_mode(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the storage mode. The value can be:
        + **0**: copy the media file to VOD bucket.
        + **1**: save the media file in user bucket.
        """
        return pulumi.get(self, "storage_mode")

    @property
    @pulumi.getter(name="templateGroupName")
    def template_group_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the transcoding template group name. If not empty,
        the uploaded media will be transcoded with the specified transcoding template group. Changing this creates a new resource.
        """
        return pulumi.get(self, "template_group_name")

    @property
    @pulumi.getter
    def thumbnail(self) -> pulumi.Output[Optional['outputs.MediaAssetThumbnail']]:
        """
        Specifies the review thumbnail configurations.
        The object structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "thumbnail")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the URL of media source file. Currently only http and https protocols
        are supported. Either this field or `input_bucket` must be specified. Changing this creates a new resource.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="workflowName")
    def workflow_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the workflow name. If not empty, the uploaded media will be
        processed with the specified workflow. Changing this creates a new resource.
        """
        return pulumi.get(self, "workflow_name")

