# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SubscriptionArgs', 'Subscription']

@pulumi.input_type
class SubscriptionArgs:
    def __init__(__self__, *,
                 endpoint: pulumi.Input[str],
                 protocol: pulumi.Input[str],
                 topic_urn: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Subscription resource.
        :param pulumi.Input[str] endpoint: Message endpoint. Changing this parameter will create a new resource.
               + **For an HTTP subscription**, the endpoint starts with http://.
               + **For an HTTPS subscription**, the endpoint starts with https://.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
               + **For a functionstage subscription**, the endpoint is a function urn.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[str] protocol: Specifies the protocol of the message endpoint. Currently, email, sms, http,
               https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] topic_urn: Specifies the resource identifier of a topic, which is unique.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SMN subscription resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] remark: Remark information. The remarks must be a UTF-8-coded character string
               containing 128 bytes.
        """
        pulumi.set(__self__, "endpoint", endpoint)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "topic_urn", topic_urn)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Input[str]:
        """
        Message endpoint. Changing this parameter will create a new resource.
        + **For an HTTP subscription**, the endpoint starts with http://.
        + **For an HTTPS subscription**, the endpoint starts with https://.
        + **For an email subscription**, the endpoint is an mail address.
        + **For an SMS message subscription**, the endpoint is a phone number,
        the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
        + **For a functionstage subscription**, the endpoint is a function urn.
        + **For a functiongraph subscription**, the endpoint is a workflow ID.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        Specifies the protocol of the message endpoint. Currently, email, sms, http,
        https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Input[str]:
        """
        Specifies the resource identifier of a topic, which is unique.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_urn", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SMN subscription resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[str]]:
        """
        Remark information. The remarks must be a UTF-8-coded character string
        containing 128 bytes.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remark", value)


@pulumi.input_type
class _SubscriptionState:
    def __init__(__self__, *,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 subscription_urn: Optional[pulumi.Input[str]] = None,
                 topic_urn: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Subscription resources.
        :param pulumi.Input[str] endpoint: Message endpoint. Changing this parameter will create a new resource.
               + **For an HTTP subscription**, the endpoint starts with http://.
               + **For an HTTPS subscription**, the endpoint starts with https://.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
               + **For a functionstage subscription**, the endpoint is a function urn.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[str] owner: Project ID of the topic creator.
        :param pulumi.Input[str] protocol: Specifies the protocol of the message endpoint. Currently, email, sms, http,
               https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SMN subscription resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] remark: Remark information. The remarks must be a UTF-8-coded character string
               containing 128 bytes.
        :param pulumi.Input[int] status: Subscription status. 0 indicates that the subscription is not confirmed. 1 indicates that the subscription
               is confirmed. 3 indicates that the subscription is canceled.
        :param pulumi.Input[str] subscription_urn: Resource identifier of a subscription, which is unique.
        :param pulumi.Input[str] topic_urn: Specifies the resource identifier of a topic, which is unique.
               Changing this parameter will create a new resource.
        """
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remark is not None:
            pulumi.set(__self__, "remark", remark)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_urn is not None:
            pulumi.set(__self__, "subscription_urn", subscription_urn)
        if topic_urn is not None:
            pulumi.set(__self__, "topic_urn", topic_urn)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Message endpoint. Changing this parameter will create a new resource.
        + **For an HTTP subscription**, the endpoint starts with http://.
        + **For an HTTPS subscription**, the endpoint starts with https://.
        + **For an email subscription**, the endpoint is an mail address.
        + **For an SMS message subscription**, the endpoint is a phone number,
        the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
        + **For a functionstage subscription**, the endpoint is a function urn.
        + **For a functiongraph subscription**, the endpoint is a workflow ID.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Project ID of the topic creator.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol of the message endpoint. Currently, email, sms, http,
        https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the SMN subscription resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def remark(self) -> Optional[pulumi.Input[str]]:
        """
        Remark information. The remarks must be a UTF-8-coded character string
        containing 128 bytes.
        """
        return pulumi.get(self, "remark")

    @remark.setter
    def remark(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remark", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        Subscription status. 0 indicates that the subscription is not confirmed. 1 indicates that the subscription
        is confirmed. 3 indicates that the subscription is canceled.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subscriptionUrn")
    def subscription_urn(self) -> Optional[pulumi.Input[str]]:
        """
        Resource identifier of a subscription, which is unique.
        """
        return pulumi.get(self, "subscription_urn")

    @subscription_urn.setter
    def subscription_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription_urn", value)

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the resource identifier of a topic, which is unique.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "topic_urn")

    @topic_urn.setter
    def topic_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_urn", value)


class Subscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 topic_urn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an SMN subscription resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        topic1 = huaweicloud.smn.Topic("topic1", display_name="The display name of topic_1")
        subscription1 = huaweicloud.smn.Subscription("subscription1",
            topic_urn=topic1.id,
            endpoint="mailtest@gmail.com",
            protocol="email",
            remark="O&M")
        subscription2 = huaweicloud.smn.Subscription("subscription2",
            topic_urn=topic1.id,
            endpoint="13600000000",
            protocol="sms",
            remark="O&M")
        ```

        ## Import

        SMN subscription can be imported using the `id` (subscription urn), e.g.

        ```sh
         $ pulumi import huaweicloud:Smn/subscription:Subscription subscription_1 urn:smn:cn-north-4:0970dd7a1300f5672ff2c003c60ae115:topic_1:a2aa5a1f66df494184f4e108398de1a6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint: Message endpoint. Changing this parameter will create a new resource.
               + **For an HTTP subscription**, the endpoint starts with http://.
               + **For an HTTPS subscription**, the endpoint starts with https://.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
               + **For a functionstage subscription**, the endpoint is a function urn.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[str] protocol: Specifies the protocol of the message endpoint. Currently, email, sms, http,
               https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SMN subscription resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] remark: Remark information. The remarks must be a UTF-8-coded character string
               containing 128 bytes.
        :param pulumi.Input[str] topic_urn: Specifies the resource identifier of a topic, which is unique.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an SMN subscription resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        topic1 = huaweicloud.smn.Topic("topic1", display_name="The display name of topic_1")
        subscription1 = huaweicloud.smn.Subscription("subscription1",
            topic_urn=topic1.id,
            endpoint="mailtest@gmail.com",
            protocol="email",
            remark="O&M")
        subscription2 = huaweicloud.smn.Subscription("subscription2",
            topic_urn=topic1.id,
            endpoint="13600000000",
            protocol="sms",
            remark="O&M")
        ```

        ## Import

        SMN subscription can be imported using the `id` (subscription urn), e.g.

        ```sh
         $ pulumi import huaweicloud:Smn/subscription:Subscription subscription_1 urn:smn:cn-north-4:0970dd7a1300f5672ff2c003c60ae115:topic_1:a2aa5a1f66df494184f4e108398de1a6
        ```

        :param str resource_name: The name of the resource.
        :param SubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remark: Optional[pulumi.Input[str]] = None,
                 topic_urn: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SubscriptionArgs.__new__(SubscriptionArgs)

            if endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'endpoint'")
            __props__.__dict__["endpoint"] = endpoint
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["remark"] = remark
            if topic_urn is None and not opts.urn:
                raise TypeError("Missing required property 'topic_urn'")
            __props__.__dict__["topic_urn"] = topic_urn
            __props__.__dict__["owner"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subscription_urn"] = None
        super(Subscription, __self__).__init__(
            'huaweicloud:Smn/subscription:Subscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            owner: Optional[pulumi.Input[str]] = None,
            protocol: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            remark: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[int]] = None,
            subscription_urn: Optional[pulumi.Input[str]] = None,
            topic_urn: Optional[pulumi.Input[str]] = None) -> 'Subscription':
        """
        Get an existing Subscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint: Message endpoint. Changing this parameter will create a new resource.
               + **For an HTTP subscription**, the endpoint starts with http://.
               + **For an HTTPS subscription**, the endpoint starts with https://.
               + **For an email subscription**, the endpoint is an mail address.
               + **For an SMS message subscription**, the endpoint is a phone number,
               the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
               + **For a functionstage subscription**, the endpoint is a function urn.
               + **For a functiongraph subscription**, the endpoint is a workflow ID.
        :param pulumi.Input[str] owner: Project ID of the topic creator.
        :param pulumi.Input[str] protocol: Specifies the protocol of the message endpoint. Currently, email, sms, http,
               https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the SMN subscription resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] remark: Remark information. The remarks must be a UTF-8-coded character string
               containing 128 bytes.
        :param pulumi.Input[int] status: Subscription status. 0 indicates that the subscription is not confirmed. 1 indicates that the subscription
               is confirmed. 3 indicates that the subscription is canceled.
        :param pulumi.Input[str] subscription_urn: Resource identifier of a subscription, which is unique.
        :param pulumi.Input[str] topic_urn: Specifies the resource identifier of a topic, which is unique.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SubscriptionState.__new__(_SubscriptionState)

        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["owner"] = owner
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["remark"] = remark
        __props__.__dict__["status"] = status
        __props__.__dict__["subscription_urn"] = subscription_urn
        __props__.__dict__["topic_urn"] = topic_urn
        return Subscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Message endpoint. Changing this parameter will create a new resource.
        + **For an HTTP subscription**, the endpoint starts with http://.
        + **For an HTTPS subscription**, the endpoint starts with https://.
        + **For an email subscription**, the endpoint is an mail address.
        + **For an SMS message subscription**, the endpoint is a phone number,
        the format is \\[+\\]\\[country code\\]\\[phone number\\], e.g. +86185xxxx0000.
        + **For a functionstage subscription**, the endpoint is a function urn.
        + **For a functiongraph subscription**, the endpoint is a workflow ID.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def owner(self) -> pulumi.Output[str]:
        """
        Project ID of the topic creator.
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        Specifies the protocol of the message endpoint. Currently, email, sms, http,
        https, functionstage and functiongraph are supported. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the SMN subscription resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def remark(self) -> pulumi.Output[Optional[str]]:
        """
        Remark information. The remarks must be a UTF-8-coded character string
        containing 128 bytes.
        """
        return pulumi.get(self, "remark")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        Subscription status. 0 indicates that the subscription is not confirmed. 1 indicates that the subscription
        is confirmed. 3 indicates that the subscription is canceled.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subscriptionUrn")
    def subscription_urn(self) -> pulumi.Output[str]:
        """
        Resource identifier of a subscription, which is unique.
        """
        return pulumi.get(self, "subscription_urn")

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> pulumi.Output[str]:
        """
        Specifies the resource identifier of a topic, which is unique.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "topic_urn")

