# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetTopicsTopicResult',
]

@pulumi.output_type
class GetTopicsTopicResult(dict):
    def __init__(__self__, *,
                 display_name: str,
                 enterprise_project_id: str,
                 id: str,
                 name: str,
                 push_policy: int,
                 tags: Mapping[str, str],
                 topic_urn: str):
        """
        :param str display_name: Specifies the topic display name.
        :param str enterprise_project_id: Specifies the enterprise project ID of the SMN topic.
        :param str id: The topic ID. The value is the topic URN.
        :param str name: Specifies the name of the topic.
        :param int push_policy: Message pushing policy.
               + **0**: indicates that the message sending fails and the message is cached in the queue.
               + **1**: indicates that the failed message is discarded.
        :param Mapping[str, str] tags: The tags of the SMN topic, key/value pair format.
        :param str topic_urn: Specifies the topic URN.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "push_policy", push_policy)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "topic_urn", topic_urn)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Specifies the topic display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Specifies the enterprise project ID of the SMN topic.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The topic ID. The value is the topic URN.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushPolicy")
    def push_policy(self) -> int:
        """
        Message pushing policy.
        + **0**: indicates that the message sending fails and the message is cached in the queue.
        + **1**: indicates that the failed message is discarded.
        """
        return pulumi.get(self, "push_policy")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        The tags of the SMN topic, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> str:
        """
        Specifies the topic URN.
        """
        return pulumi.get(self, "topic_urn")


