# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetTopicsResult',
    'AwaitableGetTopicsResult',
    'get_topics',
    'get_topics_output',
]

@pulumi.output_type
class GetTopicsResult:
    """
    A collection of values returned by getTopics.
    """
    def __init__(__self__, display_name=None, enterprise_project_id=None, id=None, name=None, region=None, topic_urn=None, topics=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if topic_urn and not isinstance(topic_urn, str):
            raise TypeError("Expected argument 'topic_urn' to be a str")
        pulumi.set(__self__, "topic_urn", topic_urn)
        if topics and not isinstance(topics, list):
            raise TypeError("Expected argument 'topics' to be a list")
        pulumi.set(__self__, "topics", topics)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The topic display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID of the SMN topic.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="topicUrn")
    def topic_urn(self) -> Optional[str]:
        """
        The topic URN.
        """
        return pulumi.get(self, "topic_urn")

    @property
    @pulumi.getter
    def topics(self) -> Sequence['outputs.GetTopicsTopicResult']:
        """
        An array of SMN topics found. Structure is documented below.
        """
        return pulumi.get(self, "topics")


class AwaitableGetTopicsResult(GetTopicsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTopicsResult(
            display_name=self.display_name,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            region=self.region,
            topic_urn=self.topic_urn,
            topics=self.topics)


def get_topics(display_name: Optional[str] = None,
               enterprise_project_id: Optional[str] = None,
               name: Optional[str] = None,
               region: Optional[str] = None,
               topic_urn: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTopicsResult:
    """
    Use this data source to get a list of SMN topics.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    topic_name = config.require_object("topicName")
    tpoic1 = huaweicloud.Smn.get_topics(name=topic_name)
    ```


    :param str display_name: Specifies the topic display name.
    :param str enterprise_project_id: Specifies the enterprise project ID of the SMN topic.
    :param str name: Specifies the name of the topic.
    :param str region: Specifies the region in which to obtain the SMN topics. If omitted, the
           provider-level region will be used.
    :param str topic_urn: Specifies the topic URN.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['topicUrn'] = topic_urn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Smn/getTopics:getTopics', __args__, opts=opts, typ=GetTopicsResult).value

    return AwaitableGetTopicsResult(
        display_name=__ret__.display_name,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region,
        topic_urn=__ret__.topic_urn,
        topics=__ret__.topics)


@_utilities.lift_output_func(get_topics)
def get_topics_output(display_name: Optional[pulumi.Input[Optional[str]]] = None,
                      enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      region: Optional[pulumi.Input[Optional[str]]] = None,
                      topic_urn: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTopicsResult]:
    """
    Use this data source to get a list of SMN topics.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    topic_name = config.require_object("topicName")
    tpoic1 = huaweicloud.Smn.get_topics(name=topic_name)
    ```


    :param str display_name: Specifies the topic display name.
    :param str enterprise_project_id: Specifies the enterprise project ID of the SMN topic.
    :param str name: Specifies the name of the topic.
    :param str region: Specifies the region in which to obtain the SMN topics. If omitted, the
           provider-level region will be used.
    :param str topic_urn: Specifies the topic URN.
    """
    ...
