# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApiBackendParameter',
    'ApiFunctionBackend',
    'ApiHttpBackend',
    'ApiMockBackend',
    'ApiRequestParameter',
]

@pulumi.output_type
class ApiBackendParameter(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 value: str,
                 description: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str location: Specifies the parameter location, which can be 'PATH', 'QUERY' or 'HEADER'.
        :param str name: Specifies the parameter name. A parameter name consists of 1–32 characters, starting with
               a letter. Only letters, digits, periods (.), hyphens (-), and underscores (_) are allowed.
        :param str value: Specifies the parameter value, which is a string of not more than 255 characters. The
               value varies depending on the parameter type:
               + 'REQUEST': parameter name in `request_parameter`
               + 'CONSTANT': real value of the parameter
               + 'SYSTEM': gateway parameter name
        :param str description: Specifies the description of the parameter. The description cannot exceed 255
               characters.
        :param str type: Specifies the parameter type, which can be 'REQUEST', 'CONSTANT', or 'SYSTEM'.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the parameter location, which can be 'PATH', 'QUERY' or 'HEADER'.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the parameter name. A parameter name consists of 1–32 characters, starting with
        a letter. Only letters, digits, periods (.), hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Specifies the parameter value, which is a string of not more than 255 characters. The
        value varies depending on the parameter type:
        + 'REQUEST': parameter name in `request_parameter`
        + 'CONSTANT': real value of the parameter
        + 'SYSTEM': gateway parameter name
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the parameter. The description cannot exceed 255
        characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the parameter type, which can be 'REQUEST', 'CONSTANT', or 'SYSTEM'.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class ApiFunctionBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "functionUrn":
            suggest = "function_urn"
        elif key == "invocationType":
            suggest = "invocation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiFunctionBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiFunctionBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiFunctionBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 function_urn: str,
                 invocation_type: str,
                 version: str,
                 timeout: Optional[int] = None):
        """
        :param str function_urn: Specifies the function URN.
        :param str invocation_type: Specifies the invocation mode, which can be 'async' or 'sync'.
        :param str version: Specifies the function version.
        :param int timeout: Timeout duration (in ms) for API Gateway to request for FunctionGraph. Defaults to 50000.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "invocation_type", invocation_type)
        pulumi.set(__self__, "version", version)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> str:
        """
        Specifies the function URN.
        """
        return pulumi.get(self, "function_urn")

    @property
    @pulumi.getter(name="invocationType")
    def invocation_type(self) -> str:
        """
        Specifies the invocation mode, which can be 'async' or 'sync'.
        """
        return pulumi.get(self, "invocation_type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the function version.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Timeout duration (in ms) for API Gateway to request for FunctionGraph. Defaults to 50000.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ApiHttpBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlDomain":
            suggest = "url_domain"
        elif key == "vpcChannel":
            suggest = "vpc_channel"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiHttpBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiHttpBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiHttpBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: str,
                 protocol: str,
                 uri: str,
                 timeout: Optional[int] = None,
                 url_domain: Optional[str] = None,
                 vpc_channel: Optional[str] = None):
        """
        :param str method: Specifies the backend request method, including 'GET','POST','PUT' and etc..
        :param str protocol: Specifies the backend request protocol. The value can be 'HTTP' and 'HTTPS'.
        :param str uri: Specifies the backend request path. The value must comply with URI specifications.
        :param int timeout: Timeout duration (in ms) for API Gateway to request for the backend service. Defaults to
               50000.
        :param str url_domain: Specifies the backend service address. An endpoint URL is in the format of
               "domain name (or IP address):port number", with up to 255 characters. This parameter and `vpc_channel` are
               alternative.
        :param str vpc_channel: Specifies the VPC channel ID. This parameter and `url_domain` are alternative.
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "uri", uri)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if url_domain is not None:
            pulumi.set(__self__, "url_domain", url_domain)
        if vpc_channel is not None:
            pulumi.set(__self__, "vpc_channel", vpc_channel)

    @property
    @pulumi.getter
    def method(self) -> str:
        """
        Specifies the backend request method, including 'GET','POST','PUT' and etc..
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Specifies the backend request protocol. The value can be 'HTTP' and 'HTTPS'.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Specifies the backend request path. The value must comply with URI specifications.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[int]:
        """
        Timeout duration (in ms) for API Gateway to request for the backend service. Defaults to
        50000.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="urlDomain")
    def url_domain(self) -> Optional[str]:
        """
        Specifies the backend service address. An endpoint URL is in the format of
        "domain name (or IP address):port number", with up to 255 characters. This parameter and `vpc_channel` are
        alternative.
        """
        return pulumi.get(self, "url_domain")

    @property
    @pulumi.getter(name="vpcChannel")
    def vpc_channel(self) -> Optional[str]:
        """
        Specifies the VPC channel ID. This parameter and `url_domain` are alternative.
        """
        return pulumi.get(self, "vpc_channel")


@pulumi.output_type
class ApiMockBackend(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resultContent":
            suggest = "result_content"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApiMockBackend. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApiMockBackend.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApiMockBackend.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 result_content: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param str description: Specifies the description of the Mock backend. The description cannot exceed 255
               characters.
        :param str result_content: Specifies the return result.
        :param str version: Specifies the version of the Mock backend.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if result_content is not None:
            pulumi.set(__self__, "result_content", result_content)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the Mock backend. The description cannot exceed 255
        characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="resultContent")
    def result_content(self) -> Optional[str]:
        """
        Specifies the return result.
        """
        return pulumi.get(self, "result_content")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Specifies the version of the Mock backend.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ApiRequestParameter(dict):
    def __init__(__self__, *,
                 location: str,
                 name: str,
                 required: bool,
                 type: str,
                 default: Optional[str] = None,
                 description: Optional[str] = None):
        """
        :param str location: Specifies the input parameter location, which can be 'PATH', 'QUERY' or 'HEADER'.
        :param str name: Specifies the input parameter name. A parameter name consists of 1–32 characters, starting
               with a letter. Only letters, digits, periods (.), hyphens (-), and underscores (_) are allowed.
        :param bool required: Specifies whether the parameter is mandatory or not.
        :param str type: Specifies the input parameter type, which can be 'STRING' or 'NUMBER'.
        :param str default: Specifies the default value when the parameter is optional.
        :param str description: Specifies the description of the parameter. The description cannot exceed 255
               characters.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "required", required)
        pulumi.set(__self__, "type", type)
        if default is not None:
            pulumi.set(__self__, "default", default)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Specifies the input parameter location, which can be 'PATH', 'QUERY' or 'HEADER'.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the input parameter name. A parameter name consists of 1–32 characters, starting
        with a letter. Only letters, digits, periods (.), hyphens (-), and underscores (_) are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def required(self) -> bool:
        """
        Specifies whether the parameter is mandatory or not.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the input parameter type, which can be 'STRING' or 'NUMBER'.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def default(self) -> Optional[str]:
        """
        Specifies the default value when the parameter is optional.
        """
        return pulumi.get(self, "default")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies the description of the parameter. The description cannot exceed 255
        characters.
        """
        return pulumi.get(self, "description")


