# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RepoPasswordAuthorizationArgs', 'RepoPasswordAuthorization']

@pulumi.input_type
class RepoPasswordAuthorizationArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 type: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RepoPasswordAuthorization resource.
        :param pulumi.Input[str] password: Specified the repository password.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **devcloud**
               + **bitbucket**
        :param pulumi.Input[str] user_name: Specified the user name of the repository.
               The format for each type is as follows:
               + **devcloud**: `{domain name}/{tenant name}`
               + **bitbucket**: `{account name}`
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_name", user_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specified the repository password.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specified the repository type. The valid values are as follows:
        + **devcloud**
        + **bitbucket**
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        Specified the user name of the repository.
        The format for each type is as follows:
        + **devcloud**: `{domain name}/{tenant name}`
        + **bitbucket**: `{account name}`
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the authorization name. The name can contain of 4 to 63 characters,
        only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the region in which to create the repository authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _RepoPasswordAuthorizationState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RepoPasswordAuthorization resources.
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] password: Specified the repository password.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **devcloud**
               + **bitbucket**
        :param pulumi.Input[str] user_name: Specified the user name of the repository.
               The format for each type is as follows:
               + **devcloud**: `{domain name}/{tenant name}`
               + **bitbucket**: `{account name}`
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the authorization name. The name can contain of 4 to 63 characters,
        only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the repository password.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the region in which to create the repository authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the repository type. The valid values are as follows:
        + **devcloud**
        + **bitbucket**
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specified the user name of the repository.
        The format for each type is as follows:
        + **devcloud**: `{domain name}/{tenant name}`
        + **bitbucket**: `{account name}`
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class RepoPasswordAuthorization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource is used for the ServiceStage service to establish the authorization relationship through username
        and password with various types of the Open-Source repository.

        ## Import

        Authorizations can be imported using their `id` or `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/repoPasswordAuthorization:RepoPasswordAuthorization test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] password: Specified the repository password.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **devcloud**
               + **bitbucket**
        :param pulumi.Input[str] user_name: Specified the user name of the repository.
               The format for each type is as follows:
               + **devcloud**: `{domain name}/{tenant name}`
               + **bitbucket**: `{account name}`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepoPasswordAuthorizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used for the ServiceStage service to establish the authorization relationship through username
        and password with various types of the Open-Source repository.

        ## Import

        Authorizations can be imported using their `id` or `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/repoPasswordAuthorization:RepoPasswordAuthorization test terraform-test
        ```

        :param str resource_name: The name of the resource.
        :param RepoPasswordAuthorizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepoPasswordAuthorizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepoPasswordAuthorizationArgs.__new__(RepoPasswordAuthorizationArgs)

            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["region"] = region
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
        super(RepoPasswordAuthorization, __self__).__init__(
            'huaweicloud:ServiceStage/repoPasswordAuthorization:RepoPasswordAuthorization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None) -> 'RepoPasswordAuthorization':
        """
        Get an existing RepoPasswordAuthorization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specified the authorization name. The name can contain of 4 to 63 characters,
               only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] password: Specified the repository password.
               Changing this parameter will create a new authorization.
        :param pulumi.Input[str] region: Specified the region in which to create the repository authorization.
               If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        :param pulumi.Input[str] type: Specified the repository type. The valid values are as follows:
               + **devcloud**
               + **bitbucket**
        :param pulumi.Input[str] user_name: Specified the user name of the repository.
               The format for each type is as follows:
               + **devcloud**: `{domain name}/{tenant name}`
               + **bitbucket**: `{account name}`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RepoPasswordAuthorizationState.__new__(_RepoPasswordAuthorizationState)

        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["user_name"] = user_name
        return RepoPasswordAuthorization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specified the authorization name. The name can contain of 4 to 63 characters,
        only letters, digits, underscores (_), hyphens (-) and dots (.) are allowed.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specified the repository password.
        Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specified the region in which to create the repository authorization.
        If omitted, the provider-level region will be used. Changing this parameter will create a new authorization.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specified the repository type. The valid values are as follows:
        + **devcloud**
        + **bitbucket**
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Specified the user name of the repository.
        The format for each type is as follows:
        + **devcloud**: `{domain name}/{tenant name}`
        + **bitbucket**: `{account name}`
        """
        return pulumi.get(self, "user_name")

