# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EnvironmentArgs', 'Environment']

@pulumi.input_type
class EnvironmentArgs:
    def __init__(__self__, *,
                 basic_resources: pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]],
                 vpc_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional_resources: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Environment resource.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]] basic_resources: Specifies the basic resources.
               The object structure is documented below.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the environment belongs.
               Changing this will create a new resource.
        :param pulumi.Input[str] description: Specifies the environment description.
               The description can contian a maximum of 128 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the environment name.
               The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter and end with a letter or a digit.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]] optional_resources: Specifies the optional resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage environment.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "basic_resources", basic_resources)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional_resources is not None:
            pulumi.set(__self__, "optional_resources", optional_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="basicResources")
    def basic_resources(self) -> pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]]:
        """
        Specifies the basic resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "basic_resources")

    @basic_resources.setter
    def basic_resources(self, value: pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]]):
        pulumi.set(self, "basic_resources", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID to which the environment belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment description.
        The description can contian a maximum of 128 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise projcet ID to which the application
        belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment name.
        The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        The name must start with a letter and end with a letter or a digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionalResources")
    def optional_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]]]:
        """
        Specifies the optional resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "optional_resources")

    @optional_resources.setter
    def optional_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]]]):
        pulumi.set(self, "optional_resources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the ServiceStage environment.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EnvironmentState:
    def __init__(__self__, *,
                 basic_resources: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional_resources: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Environment resources.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]] basic_resources: Specifies the basic resources.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the environment description.
               The description can contian a maximum of 128 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the environment name.
               The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter and end with a letter or a digit.
        :param pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]] optional_resources: Specifies the optional resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage environment.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the environment belongs.
               Changing this will create a new resource.
        """
        if basic_resources is not None:
            pulumi.set(__self__, "basic_resources", basic_resources)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optional_resources is not None:
            pulumi.set(__self__, "optional_resources", optional_resources)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="basicResources")
    def basic_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]]]:
        """
        Specifies the basic resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "basic_resources")

    @basic_resources.setter
    def basic_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentBasicResourceArgs']]]]):
        pulumi.set(self, "basic_resources", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment description.
        The description can contian a maximum of 128 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise projcet ID to which the application
        belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the environment name.
        The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        The name must start with a letter and end with a letter or a digit.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="optionalResources")
    def optional_resources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]]]:
        """
        Specifies the optional resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "optional_resources")

    @optional_resources.setter
    def optional_resources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvironmentOptionalResourceArgs']]]]):
        pulumi.set(self, "optional_resources", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the ServiceStage environment.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID to which the environment belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Environment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBasicResourceArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentOptionalResourceArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an environment resource within HuaweiCloud ServiceStage.

        ## Example Usage
        ### Create an environment based on some cce clusters

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        env_name = config.require_object("envName")
        vpc_id = config.require_object("vpcId")
        cce_cluster_id = config.require_object("cceClusterId")
        cci_namespace_name = config.require_object("cciNamespaceName")
        test = huaweicloud.service_stage.Environment("test",
            vpc_id=vpc_id,
            basic_resources=[
                huaweicloud.service_stage.EnvironmentBasicResourceArgs(
                    type="cce",
                    id=cce_cluster_id,
                ),
                huaweicloud.service_stage.EnvironmentBasicResourceArgs(
                    type="cci",
                    id=cci_namespace_name,
                ),
            ])
        ```

        ## Import

        Environments can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/environment:Environment test 17383329-b686-47e4-8f70-0d8dcddb65e9
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBasicResourceArgs']]]] basic_resources: Specifies the basic resources.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the environment description.
               The description can contian a maximum of 128 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the environment name.
               The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter and end with a letter or a digit.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentOptionalResourceArgs']]]] optional_resources: Specifies the optional resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage environment.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the environment belongs.
               Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EnvironmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an environment resource within HuaweiCloud ServiceStage.

        ## Example Usage
        ### Create an environment based on some cce clusters

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        env_name = config.require_object("envName")
        vpc_id = config.require_object("vpcId")
        cce_cluster_id = config.require_object("cceClusterId")
        cci_namespace_name = config.require_object("cciNamespaceName")
        test = huaweicloud.service_stage.Environment("test",
            vpc_id=vpc_id,
            basic_resources=[
                huaweicloud.service_stage.EnvironmentBasicResourceArgs(
                    type="cce",
                    id=cce_cluster_id,
                ),
                huaweicloud.service_stage.EnvironmentBasicResourceArgs(
                    type="cci",
                    id=cci_namespace_name,
                ),
            ])
        ```

        ## Import

        Environments can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:ServiceStage/environment:Environment test 17383329-b686-47e4-8f70-0d8dcddb65e9
        ```

        :param str resource_name: The name of the resource.
        :param EnvironmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EnvironmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBasicResourceArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 optional_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentOptionalResourceArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EnvironmentArgs.__new__(EnvironmentArgs)

            if basic_resources is None and not opts.urn:
                raise TypeError("Missing required property 'basic_resources'")
            __props__.__dict__["basic_resources"] = basic_resources
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["optional_resources"] = optional_resources
            __props__.__dict__["region"] = region
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
        super(Environment, __self__).__init__(
            'huaweicloud:ServiceStage/environment:Environment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            basic_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBasicResourceArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            optional_resources: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentOptionalResourceArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Environment':
        """
        Get an existing Environment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentBasicResourceArgs']]]] basic_resources: Specifies the basic resources.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the environment description.
               The description can contian a maximum of 128 characters.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise projcet ID to which the application
               belongs. Changing this will create a new resource.
        :param pulumi.Input[str] name: Specifies the environment name.
               The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
               The name must start with a letter and end with a letter or a digit.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['EnvironmentOptionalResourceArgs']]]] optional_resources: Specifies the optional resources.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the ServiceStage environment.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID to which the environment belongs.
               Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EnvironmentState.__new__(_EnvironmentState)

        __props__.__dict__["basic_resources"] = basic_resources
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["optional_resources"] = optional_resources
        __props__.__dict__["region"] = region
        __props__.__dict__["vpc_id"] = vpc_id
        return Environment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="basicResources")
    def basic_resources(self) -> pulumi.Output[Sequence['outputs.EnvironmentBasicResource']]:
        """
        Specifies the basic resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "basic_resources")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the environment description.
        The description can contian a maximum of 128 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise projcet ID to which the application
        belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the environment name.
        The name can contain of 2 to 64 characters, only letters, digits, hyphens (-) and underscores (_) are allowed.
        The name must start with a letter and end with a letter or a digit.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optionalResources")
    def optional_resources(self) -> pulumi.Output[Optional[Sequence['outputs.EnvironmentOptionalResource']]]:
        """
        Specifies the optional resources.
        The object structure is documented below.
        """
        return pulumi.get(self, "optional_resources")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the ServiceStage environment.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID to which the environment belongs.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

