# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ApplicationEnvironmentArgs',
    'ApplicationEnvironmentVariableArgs',
    'ComponentBuilderArgs',
    'ComponentInstanceArtifactArgs',
    'ComponentInstanceArtifactPropertiesArgs',
    'ComponentInstanceConfigurationArgs',
    'ComponentInstanceConfigurationEnvVariableArgs',
    'ComponentInstanceConfigurationLifecycleArgs',
    'ComponentInstanceConfigurationLifecycleEntrypointArgs',
    'ComponentInstanceConfigurationLifecyclePostStartArgs',
    'ComponentInstanceConfigurationLifecyclePostStartParametersArgs',
    'ComponentInstanceConfigurationLifecyclePreStopArgs',
    'ComponentInstanceConfigurationLifecyclePreStopParametersArgs',
    'ComponentInstanceConfigurationLogCollectionPolicyArgs',
    'ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs',
    'ComponentInstanceConfigurationProbeArgs',
    'ComponentInstanceConfigurationProbeLivenessArgs',
    'ComponentInstanceConfigurationProbeLivenessCommandParamArgs',
    'ComponentInstanceConfigurationProbeLivenessHttpParamArgs',
    'ComponentInstanceConfigurationProbeLivenessTcpParamArgs',
    'ComponentInstanceConfigurationProbeReadinessArgs',
    'ComponentInstanceConfigurationProbeReadinessCommandParamArgs',
    'ComponentInstanceConfigurationProbeReadinessHttpParamArgs',
    'ComponentInstanceConfigurationProbeReadinessTcpParamArgs',
    'ComponentInstanceConfigurationSchedulerArgs',
    'ComponentInstanceConfigurationSchedulerAffinityArgs',
    'ComponentInstanceConfigurationSchedulerAntiAffinityArgs',
    'ComponentInstanceConfigurationStorageArgs',
    'ComponentInstanceConfigurationStorageMountArgs',
    'ComponentInstanceConfigurationStorageParameterArgs',
    'ComponentInstanceConfigurationStrategyArgs',
    'ComponentInstanceExternalAccessArgs',
    'ComponentInstanceReferResourceArgs',
    'ComponentSourceArgs',
    'EnvironmentBasicResourceArgs',
    'EnvironmentOptionalResourceArgs',
]

@pulumi.input_type
class ApplicationEnvironmentArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 variables: pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentVariableArgs']]]):
        """
        :param pulumi.Input[str] id: Specifies the environment ID to which the variables belongs.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentVariableArgs']]] variables: Specifies the list of environment variables.
               The object structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the environment ID to which the variables belongs.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def variables(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentVariableArgs']]]:
        """
        Specifies the list of environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "variables")

    @variables.setter
    def variables(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationEnvironmentVariableArgs']]]):
        pulumi.set(self, "variables", value)


@pulumi.input_type
class ApplicationEnvironmentVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Specifies the variable name. The name can contain `1` to `64` characters, only letters,
               digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        :param pulumi.Input[str] value: Specifies the variable value. The value can contian a maximum of `2,048` characters.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the variable name. The name can contain `1` to `64` characters, only letters,
        digits, underscores (_), hyphens (-) and dots (.) are allowed. The name cannot start with a digit or dot.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the variable value. The value can contian a maximum of `2,048` characters.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ComponentBuilderArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 organization: pulumi.Input[str],
                 cmd: Optional[pulumi.Input[str]] = None,
                 node_label: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] cluster_id: Specifies the cluster ID.
        :param pulumi.Input[str] organization: Specifies the organization name.
               The organization is usually **domain name**. You can find out in the organization management of SWR.
        :param pulumi.Input[str] cmd: Specifies the build command. If omitted, the default command will be used.
               + About the  default command or script: build.sh in the root directory will be preferentially executed.
               If build.sh does not exist, the code will be compiled using the common method of the selected language,
               for example, mvn clean package for Java.
               + About the custom command: Commands will be customized using the selected language.
               Alternatively, the default command or script will be used after build.sh is modified.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] node_label: Specifies the filter labels for CCE nodes.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "organization", organization)
        if cmd is not None:
            pulumi.set(__self__, "cmd", cmd)
        if node_label is not None:
            pulumi.set(__self__, "node_label", node_label)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the cluster ID.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Input[str]:
        """
        Specifies the organization name.
        The organization is usually **domain name**. You can find out in the organization management of SWR.
        """
        return pulumi.get(self, "organization")

    @organization.setter
    def organization(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization", value)

    @property
    @pulumi.getter
    def cmd(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the build command. If omitted, the default command will be used.
        + About the  default command or script: build.sh in the root directory will be preferentially executed.
        If build.sh does not exist, the code will be compiled using the common method of the selected language,
        for example, mvn clean package for Java.
        + About the custom command: Commands will be customized using the selected language.
        Alternatively, the default command or script will be used after build.sh is modified.
        """
        return pulumi.get(self, "cmd")

    @cmd.setter
    def cmd(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmd", value)

    @property
    @pulumi.getter(name="nodeLabel")
    def node_label(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the filter labels for CCE nodes.
        """
        return pulumi.get(self, "node_label")

    @node_label.setter
    def node_label(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "node_label", value)


@pulumi.input_type
class ComponentInstanceArtifactArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 storage: pulumi.Input[str],
                 type: pulumi.Input[str],
                 url: pulumi.Input[str],
                 auth_type: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input['ComponentInstanceArtifactPropertiesArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[str] storage: Specifies the data storage configuration.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param pulumi.Input[str] url: Specifies the software package or image address.
               For a component deployed on a VM, this parameter is the software package address.
               For a component deployed based on a container, this parameter is the image address or component name:v${index}.
               The latter indicates that the component source code or the image automatically built using the software package
               will be used.
        :param pulumi.Input[str] auth_type: Specifies the authentication mode.
               The valid values are **iam** and **none**. Defaults to **iam**.
        :param pulumi.Input['ComponentInstanceArtifactPropertiesArgs'] properties: Specifies the properties of the OBS object.
               This parameter is available only `storage` is **obs**.
               The object structure is documented below.
        :param pulumi.Input[str] version: Specifies the version number.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Input[str]:
        """
        Specifies the data storage configuration.
        The object structure is documented below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Specifies the software package or image address.
        For a component deployed on a VM, this parameter is the software package address.
        For a component deployed based on a container, this parameter is the image address or component name:v${index}.
        The latter indicates that the component source code or the image automatically built using the software package
        will be used.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authentication mode.
        The valid values are **iam** and **none**. Defaults to **iam**.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input['ComponentInstanceArtifactPropertiesArgs']]:
        """
        Specifies the properties of the OBS object.
        This parameter is available only `storage` is **obs**.
        The object structure is documented below.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input['ComponentInstanceArtifactPropertiesArgs']]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version number.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ComponentInstanceArtifactPropertiesArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Specifies the OBS bucket name.
        :param pulumi.Input[str] endpoint: Specifies the OBS bucket endpoint.
        :param pulumi.Input[str] key: Specifies the key name of the OBS object.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if key is not None:
            pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS bucket name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS bucket endpoint.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key name of the OBS object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class ComponentInstanceConfigurationArgs:
    def __init__(__self__, *,
                 env_variables: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationEnvVariableArgs']]]] = None,
                 lifecycle: Optional[pulumi.Input['ComponentInstanceConfigurationLifecycleArgs']] = None,
                 log_collection_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyArgs']]]] = None,
                 probe: Optional[pulumi.Input['ComponentInstanceConfigurationProbeArgs']] = None,
                 scheduler: Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerArgs']] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageArgs']]]] = None,
                 strategy: Optional[pulumi.Input['ComponentInstanceConfigurationStrategyArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationEnvVariableArgs']]] env_variables: Specifies the environment variables.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationLifecycleArgs'] lifecycle: Specifies the lifecycle.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyArgs']]] log_collection_policies: Specifies the policies of the log collection.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationProbeArgs'] probe: Specifies the variable value.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationSchedulerArgs'] scheduler: Specifies the scheduling policy.
               The key indicates the component name. In the Docker container scenario, key indicates the container name.
               If the source parameters of a component specify the software package source, this parameter is optional, and the
               software package source of the component is inherited by default. Otherwise, this parameter is required.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageArgs']]] storages: Specifies the data storage configuration.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationStrategyArgs'] strategy: Specifies the upgrade policy.
               The object structure is documented below.
        """
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if lifecycle is not None:
            pulumi.set(__self__, "lifecycle", lifecycle)
        if log_collection_policies is not None:
            pulumi.set(__self__, "log_collection_policies", log_collection_policies)
        if probe is not None:
            pulumi.set(__self__, "probe", probe)
        if scheduler is not None:
            pulumi.set(__self__, "scheduler", scheduler)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationEnvVariableArgs']]]]:
        """
        Specifies the environment variables.
        The object structure is documented below.
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationEnvVariableArgs']]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter
    def lifecycle(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationLifecycleArgs']]:
        """
        Specifies the lifecycle.
        The object structure is documented below.
        """
        return pulumi.get(self, "lifecycle")

    @lifecycle.setter
    def lifecycle(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationLifecycleArgs']]):
        pulumi.set(self, "lifecycle", value)

    @property
    @pulumi.getter(name="logCollectionPolicies")
    def log_collection_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyArgs']]]]:
        """
        Specifies the policies of the log collection.
        The object structure is documented below.
        """
        return pulumi.get(self, "log_collection_policies")

    @log_collection_policies.setter
    def log_collection_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyArgs']]]]):
        pulumi.set(self, "log_collection_policies", value)

    @property
    @pulumi.getter
    def probe(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeArgs']]:
        """
        Specifies the variable value.
        The object structure is documented below.
        """
        return pulumi.get(self, "probe")

    @probe.setter
    def probe(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeArgs']]):
        pulumi.set(self, "probe", value)

    @property
    @pulumi.getter
    def scheduler(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerArgs']]:
        """
        Specifies the scheduling policy.
        The key indicates the component name. In the Docker container scenario, key indicates the container name.
        If the source parameters of a component specify the software package source, this parameter is optional, and the
        software package source of the component is inherited by default. Otherwise, this parameter is required.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduler")

    @scheduler.setter
    def scheduler(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerArgs']]):
        pulumi.set(self, "scheduler", value)

    @property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageArgs']]]]:
        """
        Specifies the data storage configuration.
        The object structure is documented below.
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageArgs']]]]):
        pulumi.set(self, "storages", value)

    @property
    @pulumi.getter
    def strategy(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationStrategyArgs']]:
        """
        Specifies the upgrade policy.
        The object structure is documented below.
        """
        return pulumi.get(self, "strategy")

    @strategy.setter
    def strategy(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationStrategyArgs']]):
        pulumi.set(self, "strategy", value)


@pulumi.input_type
class ComponentInstanceConfigurationEnvVariableArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[str] value: Specifies the variable value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Specifies the variable value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ComponentInstanceConfigurationLifecycleArgs:
    def __init__(__self__, *,
                 entrypoint: Optional[pulumi.Input['ComponentInstanceConfigurationLifecycleEntrypointArgs']] = None,
                 post_start: Optional[pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartArgs']] = None,
                 pre_stop: Optional[pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopArgs']] = None):
        """
        :param pulumi.Input['ComponentInstanceConfigurationLifecycleEntrypointArgs'] entrypoint: Specifies the startup commands.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartArgs'] post_start: Specifies the post-start processing.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopArgs'] pre_stop: Specifies the pre-stop processing.
               The object structure is documented below.
        """
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if post_start is not None:
            pulumi.set(__self__, "post_start", post_start)
        if pre_stop is not None:
            pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationLifecycleEntrypointArgs']]:
        """
        Specifies the startup commands.
        The object structure is documented below.
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationLifecycleEntrypointArgs']]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartArgs']]:
        """
        Specifies the post-start processing.
        The object structure is documented below.
        """
        return pulumi.get(self, "post_start")

    @post_start.setter
    def post_start(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartArgs']]):
        pulumi.set(self, "post_start", value)

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopArgs']]:
        """
        Specifies the pre-stop processing.
        The object structure is documented below.
        """
        return pulumi.get(self, "pre_stop")

    @pre_stop.setter
    def pre_stop(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopArgs']]):
        pulumi.set(self, "pre_stop", value)


@pulumi.input_type
class ComponentInstanceConfigurationLifecycleEntrypointArgs:
    def __init__(__self__, *,
                 args: pulumi.Input[Sequence[pulumi.Input[str]]],
                 commands: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Specifies the running parameters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Specifies the command list.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def args(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the running parameters.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "commands", value)


@pulumi.input_type
class ComponentInstanceConfigurationLifecyclePostStartArgs:
    def __init__(__self__, *,
                 parameters: pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartParametersArgs'],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartParametersArgs'] parameters: Specifies the start post-processing or stop pre-processing parameters.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartParametersArgs']:
        """
        Specifies the start post-processing or stop pre-processing parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['ComponentInstanceConfigurationLifecyclePostStartParametersArgs']):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ComponentInstanceConfigurationLifecyclePostStartParametersArgs:
    def __init__(__self__, *,
                 commands: pulumi.Input[Sequence[pulumi.Input[str]]],
                 path: pulumi.Input[str],
                 port: pulumi.Input[int],
                 host: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Specifies the command list.
        :param pulumi.Input[str] path: Specifies the request path.
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        :param pulumi.Input[str] host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ComponentInstanceConfigurationLifecyclePreStopArgs:
    def __init__(__self__, *,
                 parameters: pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopParametersArgs'],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopParametersArgs'] parameters: Specifies the start post-processing or stop pre-processing parameters.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopParametersArgs']:
        """
        Specifies the start post-processing or stop pre-processing parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: pulumi.Input['ComponentInstanceConfigurationLifecyclePreStopParametersArgs']):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ComponentInstanceConfigurationLifecyclePreStopParametersArgs:
    def __init__(__self__, *,
                 commands: pulumi.Input[Sequence[pulumi.Input[str]]],
                 path: pulumi.Input[str],
                 port: pulumi.Input[int],
                 host: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Specifies the command list.
        :param pulumi.Input[str] path: Specifies the request path.
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        :param pulumi.Input[str] host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ComponentInstanceConfigurationLogCollectionPolicyArgs:
    def __init__(__self__, *,
                 container_mountings: pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs']]],
                 host_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs']]] container_mountings: Specifies the configurations of the container mounting.
               The object structure is documented below.
        :param pulumi.Input[str] host_path: Specifies the The host path that will be mounted to the specified container path.
        """
        pulumi.set(__self__, "container_mountings", container_mountings)
        if host_path is not None:
            pulumi.set(__self__, "host_path", host_path)

    @property
    @pulumi.getter(name="containerMountings")
    def container_mountings(self) -> pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs']]]:
        """
        Specifies the configurations of the container mounting.
        The object structure is documented below.
        """
        return pulumi.get(self, "container_mountings")

    @container_mountings.setter
    def container_mountings(self, value: pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs']]]):
        pulumi.set(self, "container_mountings", value)

    @property
    @pulumi.getter(name="hostPath")
    def host_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the The host path that will be mounted to the specified container path.
        """
        return pulumi.get(self, "host_path")

    @host_path.setter
    def host_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_path", value)


@pulumi.input_type
class ComponentInstanceConfigurationLogCollectionPolicyContainerMountingArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 aging_period: Optional[pulumi.Input[str]] = None,
                 host_extend_path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: Specifies the request path.
        :param pulumi.Input[str] aging_period: Specifies the aging period.
               The valid values are **Hourly**, **Daily** and **Weekly**. The default value is **Hourly**.
        :param pulumi.Input[str] host_extend_path: Specifies the extended host path.
               This parameter can be configured only when `host_path` is configured.
               The valid values are as follows:
               + **PodUID**
               + **PodName**
               + **PodUID/ContainerName**
               + **PodName/ContainerName**
        """
        pulumi.set(__self__, "path", path)
        if aging_period is not None:
            pulumi.set(__self__, "aging_period", aging_period)
        if host_extend_path is not None:
            pulumi.set(__self__, "host_extend_path", host_extend_path)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="agingPeriod")
    def aging_period(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the aging period.
        The valid values are **Hourly**, **Daily** and **Weekly**. The default value is **Hourly**.
        """
        return pulumi.get(self, "aging_period")

    @aging_period.setter
    def aging_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aging_period", value)

    @property
    @pulumi.getter(name="hostExtendPath")
    def host_extend_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the extended host path.
        This parameter can be configured only when `host_path` is configured.
        The valid values are as follows:
        + **PodUID**
        + **PodName**
        + **PodUID/ContainerName**
        + **PodName/ContainerName**
        """
        return pulumi.get(self, "host_extend_path")

    @host_extend_path.setter
    def host_extend_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_extend_path", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeArgs:
    def __init__(__self__, *,
                 liveness: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessArgs']] = None,
                 readiness: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessArgs']] = None):
        """
        :param pulumi.Input['ComponentInstanceConfigurationProbeLivenessArgs'] liveness: Specifies the component liveness probe.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationProbeReadinessArgs'] readiness: Specifies the component service probe.
               The object structure is documented below.
        """
        if liveness is not None:
            pulumi.set(__self__, "liveness", liveness)
        if readiness is not None:
            pulumi.set(__self__, "readiness", readiness)

    @property
    @pulumi.getter
    def liveness(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessArgs']]:
        """
        Specifies the component liveness probe.
        The object structure is documented below.
        """
        return pulumi.get(self, "liveness")

    @liveness.setter
    def liveness(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessArgs']]):
        pulumi.set(self, "liveness", value)

    @property
    @pulumi.getter
    def readiness(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessArgs']]:
        """
        Specifies the component service probe.
        The object structure is documented below.
        """
        return pulumi.get(self, "readiness")

    @readiness.setter
    def readiness(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessArgs']]):
        pulumi.set(self, "readiness", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeLivenessArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 command_param: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessCommandParamArgs']] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 http_param: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessHttpParamArgs']] = None,
                 tcp_param: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessTcpParamArgs']] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param pulumi.Input['ComponentInstanceConfigurationProbeLivenessCommandParamArgs'] command_param: Specifies the commands. Required if `type` is **command**.
               The object structure is documented below.
        :param pulumi.Input[int] delay: Specifies the interval between the startup and detection.
        :param pulumi.Input['ComponentInstanceConfigurationProbeLivenessHttpParamArgs'] http_param: Specifies the commands. Required if `type` is **http**.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationProbeLivenessTcpParamArgs'] tcp_param: Specifies the commands. Required if `type` is **tcp**.
               The object structure is documented below.
        :param pulumi.Input[int] timeout: Specifies the detection timeout interval.
        """
        pulumi.set(__self__, "type", type)
        if command_param is not None:
            pulumi.set(__self__, "command_param", command_param)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if http_param is not None:
            pulumi.set(__self__, "http_param", http_param)
        if tcp_param is not None:
            pulumi.set(__self__, "tcp_param", tcp_param)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="commandParam")
    def command_param(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessCommandParamArgs']]:
        """
        Specifies the commands. Required if `type` is **command**.
        The object structure is documented below.
        """
        return pulumi.get(self, "command_param")

    @command_param.setter
    def command_param(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessCommandParamArgs']]):
        pulumi.set(self, "command_param", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval between the startup and detection.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="httpParam")
    def http_param(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessHttpParamArgs']]:
        """
        Specifies the commands. Required if `type` is **http**.
        The object structure is documented below.
        """
        return pulumi.get(self, "http_param")

    @http_param.setter
    def http_param(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessHttpParamArgs']]):
        pulumi.set(self, "http_param", value)

    @property
    @pulumi.getter(name="tcpParam")
    def tcp_param(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessTcpParamArgs']]:
        """
        Specifies the commands. Required if `type` is **tcp**.
        The object structure is documented below.
        """
        return pulumi.get(self, "tcp_param")

    @tcp_param.setter
    def tcp_param(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeLivenessTcpParamArgs']]):
        pulumi.set(self, "tcp_param", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the detection timeout interval.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeLivenessCommandParamArgs:
    def __init__(__self__, *,
                 commands: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Specifies the command list.
        """
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "commands", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeLivenessHttpParamArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 port: pulumi.Input[int],
                 scheme: pulumi.Input[str],
                 host: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: Specifies the request path.
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        :param pulumi.Input[str] scheme: Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        :param pulumi.Input[str] host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Input[str]:
        """
        Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeLivenessTcpParamArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int]):
        """
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeReadinessArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 command_param: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessCommandParamArgs']] = None,
                 delay: Optional[pulumi.Input[int]] = None,
                 http_param: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessHttpParamArgs']] = None,
                 tcp_param: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessTcpParamArgs']] = None,
                 timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param pulumi.Input['ComponentInstanceConfigurationProbeReadinessCommandParamArgs'] command_param: Specifies the commands. Required if `type` is **command**.
               The object structure is documented below.
        :param pulumi.Input[int] delay: Specifies the interval between the startup and detection.
        :param pulumi.Input['ComponentInstanceConfigurationProbeReadinessHttpParamArgs'] http_param: Specifies the commands. Required if `type` is **http**.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationProbeReadinessTcpParamArgs'] tcp_param: Specifies the commands. Required if `type` is **tcp**.
               The object structure is documented below.
        :param pulumi.Input[int] timeout: Specifies the detection timeout interval.
        """
        pulumi.set(__self__, "type", type)
        if command_param is not None:
            pulumi.set(__self__, "command_param", command_param)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if http_param is not None:
            pulumi.set(__self__, "http_param", http_param)
        if tcp_param is not None:
            pulumi.set(__self__, "tcp_param", tcp_param)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="commandParam")
    def command_param(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessCommandParamArgs']]:
        """
        Specifies the commands. Required if `type` is **command**.
        The object structure is documented below.
        """
        return pulumi.get(self, "command_param")

    @command_param.setter
    def command_param(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessCommandParamArgs']]):
        pulumi.set(self, "command_param", value)

    @property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the interval between the startup and detection.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "delay", value)

    @property
    @pulumi.getter(name="httpParam")
    def http_param(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessHttpParamArgs']]:
        """
        Specifies the commands. Required if `type` is **http**.
        The object structure is documented below.
        """
        return pulumi.get(self, "http_param")

    @http_param.setter
    def http_param(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessHttpParamArgs']]):
        pulumi.set(self, "http_param", value)

    @property
    @pulumi.getter(name="tcpParam")
    def tcp_param(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessTcpParamArgs']]:
        """
        Specifies the commands. Required if `type` is **tcp**.
        The object structure is documented below.
        """
        return pulumi.get(self, "tcp_param")

    @tcp_param.setter
    def tcp_param(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationProbeReadinessTcpParamArgs']]):
        pulumi.set(self, "tcp_param", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the detection timeout interval.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeReadinessCommandParamArgs:
    def __init__(__self__, *,
                 commands: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] commands: Specifies the command list.
        """
        pulumi.set(__self__, "commands", commands)

    @property
    @pulumi.getter
    def commands(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the command list.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "commands", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeReadinessHttpParamArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 port: pulumi.Input[int],
                 scheme: pulumi.Input[str],
                 host: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: Specifies the request path.
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        :param pulumi.Input[str] scheme: Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        :param pulumi.Input[str] host: Specifies the custom IP address. The defualt address is pod IP address.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)
        if host is not None:
            pulumi.set(__self__, "host", host)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Input[str]:
        """
        Specifies the protocol scheme. The valid values are **HTTP** and **HTTPS**.
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: pulumi.Input[str]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the custom IP address. The defualt address is pod IP address.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)


@pulumi.input_type
class ComponentInstanceConfigurationProbeReadinessTcpParamArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int]):
        """
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        """
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


@pulumi.input_type
class ComponentInstanceConfigurationSchedulerArgs:
    def __init__(__self__, *,
                 affinity: Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerAffinityArgs']] = None,
                 anti_affinity: Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerAntiAffinityArgs']] = None):
        """
        :param pulumi.Input['ComponentInstanceConfigurationSchedulerAffinityArgs'] affinity: Specifies the commands.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationSchedulerAntiAffinityArgs'] anti_affinity: Specifies the commands.
               The object structure is documented below.
        """
        if affinity is not None:
            pulumi.set(__self__, "affinity", affinity)
        if anti_affinity is not None:
            pulumi.set(__self__, "anti_affinity", anti_affinity)

    @property
    @pulumi.getter
    def affinity(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerAffinityArgs']]:
        """
        Specifies the commands.
        The object structure is documented below.
        """
        return pulumi.get(self, "affinity")

    @affinity.setter
    def affinity(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerAffinityArgs']]):
        pulumi.set(self, "affinity", value)

    @property
    @pulumi.getter(name="antiAffinity")
    def anti_affinity(self) -> Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerAntiAffinityArgs']]:
        """
        Specifies the commands.
        The object structure is documented below.
        """
        return pulumi.get(self, "anti_affinity")

    @anti_affinity.setter
    def anti_affinity(self, value: Optional[pulumi.Input['ComponentInstanceConfigurationSchedulerAntiAffinityArgs']]):
        pulumi.set(self, "anti_affinity", value)


@pulumi.input_type
class ComponentInstanceConfigurationSchedulerAffinityArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the AZ list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_names: Specifies the list of component instance names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Specifies the node private IP address list.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the AZ list.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of component instance names.
        """
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the node private IP address list.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)


@pulumi.input_type
class ComponentInstanceConfigurationSchedulerAntiAffinityArgs:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instance_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the AZ list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_names: Specifies the list of component instance names.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Specifies the node private IP address list.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if instance_names is not None:
            pulumi.set(__self__, "instance_names", instance_names)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the AZ list.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of component instance names.
        """
        return pulumi.get(self, "instance_names")

    @instance_names.setter
    def instance_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "instance_names", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the node private IP address list.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)


@pulumi.input_type
class ComponentInstanceConfigurationStorageArgs:
    def __init__(__self__, *,
                 mounts: pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageMountArgs']]],
                 parameter: pulumi.Input['ComponentInstanceConfigurationStorageParameterArgs'],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageMountArgs']]] mounts: Specifies the directory mounted to the container.
               The object structure is documented below.
        :param pulumi.Input['ComponentInstanceConfigurationStorageParameterArgs'] parameter: Specifies the storage parameters.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        """
        pulumi.set(__self__, "mounts", mounts)
        pulumi.set(__self__, "parameter", parameter)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def mounts(self) -> pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageMountArgs']]]:
        """
        Specifies the directory mounted to the container.
        The object structure is documented below.
        """
        return pulumi.get(self, "mounts")

    @mounts.setter
    def mounts(self, value: pulumi.Input[Sequence[pulumi.Input['ComponentInstanceConfigurationStorageMountArgs']]]):
        pulumi.set(self, "mounts", value)

    @property
    @pulumi.getter
    def parameter(self) -> pulumi.Input['ComponentInstanceConfigurationStorageParameterArgs']:
        """
        Specifies the storage parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameter")

    @parameter.setter
    def parameter(self, value: pulumi.Input['ComponentInstanceConfigurationStorageParameterArgs']):
        pulumi.set(self, "parameter", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ComponentInstanceConfigurationStorageMountArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 readonly: pulumi.Input[bool],
                 subpath: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] path: Specifies the request path.
        :param pulumi.Input[bool] readonly: Specifies the mounted disk permission is read-only or read-write.
               + **true**: read-only.
               + **false**: read-write.
        :param pulumi.Input[str] subpath: Specifies the subpath of the mounted disk.
               This parameter is applicable to `http` type.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "readonly", readonly)
        if subpath is not None:
            pulumi.set(__self__, "subpath", subpath)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def readonly(self) -> pulumi.Input[bool]:
        """
        Specifies the mounted disk permission is read-only or read-write.
        + **true**: read-only.
        + **false**: read-write.
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: pulumi.Input[bool]):
        pulumi.set(self, "readonly", value)

    @property
    @pulumi.getter
    def subpath(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the subpath of the mounted disk.
        This parameter is applicable to `http` type.
        """
        return pulumi.get(self, "subpath")

    @subpath.setter
    def subpath(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subpath", value)


@pulumi.input_type
class ComponentInstanceConfigurationStorageParameterArgs:
    def __init__(__self__, *,
                 claim_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] claim_name: Specifies the PVC name.
        :param pulumi.Input[str] name: Specifies the name of a configuration item or secret.
        :param pulumi.Input[str] path: Specifies the request path.
        """
        if claim_name is not None:
            pulumi.set(__self__, "claim_name", claim_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter(name="claimName")
    def claim_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the PVC name.
        """
        return pulumi.get(self, "claim_name")

    @claim_name.setter
    def claim_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "claim_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of a configuration item or secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the request path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ComponentInstanceConfigurationStrategyArgs:
    def __init__(__self__, *,
                 upgrade: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] upgrade: Specifies the upgrade policy.
               The valid values are **Recreate** or **RollingUpdate**. The default value is **RollingUpdate**.
               The **Recreate** indicates in-place upgrade while the **RollingUpdate** indicates rolling upgrade.
        """
        if upgrade is not None:
            pulumi.set(__self__, "upgrade", upgrade)

    @property
    @pulumi.getter
    def upgrade(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the upgrade policy.
        The valid values are **Recreate** or **RollingUpdate**. The default value is **RollingUpdate**.
        The **Recreate** indicates in-place upgrade while the **RollingUpdate** indicates rolling upgrade.
        """
        return pulumi.get(self, "upgrade")

    @upgrade.setter
    def upgrade(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "upgrade", value)


@pulumi.input_type
class ComponentInstanceExternalAccessArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 protocol: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] address: Specifies the access address. For example: www.example.com.
        :param pulumi.Input[int] port: Specifies the listening port of the application component process.
        :param pulumi.Input[str] protocol: Specifies the protocol. The valid values are **HTTP** and **HTTPS**.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the access address. For example: www.example.com.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the listening port of the application component process.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the protocol. The valid values are **HTTP** and **HTTPS**.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class ComponentInstanceReferResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] id: Specifies the resource ID.
               If the `type` is set to **ecs**, the value of this parameter must be **Default**.
        :param pulumi.Input[str] type: Specifies the probe type. The valid values are as follows:
               + **command**: command execution check.
               + **http**: HTTP request check.
               + **tcp**: TCP port check.
        :param pulumi.Input[str] alias: Specifies the application alias, which is provided only in DCS scenario.
               The valid values are: **distributed_session**, **distributed_cache** and **distributed_session, distributed_cache**.
               Defaults to **distributed_session, distributed_cache**.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Specifies the start post-processing or stop pre-processing parameters.
               The object structure is documented below.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the resource ID.
        If the `type` is set to **ecs**, the value of this parameter must be **Default**.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the probe type. The valid values are as follows:
        + **command**: command execution check.
        + **http**: HTTP request check.
        + **tcp**: TCP port check.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the application alias, which is provided only in DCS scenario.
        The valid values are: **distributed_session**, **distributed_cache** and **distributed_session, distributed_cache**.
        Defaults to **distributed_session, distributed_cache**.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the start post-processing or stop pre-processing parameters.
        The object structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class ComponentSourceArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 url: pulumi.Input[str],
                 authorization: Optional[pulumi.Input[str]] = None,
                 repo_namespace: Optional[pulumi.Input[str]] = None,
                 repo_ref: Optional[pulumi.Input[str]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: Specifies the type of repository source or storage.
               The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        :param pulumi.Input[str] url: Specifies the URL of the repository or package storage.
        :param pulumi.Input[str] authorization: Specifies the authorization name.
               This parameter and `storage_type` are alternative.
        :param pulumi.Input[str] repo_namespace: Specifies the namespace name.
        :param pulumi.Input[str] repo_ref: Specifies the name of the branch of the code repository.
               The default value is `master`.
        :param pulumi.Input[str] storage_type: Specifies the storage type, such as **obs**, **swr**.
               This parameter is conflict with `repo_ref` and `repo_namespace`.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if repo_namespace is not None:
            pulumi.set(__self__, "repo_namespace", repo_namespace)
        if repo_ref is not None:
            pulumi.set(__self__, "repo_ref", repo_ref)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of repository source or storage.
        The valid values are **GitHub**, **GitLab**, **Gitee**, **Bitbucket** and **package**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Input[str]:
        """
        Specifies the URL of the repository or package storage.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: pulumi.Input[str]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authorization name.
        This parameter and `storage_type` are alternative.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="repoNamespace")
    def repo_namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the namespace name.
        """
        return pulumi.get(self, "repo_namespace")

    @repo_namespace.setter
    def repo_namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_namespace", value)

    @property
    @pulumi.getter(name="repoRef")
    def repo_ref(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the branch of the code repository.
        The default value is `master`.
        """
        return pulumi.get(self, "repo_ref")

    @repo_ref.setter
    def repo_ref(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_ref", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage type, such as **obs**, **swr**.
        This parameter is conflict with `repo_ref` and `repo_namespace`.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)


@pulumi.input_type
class EnvironmentBasicResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
               but for CCI namespace, this parameter needs to fill in **name**.
        :param pulumi.Input[str] type: Specifies the resource type.
               + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
               + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
        but for CCI namespace, this parameter needs to fill in **name**.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the resource type.
        + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
        + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class EnvironmentOptionalResourceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
               but for CCI namespace, this parameter needs to fill in **name**.
        :param pulumi.Input[str] type: Specifies the resource type.
               + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
               + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Specifies the resource ID. For most resources, this parameter needs to fill in their **id**,
        but for CCI namespace, this parameter needs to fill in **name**.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the resource type.
        + The type of basic resource supports **cce**, **cci**, **ecs** and **as**.
        + The type of optional resource supports **elb**, **eip**, **rds**, **dcs** and **cse**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


