# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReadReplicaInstanceArgs', 'ReadReplicaInstance']

@pulumi.input_type
class ReadReplicaInstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 flavor: pulumi.Input[str],
                 primary_instance_id: pulumi.Input[str],
                 volume: pulumi.Input['ReadReplicaInstanceVolumeArgs'],
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ReadReplicaInstance resource.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] primary_instance_id: Specifies the DB instance ID, which is used to create a read
               replica. Changing this parameter will create a new resource.
        :param pulumi.Input['ReadReplicaInstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be
               unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
               case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] region: The region in which to create the rds read replica instance resource. If
               omitted, the provider-level region will be used.
               Changing this parameter will create a new resource.
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
               key-value pair.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "primary_instance_id", primary_instance_id)
        pulumi.set(__self__, "volume", volume)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the AZ name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="primaryInstanceId")
    def primary_instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the DB instance ID, which is used to create a read
        replica. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "primary_instance_id")

    @primary_instance_id.setter
    def primary_instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_instance_id", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input['ReadReplicaInstanceVolumeArgs']:
        """
        Specifies the volume information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input['ReadReplicaInstanceVolumeArgs']):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the read replica instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be
        unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
        case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the rds read replica instance resource. If
        omitted, the provider-level region will be used.
        Changing this parameter will create a new resource.
        Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
        key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ReadReplicaInstanceState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 dbs: Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceDbArgs']]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_instance_id: Optional[pulumi.Input[str]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 volume: Optional[pulumi.Input['ReadReplicaInstanceVolumeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ReadReplicaInstance resources.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceDbArgs']]] dbs: Indicates the database information. Structure is documented below.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be
               unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
               case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] primary_instance_id: Specifies the DB instance ID, which is used to create a read
               replica. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the private IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[str] region: The region in which to create the rds read replica instance resource. If
               omitted, the provider-level region will be used.
               Changing this parameter will create a new resource.
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[str] security_group_id: Indicates the security group which the RDS DB instance belongs to.
        :param pulumi.Input[str] status: Indicates the instance status.
        :param pulumi.Input[str] subnet_id: Indicates the subnet id.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
               key-value pair.
        :param pulumi.Input[str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param pulumi.Input['ReadReplicaInstanceVolumeArgs'] volume: Specifies the volume information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Indicates the VPC ID.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if dbs is not None:
            pulumi.set(__self__, "dbs", dbs)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_instance_id is not None:
            pulumi.set(__self__, "primary_instance_id", primary_instance_id)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_ips is not None:
            pulumi.set(__self__, "public_ips", public_ips)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the AZ name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def dbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceDbArgs']]]]:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "dbs")

    @dbs.setter
    def dbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReadReplicaInstanceDbArgs']]]]):
        pulumi.set(self, "dbs", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the read replica instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be
        unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
        case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="primaryInstanceId")
    def primary_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance ID, which is used to create a read
        replica. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "primary_instance_id")

    @primary_instance_id.setter
    def primary_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_instance_id", value)

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the private IP address list.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ips", value)

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @public_ips.setter
    def public_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "public_ips", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the rds read replica instance resource. If
        omitted, the provider-level region will be used.
        Changing this parameter will create a new resource.
        Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the instance status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
        key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['ReadReplicaInstanceVolumeArgs']]:
        """
        Specifies the volume information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['ReadReplicaInstanceVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class ReadReplicaInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_instance_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['ReadReplicaInstanceVolumeArgs']]] = None,
                 __props__=None):
        """
        Manage RDS Read Replica Instance resource.

        ## Example Usage
        ### Create a Rds read replica instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="security group for rds read replica instance")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2",
            availability_zones="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            enterprise_project_id="{{ enterprise_project_id }}",
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
                port=8635,
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=50,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        replica_instance = huaweicloud.rds.ReadReplicaInstance("replicaInstance",
            flavor="rds.pg.n1.large.2.rr",
            primary_instance_id=instance.id,
            availability_zone="{{ availability_zone }}",
            enterprise_project_id="{{ enterprise_project_id }}",
            volume=huaweicloud.rds.ReadReplicaInstanceVolumeArgs(
                type="ULTRAHIGH",
            ))
        ```

        ## Import

        RDS read replica instance can be imported by `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/readReplicaInstance:ReadReplicaInstance replica_instance 92302c133d13424cbe357506ce057ea5in03
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be
               unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
               case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] primary_instance_id: Specifies the DB instance ID, which is used to create a read
               replica. Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the rds read replica instance resource. If
               omitted, the provider-level region will be used.
               Changing this parameter will create a new resource.
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
               key-value pair.
        :param pulumi.Input[pulumi.InputType['ReadReplicaInstanceVolumeArgs']] volume: Specifies the volume information. Structure is documented below. Changing this
               parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReadReplicaInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage RDS Read Replica Instance resource.

        ## Example Usage
        ### Create a Rds read replica instance

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        secgroup = huaweicloud.vpc.Secgroup("secgroup", description="security group for rds read replica instance")
        instance = huaweicloud.rds.Instance("instance",
            flavor="rds.pg.n1.large.2",
            availability_zones="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_id }}",
            security_group_id=secgroup.id,
            enterprise_project_id="{{ enterprise_project_id }}",
            db=huaweicloud.rds.InstanceDbArgs(
                type="PostgreSQL",
                version="12",
                password="Huangwei!120521",
                port=8635,
            ),
            volume=huaweicloud.rds.InstanceVolumeArgs(
                type="ULTRAHIGH",
                size=50,
            ),
            backup_strategy=huaweicloud.rds.InstanceBackupStrategyArgs(
                start_time="08:00-09:00",
                keep_days=1,
            ))
        replica_instance = huaweicloud.rds.ReadReplicaInstance("replicaInstance",
            flavor="rds.pg.n1.large.2.rr",
            primary_instance_id=instance.id,
            availability_zone="{{ availability_zone }}",
            enterprise_project_id="{{ enterprise_project_id }}",
            volume=huaweicloud.rds.ReadReplicaInstanceVolumeArgs(
                type="ULTRAHIGH",
            ))
        ```

        ## Import

        RDS read replica instance can be imported by `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/readReplicaInstance:ReadReplicaInstance replica_instance 92302c133d13424cbe357506ce057ea5in03
        ```

        :param str resource_name: The name of the resource.
        :param ReadReplicaInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReadReplicaInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 primary_instance_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 volume: Optional[pulumi.Input[pulumi.InputType['ReadReplicaInstanceVolumeArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReadReplicaInstanceArgs.__new__(ReadReplicaInstanceArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["name"] = name
            if primary_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'primary_instance_id'")
            __props__.__dict__["primary_instance_id"] = primary_instance_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if volume is None and not opts.urn:
                raise TypeError("Missing required property 'volume'")
            __props__.__dict__["volume"] = volume
            __props__.__dict__["dbs"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_ips"] = None
            __props__.__dict__["security_group_id"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["subnet_id"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["vpc_id"] = None
        super(ReadReplicaInstance, __self__).__init__(
            'huaweicloud:Rds/readReplicaInstance:ReadReplicaInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            dbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadReplicaInstanceDbArgs']]]]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            primary_instance_id: Optional[pulumi.Input[str]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            public_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            volume: Optional[pulumi.Input[pulumi.InputType['ReadReplicaInstanceVolumeArgs']]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'ReadReplicaInstance':
        """
        Get an existing ReadReplicaInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_zone: Specifies the AZ name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ReadReplicaInstanceDbArgs']]]] dbs: Indicates the database information. Structure is documented below.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the read replica instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the specification code.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be
               unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
               case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
               create a new resource.
        :param pulumi.Input[str] primary_instance_id: Specifies the DB instance ID, which is used to create a read
               replica. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ips: Indicates the private IP address list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] public_ips: Indicates the public IP address list.
        :param pulumi.Input[str] region: The region in which to create the rds read replica instance resource. If
               omitted, the provider-level region will be used.
               Changing this parameter will create a new resource.
               Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        :param pulumi.Input[str] security_group_id: Indicates the security group which the RDS DB instance belongs to.
        :param pulumi.Input[str] status: Indicates the instance status.
        :param pulumi.Input[str] subnet_id: Indicates the subnet id.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
               key-value pair.
        :param pulumi.Input[str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param pulumi.Input[pulumi.InputType['ReadReplicaInstanceVolumeArgs']] volume: Specifies the volume information. Structure is documented below. Changing this
               parameter will create a new resource.
        :param pulumi.Input[str] vpc_id: Indicates the VPC ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReadReplicaInstanceState.__new__(_ReadReplicaInstanceState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["dbs"] = dbs
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_instance_id"] = primary_instance_id
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_ips"] = public_ips
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["volume"] = volume
        __props__.__dict__["vpc_id"] = vpc_id
        return ReadReplicaInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the AZ name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def dbs(self) -> pulumi.Output[Sequence['outputs.ReadReplicaInstanceDb']]:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "dbs")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the read replica instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Specifies the specification code.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be
        unique for the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is
        case-sensitive and can contain only letters, digits, hyphens (-), and underscores (_). Changing this parameter will
        create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="primaryInstanceId")
    def primary_instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the DB instance ID, which is used to create a read
        replica. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "primary_instance_id")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the private IP address list.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        Indicates the public IP address list.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the rds read replica instance resource. If
        omitted, the provider-level region will be used.
        Changing this parameter will create a new resource.
        Currently, read replicas can be created *only* in the same region as that of the primary DB instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Indicates the security group which the RDS DB instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the instance status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Indicates the subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A mapping of tags to assign to the RDS read replica instance. Each tag is represented by one
        key-value pair.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.ReadReplicaInstanceVolume']:
        """
        Specifies the volume information. Structure is documented below. Changing this
        parameter will create a new resource.
        """
        return pulumi.get(self, "volume")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Indicates the VPC ID.
        """
        return pulumi.get(self, "vpc_id")

