# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'Database_privilegeUser',
    'InstanceBackupStrategy',
    'InstanceDb',
    'InstanceNode',
    'InstanceVolume',
    'ParametergroupConfigurationParameter',
    'ParametergroupDatastore',
    'ReadReplicaInstanceDb',
    'ReadReplicaInstanceVolume',
    'GetEngineVersionsVersionResult',
    'GetFlavorsFlavorResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceBackupStrategyResult',
    'GetInstancesInstanceDbResult',
    'GetInstancesInstanceNodeResult',
    'GetInstancesInstanceVolumeResult',
]

@pulumi.output_type
class Database_privilegeUser(dict):
    def __init__(__self__, *,
                 name: str,
                 readonly: Optional[bool] = None):
        """
        :param str name: Specifies the username of the database account. Changing this creates a new resource.
        :param bool readonly: Specifies the read-only permission. The value can be:
               + **true**: indicates the read-only permission.
               + **false**: indicates the read and write permission.
        """
        pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the username of the database account. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        Specifies the read-only permission. The value can be:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.
        """
        return pulumi.get(self, "readonly")


@pulumi.output_type
class InstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the **hh:mm-HH:MM**
               format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
               MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
               00.
        :param int keep_days: Specifies the retention days for specific backup files. The value range is from 0 to
               732. If this parameter is not specified or set to 0, the automated backup policy is disabled.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the **hh:mm-HH:MM**
        format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
        MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
        00.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the retention days for specific backup files. The value range is from 0 to
        732. If this parameter is not specified or set to 0, the automated backup policy is disabled.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class InstanceDb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 password: str,
                 type: str,
                 version: str,
                 port: Optional[int] = None,
                 user_name: Optional[str] = None):
        """
        :param str password: Specifies the database password. The value cannot be empty and should
               contain 8 to 32 characters, including uppercase and lowercase letters, digits, and the following special
               characters: ~!@#%^*-_=+? You are advised to enter a strong password to improve security, preventing security risks
               such as brute force cracking. Changing this parameter will create a new resource.
        :param str type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param str version: Specifies the database version. Changing this parameter will create a new
               resource. Available values detailed in
               [DB Engines and Versions](https://support.huaweicloud.com/intl/en-us/productdesc-rds/en-us_topic_0043898356.html).
        :param int port: Specifies the database port.
               + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
               and cannot be used). The default value is 3306.
               + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
               + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
               default value is 1433.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Specifies the database password. The value cannot be empty and should
        contain 8 to 32 characters, including uppercase and lowercase letters, digits, and the following special
        characters: ~!@#%^*-_=+? You are advised to enter a strong password to improve security, preventing security risks
        such as brute force cracking. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version. Changing this parameter will create a new
        resource. Available values detailed in
        [DB Engines and Versions](https://support.huaweicloud.com/intl/en-us/productdesc-rds/en-us_topic_0043898356.html).
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Specifies the database port.
        + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
        + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
        default value is 1433.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        return pulumi.get(self, "user_name")


@pulumi.output_type
class InstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 role: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str availability_zone: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param str id: Indicates the node ID.
        :param str name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param str role: Indicates the node type. The value can be master or slave, indicating the primary node or standby node
               respectively.
        :param str status: Indicates the node status.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Indicates the node type. The value can be master or slave, indicating the primary node or standby node
        respectively.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class InstanceVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionId":
            suggest = "disk_encryption_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: int,
                 type: str,
                 disk_encryption_id: Optional[str] = None):
        """
        :param int size: Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
               multiple of 10 and greater than the original size.
        :param str type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param str disk_encryption_id: Specifies the key ID for disk encryption. Changing this parameter will create a new
               resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
        multiple of 10 and greater than the original size.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[str]:
        """
        Specifies the key ID for disk encryption. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "disk_encryption_id")


@pulumi.output_type
class ParametergroupConfigurationParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "restartRequired":
            suggest = "restart_required"
        elif key == "valueRange":
            suggest = "value_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParametergroupConfigurationParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParametergroupConfigurationParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParametergroupConfigurationParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: Optional[str] = None,
                 name: Optional[str] = None,
                 readonly: Optional[bool] = None,
                 restart_required: Optional[bool] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None,
                 value_range: Optional[str] = None):
        """
        :param str description: The parameter group description. It contains a maximum of 256 characters and cannot
               contain the following special characters:>!<"&'= the value is left blank by default.
        :param str name: The parameter group name. It contains a maximum of 64 characters.
        :param bool readonly: Indicates whether the parameter is read-only.
        :param bool restart_required: Indicates whether a restart is required.
        :param str type: The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
               value is case-insensitive and can be mysql, postgresql, or sqlserver.
        :param str value: Indicates the parameter value.
        :param str value_range: Indicates the parameter value range.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if restart_required is not None:
            pulumi.set(__self__, "restart_required", restart_required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_range is not None:
            pulumi.set(__self__, "value_range", value_range)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot
        contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def readonly(self) -> Optional[bool]:
        """
        Indicates whether the parameter is read-only.
        """
        return pulumi.get(self, "readonly")

    @property
    @pulumi.getter(name="restartRequired")
    def restart_required(self) -> Optional[bool]:
        """
        Indicates whether a restart is required.
        """
        return pulumi.get(self, "restart_required")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
        value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Indicates the parameter value.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueRange")
    def value_range(self) -> Optional[str]:
        """
        Indicates the parameter value range.
        """
        return pulumi.get(self, "value_range")


@pulumi.output_type
class ParametergroupDatastore(dict):
    def __init__(__self__, *,
                 type: str,
                 version: str):
        """
        :param str type: The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
               value is case-insensitive and can be mysql, postgresql, or sqlserver.
        :param str version: Specifies the database version.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
        value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ReadReplicaInstanceDb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaInstanceDb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaInstanceDb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaInstanceDb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: Optional[int] = None,
                 type: Optional[str] = None,
                 user_name: Optional[str] = None,
                 version: Optional[str] = None):
        """
        :param int port: Indicates the database port information.
        :param str type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param str user_name: Indicates the default user name of database.
        :param str version: Indicates the database version.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Indicates the database port information.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[str]:
        """
        Indicates the default user name of database.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ReadReplicaInstanceVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionId":
            suggest = "disk_encryption_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReadReplicaInstanceVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReadReplicaInstanceVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReadReplicaInstanceVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 disk_encryption_id: Optional[str] = None,
                 size: Optional[int] = None):
        """
        :param str type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param str disk_encryption_id: Specifies the key ID for disk encryption. Changing this parameter
               will create a new resource.
        """
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[str]:
        """
        Specifies the key ID for disk encryption. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @property
    @pulumi.getter
    def size(self) -> Optional[int]:
        return pulumi.get(self, "size")


@pulumi.output_type
class GetEngineVersionsVersionResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: Version ID.
        :param str name: Version name.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Version ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Version name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 db_versions: Sequence[str],
                 group_type: str,
                 id: str,
                 instance_mode: str,
                 memory: int,
                 mode: str,
                 name: str,
                 vcpus: int):
        """
        :param Sequence[str] availability_zones: The availability zones which the RDS flavor belongs to.
        :param Sequence[str] db_versions: The Available versions of the database.
        :param str group_type: Specifies the performance specification, the valid values are as follows:
               + **normal**: General enhanced.
               + **normal2**: General enhanced type II.
               + **armFlavors**: KunPeng general enhancement.
               + **dedicatedNormal**: (dedicatedNormalLocalssd): Dedicated for x86.
               + **armLocalssd**: KunPeng general type.
               + **normalLocalssd**: x86 general type.
               + **general**: General type.
               + **dedicated**:
               For MySQL engine: Dedicated type.
               For PostgreSQL and SQL Server engines: Dedicated type, only supported by cloud disk SSD.
               + **rapid**:
               For MySQL engine: Dedicated (discontinued).
               For PostgreSQL and SQL Server engines: Dedicated, only supported by ultra-fast SSDs.
               + **bigmem**: Large memory type.
        :param str id: The ID of the rds flavor.
        :param str instance_mode: The mode of instance. Value: *ha*(indicates primary/standby instance),
               *single*(indicates single instance) and *replica*(indicates read replicas).
        :param int memory: Specifies the memory size(GB) in the RDS flavor.
        :param str name: The name of the rds flavor.
        :param int vcpus: Specifies the number of vCPUs in the RDS flavor.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "db_versions", db_versions)
        pulumi.set(__self__, "group_type", group_type)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_mode", instance_mode)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        The availability zones which the RDS flavor belongs to.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="dbVersions")
    def db_versions(self) -> Sequence[str]:
        """
        The Available versions of the database.
        """
        return pulumi.get(self, "db_versions")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> str:
        """
        Specifies the performance specification, the valid values are as follows:
        + **normal**: General enhanced.
        + **normal2**: General enhanced type II.
        + **armFlavors**: KunPeng general enhancement.
        + **dedicatedNormal**: (dedicatedNormalLocalssd): Dedicated for x86.
        + **armLocalssd**: KunPeng general type.
        + **normalLocalssd**: x86 general type.
        + **general**: General type.
        + **dedicated**:
        For MySQL engine: Dedicated type.
        For PostgreSQL and SQL Server engines: Dedicated type, only supported by cloud disk SSD.
        + **rapid**:
        For MySQL engine: Dedicated (discontinued).
        For PostgreSQL and SQL Server engines: Dedicated, only supported by ultra-fast SSDs.
        + **bigmem**: Large memory type.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the rds flavor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceMode")
    def instance_mode(self) -> str:
        """
        The mode of instance. Value: *ha*(indicates primary/standby instance),
        *single*(indicates single instance) and *replica*(indicates read replicas).
        """
        return pulumi.get(self, "instance_mode")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Specifies the memory size(GB) in the RDS flavor.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def mode(self) -> str:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the rds flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        Specifies the number of vCPUs in the RDS flavor.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 backup_strategies: Sequence['outputs.GetInstancesInstanceBackupStrategyResult'],
                 created: str,
                 dbs: Sequence['outputs.GetInstancesInstanceDbResult'],
                 enterprise_project_id: str,
                 fixed_ip: str,
                 flavor: str,
                 ha_replication_mode: str,
                 id: str,
                 name: str,
                 nodes: Sequence['outputs.GetInstancesInstanceNodeResult'],
                 param_group_id: str,
                 private_ips: Sequence[str],
                 public_ips: Sequence[str],
                 region: str,
                 security_group_id: str,
                 ssl_enable: bool,
                 status: str,
                 subnet_id: str,
                 tags: Mapping[str, str],
                 time_zone: str,
                 volumes: Sequence['outputs.GetInstancesInstanceVolumeResult'],
                 vpc_id: str):
        """
        :param Sequence[str] availability_zones: Indicates the availability zone where the node resides.
        :param Sequence['GetInstancesInstanceBackupStrategyArgs'] backup_strategies: Indicates the advanced backup policy. Structure is documented below.
        :param str created: Indicates the creation time.
        :param Sequence['GetInstancesInstanceDbArgs'] dbs: Indicates the database information. Structure is documented below.
        :param str enterprise_project_id: Specifies the enterprise project id.
        :param str fixed_ip: Indicates the intranet floating IP address of the instance.
        :param str flavor: Indicates the instance specifications.
        :param str ha_replication_mode: Indicates the replication mode for the standby DB instance.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param Sequence['GetInstancesInstanceNodeArgs'] nodes: Indicates the instance nodes information. Structure is documented below.
        :param str param_group_id: Indicates the configuration ID.
        :param Sequence[str] private_ips: Indicates the private ips in list.
        :param Sequence[str] public_ips: Indicates the public ips in list.
        :param str region: The region in which to obtain the instances. If omitted, the provider-level region will
               be used.
        :param str security_group_id: Indicates the security group ID.
        :param bool ssl_enable: Indicates whether to enable SSL.
        :param str status: Indicates the node status.
        :param str subnet_id: Specifies the network ID of a subnet.
        :param Mapping[str, str] tags: Indicates the tags of the instance.
        :param str time_zone: Indicates the time zone.
        :param Sequence['GetInstancesInstanceVolumeArgs'] volumes: Indicates the volume information. Structure is documented below.
        :param str vpc_id: Specifies the VPC ID.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "dbs", dbs)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "fixed_ip", fixed_ip)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "ha_replication_mode", ha_replication_mode)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "param_group_id", param_group_id)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "public_ips", public_ips)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "ssl_enable", ssl_enable)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetInstancesInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @property
    @pulumi.getter
    def created(self) -> str:
        """
        Indicates the creation time.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def dbs(self) -> Sequence['outputs.GetInstancesInstanceDbResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "dbs")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Specifies the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> str:
        """
        Indicates the intranet floating IP address of the instance.
        """
        return pulumi.get(self, "fixed_ip")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="haReplicationMode")
    def ha_replication_mode(self) -> str:
        """
        Indicates the replication mode for the standby DB instance.
        """
        return pulumi.get(self, "ha_replication_mode")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetInstancesInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="paramGroupId")
    def param_group_id(self) -> str:
        """
        Indicates the configuration ID.
        """
        return pulumi.get(self, "param_group_id")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[str]:
        """
        Indicates the private ips in list.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Sequence[str]:
        """
        Indicates the public ips in list.
        """
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the instances. If omitted, the provider-level region will
        be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> bool:
        """
        Indicates whether to enable SSL.
        """
        return pulumi.get(self, "ssl_enable")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Indicates the tags of the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Indicates the time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.GetInstancesInstanceVolumeResult']:
        """
        Indicates the volume information. Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetInstancesInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated.
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated.
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetInstancesInstanceDbResult(dict):
    def __init__(__self__, *,
                 port: int,
                 type: str,
                 user_name: str,
                 version: str):
        """
        :param int port: Indicates the database port.
        :param str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        :param str user_name: Indicates the database user name.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Indicates the database user name.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetInstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 role: str,
                 status: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str role: Indicates the node type.
        :param str status: Indicates the node status.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Indicates the node type.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetInstancesInstanceVolumeResult(dict):
    def __init__(__self__, *,
                 disk_encryption_id: str,
                 size: int,
                 type: str):
        """
        :param str disk_encryption_id: Indicates the kms key id.
        :param int size: Indicates the volume size.
        :param str type: Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        """
        pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> str:
        """
        Indicates the kms key id.
        """
        return pulumi.get(self, "disk_encryption_id")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Indicates the volume size.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the type of the instance. Valid values are: Single, Ha, Replica, and Enterprise.
        """
        return pulumi.get(self, "type")


