# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['Database_privilegeArgs', 'Database_privilege']

@pulumi.input_type
class Database_privilegeArgs:
    def __init__(__self__, *,
                 db_name: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 users: pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Database_privilege resource.
        :param pulumi.Input[str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]] users: Specifies the account that associated with the database. This parameter supports
               a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "db_name", db_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "users", users)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Input[str]:
        """
        Specifies the database name. Changing this creates a new resource.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def users(self) -> pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]]:
        """
        Specifies the account that associated with the database. This parameter supports
        a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the RDS database privilege resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _Database_privilegeState:
    def __init__(__self__, *,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering Database_privilege resources.
        :param pulumi.Input[str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]] users: Specifies the account that associated with the database. This parameter supports
               a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        """
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the database name. Changing this creates a new resource.
        """
        return pulumi.get(self, "db_name")

    @db_name.setter
    def db_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_name", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the RDS database privilege resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]]]:
        """
        Specifies the account that associated with the database. This parameter supports
        a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['Database_privilegeUserArgs']]]]):
        pulumi.set(self, "users", value)


class Database_privilege(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['Database_privilegeUserArgs']]]]] = None,
                 __props__=None):
        """
        Manages RDS Mysql database privilege resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        db_name = config.require_object("dbName")
        user_name1 = config.require_object("userName1")
        user_name2 = config.require_object("userName2")
        test = huaweicloud.rds.Database_privilege("test",
            instance_id=instance_id,
            db_name=db_name,
            users=[
                huaweicloud.rds.Database_privilegeUserArgs(
                    name=user_name1,
                    readonly=True,
                ),
                huaweicloud.rds.Database_privilegeUserArgs(
                    name=user_name2,
                    readonly=False,
                ),
            ])
        ```

        ## Import

        RDS database privilege can be imported using the `instance id` and `database name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/database_privilege:Database_privilege test instance_id/database_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['Database_privilegeUserArgs']]]] users: Specifies the account that associated with the database. This parameter supports
               a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Database_privilegeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages RDS Mysql database privilege resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        db_name = config.require_object("dbName")
        user_name1 = config.require_object("userName1")
        user_name2 = config.require_object("userName2")
        test = huaweicloud.rds.Database_privilege("test",
            instance_id=instance_id,
            db_name=db_name,
            users=[
                huaweicloud.rds.Database_privilegeUserArgs(
                    name=user_name1,
                    readonly=True,
                ),
                huaweicloud.rds.Database_privilegeUserArgs(
                    name=user_name2,
                    readonly=False,
                ),
            ])
        ```

        ## Import

        RDS database privilege can be imported using the `instance id` and `database name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Rds/database_privilege:Database_privilege test instance_id/database_name
        ```

        :param str resource_name: The name of the resource.
        :param Database_privilegeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Database_privilegeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['Database_privilegeUserArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Database_privilegeArgs.__new__(Database_privilegeArgs)

            if db_name is None and not opts.urn:
                raise TypeError("Missing required property 'db_name'")
            __props__.__dict__["db_name"] = db_name
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            if users is None and not opts.urn:
                raise TypeError("Missing required property 'users'")
            __props__.__dict__["users"] = users
        super(Database_privilege, __self__).__init__(
            'huaweicloud:Rds/database_privilege:Database_privilege',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['Database_privilegeUserArgs']]]]] = None) -> 'Database_privilege':
        """
        Get an existing Database_privilege resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] db_name: Specifies the database name. Changing this creates a new resource.
        :param pulumi.Input[str] instance_id: Specifies the RDS instance ID. Changing this will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the RDS database privilege resource. If omitted,
               the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['Database_privilegeUserArgs']]]] users: Specifies the account that associated with the database. This parameter supports
               a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Database_privilegeState.__new__(_Database_privilegeState)

        __props__.__dict__["db_name"] = db_name
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["users"] = users
        return Database_privilege(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        Specifies the database name. Changing this creates a new resource.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the RDS instance ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the RDS database privilege resource. If omitted,
        the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def users(self) -> pulumi.Output[Sequence['outputs.Database_privilegeUser']]:
        """
        Specifies the account that associated with the database. This parameter supports
        a maximum of 50 elements. Structure is documented below. Changing this creates a new resource.
        """
        return pulumi.get(self, "users")

