# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'Database_privilegeUserArgs',
    'InstanceBackupStrategyArgs',
    'InstanceDbArgs',
    'InstanceNodeArgs',
    'InstanceVolumeArgs',
    'ParametergroupConfigurationParameterArgs',
    'ParametergroupDatastoreArgs',
    'ReadReplicaInstanceDbArgs',
    'ReadReplicaInstanceVolumeArgs',
    'GetEngineVersionsVersionArgs',
]

@pulumi.input_type
class Database_privilegeUserArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 readonly: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] name: Specifies the username of the database account. Changing this creates a new resource.
        :param pulumi.Input[bool] readonly: Specifies the read-only permission. The value can be:
               + **true**: indicates the read-only permission.
               + **false**: indicates the read and write permission.
        """
        pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Specifies the username of the database account. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies the read-only permission. The value can be:
        + **true**: indicates the read-only permission.
        + **false**: indicates the read and write permission.
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "readonly", value)


@pulumi.input_type
class InstanceBackupStrategyArgs:
    def __init__(__self__, *,
                 start_time: pulumi.Input[str],
                 keep_days: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the **hh:mm-HH:MM**
               format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
               MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
               00.
        :param pulumi.Input[int] keep_days: Specifies the retention days for specific backup files. The value range is from 0 to
               732. If this parameter is not specified or set to 0, the automated backup policy is disabled.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the **hh:mm-HH:MM**
        format. The current time is in the UTC format. The HH value must be 1 greater than the hh value. The values of mm and
        MM must be the same and must be set to any of the following: 00, 15, 30, or 45. Example value: 08:15-09:15 23:00-00:
        00.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the retention days for specific backup files. The value range is from 0 to
        732. If this parameter is not specified or set to 0, the automated backup policy is disabled.
        """
        return pulumi.get(self, "keep_days")

    @keep_days.setter
    def keep_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "keep_days", value)


@pulumi.input_type
class InstanceDbArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 type: pulumi.Input[str],
                 version: pulumi.Input[str],
                 port: Optional[pulumi.Input[int]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] password: Specifies the database password. The value cannot be empty and should
               contain 8 to 32 characters, including uppercase and lowercase letters, digits, and the following special
               characters: ~!@#%^*-_=+? You are advised to enter a strong password to improve security, preventing security risks
               such as brute force cracking. Changing this parameter will create a new resource.
        :param pulumi.Input[str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param pulumi.Input[str] version: Specifies the database version. Changing this parameter will create a new
               resource. Available values detailed in
               [DB Engines and Versions](https://support.huaweicloud.com/intl/en-us/productdesc-rds/en-us_topic_0043898356.html).
        :param pulumi.Input[int] port: Specifies the database port.
               + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
               and cannot be used). The default value is 3306.
               + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
               + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
               default value is 1433.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the database password. The value cannot be empty and should
        contain 8 to 32 characters, including uppercase and lowercase letters, digits, and the following special
        characters: ~!@#%^*-_=+? You are advised to enter a strong password to improve security, preventing security risks
        such as brute force cracking. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the database version. Changing this parameter will create a new
        resource. Available values detailed in
        [DB Engines and Versions](https://support.huaweicloud.com/intl/en-us/productdesc-rds/en-us_topic_0043898356.html).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the database port.
        + The MySQL database port ranges from 1024 to 65535 (excluding 12017 and 33071, which are occupied by the RDS system
        and cannot be used). The default value is 3306.
        + The PostgreSQL database port ranges from 2100 to 9500. The default value is 5432.
        + The Microsoft SQL Server database port can be 1433 or ranges from 2100 to 9500, excluding 5355 and 5985. The
        default value is 1433.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


@pulumi.input_type
class InstanceNodeArgs:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] availability_zone: Specifies the list of AZ name. Changing this parameter will create a
               new resource.
        :param pulumi.Input[str] id: Indicates the node ID.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type must be unique for
               the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
               contain only letters, digits, hyphens (-), and underscores (_).
        :param pulumi.Input[str] role: Indicates the node type. The value can be master or slave, indicating the primary node or standby node
               respectively.
        :param pulumi.Input[str] status: Indicates the node status.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the list of AZ name. Changing this parameter will create a
        new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type must be unique for
        the same tenant. The value must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can
        contain only letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node type. The value can be master or slave, indicating the primary node or standby node
        respectively.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class InstanceVolumeArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[int],
                 type: pulumi.Input[str],
                 disk_encryption_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] size: Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
               multiple of 10 and greater than the original size.
        :param pulumi.Input[str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param pulumi.Input[str] disk_encryption_id: Specifies the key ID for disk encryption. Changing this parameter will create a new
               resource.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the volume size. Its value range is from 40 GB to 4000 GB. The value must be a
        multiple of 10 and greater than the original size.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key ID for disk encryption. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_id", value)


@pulumi.input_type
class ParametergroupConfigurationParameterArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 readonly: Optional[pulumi.Input[bool]] = None,
                 restart_required: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None,
                 value_range: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] description: The parameter group description. It contains a maximum of 256 characters and cannot
               contain the following special characters:>!<"&'= the value is left blank by default.
        :param pulumi.Input[str] name: The parameter group name. It contains a maximum of 64 characters.
        :param pulumi.Input[bool] readonly: Indicates whether the parameter is read-only.
        :param pulumi.Input[bool] restart_required: Indicates whether a restart is required.
        :param pulumi.Input[str] type: The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
               value is case-insensitive and can be mysql, postgresql, or sqlserver.
        :param pulumi.Input[str] value: Indicates the parameter value.
        :param pulumi.Input[str] value_range: Indicates the parameter value range.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if readonly is not None:
            pulumi.set(__self__, "readonly", readonly)
        if restart_required is not None:
            pulumi.set(__self__, "restart_required", restart_required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)
        if value_range is not None:
            pulumi.set(__self__, "value_range", value_range)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter group description. It contains a maximum of 256 characters and cannot
        contain the following special characters:>!<"&'= the value is left blank by default.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The parameter group name. It contains a maximum of 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def readonly(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the parameter is read-only.
        """
        return pulumi.get(self, "readonly")

    @readonly.setter
    def readonly(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "readonly", value)

    @property
    @pulumi.getter(name="restartRequired")
    def restart_required(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether a restart is required.
        """
        return pulumi.get(self, "restart_required")

    @restart_required.setter
    def restart_required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "restart_required", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
        value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the parameter value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="valueRange")
    def value_range(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the parameter value range.
        """
        return pulumi.get(self, "value_range")

    @value_range.setter
    def value_range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_range", value)


@pulumi.input_type
class ParametergroupDatastoreArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
               value is case-insensitive and can be mysql, postgresql, or sqlserver.
        :param pulumi.Input[str] version: Specifies the database version.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The DB engine. Currently, MySQL, PostgreSQL, and Microsoft SQL Server are supported. The
        value is case-insensitive and can be mysql, postgresql, or sqlserver.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Specifies the database version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ReadReplicaInstanceDbArgs:
    def __init__(__self__, *,
                 port: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: Indicates the database port information.
        :param pulumi.Input[str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param pulumi.Input[str] user_name: Indicates the default user name of database.
        :param pulumi.Input[str] version: Indicates the database version.
        """
        if port is not None:
            pulumi.set(__self__, "port", port)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the database port information.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the default user name of database.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ReadReplicaInstanceVolumeArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 disk_encryption_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] type: Specifies the volume type. Its value can be any of the following and is
               case-sensitive:
               + *ULTRAHIGH*: SSD storage.
               + *LOCALSSD*: local SSD storage.
               + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
               instances.
               + *ESSD*: extreme SSD storage.
        :param pulumi.Input[str] disk_encryption_id: Specifies the key ID for disk encryption. Changing this parameter
               will create a new resource.
        """
        pulumi.set(__self__, "type", type)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the volume type. Its value can be any of the following and is
        case-sensitive:
        + *ULTRAHIGH*: SSD storage.
        + *LOCALSSD*: local SSD storage.
        + *CLOUDSSD*: cloud SSD storage. This storage type is supported only with general-purpose and dedicated DB
        instances.
        + *ESSD*: extreme SSD storage.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the key ID for disk encryption. Changing this parameter
        will create a new resource.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class GetEngineVersionsVersionArgs:
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: Version ID.
        :param str name: Version name.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Version ID.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: str):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Version name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)


