# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ProjectArgs', 'Project']

@pulumi.input_type
class ProjectArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 template_id: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Project resource.
        :param pulumi.Input[str] type: The type of project.  
               The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        :param pulumi.Input[str] description: The description about the project.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project ID of the project.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[str] name: The project name.  
               The name can contain 1 to 128 characters.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source: The source of project.
        :param pulumi.Input[int] template_id: The template id which used to create project.
        """
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of project.  
        The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description about the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project ID of the project.  
        Value 0 indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name.  
        The name can contain 1 to 128 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of project.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[int]]:
        """
        The template id which used to create project.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "template_id", value)


@pulumi.input_type
class _ProjectState:
    def __init__(__self__, *,
                 archive: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_code: Optional[pulumi.Input[str]] = None,
                 project_num_id: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 template_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Project resources.
        :param pulumi.Input[int] archive: Whether the project is archived.
        :param pulumi.Input[str] description: The description about the project.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project ID of the project.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[str] name: The project name.  
               The name can contain 1 to 128 characters.
        :param pulumi.Input[str] project_code: The project code.
        :param pulumi.Input[int] project_num_id: The number id of project.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source: The source of project.
        :param pulumi.Input[int] template_id: The template id which used to create project.
        :param pulumi.Input[str] type: The type of project.  
               The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        """
        if archive is not None:
            pulumi.set(__self__, "archive", archive)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_code is not None:
            pulumi.set(__self__, "project_code", project_code)
        if project_num_id is not None:
            pulumi.set(__self__, "project_num_id", project_num_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if template_id is not None:
            pulumi.set(__self__, "template_id", template_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def archive(self) -> Optional[pulumi.Input[int]]:
        """
        Whether the project is archived.
        """
        return pulumi.get(self, "archive")

    @archive.setter
    def archive(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "archive", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description about the project.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project ID of the project.  
        Value 0 indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name.  
        The name can contain 1 to 128 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="projectCode")
    def project_code(self) -> Optional[pulumi.Input[str]]:
        """
        The project code.
        """
        return pulumi.get(self, "project_code")

    @project_code.setter
    def project_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_code", value)

    @property
    @pulumi.getter(name="projectNumId")
    def project_num_id(self) -> Optional[pulumi.Input[int]]:
        """
        The number id of project.
        """
        return pulumi.get(self, "project_num_id")

    @project_num_id.setter
    def project_num_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "project_num_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of project.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> Optional[pulumi.Input[int]]:
        """
        The template id which used to create project.
        """
        return pulumi.get(self, "template_id")

    @template_id.setter
    def template_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "template_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of project.  
        The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Project(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 template_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Project resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.project_man.Project("test", type="scrum")
        ```

        ## Import

        The project can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:ProjectMan/project:Project test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description about the project.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project ID of the project.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[str] name: The project name.  
               The name can contain 1 to 128 characters.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source: The source of project.
        :param pulumi.Input[int] template_id: The template id which used to create project.
        :param pulumi.Input[str] type: The type of project.  
               The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Project resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        test = huaweicloud.project_man.Project("test", type="scrum")
        ```

        ## Import

        The project can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:ProjectMan/project:Project test 0ce123456a00f2591fabc00385ff1234
        ```

        :param str resource_name: The name of the resource.
        :param ProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 template_id: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectArgs.__new__(ProjectArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["source"] = source
            __props__.__dict__["template_id"] = template_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["archive"] = None
            __props__.__dict__["project_code"] = None
            __props__.__dict__["project_num_id"] = None
        super(Project, __self__).__init__(
            'huaweicloud:ProjectMan/project:Project',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            archive: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_code: Optional[pulumi.Input[str]] = None,
            project_num_id: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            template_id: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Project':
        """
        Get an existing Project resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] archive: Whether the project is archived.
        :param pulumi.Input[str] description: The description about the project.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project ID of the project.  
               Value 0 indicates the default enterprise project.
        :param pulumi.Input[str] name: The project name.  
               The name can contain 1 to 128 characters.
        :param pulumi.Input[str] project_code: The project code.
        :param pulumi.Input[int] project_num_id: The number id of project.
        :param pulumi.Input[str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] source: The source of project.
        :param pulumi.Input[int] template_id: The template id which used to create project.
        :param pulumi.Input[str] type: The type of project.  
               The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectState.__new__(_ProjectState)

        __props__.__dict__["archive"] = archive
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["project_code"] = project_code
        __props__.__dict__["project_num_id"] = project_num_id
        __props__.__dict__["region"] = region
        __props__.__dict__["source"] = source
        __props__.__dict__["template_id"] = template_id
        __props__.__dict__["type"] = type
        return Project(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def archive(self) -> pulumi.Output[int]:
        """
        Whether the project is archived.
        """
        return pulumi.get(self, "archive")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description about the project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project ID of the project.  
        Value 0 indicates the default enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The project name.  
        The name can contain 1 to 128 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectCode")
    def project_code(self) -> pulumi.Output[str]:
        """
        The project code.
        """
        return pulumi.get(self, "project_code")

    @property
    @pulumi.getter(name="projectNumId")
    def project_num_id(self) -> pulumi.Output[int]:
        """
        The number id of project.
        """
        return pulumi.get(self, "project_num_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source of project.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="templateId")
    def template_id(self) -> pulumi.Output[int]:
        """
        The template id which used to create project.
        """
        return pulumi.get(self, "template_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of project.  
        The valid values are **scrum**, **xboard**, **basic**, **phoenix**.
        """
        return pulumi.get(self, "type")

