# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 acl: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]] = None,
                 encryption: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_project_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 parallel_fs: Optional[pulumi.Input[bool]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 policy_format: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input[bool]] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input[str] bucket: Specifies the name of the bucket. Changing this parameter will create a new
               resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
               + The name must be globally unique in OBS.
               + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
               allowed.
               + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
               contain a period (.) and a hyphen (-) adjacent to each other.
               + The name cannot be an IP address.
               + If the name contains any periods (.), a security certificate verification message may appear when you access the
               bucket or its objects by entering a domain name.
        :param pulumi.Input[str] acl: Specifies the ACL policy for a bucket. The predefined common policies are as follows:
               "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]] cors_rules: A rule of Cross-Origin Resource Sharing (documented below).
        :param pulumi.Input[bool] encryption: Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the OBS bucket. Changing
               this will create a new bucket.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket, so that the
               bucket can be destroyed without error. Default to `false`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of a KMS key. If omitted, the default master key will be used.
        :param pulumi.Input[str] kms_key_project_id: Specifies the project ID to which the KMS key belongs. If omitted, the ID
               of the provider-level project will be used.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of object lifecycle management (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]] loggings: A settings of bucket logging (documented below).
        :param pulumi.Input[bool] multi_az: Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
               enabled, data in the bucket is duplicated and stored in multiple AZs.
        :param pulumi.Input[bool] parallel_fs: Whether enable a bucket as a parallel file system. Changing this will
               create a new bucket.
        :param pulumi.Input[str] policy: Specifies the text of the bucket policy in JSON format. For more information about obs
               format bucket policy,
               see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        :param pulumi.Input[str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults
               to *obs*.
        :param pulumi.Input[int] quota: Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
               storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
               quota is not limited.
               <!-- markdownlint-enable MD033 -->
        :param pulumi.Input[str] region: Specifies the region where this bucket will be created. If not specified, used
               the region by the provider. Changing this will create a new bucket.
        :param pulumi.Input[str] storage_class: Specifies the storage class of the bucket. OBS provides three storage classes:
               "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        :param pulumi.Input[bool] versioning: Whether enable versioning. Once you version-enable a bucket, it can never return to an
               unversioned state. You can, however, suspend versioning on that bucket.
        :param pulumi.Input['BucketWebsiteArgs'] website: A website object (documented below).
        """
        pulumi.set(__self__, "bucket", bucket)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_project_id is not None:
            pulumi.set(__self__, "kms_key_project_id", kms_key_project_id)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if parallel_fs is not None:
            pulumi.set(__self__, "parallel_fs", parallel_fs)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_format is not None:
            pulumi.set(__self__, "policy_format", policy_format)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Specifies the name of the bucket. Changing this parameter will create a new
        resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
        + The name must be globally unique in OBS.
        + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
        allowed.
        + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
        contain a period (.) and a hyphen (-) adjacent to each other.
        + The name cannot be an IP address.
        + If the name contains any periods (.), a security certificate verification message may appear when you access the
        bucket or its objects by entering a domain name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ACL policy for a bucket. The predefined common policies are as follows:
        "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]:
        """
        A rule of Cross-Origin Resource Sharing (documented below).
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the OBS bucket. Changing
        this will create a new bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket, so that the
        bucket can be destroyed without error. Default to `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a KMS key. If omitted, the default master key will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyProjectId")
    def kms_key_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID to which the KMS key belongs. If omitted, the ID
        of the provider-level project will be used.
        """
        return pulumi.get(self, "kms_key_project_id")

    @kms_key_project_id.setter
    def kms_key_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_project_id", value)

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        A configuration of object lifecycle management (documented below).
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]]]:
        """
        A settings of bucket logging (documented below).
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
        enabled, data in the bucket is duplicated and stored in multiple AZs.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter(name="parallelFs")
    def parallel_fs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable a bucket as a parallel file system. Changing this will
        create a new bucket.
        """
        return pulumi.get(self, "parallel_fs")

    @parallel_fs.setter
    def parallel_fs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parallel_fs", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the text of the bucket policy in JSON format. For more information about obs
        format bucket policy,
        see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyFormat")
    def policy_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy format, the supported values are *obs* and *s3*. Defaults
        to *obs*.
        """
        return pulumi.get(self, "policy_format")

    @policy_format.setter
    def policy_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_format", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
        storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
        quota is not limited.
        <!-- markdownlint-enable MD033 -->
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where this bucket will be created. If not specified, used
        the region by the provider. Changing this will create a new bucket.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage class of the bucket. OBS provides three storage classes:
        "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable versioning. Once you version-enable a bucket, it can never return to an
        unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "versioning", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        A website object (documented below).
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


@pulumi.input_type
class _BucketState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_domain_name: Optional[pulumi.Input[str]] = None,
                 bucket_version: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]] = None,
                 encryption: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_project_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 parallel_fs: Optional[pulumi.Input[bool]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 policy_format: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input[bool]] = None,
                 website: Optional[pulumi.Input['BucketWebsiteArgs']] = None):
        """
        Input properties used for looking up and filtering Bucket resources.
        :param pulumi.Input[str] acl: Specifies the ACL policy for a bucket. The predefined common policies are as follows:
               "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        :param pulumi.Input[str] bucket: Specifies the name of the bucket. Changing this parameter will create a new
               resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
               + The name must be globally unique in OBS.
               + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
               allowed.
               + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
               contain a period (.) and a hyphen (-) adjacent to each other.
               + The name cannot be an IP address.
               + If the name contains any periods (.), a security certificate verification message may appear when you access the
               bucket or its objects by entering a domain name.
        :param pulumi.Input[str] bucket_domain_name: The bucket domain name. Will be of format `bucketname.obs.region.myhuaweicloud.com`.
        :param pulumi.Input[str] bucket_version: The OBS version of the bucket.
        :param pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]] cors_rules: A rule of Cross-Origin Resource Sharing (documented below).
        :param pulumi.Input[bool] encryption: Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the OBS bucket. Changing
               this will create a new bucket.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket, so that the
               bucket can be destroyed without error. Default to `false`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of a KMS key. If omitted, the default master key will be used.
        :param pulumi.Input[str] kms_key_project_id: Specifies the project ID to which the KMS key belongs. If omitted, the ID
               of the provider-level project will be used.
        :param pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of object lifecycle management (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]] loggings: A settings of bucket logging (documented below).
        :param pulumi.Input[bool] multi_az: Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
               enabled, data in the bucket is duplicated and stored in multiple AZs.
        :param pulumi.Input[bool] parallel_fs: Whether enable a bucket as a parallel file system. Changing this will
               create a new bucket.
        :param pulumi.Input[str] policy: Specifies the text of the bucket policy in JSON format. For more information about obs
               format bucket policy,
               see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        :param pulumi.Input[str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults
               to *obs*.
        :param pulumi.Input[int] quota: Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
               storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
               quota is not limited.
               <!-- markdownlint-enable MD033 -->
        :param pulumi.Input[str] region: Specifies the region where this bucket will be created. If not specified, used
               the region by the provider. Changing this will create a new bucket.
        :param pulumi.Input[str] storage_class: Specifies the storage class of the bucket. OBS provides three storage classes:
               "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        :param pulumi.Input[bool] versioning: Whether enable versioning. Once you version-enable a bucket, it can never return to an
               unversioned state. You can, however, suspend versioning on that bucket.
        :param pulumi.Input['BucketWebsiteArgs'] website: A website object (documented below).
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_domain_name is not None:
            pulumi.set(__self__, "bucket_domain_name", bucket_domain_name)
        if bucket_version is not None:
            pulumi.set(__self__, "bucket_version", bucket_version)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_project_id is not None:
            pulumi.set(__self__, "kms_key_project_id", kms_key_project_id)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if multi_az is not None:
            pulumi.set(__self__, "multi_az", multi_az)
        if parallel_fs is not None:
            pulumi.set(__self__, "parallel_fs", parallel_fs)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if policy_format is not None:
            pulumi.set(__self__, "policy_format", policy_format)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ACL policy for a bucket. The predefined common policies are as follows:
        "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the bucket. Changing this parameter will create a new
        resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
        + The name must be globally unique in OBS.
        + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
        allowed.
        + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
        contain a period (.) and a hyphen (-) adjacent to each other.
        + The name cannot be an IP address.
        + If the name contains any periods (.), a security certificate verification message may appear when you access the
        bucket or its objects by entering a domain name.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket domain name. Will be of format `bucketname.obs.region.myhuaweicloud.com`.
        """
        return pulumi.get(self, "bucket_domain_name")

    @bucket_domain_name.setter
    def bucket_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_domain_name", value)

    @property
    @pulumi.getter(name="bucketVersion")
    def bucket_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OBS version of the bucket.
        """
        return pulumi.get(self, "bucket_version")

    @bucket_version.setter
    def bucket_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_version", value)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]:
        """
        A rule of Cross-Origin Resource Sharing (documented below).
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the OBS bucket. Changing
        this will create a new bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket, so that the
        bucket can be destroyed without error. Default to `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of a KMS key. If omitted, the default master key will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyProjectId")
    def kms_key_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the project ID to which the KMS key belongs. If omitted, the ID
        of the provider-level project will be used.
        """
        return pulumi.get(self, "kms_key_project_id")

    @kms_key_project_id.setter
    def kms_key_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_project_id", value)

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]:
        """
        A configuration of object lifecycle management (documented below).
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]]]:
        """
        A settings of bucket logging (documented below).
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
        enabled, data in the bucket is duplicated and stored in multiple AZs.
        """
        return pulumi.get(self, "multi_az")

    @multi_az.setter
    def multi_az(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multi_az", value)

    @property
    @pulumi.getter(name="parallelFs")
    def parallel_fs(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable a bucket as a parallel file system. Changing this will
        create a new bucket.
        """
        return pulumi.get(self, "parallel_fs")

    @parallel_fs.setter
    def parallel_fs(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "parallel_fs", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the text of the bucket policy in JSON format. For more information about obs
        format bucket policy,
        see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="policyFormat")
    def policy_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the policy format, the supported values are *obs* and *s3*. Defaults
        to *obs*.
        """
        return pulumi.get(self, "policy_format")

    @policy_format.setter
    def policy_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_format", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
        storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
        quota is not limited.
        <!-- markdownlint-enable MD033 -->
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "quota", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where this bucket will be created. If not specified, used
        the region by the provider. Changing this will create a new bucket.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the storage class of the bucket. OBS provides three storage classes:
        "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable versioning. Once you version-enable a bucket, it can never return to an
        unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "versioning", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['BucketWebsiteArgs']]:
        """
        A website object (documented below).
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['BucketWebsiteArgs']]):
        pulumi.set(self, "website", value)


class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsRuleArgs']]]]] = None,
                 encryption: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_project_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLifecycleRuleArgs']]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]]]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 parallel_fs: Optional[pulumi.Input[bool]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 policy_format: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input[bool]] = None,
                 website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgs']]] = None,
                 __props__=None):
        """
        Provides an OBS bucket resource.

        ## Example Usage
        ### Private Bucket with Tags

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="private",
            bucket="my-tf-test-bucket",
            tags={
                "Env": "Test",
                "foo": "bar",
            })
        ```
        ### Enable versioning

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="private",
            bucket="my-tf-test-bucket",
            versioning=True)
        ```
        ### Enable Logging

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        log_bucket = huaweicloud.obs.Bucket("logBucket",
            bucket="my-tf-log-bucket",
            acl="log-delivery-write")
        bucket = huaweicloud.obs.Bucket("bucket",
            bucket="my-tf-test-bucket",
            acl="private",
            loggings=[huaweicloud.obs.BucketLoggingArgs(
                target_bucket=log_bucket.id,
                target_prefix="log/",
            )])
        ```
        ### Static Website Hosting

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="public-read",
            bucket="obs-website-test.hashicorp.com",
            website=huaweicloud.obs.BucketWebsiteArgs(
                error_document="error.html",
                index_document="index.html",
                routing_rules=\"\"\"[{
            "Condition": {
                "KeyPrefixEquals": "docs/"
            },
            "Redirect": {
                "ReplaceKeyPrefixWith": "documents/"
            }
        }]

        \"\"\",
            ))
        ```
        ### Using CORS

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="public-read",
            bucket="obs-website-test.hashicorp.com",
            cors_rules=[huaweicloud.obs.BucketCorsRuleArgs(
                allowed_headers=["*"],
                allowed_methods=[
                    "PUT",
                    "POST",
                ],
                allowed_origins=["https://obs-website-test.hashicorp.com"],
                expose_headers=["ETag"],
                max_age_seconds=3000,
            )])
        ```
        ### Using object lifecycle

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="private",
            bucket="my-bucket",
            lifecycle_rules=[
                huaweicloud.obs.BucketLifecycleRuleArgs(
                    enabled=True,
                    expirations=[huaweicloud.obs.BucketLifecycleRuleExpirationArgs(
                        days=365,
                    )],
                    name="log",
                    prefix="log/",
                    transitions=[
                        huaweicloud.obs.BucketLifecycleRuleTransitionArgs(
                            days=60,
                            storage_class="WARM",
                        ),
                        huaweicloud.obs.BucketLifecycleRuleTransitionArgs(
                            days=180,
                            storage_class="COLD",
                        ),
                    ],
                ),
                huaweicloud.obs.BucketLifecycleRuleArgs(
                    enabled=True,
                    name="tmp",
                    noncurrent_version_expirations=[huaweicloud.obs.BucketLifecycleRuleNoncurrentVersionExpirationArgs(
                        days=180,
                    )],
                    noncurrent_version_transitions=[
                        huaweicloud.obs.BucketLifecycleRuleNoncurrentVersionTransitionArgs(
                            days=30,
                            storage_class="WARM",
                        ),
                        huaweicloud.obs.BucketLifecycleRuleNoncurrentVersionTransitionArgs(
                            days=60,
                            storage_class="COLD",
                        ),
                    ],
                    prefix="tmp/",
                ),
            ],
            versioning=True)
        ```

        ## Import

        OBS bucket can be imported using the `bucket`, e.g.

        ```sh
         $ pulumi import huaweicloud:Obs/bucket:Bucket bucket <bucket-name>
        ```

         OBS bucket with S3 foramt bucket policy can be imported using the `bucket` and "s3" by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Obs/bucket:Bucket bucket_with_s3_policy <bucket-name>/s3
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response. The missing attributes include `acl` and `force_destroy`. It is generally recommended running `terraform plan` after importing an OBS bucket. Also you can ignore changes as below. resource "huaweicloud_obs_bucket" "bucket" {

         ...

         lifecycle {

         ignore_changes = [

         acl, force_destroy,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: Specifies the ACL policy for a bucket. The predefined common policies are as follows:
               "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        :param pulumi.Input[str] bucket: Specifies the name of the bucket. Changing this parameter will create a new
               resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
               + The name must be globally unique in OBS.
               + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
               allowed.
               + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
               contain a period (.) and a hyphen (-) adjacent to each other.
               + The name cannot be an IP address.
               + If the name contains any periods (.), a security certificate verification message may appear when you access the
               bucket or its objects by entering a domain name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsRuleArgs']]]] cors_rules: A rule of Cross-Origin Resource Sharing (documented below).
        :param pulumi.Input[bool] encryption: Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the OBS bucket. Changing
               this will create a new bucket.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket, so that the
               bucket can be destroyed without error. Default to `false`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of a KMS key. If omitted, the default master key will be used.
        :param pulumi.Input[str] kms_key_project_id: Specifies the project ID to which the KMS key belongs. If omitted, the ID
               of the provider-level project will be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLifecycleRuleArgs']]]] lifecycle_rules: A configuration of object lifecycle management (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]]] loggings: A settings of bucket logging (documented below).
        :param pulumi.Input[bool] multi_az: Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
               enabled, data in the bucket is duplicated and stored in multiple AZs.
        :param pulumi.Input[bool] parallel_fs: Whether enable a bucket as a parallel file system. Changing this will
               create a new bucket.
        :param pulumi.Input[str] policy: Specifies the text of the bucket policy in JSON format. For more information about obs
               format bucket policy,
               see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        :param pulumi.Input[str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults
               to *obs*.
        :param pulumi.Input[int] quota: Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
               storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
               quota is not limited.
               <!-- markdownlint-enable MD033 -->
        :param pulumi.Input[str] region: Specifies the region where this bucket will be created. If not specified, used
               the region by the provider. Changing this will create a new bucket.
        :param pulumi.Input[str] storage_class: Specifies the storage class of the bucket. OBS provides three storage classes:
               "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        :param pulumi.Input[bool] versioning: Whether enable versioning. Once you version-enable a bucket, it can never return to an
               unversioned state. You can, however, suspend versioning on that bucket.
        :param pulumi.Input[pulumi.InputType['BucketWebsiteArgs']] website: A website object (documented below).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides an OBS bucket resource.

        ## Example Usage
        ### Private Bucket with Tags

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="private",
            bucket="my-tf-test-bucket",
            tags={
                "Env": "Test",
                "foo": "bar",
            })
        ```
        ### Enable versioning

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="private",
            bucket="my-tf-test-bucket",
            versioning=True)
        ```
        ### Enable Logging

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        log_bucket = huaweicloud.obs.Bucket("logBucket",
            bucket="my-tf-log-bucket",
            acl="log-delivery-write")
        bucket = huaweicloud.obs.Bucket("bucket",
            bucket="my-tf-test-bucket",
            acl="private",
            loggings=[huaweicloud.obs.BucketLoggingArgs(
                target_bucket=log_bucket.id,
                target_prefix="log/",
            )])
        ```
        ### Static Website Hosting

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="public-read",
            bucket="obs-website-test.hashicorp.com",
            website=huaweicloud.obs.BucketWebsiteArgs(
                error_document="error.html",
                index_document="index.html",
                routing_rules=\"\"\"[{
            "Condition": {
                "KeyPrefixEquals": "docs/"
            },
            "Redirect": {
                "ReplaceKeyPrefixWith": "documents/"
            }
        }]

        \"\"\",
            ))
        ```
        ### Using CORS

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="public-read",
            bucket="obs-website-test.hashicorp.com",
            cors_rules=[huaweicloud.obs.BucketCorsRuleArgs(
                allowed_headers=["*"],
                allowed_methods=[
                    "PUT",
                    "POST",
                ],
                allowed_origins=["https://obs-website-test.hashicorp.com"],
                expose_headers=["ETag"],
                max_age_seconds=3000,
            )])
        ```
        ### Using object lifecycle

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        bucket = huaweicloud.obs.Bucket("bucket",
            acl="private",
            bucket="my-bucket",
            lifecycle_rules=[
                huaweicloud.obs.BucketLifecycleRuleArgs(
                    enabled=True,
                    expirations=[huaweicloud.obs.BucketLifecycleRuleExpirationArgs(
                        days=365,
                    )],
                    name="log",
                    prefix="log/",
                    transitions=[
                        huaweicloud.obs.BucketLifecycleRuleTransitionArgs(
                            days=60,
                            storage_class="WARM",
                        ),
                        huaweicloud.obs.BucketLifecycleRuleTransitionArgs(
                            days=180,
                            storage_class="COLD",
                        ),
                    ],
                ),
                huaweicloud.obs.BucketLifecycleRuleArgs(
                    enabled=True,
                    name="tmp",
                    noncurrent_version_expirations=[huaweicloud.obs.BucketLifecycleRuleNoncurrentVersionExpirationArgs(
                        days=180,
                    )],
                    noncurrent_version_transitions=[
                        huaweicloud.obs.BucketLifecycleRuleNoncurrentVersionTransitionArgs(
                            days=30,
                            storage_class="WARM",
                        ),
                        huaweicloud.obs.BucketLifecycleRuleNoncurrentVersionTransitionArgs(
                            days=60,
                            storage_class="COLD",
                        ),
                    ],
                    prefix="tmp/",
                ),
            ],
            versioning=True)
        ```

        ## Import

        OBS bucket can be imported using the `bucket`, e.g.

        ```sh
         $ pulumi import huaweicloud:Obs/bucket:Bucket bucket <bucket-name>
        ```

         OBS bucket with S3 foramt bucket policy can be imported using the `bucket` and "s3" by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Obs/bucket:Bucket bucket_with_s3_policy <bucket-name>/s3
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response. The missing attributes include `acl` and `force_destroy`. It is generally recommended running `terraform plan` after importing an OBS bucket. Also you can ignore changes as below. resource "huaweicloud_obs_bucket" "bucket" {

         ...

         lifecycle {

         ignore_changes = [

         acl, force_destroy,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsRuleArgs']]]]] = None,
                 encryption: Optional[pulumi.Input[bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 kms_key_project_id: Optional[pulumi.Input[str]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLifecycleRuleArgs']]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]]]] = None,
                 multi_az: Optional[pulumi.Input[bool]] = None,
                 parallel_fs: Optional[pulumi.Input[bool]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 policy_format: Optional[pulumi.Input[str]] = None,
                 quota: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input[bool]] = None,
                 website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["acl"] = acl
            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cors_rules"] = cors_rules
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["kms_key_project_id"] = kms_key_project_id
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["loggings"] = loggings
            __props__.__dict__["multi_az"] = multi_az
            __props__.__dict__["parallel_fs"] = parallel_fs
            __props__.__dict__["policy"] = policy
            __props__.__dict__["policy_format"] = policy_format
            __props__.__dict__["quota"] = quota
            __props__.__dict__["region"] = region
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["bucket_domain_name"] = None
            __props__.__dict__["bucket_version"] = None
        super(Bucket, __self__).__init__(
            'huaweicloud:Obs/bucket:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[str]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            bucket_domain_name: Optional[pulumi.Input[str]] = None,
            bucket_version: Optional[pulumi.Input[str]] = None,
            cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsRuleArgs']]]]] = None,
            encryption: Optional[pulumi.Input[bool]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            kms_key_project_id: Optional[pulumi.Input[str]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLifecycleRuleArgs']]]]] = None,
            loggings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]]]] = None,
            multi_az: Optional[pulumi.Input[bool]] = None,
            parallel_fs: Optional[pulumi.Input[bool]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            policy_format: Optional[pulumi.Input[str]] = None,
            quota: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            storage_class: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            versioning: Optional[pulumi.Input[bool]] = None,
            website: Optional[pulumi.Input[pulumi.InputType['BucketWebsiteArgs']]] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: Specifies the ACL policy for a bucket. The predefined common policies are as follows:
               "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        :param pulumi.Input[str] bucket: Specifies the name of the bucket. Changing this parameter will create a new
               resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
               + The name must be globally unique in OBS.
               + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
               allowed.
               + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
               contain a period (.) and a hyphen (-) adjacent to each other.
               + The name cannot be an IP address.
               + If the name contains any periods (.), a security certificate verification message may appear when you access the
               bucket or its objects by entering a domain name.
        :param pulumi.Input[str] bucket_domain_name: The bucket domain name. Will be of format `bucketname.obs.region.myhuaweicloud.com`.
        :param pulumi.Input[str] bucket_version: The OBS version of the bucket.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketCorsRuleArgs']]]] cors_rules: A rule of Cross-Origin Resource Sharing (documented below).
        :param pulumi.Input[bool] encryption: Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the OBS bucket. Changing
               this will create a new bucket.
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket, so that the
               bucket can be destroyed without error. Default to `false`.
        :param pulumi.Input[str] kms_key_id: Specifies the ID of a KMS key. If omitted, the default master key will be used.
        :param pulumi.Input[str] kms_key_project_id: Specifies the project ID to which the KMS key belongs. If omitted, the ID
               of the provider-level project will be used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLifecycleRuleArgs']]]] lifecycle_rules: A configuration of object lifecycle management (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketLoggingArgs']]]] loggings: A settings of bucket logging (documented below).
        :param pulumi.Input[bool] multi_az: Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
               enabled, data in the bucket is duplicated and stored in multiple AZs.
        :param pulumi.Input[bool] parallel_fs: Whether enable a bucket as a parallel file system. Changing this will
               create a new bucket.
        :param pulumi.Input[str] policy: Specifies the text of the bucket policy in JSON format. For more information about obs
               format bucket policy,
               see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        :param pulumi.Input[str] policy_format: Specifies the policy format, the supported values are *obs* and *s3*. Defaults
               to *obs*.
        :param pulumi.Input[int] quota: Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
               storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
               quota is not limited.
               <!-- markdownlint-enable MD033 -->
        :param pulumi.Input[str] region: Specifies the region where this bucket will be created. If not specified, used
               the region by the provider. Changing this will create a new bucket.
        :param pulumi.Input[str] storage_class: Specifies the storage class of the bucket. OBS provides three storage classes:
               "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        :param pulumi.Input[bool] versioning: Whether enable versioning. Once you version-enable a bucket, it can never return to an
               unversioned state. You can, however, suspend versioning on that bucket.
        :param pulumi.Input[pulumi.InputType['BucketWebsiteArgs']] website: A website object (documented below).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketState.__new__(_BucketState)

        __props__.__dict__["acl"] = acl
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["bucket_domain_name"] = bucket_domain_name
        __props__.__dict__["bucket_version"] = bucket_version
        __props__.__dict__["cors_rules"] = cors_rules
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_project_id"] = kms_key_project_id
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["loggings"] = loggings
        __props__.__dict__["multi_az"] = multi_az
        __props__.__dict__["parallel_fs"] = parallel_fs
        __props__.__dict__["policy"] = policy
        __props__.__dict__["policy_format"] = policy_format
        __props__.__dict__["quota"] = quota
        __props__.__dict__["region"] = region
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["tags"] = tags
        __props__.__dict__["versioning"] = versioning
        __props__.__dict__["website"] = website
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ACL policy for a bucket. The predefined common policies are as follows:
        "private", "public-read", "public-read-write" and "log-delivery-write". Defaults to `private`.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        Specifies the name of the bucket. Changing this parameter will create a new
        resource. A bucket must be named according to the globally applied DNS naming regulations as follows:
        + The name must be globally unique in OBS.
        + The name must contain 3 to 63 characters. Only lowercase letters, digits, hyphens (-), and periods (.) are
        allowed.
        + The name cannot start or end with a period (.) or hyphen (-), and cannot contain two consecutive periods (.) or
        contain a period (.) and a hyphen (-) adjacent to each other.
        + The name cannot be an IP address.
        + If the name contains any periods (.), a security certificate verification message may appear when you access the
        bucket or its objects by entering a domain name.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> pulumi.Output[str]:
        """
        The bucket domain name. Will be of format `bucketname.obs.region.myhuaweicloud.com`.
        """
        return pulumi.get(self, "bucket_domain_name")

    @property
    @pulumi.getter(name="bucketVersion")
    def bucket_version(self) -> pulumi.Output[str]:
        """
        The OBS version of the bucket.
        """
        return pulumi.get(self, "bucket_version")

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BucketCorsRule']]]:
        """
        A rule of Cross-Origin Resource Sharing (documented below).
        """
        return pulumi.get(self, "cors_rules")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable default server-side encryption of the bucket in SSE-KMS mode.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the OBS bucket. Changing
        this will create a new bucket.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket, so that the
        bucket can be destroyed without error. Default to `false`.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ID of a KMS key. If omitted, the default master key will be used.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyProjectId")
    def kms_key_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the project ID to which the KMS key belongs. If omitted, the ID
        of the provider-level project will be used.
        """
        return pulumi.get(self, "kms_key_project_id")

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.BucketLifecycleRule']]]:
        """
        A configuration of object lifecycle management (documented below).
        """
        return pulumi.get(self, "lifecycle_rules")

    @property
    @pulumi.getter
    def loggings(self) -> pulumi.Output[Optional[Sequence['outputs.BucketLogging']]]:
        """
        A settings of bucket logging (documented below).
        """
        return pulumi.get(self, "loggings")

    @property
    @pulumi.getter(name="multiAz")
    def multi_az(self) -> pulumi.Output[bool]:
        """
        Whether enable the multi-AZ mode for the bucket. When the multi-AZ mode is
        enabled, data in the bucket is duplicated and stored in multiple AZs.
        """
        return pulumi.get(self, "multi_az")

    @property
    @pulumi.getter(name="parallelFs")
    def parallel_fs(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable a bucket as a parallel file system. Changing this will
        create a new bucket.
        """
        return pulumi.get(self, "parallel_fs")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        Specifies the text of the bucket policy in JSON format. For more information about obs
        format bucket policy,
        see the [Developer Guide](https://support.huaweicloud.com/intl/en-us/perms-cfg-obs/obs_40_0004.html).
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="policyFormat")
    def policy_format(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the policy format, the supported values are *obs* and *s3*. Defaults
        to *obs*.
        """
        return pulumi.get(self, "policy_format")

    @property
    @pulumi.getter
    def quota(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies bucket storage quota. Must be a positive integer in the unit of byte. The maximum
        storage quota is 2<sup>63</sup> – 1 bytes. The default bucket storage quota is 0, indicating that the bucket storage
        quota is not limited.
        <!-- markdownlint-enable MD033 -->
        """
        return pulumi.get(self, "quota")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where this bucket will be created. If not specified, used
        the region by the provider. Changing this will create a new bucket.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the storage class of the bucket. OBS provides three storage classes:
        "STANDARD", "WARM" (Infrequent Access) and "COLD" (Archive). Defaults to `STANDARD`.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A mapping of tags to assign to the bucket. Each tag is represented by one key-value pair.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def versioning(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether enable versioning. Once you version-enable a bucket, it can never return to an
        unversioned state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "versioning")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional['outputs.BucketWebsite']]:
        """
        A website object (documented below).
        """
        return pulumi.get(self, "website")

