# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[str] description: Specifies the supplementary information about the network ACL. This parameter can
               contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_rules: A list of the IDs of ingress rules associated with the network ACL.
        :param pulumi.Input[str] name: Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outbound_rules: A list of the IDs of egress rules associated with the network ACL.
        :param pulumi.Input[str] region: The region in which to create the network acl resource. If omitted, the
               provider-level region will be used. Changing this creates a new network acl resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of the IDs of networks associated with the network ACL.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inbound_rules is not None:
            pulumi.set(__self__, "inbound_rules", inbound_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_rules is not None:
            pulumi.set(__self__, "outbound_rules", outbound_rules)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the network ACL. This parameter can
        contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inboundRules")
    def inbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of ingress rules associated with the network ACL.
        """
        return pulumi.get(self, "inbound_rules")

    @inbound_rules.setter
    def inbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inbound_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
        which may consist of letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of egress rules associated with the network ACL.
        """
        return pulumi.get(self, "outbound_rules")

    @outbound_rules.setter
    def outbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "outbound_rules", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the network acl resource. If omitted, the
        provider-level region will be used. Changing this creates a new network acl resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of networks associated with the network ACL.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_policy_id: Optional[pulumi.Input[str]] = None,
                 inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_policy_id: Optional[pulumi.Input[str]] = None,
                 outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[str] description: Specifies the supplementary information about the network ACL. This parameter can
               contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] inbound_policy_id: The ID of the ingress firewall policy for the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_rules: A list of the IDs of ingress rules associated with the network ACL.
        :param pulumi.Input[str] name: Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[str] outbound_policy_id: The ID of the egress firewall policy for the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outbound_rules: A list of the IDs of egress rules associated with the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: A list of the port IDs of the subnet gateway.
        :param pulumi.Input[str] region: The region in which to create the network acl resource. If omitted, the
               provider-level region will be used. Changing this creates a new network acl resource.
        :param pulumi.Input[str] status: The status of the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of the IDs of networks associated with the network ACL.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if inbound_policy_id is not None:
            pulumi.set(__self__, "inbound_policy_id", inbound_policy_id)
        if inbound_rules is not None:
            pulumi.set(__self__, "inbound_rules", inbound_rules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_policy_id is not None:
            pulumi.set(__self__, "outbound_policy_id", outbound_policy_id)
        if outbound_rules is not None:
            pulumi.set(__self__, "outbound_rules", outbound_rules)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the supplementary information about the network ACL. This parameter can
        contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="inboundPolicyId")
    def inbound_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ingress firewall policy for the network ACL.
        """
        return pulumi.get(self, "inbound_policy_id")

    @inbound_policy_id.setter
    def inbound_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inbound_policy_id", value)

    @property
    @pulumi.getter(name="inboundRules")
    def inbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of ingress rules associated with the network ACL.
        """
        return pulumi.get(self, "inbound_rules")

    @inbound_rules.setter
    def inbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "inbound_rules", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
        which may consist of letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outboundPolicyId")
    def outbound_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the egress firewall policy for the network ACL.
        """
        return pulumi.get(self, "outbound_policy_id")

    @outbound_policy_id.setter
    def outbound_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "outbound_policy_id", value)

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of egress rules associated with the network ACL.
        """
        return pulumi.get(self, "outbound_rules")

    @outbound_rules.setter
    def outbound_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "outbound_rules", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the port IDs of the subnet gateway.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the network acl resource. If omitted, the
        provider-level region will be used. Changing this creates a new network acl resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the network ACL.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of networks associated with the network ACL.
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a network ACL resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        subnet = huaweicloud.Vpc.get_subnet(name="subnet-default")
        rule1 = huaweicloud.network_acl.AclRule("rule1",
            description="drop TELNET traffic",
            action="deny",
            protocol="tcp",
            destination_port="23",
            enabled=True)
        rule2 = huaweicloud.network_acl.AclRule("rule2",
            description="drop NTP traffic",
            action="deny",
            protocol="udp",
            destination_port="123",
            enabled=False)
        fw_acl = huaweicloud.network_acl.Acl("fwAcl",
            subnets=[subnet.id],
            inbound_rules=[
                rule1.id,
                rule2.id,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the supplementary information about the network ACL. This parameter can
               contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_rules: A list of the IDs of ingress rules associated with the network ACL.
        :param pulumi.Input[str] name: Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outbound_rules: A list of the IDs of egress rules associated with the network ACL.
        :param pulumi.Input[str] region: The region in which to create the network acl resource. If omitted, the
               provider-level region will be used. Changing this creates a new network acl resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of the IDs of networks associated with the network ACL.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AclArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a network ACL resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        subnet = huaweicloud.Vpc.get_subnet(name="subnet-default")
        rule1 = huaweicloud.network_acl.AclRule("rule1",
            description="drop TELNET traffic",
            action="deny",
            protocol="tcp",
            destination_port="23",
            enabled=True)
        rule2 = huaweicloud.network_acl.AclRule("rule2",
            description="drop NTP traffic",
            action="deny",
            protocol="udp",
            destination_port="123",
            enabled=False)
        fw_acl = huaweicloud.network_acl.Acl("fwAcl",
            subnets=[subnet.id],
            inbound_rules=[
                rule1.id,
                rule2.id,
            ])
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["inbound_rules"] = inbound_rules
            __props__.__dict__["name"] = name
            __props__.__dict__["outbound_rules"] = outbound_rules
            __props__.__dict__["region"] = region
            __props__.__dict__["subnets"] = subnets
            __props__.__dict__["inbound_policy_id"] = None
            __props__.__dict__["outbound_policy_id"] = None
            __props__.__dict__["ports"] = None
            __props__.__dict__["status"] = None
        super(Acl, __self__).__init__(
            'huaweicloud:NetworkAcl/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            inbound_policy_id: Optional[pulumi.Input[str]] = None,
            inbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            outbound_policy_id: Optional[pulumi.Input[str]] = None,
            outbound_rules: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the supplementary information about the network ACL. This parameter can
               contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        :param pulumi.Input[str] inbound_policy_id: The ID of the ingress firewall policy for the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] inbound_rules: A list of the IDs of ingress rules associated with the network ACL.
        :param pulumi.Input[str] name: Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
               which may consist of letters, digits, underscores (_), and hyphens (-).
        :param pulumi.Input[str] outbound_policy_id: The ID of the egress firewall policy for the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] outbound_rules: A list of the IDs of egress rules associated with the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: A list of the port IDs of the subnet gateway.
        :param pulumi.Input[str] region: The region in which to create the network acl resource. If omitted, the
               provider-level region will be used. Changing this creates a new network acl resource.
        :param pulumi.Input[str] status: The status of the network ACL.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A list of the IDs of networks associated with the network ACL.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["description"] = description
        __props__.__dict__["inbound_policy_id"] = inbound_policy_id
        __props__.__dict__["inbound_rules"] = inbound_rules
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_policy_id"] = outbound_policy_id
        __props__.__dict__["outbound_rules"] = outbound_rules
        __props__.__dict__["ports"] = ports
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["subnets"] = subnets
        return Acl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the supplementary information about the network ACL. This parameter can
        contain a maximum of 255 characters and cannot contain angle brackets (< or >).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="inboundPolicyId")
    def inbound_policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the ingress firewall policy for the network ACL.
        """
        return pulumi.get(self, "inbound_policy_id")

    @property
    @pulumi.getter(name="inboundRules")
    def inbound_rules(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the IDs of ingress rules associated with the network ACL.
        """
        return pulumi.get(self, "inbound_rules")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the network ACL name. This parameter can contain a maximum of 64 characters,
        which may consist of letters, digits, underscores (_), and hyphens (-).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outboundPolicyId")
    def outbound_policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the egress firewall policy for the network ACL.
        """
        return pulumi.get(self, "outbound_policy_id")

    @property
    @pulumi.getter(name="outboundRules")
    def outbound_rules(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the IDs of egress rules associated with the network ACL.
        """
        return pulumi.get(self, "outbound_rules")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the port IDs of the subnet gateway.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the network acl resource. If omitted, the
        provider-level region will be used. Changing this creates a new network acl resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the network ACL.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the IDs of networks associated with the network ACL.
        """
        return pulumi.get(self, "subnets")

