# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetGatewayResult',
    'AwaitableGetGatewayResult',
    'get_gateway',
    'get_gateway_output',
]

@pulumi.output_type
class GetGatewayResult:
    """
    A collection of values returned by getGateway.
    """
    def __init__(__self__, description=None, enterprise_project_id=None, id=None, internal_network_id=None, name=None, region=None, router_id=None, spec=None, status=None, subnet_id=None, vpc_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_network_id and not isinstance(internal_network_id, str):
            raise TypeError("Expected argument 'internal_network_id' to be a str")
        if internal_network_id is not None:
            warnings.warn("""use subnet_id instead""", DeprecationWarning)
            pulumi.log.warn("""internal_network_id is deprecated: use subnet_id instead""")

        pulumi.set(__self__, "internal_network_id", internal_network_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if router_id and not isinstance(router_id, str):
            raise TypeError("Expected argument 'router_id' to be a str")
        if router_id is not None:
            warnings.warn("""use vpc_id instead""", DeprecationWarning)
            pulumi.log.warn("""router_id is deprecated: use vpc_id instead""")

        pulumi.set(__self__, "router_id", router_id)
        if spec and not isinstance(spec, str):
            raise TypeError("Expected argument 'spec' to be a str")
        pulumi.set(__self__, "spec", spec)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalNetworkId")
    def internal_network_id(self) -> Optional[str]:
        return pulumi.get(self, "internal_network_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="routerId")
    def router_id(self) -> Optional[str]:
        return pulumi.get(self, "router_id")

    @property
    @pulumi.getter
    def spec(self) -> str:
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        return pulumi.get(self, "vpc_id")


class AwaitableGetGatewayResult(GetGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGatewayResult(
            description=self.description,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            internal_network_id=self.internal_network_id,
            name=self.name,
            region=self.region,
            router_id=self.router_id,
            spec=self.spec,
            status=self.status,
            subnet_id=self.subnet_id,
            vpc_id=self.vpc_id)


def get_gateway(description: Optional[str] = None,
                enterprise_project_id: Optional[str] = None,
                id: Optional[str] = None,
                internal_network_id: Optional[str] = None,
                name: Optional[str] = None,
                region: Optional[str] = None,
                router_id: Optional[str] = None,
                spec: Optional[str] = None,
                status: Optional[str] = None,
                subnet_id: Optional[str] = None,
                vpc_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGatewayResult:
    """
    Use this data source to get the information of an available HuaweiCloud NAT gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    natgateway = huaweicloud.Nat.get_gateway(name="tf_test_natgateway")
    ```


    :param str description: Specifies the description of the NAT gateway. The value contains 0 to 255
           characters, and angle brackets (<)
           and (>) are not allowed.
    :param str enterprise_project_id: Specifies the enterprise project ID of the NAT gateway.
    :param str id: Specifies the ID of the NAT gateway.
    :param str name: Specifies the NAT gateway name. The name can contain only digits, letters, underscores (_)
           , and hyphens(-).
    :param str region: Specifies the region in which to create the NAT gateway resource. If omitted, the
           provider-level region will be used.
    :param str spec: The NAT gateway type. The value can be:
           + `1`: small type, which supports up to 10,000 SNAT connections.
           + `2`: medium type, which supports up to 50,000 SNAT connections.
           + `3`: large type, which supports up to 200,000 SNAT connections.
           + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
    :param str status: Specifies the status of the NAT gateway.
    :param str subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the DVR) of the
           NAT gateway.
    :param str vpc_id: Specifies the ID of the VPC this NAT gateway belongs to.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['id'] = id
    __args__['internalNetworkId'] = internal_network_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['routerId'] = router_id
    __args__['spec'] = spec
    __args__['status'] = status
    __args__['subnetId'] = subnet_id
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Nat/getGateway:getGateway', __args__, opts=opts, typ=GetGatewayResult).value

    return AwaitableGetGatewayResult(
        description=__ret__.description,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        internal_network_id=__ret__.internal_network_id,
        name=__ret__.name,
        region=__ret__.region,
        router_id=__ret__.router_id,
        spec=__ret__.spec,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        vpc_id=__ret__.vpc_id)


@_utilities.lift_output_func(get_gateway)
def get_gateway_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                       enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                       id: Optional[pulumi.Input[Optional[str]]] = None,
                       internal_network_id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       router_id: Optional[pulumi.Input[Optional[str]]] = None,
                       spec: Optional[pulumi.Input[Optional[str]]] = None,
                       status: Optional[pulumi.Input[Optional[str]]] = None,
                       subnet_id: Optional[pulumi.Input[Optional[str]]] = None,
                       vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetGatewayResult]:
    """
    Use this data source to get the information of an available HuaweiCloud NAT gateway.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    natgateway = huaweicloud.Nat.get_gateway(name="tf_test_natgateway")
    ```


    :param str description: Specifies the description of the NAT gateway. The value contains 0 to 255
           characters, and angle brackets (<)
           and (>) are not allowed.
    :param str enterprise_project_id: Specifies the enterprise project ID of the NAT gateway.
    :param str id: Specifies the ID of the NAT gateway.
    :param str name: Specifies the NAT gateway name. The name can contain only digits, letters, underscores (_)
           , and hyphens(-).
    :param str region: Specifies the region in which to create the NAT gateway resource. If omitted, the
           provider-level region will be used.
    :param str spec: The NAT gateway type. The value can be:
           + `1`: small type, which supports up to 10,000 SNAT connections.
           + `2`: medium type, which supports up to 50,000 SNAT connections.
           + `3`: large type, which supports up to 200,000 SNAT connections.
           + `4`: extra-large type, which supports up to 1,000,000 SNAT connections.
    :param str status: Specifies the status of the NAT gateway.
    :param str subnet_id: Specifies the subnet ID of the downstream interface (the next hop of the DVR) of the
           NAT gateway.
    :param str vpc_id: Specifies the ID of the VPC this NAT gateway belongs to.
    """
    ...
