# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 program_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input[str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        :param pulumi.Input[str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if program_parameters is not None:
            pulumi.set(__self__, "program_parameters", program_parameters)
        if program_path is not None:
            pulumi.set(__self__, "program_path", program_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_parameters is not None:
            pulumi.set(__self__, "service_parameters", service_parameters)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the MapReduce cluster to which the job belongs to.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the MapReduce job. The name can contain 1 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameters for the MapReduce job. Add an at sign (@) before
        each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
        This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="programParameters")
    def program_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the the key/value pairs of the program parameters, such as
        thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
        can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
        **HiveScript**. Refer to the documents for each type of support key-values.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_parameters")

    @program_parameters.setter
    def program_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "program_parameters", value)

    @property
    @pulumi.getter(name="programPath")
    def program_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the .jar package path or .py file path for program execution.
        The parameter must meet the following requirements:
        + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
        + The address cannot be empty or full of spaces.
        + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
        with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        """
        return pulumi.get(self, "program_path")

    @program_path.setter
    def program_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "program_path", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the MapReduce job resource. If
        omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceParameters")
    def service_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs used to modify service configuration.
        Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "service_parameters")

    @service_parameters.setter
    def service_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "service_parameters", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SQL command or file path. Only required if `type` is **HiveSql**
        or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 finish_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 program_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 submit_time: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] finish_time: The completion time of the MapReduce job.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        :param pulumi.Input[str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] start_time: The creation time of the MapReduce job.
        :param pulumi.Input[str] status: Status of the MapReduce job.
        :param pulumi.Input[str] submit_time: The submission time of the MapReduce job.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if finish_time is not None:
            pulumi.set(__self__, "finish_time", finish_time)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if program_parameters is not None:
            pulumi.set(__self__, "program_parameters", program_parameters)
        if program_path is not None:
            pulumi.set(__self__, "program_path", program_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_parameters is not None:
            pulumi.set(__self__, "service_parameters", service_parameters)
        if sql is not None:
            pulumi.set(__self__, "sql", sql)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if submit_time is not None:
            pulumi.set(__self__, "submit_time", submit_time)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the MapReduce cluster to which the job belongs to.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> Optional[pulumi.Input[str]]:
        """
        The completion time of the MapReduce job.
        """
        return pulumi.get(self, "finish_time")

    @finish_time.setter
    def finish_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finish_time", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the MapReduce job. The name can contain 1 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the parameters for the MapReduce job. Add an at sign (@) before
        each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
        This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="programParameters")
    def program_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the the key/value pairs of the program parameters, such as
        thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
        can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
        **HiveScript**. Refer to the documents for each type of support key-values.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_parameters")

    @program_parameters.setter
    def program_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "program_parameters", value)

    @property
    @pulumi.getter(name="programPath")
    def program_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the .jar package path or .py file path for program execution.
        The parameter must meet the following requirements:
        + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
        + The address cannot be empty or full of spaces.
        + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
        with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        """
        return pulumi.get(self, "program_path")

    @program_path.setter
    def program_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "program_path", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the MapReduce job resource. If
        omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceParameters")
    def service_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs used to modify service configuration.
        Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "service_parameters")

    @service_parameters.setter
    def service_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "service_parameters", value)

    @property
    @pulumi.getter
    def sql(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the SQL command or file path. Only required if `type` is **HiveSql**
        or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "sql")

    @sql.setter
    def sql(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sql", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the MapReduce job.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the MapReduce job.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="submitTime")
    def submit_time(self) -> Optional[pulumi.Input[str]]:
        """
        The submission time of the MapReduce job.
        """
        return pulumi.get(self, "submit_time")

    @submit_time.setter
    def submit_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "submit_time", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 program_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manage a job resource within HuaweiCloud MRS.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        job_name = config.require_object("jobName")
        program_path = config.require_object("programPath")
        access_key = config.require_object("accessKey")
        secret_key = config.require_object("secretKey")
        test = huaweicloud.mrs.Job("test",
            cluster_id=cluster_id,
            type="SparkSubmit",
            program_path=program_path,
            parameters=f"{access_key} {secret_key} 1 obs://obs-demo-analysis/input obs://obs-demo-analysis/output",
            program_parameters={
                "--class": "com.huawei.bigdata.spark.examples.DriverBehavior",
            })
        ```

        ## Import

        MapReduce jobs can be imported using their `id` and the IDs of the MapReduce cluster to which the job belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Mrs/job:Job test <cluster_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        :param pulumi.Input[str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a job resource within HuaweiCloud MRS.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        cluster_id = config.require_object("clusterId")
        job_name = config.require_object("jobName")
        program_path = config.require_object("programPath")
        access_key = config.require_object("accessKey")
        secret_key = config.require_object("secretKey")
        test = huaweicloud.mrs.Job("test",
            cluster_id=cluster_id,
            type="SparkSubmit",
            program_path=program_path,
            parameters=f"{access_key} {secret_key} 1 obs://obs-demo-analysis/input obs://obs-demo-analysis/output",
            program_parameters={
                "--class": "com.huawei.bigdata.spark.examples.DriverBehavior",
            })
        ```

        ## Import

        MapReduce jobs can be imported using their `id` and the IDs of the MapReduce cluster to which the job belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:Mrs/job:Job test <cluster_id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[str]] = None,
                 program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 program_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 sql: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["program_parameters"] = program_parameters
            __props__.__dict__["program_path"] = program_path
            __props__.__dict__["region"] = region
            __props__.__dict__["service_parameters"] = service_parameters
            __props__.__dict__["sql"] = sql
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["finish_time"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["submit_time"] = None
        super(Job, __self__).__init__(
            'huaweicloud:Mrs/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            finish_time: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameters: Optional[pulumi.Input[str]] = None,
            program_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            program_path: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            sql: Optional[pulumi.Input[str]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            submit_time: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: Specifies an ID of the MapReduce cluster to which the job belongs to.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] finish_time: The completion time of the MapReduce job.
        :param pulumi.Input[str] name: Specifies the name of the MapReduce job. The name can contain 1 to 64
               characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[str] parameters: Specifies the parameters for the MapReduce job. Add an at sign (@) before
               each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
               This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
               MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] program_parameters: Specifies the the key/value pairs of the program parameters, such as
               thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
               can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
               **HiveScript**. Refer to the documents for each type of support key-values.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] program_path: Specifies the .jar package path or .py file path for program execution.
               The parameter must meet the following requirements:
               + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
               + The address cannot be empty or full of spaces.
               + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
               with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        :param pulumi.Input[str] region: Specifies the region in which to create the MapReduce job resource. If
               omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] service_parameters: Specifies the key/value pairs used to modify service configuration.
               Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
               Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] sql: Specifies the SQL command or file path. Only required if `type` is **HiveSql**
               or **SparkSql**. Changing this will create a new MapReduce job resource.
        :param pulumi.Input[str] start_time: The creation time of the MapReduce job.
        :param pulumi.Input[str] status: Status of the MapReduce job.
        :param pulumi.Input[str] submit_time: The submission time of the MapReduce job.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["finish_time"] = finish_time
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["program_parameters"] = program_parameters
        __props__.__dict__["program_path"] = program_path
        __props__.__dict__["region"] = region
        __props__.__dict__["service_parameters"] = service_parameters
        __props__.__dict__["sql"] = sql
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["submit_time"] = submit_time
        __props__.__dict__["type"] = type
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the MapReduce cluster to which the job belongs to.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> pulumi.Output[str]:
        """
        The completion time of the MapReduce job.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the MapReduce job. The name can contain 1 to 64
        characters, which may consist of letters, digits, underscores (_) and hyphens (-). Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the parameters for the MapReduce job. Add an at sign (@) before
        each parameter can prevent the parameters being saved in plaintext format. Each parameters are separated with spaces.
        This parameter can be set when `type` is **Flink**, **MapReduce** or **SparkSubmit**. Changing this will create a new
        MapReduce job resource.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="programParameters")
    def program_parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the the key/value pairs of the program parameters, such as
        thread, memory, and vCPUs, are used to optimize resource usage and improve job execution performance. This parameter
        can be set when `type` is **Flink**, **SparkSubmit**, **SparkSql**, **SparkScript**, **HiveSql** or
        **HiveScript**. Refer to the documents for each type of support key-values.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "program_parameters")

    @property
    @pulumi.getter(name="programPath")
    def program_path(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the .jar package path or .py file path for program execution.
        The parameter must meet the following requirements:
        + Contains a maximum of 1023 characters, excluding special characters such as `;|&><'$`.
        + The address cannot be empty or full of spaces.
        + The program support OBS or DHFS to storage program file or package. For OBS, starts with (OBS:) **obs://** and end
        with **.jar** or **.py**. For DHFS, starts with (DHFS:) **/user**.
        """
        return pulumi.get(self, "program_path")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the MapReduce job resource. If
        omitted, the provider-level region will be used. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceParameters")
    def service_parameters(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies the key/value pairs used to modify service configuration.
        Parameter configurations of services are available on the Service Configuration tab page of MapReduce Manager.
        Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "service_parameters")

    @property
    @pulumi.getter
    def sql(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the SQL command or file path. Only required if `type` is **HiveSql**
        or **SparkSql**. Changing this will create a new MapReduce job resource.
        """
        return pulumi.get(self, "sql")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        The creation time of the MapReduce job.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the MapReduce job.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="submitTime")
    def submit_time(self) -> pulumi.Output[str]:
        """
        The submission time of the MapReduce job.
        """
        return pulumi.get(self, "submit_time")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "type")

