# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNotebookImagesResult',
    'AwaitableGetNotebookImagesResult',
    'get_notebook_images',
    'get_notebook_images_output',
]

@pulumi.output_type
class GetNotebookImagesResult:
    """
    A collection of values returned by getNotebookImages.
    """
    def __init__(__self__, cpu_arch=None, id=None, images=None, name=None, organization=None, region=None, type=None, workspace_id=None):
        if cpu_arch and not isinstance(cpu_arch, str):
            raise TypeError("Expected argument 'cpu_arch' to be a str")
        pulumi.set(__self__, "cpu_arch", cpu_arch)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if organization and not isinstance(organization, str):
            raise TypeError("Expected argument 'organization' to be a str")
        pulumi.set(__self__, "organization", organization)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> Optional[str]:
        """
        The CPU architecture of the image. The value can be **x86_64** and **aarch64**.
        """
        return pulumi.get(self, "cpu_arch")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetNotebookImagesImageResult']:
        """
        Indicates a list of all images found. Structure is documented below.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def organization(self) -> Optional[str]:
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the image.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetNotebookImagesResult(GetNotebookImagesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotebookImagesResult(
            cpu_arch=self.cpu_arch,
            id=self.id,
            images=self.images,
            name=self.name,
            organization=self.organization,
            region=self.region,
            type=self.type,
            workspace_id=self.workspace_id)


def get_notebook_images(cpu_arch: Optional[str] = None,
                        name: Optional[str] = None,
                        organization: Optional[str] = None,
                        region: Optional[str] = None,
                        type: Optional[str] = None,
                        workspace_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotebookImagesResult:
    """
    Use this data source to get a list of ModelArts notebook images.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.ModelArts.get_notebook_images(type="BUILD_IN")
    pulumi.export("imageId", test.images[0].id)
    ```


    :param str cpu_arch: Specifies the CPU architecture of image. The value can be **x86_64** and **aarch64**.
    :param str name: Specifies the name of image.
    :param str organization: Specifies the name of the organization (namespace) which image belongs to.
    :param str region: Specifies the region in which to obtain images. If omitted, the provider-level region
           will be used.
    :param str type: Specifies the type of image. The options are:
           + `BUILD_IN`: The system built-in image.
           + `DEDICATED`: User-saved images.
    :param str workspace_id: Specifies the workspace ID which image belongs to.
    """
    __args__ = dict()
    __args__['cpuArch'] = cpu_arch
    __args__['name'] = name
    __args__['organization'] = organization
    __args__['region'] = region
    __args__['type'] = type
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:ModelArts/getNotebookImages:getNotebookImages', __args__, opts=opts, typ=GetNotebookImagesResult).value

    return AwaitableGetNotebookImagesResult(
        cpu_arch=__ret__.cpu_arch,
        id=__ret__.id,
        images=__ret__.images,
        name=__ret__.name,
        organization=__ret__.organization,
        region=__ret__.region,
        type=__ret__.type,
        workspace_id=__ret__.workspace_id)


@_utilities.lift_output_func(get_notebook_images)
def get_notebook_images_output(cpu_arch: Optional[pulumi.Input[Optional[str]]] = None,
                               name: Optional[pulumi.Input[Optional[str]]] = None,
                               organization: Optional[pulumi.Input[Optional[str]]] = None,
                               region: Optional[pulumi.Input[Optional[str]]] = None,
                               type: Optional[pulumi.Input[Optional[str]]] = None,
                               workspace_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNotebookImagesResult]:
    """
    Use this data source to get a list of ModelArts notebook images.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.ModelArts.get_notebook_images(type="BUILD_IN")
    pulumi.export("imageId", test.images[0].id)
    ```


    :param str cpu_arch: Specifies the CPU architecture of image. The value can be **x86_64** and **aarch64**.
    :param str name: Specifies the name of image.
    :param str organization: Specifies the name of the organization (namespace) which image belongs to.
    :param str region: Specifies the region in which to obtain images. If omitted, the provider-level region
           will be used.
    :param str type: Specifies the type of image. The options are:
           + `BUILD_IN`: The system built-in image.
           + `DEDICATED`: User-saved images.
    :param str workspace_id: Specifies the workspace ID which image belongs to.
    """
    ...
