# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DatasetVersionArgs', 'DatasetVersion']

@pulumi.input_type
class DatasetVersionArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 hard_example: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split_ratio: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatasetVersion resource.
        :param pulumi.Input[str] dataset_id: Specifies the ID of dataset.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset version. It contains a maximum of
               256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] hard_example: Specifies whether to enable ModelArts to write the hard example
               attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
               use these attributes to optimize hard example filtering. Default value is `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the dataset version. The name consists of 1 to 32
               characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] split_ratio: Specifies the ratio of splitting which randomly divides a labeled sample
               into a training set and a validation set. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hard_example is not None:
            pulumi.set(__self__, "hard_example", hard_example)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if split_ratio is not None:
            pulumi.set(__self__, "split_ratio", split_ratio)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of dataset.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of dataset version. It contains a maximum of
        256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="hardExample")
    def hard_example(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable ModelArts to write the hard example
        attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
        use these attributes to optimize hard example filtering. Default value is `false`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "hard_example")

    @hard_example.setter
    def hard_example(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hard_example", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dataset version. The name consists of 1 to 32
        characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="splitRatio")
    def split_ratio(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ratio of splitting which randomly divides a labeled sample
        into a training set and a validation set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "split_ratio")

    @split_ratio.setter
    def split_ratio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "split_ratio", value)


@pulumi.input_type
class _DatasetVersionState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 files: Optional[pulumi.Input[int]] = None,
                 hard_example: Optional[pulumi.Input[bool]] = None,
                 is_current: Optional[pulumi.Input[bool]] = None,
                 labeling_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split_ratio: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 storage_path: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 verification: Optional[pulumi.Input[bool]] = None,
                 version_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DatasetVersion resources.
        :param pulumi.Input[str] created_at: The creation time, in UTC format.
        :param pulumi.Input[str] dataset_id: Specifies the ID of dataset.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset version. It contains a maximum of
               256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        :param pulumi.Input[int] files: The total number of samples.
        :param pulumi.Input[bool] hard_example: Specifies whether to enable ModelArts to write the hard example
               attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
               use these attributes to optimize hard example filtering. Default value is `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] is_current: Whether this version is current version.
        :param pulumi.Input[str] labeling_type: The label type of the dataset version. Valid values are as follows:
               + **multi**: Indicates that there are multi-label samples.
               + **single**: Indicates that all samples are single-label.
               + **unlabeled**: Indicates that all samples are unlabeled.
        :param pulumi.Input[str] name: Specifies the name of the dataset version. The name consists of 1 to 32
               characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] split_ratio: Specifies the ratio of splitting which randomly divides a labeled sample
               into a training set and a validation set. Changing this parameter will create a new resource.
        :param pulumi.Input[int] status: The status of the dataset version. Valid values are as follows:
               + **0**: Creating.
               + **1**: Normal.
               + **2**: Deleting.
               + **3**: Deleted.
               + **4**: Exception.
        :param pulumi.Input[str] storage_path: The path to save the manifest file of the version.
        :param pulumi.Input[str] updated_at: The last update time, in UTC format.
        :param pulumi.Input[bool] verification: Whether the data has been verified by the verification algorithm before publishing.
        :param pulumi.Input[str] version_id: The version ID.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if hard_example is not None:
            pulumi.set(__self__, "hard_example", hard_example)
        if is_current is not None:
            pulumi.set(__self__, "is_current", is_current)
        if labeling_type is not None:
            pulumi.set(__self__, "labeling_type", labeling_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if split_ratio is not None:
            pulumi.set(__self__, "split_ratio", split_ratio)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if verification is not None:
            pulumi.set(__self__, "verification", verification)
        if version_id is not None:
            pulumi.set(__self__, "version_id", version_id)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of dataset.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of dataset version. It contains a maximum of
        256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of samples.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "files", value)

    @property
    @pulumi.getter(name="hardExample")
    def hard_example(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable ModelArts to write the hard example
        attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
        use these attributes to optimize hard example filtering. Default value is `false`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "hard_example")

    @hard_example.setter
    def hard_example(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "hard_example", value)

    @property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this version is current version.
        """
        return pulumi.get(self, "is_current")

    @is_current.setter
    def is_current(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_current", value)

    @property
    @pulumi.getter(name="labelingType")
    def labeling_type(self) -> Optional[pulumi.Input[str]]:
        """
        The label type of the dataset version. Valid values are as follows:
        + **multi**: Indicates that there are multi-label samples.
        + **single**: Indicates that all samples are single-label.
        + **unlabeled**: Indicates that all samples are unlabeled.
        """
        return pulumi.get(self, "labeling_type")

    @labeling_type.setter
    def labeling_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "labeling_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dataset version. The name consists of 1 to 32
        characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="splitRatio")
    def split_ratio(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ratio of splitting which randomly divides a labeled sample
        into a training set and a validation set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "split_ratio")

    @split_ratio.setter
    def split_ratio(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "split_ratio", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        The status of the dataset version. Valid values are as follows:
        + **0**: Creating.
        + **1**: Normal.
        + **2**: Deleting.
        + **3**: Deleted.
        + **4**: Exception.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path to save the manifest file of the version.
        """
        return pulumi.get(self, "storage_path")

    @storage_path.setter
    def storage_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_path", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def verification(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the data has been verified by the verification algorithm before publishing.
        """
        return pulumi.get(self, "verification")

    @verification.setter
    def verification(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verification", value)

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> Optional[pulumi.Input[str]]:
        """
        The version ID.
        """
        return pulumi.get(self, "version_id")

    @version_id.setter
    def version_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_id", value)


class DatasetVersion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hard_example: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split_ratio: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages ModelArts dataset version resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        dataset_id = config.require_object("datasetId")
        v001 = huaweicloud.model_arts.DatasetVersion("v001",
            dataset_id=dataset_id,
            description="Created by demo")
        ```

        ## Import

        The dataset versions can be imported by dataset ID and version ID, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:ModelArts/datasetVersion:DatasetVersion test yiROKoTTjtwjvP71yLG/wieeeoTrtrtjvn67yLm
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`hard_example`. It is generally recommended running `terraform plan` after importing a dataset. You can then decide if changes should be applied to the dataset, or the resource definition should be updated to align with the dataset. Also you can ignore changes as below. resource "huaweicloud_modelarts_dataset_version" "test" {

         ...

         lifecycle {

         ignore_changes = [

         hard_example,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset_id: Specifies the ID of dataset.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset version. It contains a maximum of
               256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        :param pulumi.Input[bool] hard_example: Specifies whether to enable ModelArts to write the hard example
               attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
               use these attributes to optimize hard example filtering. Default value is `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] name: Specifies the name of the dataset version. The name consists of 1 to 32
               characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] split_ratio: Specifies the ratio of splitting which randomly divides a labeled sample
               into a training set and a validation set. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages ModelArts dataset version resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        dataset_id = config.require_object("datasetId")
        v001 = huaweicloud.model_arts.DatasetVersion("v001",
            dataset_id=dataset_id,
            description="Created by demo")
        ```

        ## Import

        The dataset versions can be imported by dataset ID and version ID, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:ModelArts/datasetVersion:DatasetVersion test yiROKoTTjtwjvP71yLG/wieeeoTrtrtjvn67yLm
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`hard_example`. It is generally recommended running `terraform plan` after importing a dataset. You can then decide if changes should be applied to the dataset, or the resource definition should be updated to align with the dataset. Also you can ignore changes as below. resource "huaweicloud_modelarts_dataset_version" "test" {

         ...

         lifecycle {

         ignore_changes = [

         hard_example,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param DatasetVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hard_example: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 split_ratio: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetVersionArgs.__new__(DatasetVersionArgs)

            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            __props__.__dict__["description"] = description
            __props__.__dict__["hard_example"] = hard_example
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["split_ratio"] = split_ratio
            __props__.__dict__["created_at"] = None
            __props__.__dict__["files"] = None
            __props__.__dict__["is_current"] = None
            __props__.__dict__["labeling_type"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage_path"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["verification"] = None
            __props__.__dict__["version_id"] = None
        super(DatasetVersion, __self__).__init__(
            'huaweicloud:ModelArts/datasetVersion:DatasetVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            dataset_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            files: Optional[pulumi.Input[int]] = None,
            hard_example: Optional[pulumi.Input[bool]] = None,
            is_current: Optional[pulumi.Input[bool]] = None,
            labeling_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            split_ratio: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[int]] = None,
            storage_path: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            verification: Optional[pulumi.Input[bool]] = None,
            version_id: Optional[pulumi.Input[str]] = None) -> 'DatasetVersion':
        """
        Get an existing DatasetVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The creation time, in UTC format.
        :param pulumi.Input[str] dataset_id: Specifies the ID of dataset.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset version. It contains a maximum of
               256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        :param pulumi.Input[int] files: The total number of samples.
        :param pulumi.Input[bool] hard_example: Specifies whether to enable ModelArts to write the hard example
               attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
               use these attributes to optimize hard example filtering. Default value is `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] is_current: Whether this version is current version.
        :param pulumi.Input[str] labeling_type: The label type of the dataset version. Valid values are as follows:
               + **multi**: Indicates that there are multi-label samples.
               + **single**: Indicates that all samples are single-label.
               + **unlabeled**: Indicates that all samples are unlabeled.
        :param pulumi.Input[str] name: Specifies the name of the dataset version. The name consists of 1 to 32
               characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] split_ratio: Specifies the ratio of splitting which randomly divides a labeled sample
               into a training set and a validation set. Changing this parameter will create a new resource.
        :param pulumi.Input[int] status: The status of the dataset version. Valid values are as follows:
               + **0**: Creating.
               + **1**: Normal.
               + **2**: Deleting.
               + **3**: Deleted.
               + **4**: Exception.
        :param pulumi.Input[str] storage_path: The path to save the manifest file of the version.
        :param pulumi.Input[str] updated_at: The last update time, in UTC format.
        :param pulumi.Input[bool] verification: Whether the data has been verified by the verification algorithm before publishing.
        :param pulumi.Input[str] version_id: The version ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetVersionState.__new__(_DatasetVersionState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dataset_id"] = dataset_id
        __props__.__dict__["description"] = description
        __props__.__dict__["files"] = files
        __props__.__dict__["hard_example"] = hard_example
        __props__.__dict__["is_current"] = is_current
        __props__.__dict__["labeling_type"] = labeling_type
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["split_ratio"] = split_ratio
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_path"] = storage_path
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["verification"] = verification
        __props__.__dict__["version_id"] = version_id
        return DatasetVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of dataset.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of dataset version. It contains a maximum of
        256 characters and cannot contain special characters `!<>=&"'`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def files(self) -> pulumi.Output[int]:
        """
        The total number of samples.
        """
        return pulumi.get(self, "files")

    @property
    @pulumi.getter(name="hardExample")
    def hard_example(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable ModelArts to write the hard example
        attributes (difficult, hard-coefficient, and hard-reasons) into the XML and manifest labeling files. ModelArts will
        use these attributes to optimize hard example filtering. Default value is `false`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "hard_example")

    @property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> pulumi.Output[bool]:
        """
        Whether this version is current version.
        """
        return pulumi.get(self, "is_current")

    @property
    @pulumi.getter(name="labelingType")
    def labeling_type(self) -> pulumi.Output[str]:
        """
        The label type of the dataset version. Valid values are as follows:
        + **multi**: Indicates that there are multi-label samples.
        + **single**: Indicates that all samples are single-label.
        + **unlabeled**: Indicates that all samples are unlabeled.
        """
        return pulumi.get(self, "labeling_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the dataset version. The name consists of 1 to 32
        characters. Only letters, Chinese characters, digits underscores (_) and hyphens (-) are allowed.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="splitRatio")
    def split_ratio(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the ratio of splitting which randomly divides a labeled sample
        into a training set and a validation set. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "split_ratio")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        The status of the dataset version. Valid values are as follows:
        + **0**: Creating.
        + **1**: Normal.
        + **2**: Deleting.
        + **3**: Deleted.
        + **4**: Exception.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> pulumi.Output[str]:
        """
        The path to save the manifest file of the version.
        """
        return pulumi.get(self, "storage_path")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def verification(self) -> pulumi.Output[bool]:
        """
        Whether the data has been verified by the verification algorithm before publishing.
        """
        return pulumi.get(self, "verification")

    @property
    @pulumi.getter(name="versionId")
    def version_id(self) -> pulumi.Output[str]:
        """
        The version ID.
        """
        return pulumi.get(self, "version_id")

