# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatasetArgs', 'Dataset']

@pulumi.input_type
class DatasetArgs:
    def __init__(__self__, *,
                 data_source: pulumi.Input['DatasetDataSourceArgs'],
                 output_path: pulumi.Input[str],
                 type: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None,
                 import_labeled_enabled: Optional[pulumi.Input[bool]] = None,
                 label_format: Optional[pulumi.Input['DatasetLabelFormatArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]]] = None):
        """
        The set of arguments for constructing a Dataset resource.
        :param pulumi.Input['DatasetDataSourceArgs'] data_source: Specifies the data sources which be used to imported the source data (such
               as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] output_path: Specifies the OBS path for storing output files such as labeled files.
               The path cannot be the same as the import path or subdirectory of the import path.
               Changing this parameter will create a new resource.
        :param pulumi.Input[int] type: Specifies Label type for text classification.
               The optional values are as follows:
        :param pulumi.Input[str] description: Specifies the description of dataset. It contains a maximum of 256 characters and
               cannot contain special characters `!<>=&"'`.
        :param pulumi.Input[bool] import_labeled_enabled: Specifies whether to import labeled files.
               Default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input['DatasetLabelFormatArgs'] label_format: Specifies the custom format information of labeled files when import
               labeled files for Text classification. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]] labels: Specifies labels information. Structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of label.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]] schemas: Specifies the schema information of source data when `type` is `400`.
               Structure is documented below. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "data_source", data_source)
        pulumi.set(__self__, "output_path", output_path)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if import_labeled_enabled is not None:
            pulumi.set(__self__, "import_labeled_enabled", import_labeled_enabled)
        if label_format is not None:
            pulumi.set(__self__, "label_format", label_format)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Input['DatasetDataSourceArgs']:
        """
        Specifies the data sources which be used to imported the source data (such
        as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: pulumi.Input['DatasetDataSourceArgs']):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> pulumi.Input[str]:
        """
        Specifies the OBS path for storing output files such as labeled files.
        The path cannot be the same as the import path or subdirectory of the import path.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "output_path")

    @output_path.setter
    def output_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "output_path", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[int]:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[int]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of dataset. It contains a maximum of 256 characters and
        cannot contain special characters `!<>=&"'`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="importLabeledEnabled")
    def import_labeled_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to import labeled files.
        Default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "import_labeled_enabled")

    @import_labeled_enabled.setter
    def import_labeled_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_labeled_enabled", value)

    @property
    @pulumi.getter(name="labelFormat")
    def label_format(self) -> Optional[pulumi.Input['DatasetLabelFormatArgs']]:
        """
        Specifies the custom format information of labeled files when import
        labeled files for Text classification. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "label_format")

    @label_format.setter
    def label_format(self, value: Optional[pulumi.Input['DatasetLabelFormatArgs']]):
        pulumi.set(self, "label_format", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]]]:
        """
        Specifies labels information. Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]]]:
        """
        Specifies the schema information of source data when `type` is `400`.
        Structure is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]]]):
        pulumi.set(self, "schemas", value)


@pulumi.input_type
class _DatasetState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 data_format: Optional[pulumi.Input[str]] = None,
                 data_source: Optional[pulumi.Input['DatasetDataSourceArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 import_labeled_enabled: Optional[pulumi.Input[bool]] = None,
                 label_format: Optional[pulumi.Input['DatasetLabelFormatArgs']] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]]] = None,
                 status: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Dataset resources.
        :param pulumi.Input[str] created_at: The dataset creation time.
        :param pulumi.Input[str] data_format: dataset format. Valid values include: `Default`, `CarbonData`: Carbon format(Supported only for
               table type datasets).
        :param pulumi.Input['DatasetDataSourceArgs'] data_source: Specifies the data sources which be used to imported the source data (such
               as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset. It contains a maximum of 256 characters and
               cannot contain special characters `!<>=&"'`.
        :param pulumi.Input[bool] import_labeled_enabled: Specifies whether to import labeled files.
               Default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input['DatasetLabelFormatArgs'] label_format: Specifies the custom format information of labeled files when import
               labeled files for Text classification. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]] labels: Specifies labels information. Structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of label.
        :param pulumi.Input[str] output_path: Specifies the OBS path for storing output files such as labeled files.
               The path cannot be the same as the import path or subdirectory of the import path.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]] schemas: Specifies the schema information of source data when `type` is `400`.
               Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[int] status: Dataset status. Valid values are as follows:
               + **0**: Creating.
               + **1**: Completed.
               + **2**: Deleting.
               + **3**: Deleted.
               + **4**: Exception.
               + **5**: Syncing.
               + **6**: Releasing.
               + **7**: Version switching.
               + **8**: Importing.
        :param pulumi.Input[int] type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_format is not None:
            pulumi.set(__self__, "data_format", data_format)
        if data_source is not None:
            pulumi.set(__self__, "data_source", data_source)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if import_labeled_enabled is not None:
            pulumi.set(__self__, "import_labeled_enabled", import_labeled_enabled)
        if label_format is not None:
            pulumi.set(__self__, "label_format", label_format)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_path is not None:
            pulumi.set(__self__, "output_path", output_path)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> Optional[pulumi.Input[str]]:
        """
        dataset format. Valid values include: `Default`, `CarbonData`: Carbon format(Supported only for
        table type datasets).
        """
        return pulumi.get(self, "data_format")

    @data_format.setter
    def data_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_format", value)

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> Optional[pulumi.Input['DatasetDataSourceArgs']]:
        """
        Specifies the data sources which be used to imported the source data (such
        as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_source")

    @data_source.setter
    def data_source(self, value: Optional[pulumi.Input['DatasetDataSourceArgs']]):
        pulumi.set(self, "data_source", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of dataset. It contains a maximum of 256 characters and
        cannot contain special characters `!<>=&"'`.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="importLabeledEnabled")
    def import_labeled_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to import labeled files.
        Default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "import_labeled_enabled")

    @import_labeled_enabled.setter
    def import_labeled_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "import_labeled_enabled", value)

    @property
    @pulumi.getter(name="labelFormat")
    def label_format(self) -> Optional[pulumi.Input['DatasetLabelFormatArgs']]:
        """
        Specifies the custom format information of labeled files when import
        labeled files for Text classification. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "label_format")

    @label_format.setter
    def label_format(self, value: Optional[pulumi.Input['DatasetLabelFormatArgs']]):
        pulumi.set(self, "label_format", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]]]:
        """
        Specifies labels information. Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetLabelArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS path for storing output files such as labeled files.
        The path cannot be the same as the import path or subdirectory of the import path.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "output_path")

    @output_path.setter
    def output_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_path", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]]]:
        """
        Specifies the schema information of source data when `type` is `400`.
        Structure is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatasetSchemaArgs']]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[int]]:
        """
        Dataset status. Valid values are as follows:
        + **0**: Creating.
        + **1**: Completed.
        + **2**: Deleting.
        + **3**: Deleted.
        + **4**: Exception.
        + **5**: Syncing.
        + **6**: Releasing.
        + **7**: Version switching.
        + **8**: Importing.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "type", value)


class Dataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source: Optional[pulumi.Input[pulumi.InputType['DatasetDataSourceArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 import_labeled_enabled: Optional[pulumi.Input[bool]] = None,
                 label_format: Optional[pulumi.Input[pulumi.InputType['DatasetLabelFormatArgs']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetLabelArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetSchemaArgs']]]]] = None,
                 type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages ModelArts dataset resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        name = config.require_object("name")
        output_obs_path = config.require_object("outputObsPath")
        input_obs_path = config.require_object("inputObsPath")
        test = huaweicloud.model_arts.Dataset("test",
            type=1,
            output_path=output_obs_path,
            description="Terraform Demo",
            data_source=huaweicloud.model_arts.DatasetDataSourceArgs(
                path=input_obs_path,
            ),
            labels=[huaweicloud.model_arts.DatasetLabelArgs(
                name="foo",
            )])
        ```

        ## Import

        The datasets can be imported by `id`.

        ```sh
         $ pulumi import huaweicloud:ModelArts/dataset:Dataset test yiROKoTTjtwjvP71yLG
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`data_source.0.path`, `data_source.0.queue_name`, `data_source.0.database_name`, `data_source.0.table_name`, `data_source.0.cluster_id`, `data_source.0.user_name` and `data_source.0.password`. It is generally recommended running `terraform plan` after importing a dataset. You can then decide if changes should be applied to the dataset, or the resource definition should be updated to align with the dataset. Also you can ignore changes as below. resource "huaweicloud_modelarts_dataset" "test" {

         ...

         lifecycle {

         ignore_changes = [

         data_source.0.path, data_source.0.queue_name, data_source.0.database_name, data_source.0.table_name,

         data_source.0.cluster_id, data_source.0.user_name, data_source.0.password,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['DatasetDataSourceArgs']] data_source: Specifies the data sources which be used to imported the source data (such
               as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset. It contains a maximum of 256 characters and
               cannot contain special characters `!<>=&"'`.
        :param pulumi.Input[bool] import_labeled_enabled: Specifies whether to import labeled files.
               Default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['DatasetLabelFormatArgs']] label_format: Specifies the custom format information of labeled files when import
               labeled files for Text classification. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetLabelArgs']]]] labels: Specifies labels information. Structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of label.
        :param pulumi.Input[str] output_path: Specifies the OBS path for storing output files such as labeled files.
               The path cannot be the same as the import path or subdirectory of the import path.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetSchemaArgs']]]] schemas: Specifies the schema information of source data when `type` is `400`.
               Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[int] type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages ModelArts dataset resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        name = config.require_object("name")
        output_obs_path = config.require_object("outputObsPath")
        input_obs_path = config.require_object("inputObsPath")
        test = huaweicloud.model_arts.Dataset("test",
            type=1,
            output_path=output_obs_path,
            description="Terraform Demo",
            data_source=huaweicloud.model_arts.DatasetDataSourceArgs(
                path=input_obs_path,
            ),
            labels=[huaweicloud.model_arts.DatasetLabelArgs(
                name="foo",
            )])
        ```

        ## Import

        The datasets can be imported by `id`.

        ```sh
         $ pulumi import huaweicloud:ModelArts/dataset:Dataset test yiROKoTTjtwjvP71yLG
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`data_source.0.path`, `data_source.0.queue_name`, `data_source.0.database_name`, `data_source.0.table_name`, `data_source.0.cluster_id`, `data_source.0.user_name` and `data_source.0.password`. It is generally recommended running `terraform plan` after importing a dataset. You can then decide if changes should be applied to the dataset, or the resource definition should be updated to align with the dataset. Also you can ignore changes as below. resource "huaweicloud_modelarts_dataset" "test" {

         ...

         lifecycle {

         ignore_changes = [

         data_source.0.path, data_source.0.queue_name, data_source.0.database_name, data_source.0.table_name,

         data_source.0.cluster_id, data_source.0.user_name, data_source.0.password,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param DatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source: Optional[pulumi.Input[pulumi.InputType['DatasetDataSourceArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 import_labeled_enabled: Optional[pulumi.Input[bool]] = None,
                 label_format: Optional[pulumi.Input[pulumi.InputType['DatasetLabelFormatArgs']]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetLabelArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_path: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetSchemaArgs']]]]] = None,
                 type: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatasetArgs.__new__(DatasetArgs)

            if data_source is None and not opts.urn:
                raise TypeError("Missing required property 'data_source'")
            __props__.__dict__["data_source"] = data_source
            __props__.__dict__["description"] = description
            __props__.__dict__["import_labeled_enabled"] = import_labeled_enabled
            __props__.__dict__["label_format"] = label_format
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if output_path is None and not opts.urn:
                raise TypeError("Missing required property 'output_path'")
            __props__.__dict__["output_path"] = output_path
            __props__.__dict__["region"] = region
            __props__.__dict__["schemas"] = schemas
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["data_format"] = None
            __props__.__dict__["status"] = None
        super(Dataset, __self__).__init__(
            'huaweicloud:ModelArts/dataset:Dataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            data_format: Optional[pulumi.Input[str]] = None,
            data_source: Optional[pulumi.Input[pulumi.InputType['DatasetDataSourceArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            import_labeled_enabled: Optional[pulumi.Input[bool]] = None,
            label_format: Optional[pulumi.Input[pulumi.InputType['DatasetLabelFormatArgs']]] = None,
            labels: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetLabelArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_path: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetSchemaArgs']]]]] = None,
            status: Optional[pulumi.Input[int]] = None,
            type: Optional[pulumi.Input[int]] = None) -> 'Dataset':
        """
        Get an existing Dataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The dataset creation time.
        :param pulumi.Input[str] data_format: dataset format. Valid values include: `Default`, `CarbonData`: Carbon format(Supported only for
               table type datasets).
        :param pulumi.Input[pulumi.InputType['DatasetDataSourceArgs']] data_source: Specifies the data sources which be used to imported the source data (such
               as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] description: Specifies the description of dataset. It contains a maximum of 256 characters and
               cannot contain special characters `!<>=&"'`.
        :param pulumi.Input[bool] import_labeled_enabled: Specifies whether to import labeled files.
               Default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['DatasetLabelFormatArgs']] label_format: Specifies the custom format information of labeled files when import
               labeled files for Text classification. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetLabelArgs']]]] labels: Specifies labels information. Structure is documented below.
        :param pulumi.Input[str] name: Specifies the name of label.
        :param pulumi.Input[str] output_path: Specifies the OBS path for storing output files such as labeled files.
               The path cannot be the same as the import path or subdirectory of the import path.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DatasetSchemaArgs']]]] schemas: Specifies the schema information of source data when `type` is `400`.
               Structure is documented below. Changing this parameter will create a new resource.
        :param pulumi.Input[int] status: Dataset status. Valid values are as follows:
               + **0**: Creating.
               + **1**: Completed.
               + **2**: Deleting.
               + **3**: Deleted.
               + **4**: Exception.
               + **5**: Syncing.
               + **6**: Releasing.
               + **7**: Version switching.
               + **8**: Importing.
        :param pulumi.Input[int] type: Specifies Label type for text classification.
               The optional values are as follows:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatasetState.__new__(_DatasetState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_format"] = data_format
        __props__.__dict__["data_source"] = data_source
        __props__.__dict__["description"] = description
        __props__.__dict__["import_labeled_enabled"] = import_labeled_enabled
        __props__.__dict__["label_format"] = label_format
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["output_path"] = output_path
        __props__.__dict__["region"] = region
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["status"] = status
        __props__.__dict__["type"] = type
        return Dataset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The dataset creation time.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dataFormat")
    def data_format(self) -> pulumi.Output[str]:
        """
        dataset format. Valid values include: `Default`, `CarbonData`: Carbon format(Supported only for
        table type datasets).
        """
        return pulumi.get(self, "data_format")

    @property
    @pulumi.getter(name="dataSource")
    def data_source(self) -> pulumi.Output['outputs.DatasetDataSource']:
        """
        Specifies the data sources which be used to imported the source data (such
        as pictures/files/audio, etc.) in this directory and subdirectories to the dataset. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_source")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of dataset. It contains a maximum of 256 characters and
        cannot contain special characters `!<>=&"'`.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="importLabeledEnabled")
    def import_labeled_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to import labeled files.
        Default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "import_labeled_enabled")

    @property
    @pulumi.getter(name="labelFormat")
    def label_format(self) -> pulumi.Output[Optional['outputs.DatasetLabelFormat']]:
        """
        Specifies the custom format information of labeled files when import
        labeled files for Text classification. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "label_format")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Sequence['outputs.DatasetLabel']]]:
        """
        Specifies labels information. Structure is documented below.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of label.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputPath")
    def output_path(self) -> pulumi.Output[str]:
        """
        Specifies the OBS path for storing output files such as labeled files.
        The path cannot be the same as the import path or subdirectory of the import path.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "output_path")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Optional[Sequence['outputs.DatasetSchema']]]:
        """
        Specifies the schema information of source data when `type` is `400`.
        Structure is documented below. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[int]:
        """
        Dataset status. Valid values are as follows:
        + **0**: Creating.
        + **1**: Completed.
        + **2**: Deleting.
        + **3**: Deleted.
        + **4**: Exception.
        + **5**: Syncing.
        + **6**: Releasing.
        + **7**: Version switching.
        + **8**: Importing.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[int]:
        """
        Specifies Label type for text classification.
        The optional values are as follows:
        """
        return pulumi.get(self, "type")

