# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 group_name: pulumi.Input[str],
                 ttl_in_days: pulumi.Input[int],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        :param pulumi.Input[str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "ttl_in_days", ttl_in_days)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Input[str]:
        """
        Specifies the log group name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> pulumi.Input[int]:
        """
        Specifies the log expiration time(days), value range: 1-30.
        """
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: pulumi.Input[int]):
        pulumi.set(self, "ttl_in_days", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the log group resource. If omitted, the
        provider-level region will be used. Changing this creates a new log group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 group_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ttl_in_days: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        :param pulumi.Input[int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ttl_in_days is not None:
            pulumi.set(__self__, "ttl_in_days", ttl_in_days)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the log group name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the log group resource. If omitted, the
        provider-level region will be used. Changing this creates a new log group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the log expiration time(days), value range: 1-30.
        """
        return pulumi.get(self, "ttl_in_days")

    @ttl_in_days.setter
    def ttl_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ttl_in_days", value)


class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ttl_in_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a log group resource within HuaweiCloud.

        ## Example Usage
        ### create a log group

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        log_group1 = huaweicloud.lts.Group("logGroup1",
            group_name="log_group1",
            ttl_in_days=1)
        ```

        ## Import

        Log group can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Lts/group:Group group_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        :param pulumi.Input[int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a log group resource within HuaweiCloud.

        ## Example Usage
        ### create a log group

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        log_group1 = huaweicloud.lts.Group("logGroup1",
            group_name="log_group1",
            ttl_in_days=1)
        ```

        ## Import

        Log group can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Lts/group:Group group_1 7117d38e-4c8f-4624-a505-bd96b97d024c
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ttl_in_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            if group_name is None and not opts.urn:
                raise TypeError("Missing required property 'group_name'")
            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["region"] = region
            if ttl_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'ttl_in_days'")
            __props__.__dict__["ttl_in_days"] = ttl_in_days
        super(Group, __self__).__init__(
            'huaweicloud:Lts/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group_name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            ttl_in_days: Optional[pulumi.Input[int]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] group_name: Specifies the log group name. Changing this parameter will create a new
               resource.
        :param pulumi.Input[str] region: The region in which to create the log group resource. If omitted, the
               provider-level region will be used. Changing this creates a new log group resource.
        :param pulumi.Input[int] ttl_in_days: Specifies the log expiration time(days), value range: 1-30.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["region"] = region
        __props__.__dict__["ttl_in_days"] = ttl_in_days
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[str]:
        """
        Specifies the log group name. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the log group resource. If omitted, the
        provider-level region will be used. Changing this creates a new log group resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="ttlInDays")
    def ttl_in_days(self) -> pulumi.Output[int]:
        """
        Specifies the log expiration time(days), value range: 1-30.
        """
        return pulumi.get(self, "ttl_in_days")

