# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SpaceArgs', 'Space']

@pulumi.input_type
class SpaceArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Space resource.
        :param pulumi.Input[str] name: Specifies the space name. The name contains a maximum of 64 characters.
               Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA resource space resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the space name. The name contains a maximum of 64 characters.
        Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA resource space resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _SpaceState:
    def __init__(__self__, *,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Space resources.
        :param pulumi.Input[bool] is_default: Whether it is the default resource space. The IoT platform automatically creates and assigns
               a default resource space (undeletable) to your account.
        :param pulumi.Input[str] name: Specifies the space name. The name contains a maximum of 64 characters.
               Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA resource space resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether it is the default resource space. The IoT platform automatically creates and assigns
        a default resource space (undeletable) to your account.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the space name. The name contains a maximum of 64 characters.
        Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the IoTDA resource space resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class Space(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an IoTDA resource space within HuaweiCloud.

        A resource space is the basic unit of service management and provides independent device management and platform
        configuration capabilities at the service layer. Resources (such as products and devices) must be created on
        a resource space.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        space = huaweicloud.io_tda.Space("space")
        ```

        ## Import

        Spaces can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/space:Space test 10022532f4f94f26b01daa1e424853e1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Specifies the space name. The name contains a maximum of 64 characters.
               Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA resource space resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SpaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoTDA resource space within HuaweiCloud.

        A resource space is the basic unit of service management and provides independent device management and platform
        configuration capabilities at the service layer. Resources (such as products and devices) must be created on
        a resource space.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        space = huaweicloud.io_tda.Space("space")
        ```

        ## Import

        Spaces can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:IoTDA/space:Space test 10022532f4f94f26b01daa1e424853e1
        ```

        :param str resource_name: The name of the resource.
        :param SpaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpaceArgs.__new__(SpaceArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["is_default"] = None
        super(Space, __self__).__init__(
            'huaweicloud:IoTDA/space:Space',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'Space':
        """
        Get an existing Space resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_default: Whether it is the default resource space. The IoT platform automatically creates and assigns
               a default resource space (undeletable) to your account.
        :param pulumi.Input[str] name: Specifies the space name. The name contains a maximum of 64 characters.
               Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to create the IoTDA resource space resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpaceState.__new__(_SpaceState)

        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        return Space(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[bool]:
        """
        Whether it is the default resource space. The IoT platform automatically creates and assigns
        a default resource space (undeletable) to your account.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the space name. The name contains a maximum of 64 characters.
        Only letters, digits, hyphens (-), underscore (_) and the following specail characters are allowed: `?'#().,&%@!`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the IoTDA resource space resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

