# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ImageArgs', 'Image']

@pulumi.input_type
class ImageArgs:
    def __init__(__self__, *,
                 cmk_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_config: Optional[pulumi.Input[bool]] = None,
                 max_ram: Optional[pulumi.Input[int]] = None,
                 min_disk: Optional[pulumi.Input[int]] = None,
                 min_ram: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Image resource.
        :param pulumi.Input[str] cmk_id: The master key used for encrypting an image.
        :param pulumi.Input[str] description: A description of the image.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the image. Changing this creates a
               new image.
        :param pulumi.Input[str] image_url: The URL of the external image file in the OBS bucket. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
               name:Image file name*.
        :param pulumi.Input[str] instance_id: The ID of the ECS that needs to be converted into an image. This
               parameter is mandatory when you create a privete image from an ECS.
        :param pulumi.Input[bool] is_config: If automatic configuration is required, set the value to true. Otherwise, set
               the value to false.
        :param pulumi.Input[int] max_ram: The maximum memory of the image in the unit of MB.
        :param pulumi.Input[int] min_disk: The minimum size of the system disk in the unit of GB. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
               to 1024 GB.
        :param pulumi.Input[int] min_ram: The minimum memory of the image in the unit of MB. The default value is 0,
               indicating that the memory is not restricted.
        :param pulumi.Input[str] name: The name of the image.
        :param pulumi.Input[str] os_version: The OS version. This parameter is valid when you create a private image
               from an external file uploaded to an OBS bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the image.
        :param pulumi.Input[str] type: The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        """
        if cmk_id is not None:
            pulumi.set(__self__, "cmk_id", cmk_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_config is not None:
            pulumi.set(__self__, "is_config", is_config)
        if max_ram is not None:
            pulumi.set(__self__, "max_ram", max_ram)
        if min_disk is not None:
            pulumi.set(__self__, "min_disk", min_disk)
        if min_ram is not None:
            pulumi.set(__self__, "min_ram", min_ram)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cmkId")
    def cmk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The master key used for encrypting an image.
        """
        return pulumi.get(self, "cmk_id")

    @cmk_id.setter
    def cmk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmk_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the image. Changing this creates a
        new image.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the external image file in the OBS bucket. This parameter is
        mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
        name:Image file name*.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ECS that needs to be converted into an image. This
        parameter is mandatory when you create a privete image from an ECS.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isConfig")
    def is_config(self) -> Optional[pulumi.Input[bool]]:
        """
        If automatic configuration is required, set the value to true. Otherwise, set
        the value to false.
        """
        return pulumi.get(self, "is_config")

    @is_config.setter
    def is_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_config", value)

    @property
    @pulumi.getter(name="maxRam")
    def max_ram(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum memory of the image in the unit of MB.
        """
        return pulumi.get(self, "max_ram")

    @max_ram.setter
    def max_ram(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ram", value)

    @property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum size of the system disk in the unit of GB. This parameter is
        mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
        to 1024 GB.
        """
        return pulumi.get(self, "min_disk")

    @min_disk.setter
    def min_disk(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_disk", value)

    @property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum memory of the image in the unit of MB. The default value is 0,
        indicating that the memory is not restricted.
        """
        return pulumi.get(self, "min_ram")

    @min_ram.setter
    def min_ram(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ram", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OS version. This parameter is valid when you create a private image
        from an external file uploaded to an OBS bucket.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _ImageState:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[str]] = None,
                 cmk_id: Optional[pulumi.Input[str]] = None,
                 data_origin: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disk_format: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_size: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_config: Optional[pulumi.Input[bool]] = None,
                 max_ram: Optional[pulumi.Input[int]] = None,
                 min_disk: Optional[pulumi.Input[int]] = None,
                 min_ram: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 visibility: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Image resources.
        :param pulumi.Input[str] checksum: The checksum of the data associated with the image.
        :param pulumi.Input[str] cmk_id: The master key used for encrypting an image.
        :param pulumi.Input[str] data_origin: The image resource. The pattern can be 'instance,*instance_id*' or 'file,*image_url*'.
        :param pulumi.Input[str] description: A description of the image.
        :param pulumi.Input[str] disk_format: The image file format. The value can be `vhd`, `zvhd`, `raw`, `zvhd2`, or `qcow2`.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the image. Changing this creates a
               new image.
        :param pulumi.Input[str] image_size: The size(bytes) of the image file format.
        :param pulumi.Input[str] image_url: The URL of the external image file in the OBS bucket. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
               name:Image file name*.
        :param pulumi.Input[str] instance_id: The ID of the ECS that needs to be converted into an image. This
               parameter is mandatory when you create a privete image from an ECS.
        :param pulumi.Input[bool] is_config: If automatic configuration is required, set the value to true. Otherwise, set
               the value to false.
        :param pulumi.Input[int] max_ram: The maximum memory of the image in the unit of MB.
        :param pulumi.Input[int] min_disk: The minimum size of the system disk in the unit of GB. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
               to 1024 GB.
        :param pulumi.Input[int] min_ram: The minimum memory of the image in the unit of MB. The default value is 0,
               indicating that the memory is not restricted.
        :param pulumi.Input[str] name: The name of the image.
        :param pulumi.Input[str] os_version: The OS version. This parameter is valid when you create a private image
               from an external file uploaded to an OBS bucket.
        :param pulumi.Input[str] status: The status of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the image.
        :param pulumi.Input[str] type: The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        :param pulumi.Input[str] visibility: Whether the image is visible to other tenants.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if cmk_id is not None:
            pulumi.set(__self__, "cmk_id", cmk_id)
        if data_origin is not None:
            pulumi.set(__self__, "data_origin", data_origin)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_format is not None:
            pulumi.set(__self__, "disk_format", disk_format)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if image_size is not None:
            pulumi.set(__self__, "image_size", image_size)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_config is not None:
            pulumi.set(__self__, "is_config", is_config)
        if max_ram is not None:
            pulumi.set(__self__, "max_ram", max_ram)
        if min_disk is not None:
            pulumi.set(__self__, "min_disk", min_disk)
        if min_ram is not None:
            pulumi.set(__self__, "min_ram", min_ram)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_version is not None:
            pulumi.set(__self__, "os_version", os_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        """
        The checksum of the data associated with the image.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter(name="cmkId")
    def cmk_id(self) -> Optional[pulumi.Input[str]]:
        """
        The master key used for encrypting an image.
        """
        return pulumi.get(self, "cmk_id")

    @cmk_id.setter
    def cmk_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cmk_id", value)

    @property
    @pulumi.getter(name="dataOrigin")
    def data_origin(self) -> Optional[pulumi.Input[str]]:
        """
        The image resource. The pattern can be 'instance,*instance_id*' or 'file,*image_url*'.
        """
        return pulumi.get(self, "data_origin")

    @data_origin.setter
    def data_origin(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_origin", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> Optional[pulumi.Input[str]]:
        """
        The image file format. The value can be `vhd`, `zvhd`, `raw`, `zvhd2`, or `qcow2`.
        """
        return pulumi.get(self, "disk_format")

    @disk_format.setter
    def disk_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_format", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the image. Changing this creates a
        new image.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> Optional[pulumi.Input[str]]:
        """
        The size(bytes) of the image file format.
        """
        return pulumi.get(self, "image_size")

    @image_size.setter
    def image_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_size", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the external image file in the OBS bucket. This parameter is
        mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
        name:Image file name*.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the ECS that needs to be converted into an image. This
        parameter is mandatory when you create a privete image from an ECS.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="isConfig")
    def is_config(self) -> Optional[pulumi.Input[bool]]:
        """
        If automatic configuration is required, set the value to true. Otherwise, set
        the value to false.
        """
        return pulumi.get(self, "is_config")

    @is_config.setter
    def is_config(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_config", value)

    @property
    @pulumi.getter(name="maxRam")
    def max_ram(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum memory of the image in the unit of MB.
        """
        return pulumi.get(self, "max_ram")

    @max_ram.setter
    def max_ram(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_ram", value)

    @property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum size of the system disk in the unit of GB. This parameter is
        mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
        to 1024 GB.
        """
        return pulumi.get(self, "min_disk")

    @min_disk.setter
    def min_disk(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_disk", value)

    @property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum memory of the image in the unit of MB. The default value is 0,
        indicating that the memory is not restricted.
        """
        return pulumi.get(self, "min_ram")

    @min_ram.setter
    def min_ram(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_ram", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> Optional[pulumi.Input[str]]:
        """
        The OS version. This parameter is valid when you create a private image
        from an external file uploaded to an OBS bucket.
        """
        return pulumi.get(self, "os_version")

    @os_version.setter
    def os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "os_version", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The tags of the image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the image is visible to other tenants.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "visibility", value)


class Image(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmk_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_config: Optional[pulumi.Input[bool]] = None,
                 max_ram: Optional[pulumi.Input[int]] = None,
                 min_disk: Optional[pulumi.Input[int]] = None,
                 min_ram: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an Image resource within HuaweiCloud IMS.

        ## Example Usage
        ### Creating an image from OBS bucket

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        ims_test_file = huaweicloud.ims.Image("imsTestFile",
            description="Create an image from the OBS bucket.",
            image_url="ims-image:centos70.qcow2",
            min_disk=40,
            tags={
                "foo": "bar1",
                "key": "value",
            })
        ```

        ## Import

        Images can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Ims/image:Image my_image 7886e623-f1b3-473e-b882-67ba1c35887f
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cmk_id: The master key used for encrypting an image.
        :param pulumi.Input[str] description: A description of the image.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the image. Changing this creates a
               new image.
        :param pulumi.Input[str] image_url: The URL of the external image file in the OBS bucket. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
               name:Image file name*.
        :param pulumi.Input[str] instance_id: The ID of the ECS that needs to be converted into an image. This
               parameter is mandatory when you create a privete image from an ECS.
        :param pulumi.Input[bool] is_config: If automatic configuration is required, set the value to true. Otherwise, set
               the value to false.
        :param pulumi.Input[int] max_ram: The maximum memory of the image in the unit of MB.
        :param pulumi.Input[int] min_disk: The minimum size of the system disk in the unit of GB. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
               to 1024 GB.
        :param pulumi.Input[int] min_ram: The minimum memory of the image in the unit of MB. The default value is 0,
               indicating that the memory is not restricted.
        :param pulumi.Input[str] name: The name of the image.
        :param pulumi.Input[str] os_version: The OS version. This parameter is valid when you create a private image
               from an external file uploaded to an OBS bucket.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the image.
        :param pulumi.Input[str] type: The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ImageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Image resource within HuaweiCloud IMS.

        ## Example Usage
        ### Creating an image from OBS bucket

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        ims_test_file = huaweicloud.ims.Image("imsTestFile",
            description="Create an image from the OBS bucket.",
            image_url="ims-image:centos70.qcow2",
            min_disk=40,
            tags={
                "foo": "bar1",
                "key": "value",
            })
        ```

        ## Import

        Images can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Ims/image:Image my_image 7886e623-f1b3-473e-b882-67ba1c35887f
        ```

        :param str resource_name: The name of the resource.
        :param ImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cmk_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 is_config: Optional[pulumi.Input[bool]] = None,
                 max_ram: Optional[pulumi.Input[int]] = None,
                 min_disk: Optional[pulumi.Input[int]] = None,
                 min_ram: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 os_version: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImageArgs.__new__(ImageArgs)

            __props__.__dict__["cmk_id"] = cmk_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["image_url"] = image_url
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_config"] = is_config
            __props__.__dict__["max_ram"] = max_ram
            __props__.__dict__["min_disk"] = min_disk
            __props__.__dict__["min_ram"] = min_ram
            __props__.__dict__["name"] = name
            __props__.__dict__["os_version"] = os_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["checksum"] = None
            __props__.__dict__["data_origin"] = None
            __props__.__dict__["disk_format"] = None
            __props__.__dict__["image_size"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["visibility"] = None
        super(Image, __self__).__init__(
            'huaweicloud:Ims/image:Image',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            checksum: Optional[pulumi.Input[str]] = None,
            cmk_id: Optional[pulumi.Input[str]] = None,
            data_origin: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disk_format: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            image_size: Optional[pulumi.Input[str]] = None,
            image_url: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            is_config: Optional[pulumi.Input[bool]] = None,
            max_ram: Optional[pulumi.Input[int]] = None,
            min_disk: Optional[pulumi.Input[int]] = None,
            min_ram: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            os_version: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            visibility: Optional[pulumi.Input[str]] = None) -> 'Image':
        """
        Get an existing Image resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] checksum: The checksum of the data associated with the image.
        :param pulumi.Input[str] cmk_id: The master key used for encrypting an image.
        :param pulumi.Input[str] data_origin: The image resource. The pattern can be 'instance,*instance_id*' or 'file,*image_url*'.
        :param pulumi.Input[str] description: A description of the image.
        :param pulumi.Input[str] disk_format: The image file format. The value can be `vhd`, `zvhd`, `raw`, `zvhd2`, or `qcow2`.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the image. Changing this creates a
               new image.
        :param pulumi.Input[str] image_size: The size(bytes) of the image file format.
        :param pulumi.Input[str] image_url: The URL of the external image file in the OBS bucket. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
               name:Image file name*.
        :param pulumi.Input[str] instance_id: The ID of the ECS that needs to be converted into an image. This
               parameter is mandatory when you create a privete image from an ECS.
        :param pulumi.Input[bool] is_config: If automatic configuration is required, set the value to true. Otherwise, set
               the value to false.
        :param pulumi.Input[int] max_ram: The maximum memory of the image in the unit of MB.
        :param pulumi.Input[int] min_disk: The minimum size of the system disk in the unit of GB. This parameter is
               mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
               to 1024 GB.
        :param pulumi.Input[int] min_ram: The minimum memory of the image in the unit of MB. The default value is 0,
               indicating that the memory is not restricted.
        :param pulumi.Input[str] name: The name of the image.
        :param pulumi.Input[str] os_version: The OS version. This parameter is valid when you create a private image
               from an external file uploaded to an OBS bucket.
        :param pulumi.Input[str] status: The status of the image.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The tags of the image.
        :param pulumi.Input[str] type: The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        :param pulumi.Input[str] visibility: Whether the image is visible to other tenants.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImageState.__new__(_ImageState)

        __props__.__dict__["checksum"] = checksum
        __props__.__dict__["cmk_id"] = cmk_id
        __props__.__dict__["data_origin"] = data_origin
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_format"] = disk_format
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["image_size"] = image_size
        __props__.__dict__["image_url"] = image_url
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_config"] = is_config
        __props__.__dict__["max_ram"] = max_ram
        __props__.__dict__["min_disk"] = min_disk
        __props__.__dict__["min_ram"] = min_ram
        __props__.__dict__["name"] = name
        __props__.__dict__["os_version"] = os_version
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["visibility"] = visibility
        return Image(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def checksum(self) -> pulumi.Output[str]:
        """
        The checksum of the data associated with the image.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter(name="cmkId")
    def cmk_id(self) -> pulumi.Output[Optional[str]]:
        """
        The master key used for encrypting an image.
        """
        return pulumi.get(self, "cmk_id")

    @property
    @pulumi.getter(name="dataOrigin")
    def data_origin(self) -> pulumi.Output[str]:
        """
        The image resource. The pattern can be 'instance,*instance_id*' or 'file,*image_url*'.
        """
        return pulumi.get(self, "data_origin")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the image.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="diskFormat")
    def disk_format(self) -> pulumi.Output[str]:
        """
        The image file format. The value can be `vhd`, `zvhd`, `raw`, `zvhd2`, or `qcow2`.
        """
        return pulumi.get(self, "disk_format")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the image. Changing this creates a
        new image.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="imageSize")
    def image_size(self) -> pulumi.Output[str]:
        """
        The size(bytes) of the image file format.
        """
        return pulumi.get(self, "image_size")

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> pulumi.Output[Optional[str]]:
        """
        The URL of the external image file in the OBS bucket. This parameter is
        mandatory when you create a private image from an external file uploaded to an OBS bucket. The format is *OBS bucket
        name:Image file name*.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the ECS that needs to be converted into an image. This
        parameter is mandatory when you create a privete image from an ECS.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isConfig")
    def is_config(self) -> pulumi.Output[Optional[bool]]:
        """
        If automatic configuration is required, set the value to true. Otherwise, set
        the value to false.
        """
        return pulumi.get(self, "is_config")

    @property
    @pulumi.getter(name="maxRam")
    def max_ram(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum memory of the image in the unit of MB.
        """
        return pulumi.get(self, "max_ram")

    @property
    @pulumi.getter(name="minDisk")
    def min_disk(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum size of the system disk in the unit of GB. This parameter is
        mandatory when you create a private image from an external file uploaded to an OBS bucket. The value ranges from 1 GB
        to 1024 GB.
        """
        return pulumi.get(self, "min_disk")

    @property
    @pulumi.getter(name="minRam")
    def min_ram(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum memory of the image in the unit of MB. The default value is 0,
        indicating that the memory is not restricted.
        """
        return pulumi.get(self, "min_ram")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the image.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="osVersion")
    def os_version(self) -> pulumi.Output[str]:
        """
        The OS version. This parameter is valid when you create a private image
        from an external file uploaded to an OBS bucket.
        """
        return pulumi.get(self, "os_version")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the image.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The tags of the image.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The image type. Must be one of `ECS`, `FusionCompute`, `BMS`, or `Ironic`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[str]:
        """
        Whether the image is visible to other tenants.
        """
        return pulumi.get(self, "visibility")

