# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['VipArgs', 'Vip']

@pulumi.input_type
class VipArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Vip resource.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the network to which the vip belongs.
               Changing this parameter creates a new vip resource.
        :param pulumi.Input[str] ip_address: Specifies the IP address desired in the subnet for this vip.
               If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
               Changing this parameter creates a new vip resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_ids: Specifies an array of IDs of the ports to attach the vip to.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if port_ids is not None:
            pulumi.set(__self__, "port_ids", port_ids)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the network to which the vip belongs.
        Changing this parameter creates a new vip resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address desired in the subnet for this vip.
        If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
        Changing this parameter creates a new vip resource.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="portIds")
    def port_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of IDs of the ports to attach the vip to.
        """
        return pulumi.get(self, "port_ids")

    @port_ids.setter
    def port_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "port_ids", value)


@pulumi.input_type
class _VipState:
    def __init__(__self__, *,
                 allowed_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 port_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Vip resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_addresses: An array of IP addresses of the ports to attach the vip to.
        :param pulumi.Input[str] ip_address: Specifies the IP address desired in the subnet for this vip.
               If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
               Changing this parameter creates a new vip resource.
        :param pulumi.Input[str] mac_address: The MAC address of the vip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_ids: Specifies an array of IDs of the ports to attach the vip to.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the network to which the vip belongs.
               Changing this parameter creates a new vip resource.
        """
        if allowed_addresses is not None:
            pulumi.set(__self__, "allowed_addresses", allowed_addresses)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if port_ids is not None:
            pulumi.set(__self__, "port_ids", port_ids)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="allowedAddresses")
    def allowed_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of IP addresses of the ports to attach the vip to.
        """
        return pulumi.get(self, "allowed_addresses")

    @allowed_addresses.setter
    def allowed_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_addresses", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the IP address desired in the subnet for this vip.
        If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
        Changing this parameter creates a new vip resource.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address of the vip.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter(name="portIds")
    def port_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies an array of IDs of the ports to attach the vip to.
        """
        return pulumi.get(self, "port_ids")

    @port_ids.setter
    def port_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "port_ids", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the network to which the vip belongs.
        Changing this parameter creates a new vip resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)


class Vip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a VIP resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_subnet_id = config.require_object("iecSubnetId")
        vip_test = huaweicloud.iec.Vip("vipTest", subnet_id=iec_subnet_id)
        ```

        ## Import

        IEC VIP can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/vip:Vip vip_test 61fd8d31-8f92-4526-a5f5-07ec303e69e7
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip_address: Specifies the IP address desired in the subnet for this vip.
               If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
               Changing this parameter creates a new vip resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_ids: Specifies an array of IDs of the ports to attach the vip to.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the network to which the vip belongs.
               Changing this parameter creates a new vip resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VIP resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        iec_subnet_id = config.require_object("iecSubnetId")
        vip_test = huaweicloud.iec.Vip("vipTest", subnet_id=iec_subnet_id)
        ```

        ## Import

        IEC VIP can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/vip:Vip vip_test 61fd8d31-8f92-4526-a5f5-07ec303e69e7
        ```

        :param str resource_name: The name of the resource.
        :param VipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 port_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VipArgs.__new__(VipArgs)

            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["port_ids"] = port_ids
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["allowed_addresses"] = None
            __props__.__dict__["mac_address"] = None
        super(Vip, __self__).__init__(
            'huaweicloud:Iec/vip:Vip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            mac_address: Optional[pulumi.Input[str]] = None,
            port_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None) -> 'Vip':
        """
        Get an existing Vip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_addresses: An array of IP addresses of the ports to attach the vip to.
        :param pulumi.Input[str] ip_address: Specifies the IP address desired in the subnet for this vip.
               If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
               Changing this parameter creates a new vip resource.
        :param pulumi.Input[str] mac_address: The MAC address of the vip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] port_ids: Specifies an array of IDs of the ports to attach the vip to.
        :param pulumi.Input[str] subnet_id: Specifies the ID of the network to which the vip belongs.
               Changing this parameter creates a new vip resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VipState.__new__(_VipState)

        __props__.__dict__["allowed_addresses"] = allowed_addresses
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["port_ids"] = port_ids
        __props__.__dict__["subnet_id"] = subnet_id
        return Vip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedAddresses")
    def allowed_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of IP addresses of the ports to attach the vip to.
        """
        return pulumi.get(self, "allowed_addresses")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        Specifies the IP address desired in the subnet for this vip.
        If you don't specify it, an available IP address from the specified subnet will be allocated to this vip.
        Changing this parameter creates a new vip resource.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[str]:
        """
        The MAC address of the vip.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="portIds")
    def port_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies an array of IDs of the ports to attach the vip to.
        """
        return pulumi.get(self, "port_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the network to which the vip belongs.
        Changing this parameter creates a new vip resource.
        """
        return pulumi.get(self, "subnet_id")

