# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetSitesResult',
    'AwaitableGetSitesResult',
    'get_sites',
    'get_sites_output',
]

@pulumi.output_type
class GetSitesResult:
    """
    A collection of values returned by getSites.
    """
    def __init__(__self__, area=None, city=None, id=None, province=None, region=None, sites=None):
        if area and not isinstance(area, str):
            raise TypeError("Expected argument 'area' to be a str")
        pulumi.set(__self__, "area", area)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if province and not isinstance(province, str):
            raise TypeError("Expected argument 'province' to be a str")
        pulumi.set(__self__, "province", province)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if sites and not isinstance(sites, list):
            raise TypeError("Expected argument 'sites' to be a list")
        pulumi.set(__self__, "sites", sites)

    @property
    @pulumi.getter
    def area(self) -> Optional[str]:
        """
        The area of the IEC service site located.
        """
        return pulumi.get(self, "area")

    @property
    @pulumi.getter
    def city(self) -> Optional[str]:
        """
        The city of the IEC service site located.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def province(self) -> Optional[str]:
        """
        The province of the IEC service site located.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def sites(self) -> Sequence['outputs.GetSitesSiteResult']:
        """
        An array of one or more IEC service sites. The sites object structure is documented below.
        """
        return pulumi.get(self, "sites")


class AwaitableGetSitesResult(GetSitesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSitesResult(
            area=self.area,
            city=self.city,
            id=self.id,
            province=self.province,
            region=self.region,
            sites=self.sites)


def get_sites(area: Optional[str] = None,
              city: Optional[str] = None,
              province: Optional[str] = None,
              region: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSitesResult:
    """
    Use this data source to get the available of HuaweiCloud IEC sites.

    ## Example Usage
    ### Basic IEC Sites

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    iec_sites = huaweicloud.Iec.get_sites()
    ```


    :param str area: Specifies the area of the IEC sites located.
    :param str city: Specifies the city of the IEC sites located.
    :param str province: Specifies the province of the IEC sites located.
    """
    __args__ = dict()
    __args__['area'] = area
    __args__['city'] = city
    __args__['province'] = province
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Iec/getSites:getSites', __args__, opts=opts, typ=GetSitesResult).value

    return AwaitableGetSitesResult(
        area=__ret__.area,
        city=__ret__.city,
        id=__ret__.id,
        province=__ret__.province,
        region=__ret__.region,
        sites=__ret__.sites)


@_utilities.lift_output_func(get_sites)
def get_sites_output(area: Optional[pulumi.Input[Optional[str]]] = None,
                     city: Optional[pulumi.Input[Optional[str]]] = None,
                     province: Optional[pulumi.Input[Optional[str]]] = None,
                     region: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSitesResult]:
    """
    Use this data source to get the available of HuaweiCloud IEC sites.

    ## Example Usage
    ### Basic IEC Sites

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    iec_sites = huaweicloud.Iec.get_sites()
    ```


    :param str area: Specifies the area of the IEC sites located.
    :param str city: Specifies the city of the IEC sites located.
    :param str province: Specifies the province of the IEC sites located.
    """
    ...
