# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['EipArgs', 'Eip']

@pulumi.input_type
class EipArgs:
    def __init__(__self__, *,
                 site_id: pulumi.Input[str],
                 ip_version: Optional[pulumi.Input[int]] = None,
                 line_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Eip resource.
        :param pulumi.Input[str] site_id: Specifies the ID of IEC sevice site. Changing this parameter creates a new
               resource.
        :param pulumi.Input[int] ip_version: The version of elastic IP address.
        :param pulumi.Input[str] line_id: Specifies the line ID of IEC sevice site.
               Changing this parameter creates a new resource.
        :param pulumi.Input[str] port_id: Specifies the port ID which this eip will associate with.
        """
        pulumi.set(__self__, "site_id", site_id)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if line_id is not None:
            pulumi.set(__self__, "line_id", line_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of IEC sevice site. Changing this parameter creates a new
        resource.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of elastic IP address.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="lineId")
    def line_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the line ID of IEC sevice site.
        Changing this parameter creates a new resource.
        """
        return pulumi.get(self, "line_id")

    @line_id.setter
    def line_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line_id", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the port ID which this eip will associate with.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EipState:
    def __init__(__self__, *,
                 bandwidth_id: Optional[pulumi.Input[str]] = None,
                 bandwidth_name: Optional[pulumi.Input[str]] = None,
                 bandwidth_share_type: Optional[pulumi.Input[str]] = None,
                 bandwidth_size: Optional[pulumi.Input[int]] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 line_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 site_info: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Eip resources.
        :param pulumi.Input[int] ip_version: The version of elastic IP address.
        :param pulumi.Input[str] line_id: Specifies the line ID of IEC sevice site.
               Changing this parameter creates a new resource.
        :param pulumi.Input[str] port_id: Specifies the port ID which this eip will associate with.
        :param pulumi.Input[str] private_ip: The address of private IP.
        :param pulumi.Input[str] public_ip: The address of elastic IP.
        :param pulumi.Input[str] site_id: Specifies the ID of IEC sevice site. Changing this parameter creates a new
               resource.
        :param pulumi.Input[str] site_info: The located information of the IEC site. It contains area, province and city.
        :param pulumi.Input[str] status: The status of elastic IP.
        """
        if bandwidth_id is not None:
            pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if bandwidth_name is not None:
            pulumi.set(__self__, "bandwidth_name", bandwidth_name)
        if bandwidth_share_type is not None:
            pulumi.set(__self__, "bandwidth_share_type", bandwidth_share_type)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if line_id is not None:
            pulumi.set(__self__, "line_id", line_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if site_id is not None:
            pulumi.set(__self__, "site_id", site_id)
        if site_info is not None:
            pulumi.set(__self__, "site_info", site_info)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bandwidth_id")

    @bandwidth_id.setter
    def bandwidth_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_id", value)

    @property
    @pulumi.getter(name="bandwidthName")
    def bandwidth_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bandwidth_name")

    @bandwidth_name.setter
    def bandwidth_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_name", value)

    @property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bandwidth_share_type")

    @bandwidth_share_type.setter
    def bandwidth_share_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth_share_type", value)

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth_size", value)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of elastic IP address.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ip_version", value)

    @property
    @pulumi.getter(name="lineId")
    def line_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the line ID of IEC sevice site.
        Changing this parameter creates a new resource.
        """
        return pulumi.get(self, "line_id")

    @line_id.setter
    def line_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "line_id", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the port ID which this eip will associate with.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The address of private IP.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The address of elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of IEC sevice site. Changing this parameter creates a new
        resource.
        """
        return pulumi.get(self, "site_id")

    @site_id.setter
    def site_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_id", value)

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> Optional[pulumi.Input[str]]:
        """
        The located information of the IEC site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")

    @site_info.setter
    def site_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "site_info", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of elastic IP.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Eip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 line_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a eip resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        iec_sites = huaweicloud.Iec.get_sites()
        eip_test = huaweicloud.iec.Eip("eipTest", site_id=iec_sites.sites[0].id)
        ```

        ## Import

        IEC EIPs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/eip:Eip eip_test b5ad19d1-57d1-48fd-aab7-1378f9bee169
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] ip_version: The version of elastic IP address.
        :param pulumi.Input[str] line_id: Specifies the line ID of IEC sevice site.
               Changing this parameter creates a new resource.
        :param pulumi.Input[str] port_id: Specifies the port ID which this eip will associate with.
        :param pulumi.Input[str] site_id: Specifies the ID of IEC sevice site. Changing this parameter creates a new
               resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a eip resource within HuaweiCloud IEC.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        iec_sites = huaweicloud.Iec.get_sites()
        eip_test = huaweicloud.iec.Eip("eipTest", site_id=iec_sites.sites[0].id)
        ```

        ## Import

        IEC EIPs can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Iec/eip:Eip eip_test b5ad19d1-57d1-48fd-aab7-1378f9bee169
        ```

        :param str resource_name: The name of the resource.
        :param EipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_version: Optional[pulumi.Input[int]] = None,
                 line_id: Optional[pulumi.Input[str]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 site_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipArgs.__new__(EipArgs)

            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["line_id"] = line_id
            __props__.__dict__["port_id"] = port_id
            __props__.__dict__["region"] = region
            if site_id is None and not opts.urn:
                raise TypeError("Missing required property 'site_id'")
            __props__.__dict__["site_id"] = site_id
            __props__.__dict__["bandwidth_id"] = None
            __props__.__dict__["bandwidth_name"] = None
            __props__.__dict__["bandwidth_share_type"] = None
            __props__.__dict__["bandwidth_size"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["site_info"] = None
            __props__.__dict__["status"] = None
        super(Eip, __self__).__init__(
            'huaweicloud:Iec/eip:Eip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_id: Optional[pulumi.Input[str]] = None,
            bandwidth_name: Optional[pulumi.Input[str]] = None,
            bandwidth_share_type: Optional[pulumi.Input[str]] = None,
            bandwidth_size: Optional[pulumi.Input[int]] = None,
            ip_version: Optional[pulumi.Input[int]] = None,
            line_id: Optional[pulumi.Input[str]] = None,
            port_id: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            site_id: Optional[pulumi.Input[str]] = None,
            site_info: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Eip':
        """
        Get an existing Eip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] ip_version: The version of elastic IP address.
        :param pulumi.Input[str] line_id: Specifies the line ID of IEC sevice site.
               Changing this parameter creates a new resource.
        :param pulumi.Input[str] port_id: Specifies the port ID which this eip will associate with.
        :param pulumi.Input[str] private_ip: The address of private IP.
        :param pulumi.Input[str] public_ip: The address of elastic IP.
        :param pulumi.Input[str] site_id: Specifies the ID of IEC sevice site. Changing this parameter creates a new
               resource.
        :param pulumi.Input[str] site_info: The located information of the IEC site. It contains area, province and city.
        :param pulumi.Input[str] status: The status of elastic IP.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipState.__new__(_EipState)

        __props__.__dict__["bandwidth_id"] = bandwidth_id
        __props__.__dict__["bandwidth_name"] = bandwidth_name
        __props__.__dict__["bandwidth_share_type"] = bandwidth_share_type
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["line_id"] = line_id
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["site_id"] = site_id
        __props__.__dict__["site_info"] = site_info
        __props__.__dict__["status"] = status
        return Eip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "bandwidth_id")

    @property
    @pulumi.getter(name="bandwidthName")
    def bandwidth_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "bandwidth_name")

    @property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> pulumi.Output[str]:
        return pulumi.get(self, "bandwidth_share_type")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[int]:
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[int]:
        """
        The version of elastic IP address.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="lineId")
    def line_id(self) -> pulumi.Output[str]:
        """
        Specifies the line ID of IEC sevice site.
        Changing this parameter creates a new resource.
        """
        return pulumi.get(self, "line_id")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[str]:
        """
        Specifies the port ID which this eip will associate with.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[str]:
        """
        The address of private IP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The address of elastic IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="siteId")
    def site_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of IEC sevice site. Changing this parameter creates a new
        resource.
        """
        return pulumi.get(self, "site_id")

    @property
    @pulumi.getter(name="siteInfo")
    def site_info(self) -> pulumi.Output[str]:
        """
        The located information of the IEC site. It contains area, province and city.
        """
        return pulumi.get(self, "site_info")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of elastic IP.
        """
        return pulumi.get(self, "status")

