# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AclIpCidr',
    'AclIpRange',
    'AgencyProjectRole',
    'ProviderAccessConfig',
    'ProviderConversionRule',
    'ProviderConversionRuleLocal',
    'ProviderConversionRuleRemote',
    'GetGroupUserResult',
    'GetProjectsProjectResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class AclIpCidr(dict):
    def __init__(__self__, *,
                 cidr: str,
                 description: Optional[str] = None):
        """
        :param str cidr: Specifies the IPv4 CIDR block, for example, **192.168.0.0/24**.
        :param str description: Specifies a description about an IP address range. This parameter can contain a
               maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        pulumi.set(__self__, "cidr", cidr)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def cidr(self) -> str:
        """
        Specifies the IPv4 CIDR block, for example, **192.168.0.0/24**.
        """
        return pulumi.get(self, "cidr")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies a description about an IP address range. This parameter can contain a
        maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AclIpRange(dict):
    def __init__(__self__, *,
                 range: str,
                 description: Optional[str] = None):
        """
        :param str range: Specifies the Ip address range, for example, **0.0.0.0-255.255.255.0**.
        :param str description: Specifies a description about an IP address range. This parameter can contain a
               maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        pulumi.set(__self__, "range", range)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def range(self) -> str:
        """
        Specifies the Ip address range, for example, **0.0.0.0-255.255.255.0**.
        """
        return pulumi.get(self, "range")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Specifies a description about an IP address range. This parameter can contain a
        maximum of 255 characters and the following charactors are not allowed:**@#%^&*<>\\\\**.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class AgencyProjectRole(dict):
    def __init__(__self__, *,
                 project: str,
                 roles: Sequence[str]):
        """
        :param str project: Specifies the name of project.
        :param Sequence[str] roles: Specifies an array of role names.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Specifies the name of project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def roles(self) -> Sequence[str]:
        """
        Specifies an array of role names.
        """
        return pulumi.get(self, "roles")


@pulumi.output_type
class ProviderAccessConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessType":
            suggest = "access_type"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "providerUrl":
            suggest = "provider_url"
        elif key == "signingKey":
            suggest = "signing_key"
        elif key == "authorizationEndpoint":
            suggest = "authorization_endpoint"
        elif key == "responseMode":
            suggest = "response_mode"
        elif key == "responseType":
            suggest = "response_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProviderAccessConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProviderAccessConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProviderAccessConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_type: str,
                 client_id: str,
                 provider_url: str,
                 signing_key: str,
                 authorization_endpoint: Optional[str] = None,
                 response_mode: Optional[str] = None,
                 response_type: Optional[str] = None,
                 scopes: Optional[Sequence[str]] = None):
        """
        :param str access_type: Specifies the access type of the identity provider.
               Available options are:
               + `program`: programmatic access only.
               + `program_console`: programmatic access and management console access.
        :param str client_id: Specifies the ID of a client registered with the OpenID Connect identity provider.
        :param str provider_url: Specifies the URL of the identity provider.
               This field corresponds to the iss field in the ID token.
        :param str signing_key: Public key used to sign the ID token of the OpenID Connect identity provider.
               This field is required only if the protocol is set to *oidc*.
        :param str authorization_endpoint: Specifies the authorization endpoint of the OpenID Connect identity
               provider. This field is required only if the access type is set to `program_console`.
        :param str response_mode: Response mode.
               Valid values is *form_post* and *fragment*, default value is *form_post*.
               This field is required only if the access type is set to `program_console`.
        :param str response_type: Response type. Valid values is *id_token*, default value is *id_token*.
               This field is required only if the access type is set to `program_console`.
        :param Sequence[str] scopes: Specifies the scopes of authorization requests. It is an array of one or more scopes.
               Valid values are *openid*, *email*, *profile* and other values defined by you.
               This field is required only if the access type is set to `program_console`.
        """
        pulumi.set(__self__, "access_type", access_type)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "provider_url", provider_url)
        pulumi.set(__self__, "signing_key", signing_key)
        if authorization_endpoint is not None:
            pulumi.set(__self__, "authorization_endpoint", authorization_endpoint)
        if response_mode is not None:
            pulumi.set(__self__, "response_mode", response_mode)
        if response_type is not None:
            pulumi.set(__self__, "response_type", response_type)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)

    @property
    @pulumi.getter(name="accessType")
    def access_type(self) -> str:
        """
        Specifies the access type of the identity provider.
        Available options are:
        + `program`: programmatic access only.
        + `program_console`: programmatic access and management console access.
        """
        return pulumi.get(self, "access_type")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> str:
        """
        Specifies the ID of a client registered with the OpenID Connect identity provider.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="providerUrl")
    def provider_url(self) -> str:
        """
        Specifies the URL of the identity provider.
        This field corresponds to the iss field in the ID token.
        """
        return pulumi.get(self, "provider_url")

    @property
    @pulumi.getter(name="signingKey")
    def signing_key(self) -> str:
        """
        Public key used to sign the ID token of the OpenID Connect identity provider.
        This field is required only if the protocol is set to *oidc*.
        """
        return pulumi.get(self, "signing_key")

    @property
    @pulumi.getter(name="authorizationEndpoint")
    def authorization_endpoint(self) -> Optional[str]:
        """
        Specifies the authorization endpoint of the OpenID Connect identity
        provider. This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "authorization_endpoint")

    @property
    @pulumi.getter(name="responseMode")
    def response_mode(self) -> Optional[str]:
        """
        Response mode.
        Valid values is *form_post* and *fragment*, default value is *form_post*.
        This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "response_mode")

    @property
    @pulumi.getter(name="responseType")
    def response_type(self) -> Optional[str]:
        """
        Response type. Valid values is *id_token*, default value is *id_token*.
        This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "response_type")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[Sequence[str]]:
        """
        Specifies the scopes of authorization requests. It is an array of one or more scopes.
        Valid values are *openid*, *email*, *profile* and other values defined by you.
        This field is required only if the access type is set to `program_console`.
        """
        return pulumi.get(self, "scopes")


@pulumi.output_type
class ProviderConversionRule(dict):
    def __init__(__self__, *,
                 locals: Optional[Sequence['outputs.ProviderConversionRuleLocal']] = None,
                 remotes: Optional[Sequence['outputs.ProviderConversionRuleRemote']] = None):
        """
        :param Sequence['ProviderConversionRuleLocalArgs'] locals: The federated user information on the cloud platform.
        :param Sequence['ProviderConversionRuleRemoteArgs'] remotes: The description of the identity provider.
        """
        if locals is not None:
            pulumi.set(__self__, "locals", locals)
        if remotes is not None:
            pulumi.set(__self__, "remotes", remotes)

    @property
    @pulumi.getter
    def locals(self) -> Optional[Sequence['outputs.ProviderConversionRuleLocal']]:
        """
        The federated user information on the cloud platform.
        """
        return pulumi.get(self, "locals")

    @property
    @pulumi.getter
    def remotes(self) -> Optional[Sequence['outputs.ProviderConversionRuleRemote']]:
        """
        The description of the identity provider.
        """
        return pulumi.get(self, "remotes")


@pulumi.output_type
class ProviderConversionRuleLocal(dict):
    def __init__(__self__, *,
                 group: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str group: The user group to which the federated user belongs on the cloud platform.
        :param str username: The name of a federated user on the cloud platform.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def group(self) -> Optional[str]:
        """
        The user group to which the federated user belongs on the cloud platform.
        """
        return pulumi.get(self, "group")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The name of a federated user on the cloud platform.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ProviderConversionRuleRemote(dict):
    def __init__(__self__, *,
                 attribute: Optional[str] = None,
                 condition: Optional[str] = None,
                 values: Optional[Sequence[str]] = None):
        """
        :param str attribute: The attribute in the IDP assertion.
        :param str condition: The condition of conversion rule.
        :param Sequence[str] values: The rule is matched only if the specified strings appear in the attribute type.
        """
        if attribute is not None:
            pulumi.set(__self__, "attribute", attribute)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def attribute(self) -> Optional[str]:
        """
        The attribute in the IDP assertion.
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def condition(self) -> Optional[str]:
        """
        The condition of conversion rule.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def values(self) -> Optional[Sequence[str]]:
        """
        The rule is matched only if the specified strings appear in the attribute type.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetGroupUserResult(dict):
    def __init__(__self__, *,
                 description: str,
                 enabled: bool,
                 id: str,
                 name: str,
                 password_expires_at: str,
                 password_status: bool,
                 password_strength: str):
        """
        :param str description: Specifies the description of the identity group.
        :param bool enabled: Indicates the whether the IAM user is enabled.
        :param str id: Specifies the ID of the identity group.
        :param str name: Specifies the name of the identity group.
        :param str password_expires_at: Indicates the time when the password will expire.
               Null indicates that the password has unlimited validity.
        :param bool password_status: Indicates the password status. True means that the password needs to be changed,
               and false means that the password is normal.
        :param str password_strength: Indicates the password strength. The value can be high, mid, or low.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password_expires_at", password_expires_at)
        pulumi.set(__self__, "password_status", password_status)
        pulumi.set(__self__, "password_strength", password_strength)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Specifies the description of the identity group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Indicates the whether the IAM user is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Specifies the ID of the identity group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the identity group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordExpiresAt")
    def password_expires_at(self) -> str:
        """
        Indicates the time when the password will expire.
        Null indicates that the password has unlimited validity.
        """
        return pulumi.get(self, "password_expires_at")

    @property
    @pulumi.getter(name="passwordStatus")
    def password_status(self) -> bool:
        """
        Indicates the password status. True means that the password needs to be changed,
        and false means that the password is normal.
        """
        return pulumi.get(self, "password_status")

    @property
    @pulumi.getter(name="passwordStrength")
    def password_strength(self) -> str:
        """
        Indicates the password strength. The value can be high, mid, or low.
        """
        return pulumi.get(self, "password_strength")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 enabled: bool,
                 id: str,
                 name: str):
        """
        :param bool enabled: Whether project is enabled.
        :param str id: The project ID.
        :param str name: Specifies the project name to query.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Whether project is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The project ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the project name to query.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 description: str,
                 enabled: bool,
                 groups: Sequence[str],
                 id: str,
                 name: str,
                 password_expires_at: str,
                 password_status: bool):
        """
        :param str description: Indicates the description of the IAM user.
        :param bool enabled: Specifies the status of the IAM user, the default value is **true**.
        :param Sequence[str] groups: Indicates the user groups to which an IAM user belongs.
        :param str id: Indicates the ID of the User.
        :param str name: Specifies the IAM user name.
        :param str password_expires_at: Indicates the time when the password will expire.
               Null indicates that the password has unlimited validity.
        :param bool password_status: Indicates the password status. True means that the password needs to be changed,
               and false means that the password is normal.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "groups", groups)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password_expires_at", password_expires_at)
        pulumi.set(__self__, "password_status", password_status)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Indicates the description of the IAM user.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies the status of the IAM user, the default value is **true**.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def groups(self) -> Sequence[str]:
        """
        Indicates the user groups to which an IAM user belongs.
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the ID of the User.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the IAM user name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordExpiresAt")
    def password_expires_at(self) -> str:
        """
        Indicates the time when the password will expire.
        Null indicates that the password has unlimited validity.
        """
        return pulumi.get(self, "password_expires_at")

    @property
    @pulumi.getter(name="passwordStatus")
    def password_status(self) -> bool:
        """
        Indicates the password status. True means that the password needs to be changed,
        and false means that the password is normal.
        """
        return pulumi.get(self, "password_status")


