# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CassandraInstanceBackupStrategy',
    'CassandraInstanceDatastore',
    'CassandraInstanceNode',
    'InfluxInstanceBackupStrategy',
    'InfluxInstanceDatastore',
    'InfluxInstanceNode',
    'MongoInstanceBackupStrategy',
    'MongoInstanceDatastore',
    'MongoInstanceNode',
    'RedisInstanceBackupStrategy',
    'RedisInstanceDatastore',
    'RedisInstanceNode',
    'GetCassandraFlavorsFlavorResult',
    'GetCassandraInstanceBackupStrategyResult',
    'GetCassandraInstanceDatastoreResult',
    'GetCassandraInstanceNodeResult',
    'GetCassandraInstancesInstanceResult',
    'GetCassandraInstancesInstanceBackupStrategyResult',
    'GetCassandraInstancesInstanceDatastoreResult',
    'GetCassandraInstancesInstanceNodeResult',
    'GetNosqlFlavorsFlavorResult',
    'GetRedisInstanceBackupStrategyResult',
    'GetRedisInstanceDatastoreResult',
    'GetRedisInstanceNodeResult',
]

@pulumi.output_type
class CassandraInstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraInstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraInstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraInstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
               HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
               value: 08:00-09:00, 03:00-04:00.
        :param int keep_days: Specifies the number of days to retain the generated backup files. The value ranges from
               0 to 35. If this parameter is set to 0, the automated backup policy is not set. If this parameter is not transferred,
               the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
        HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
        value: 08:00-09:00, 03:00-04:00.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated backup files. The value ranges from
        0 to 35. If this parameter is set to 0, the automated backup policy is not set. If this parameter is not transferred,
        the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class CassandraInstanceDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageEngine":
            suggest = "storage_engine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraInstanceDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraInstanceDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraInstanceDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Specifies the database engine. Only "GeminiDB-Cassandra" is supported now.
        :param str storage_engine: Specifies the storage engine. Only "rocksDB" is supported now.
        :param str version: Specifies the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the database engine. Only "GeminiDB-Cassandra" is supported now.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Specifies the storage engine. Only "rocksDB" is supported now.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class CassandraInstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"
        elif key == "supportReduce":
            suggest = "support_reduce"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CassandraInstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CassandraInstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CassandraInstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 status: Optional[str] = None,
                 support_reduce: Optional[bool] = None):
        """
        :param str id: Indicates the node ID.
        :param str name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_).
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce or not.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_reduce is not None:
            pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The value
        must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
        digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> Optional[bool]:
        """
        Indicates whether the node support reduce or not.
        """
        return pulumi.get(self, "support_reduce")


@pulumi.output_type
class InfluxInstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfluxInstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfluxInstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfluxInstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
               HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
               value: 08:00-09:00, 03:00-04:00.
        :param int keep_days: Specifies the number of days to retain the generated backup files. The value ranges from
               **0** to **35**. If this parameter is set to **0**, the automated backup policy is not set. If this parameter is not
               transferred, the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
        HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
        value: 08:00-09:00, 03:00-04:00.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated backup files. The value ranges from
        **0** to **35**. If this parameter is set to **0**, the automated backup policy is not set. If this parameter is not
        transferred, the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class InfluxInstanceDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageEngine":
            suggest = "storage_engine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfluxInstanceDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfluxInstanceDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfluxInstanceDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Specifies the database engine. Only **influxdb** is supported now.
        :param str storage_engine: Specifies the storage engine. Only **rocksDB** is supported now.
        :param str version: Specifies the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the database engine. Only **influxdb** is supported now.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Specifies the storage engine. Only **rocksDB** is supported now.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class InfluxInstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"
        elif key == "supportReduce":
            suggest = "support_reduce"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfluxInstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfluxInstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfluxInstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 status: Optional[str] = None,
                 support_reduce: Optional[bool] = None):
        """
        :param str id: Indicates the node ID.
        :param str name: Specifies the instance name, which can be the same as an existing instance name. The
               value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce or not.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_reduce is not None:
            pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The
        value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> Optional[bool]:
        """
        Indicates whether the node support reduce or not.
        """
        return pulumi.get(self, "support_reduce")


@pulumi.output_type
class MongoInstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoInstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoInstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoInstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
               HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
               value: 08:00-09:00, 03:00-04:00.
        :param int keep_days: Specifies the number of days to retain the generated backup files. The value ranges from
               **0** to **35**. If this parameter is set to **0**, the automated backup policy is not set. If this parameter is not
               transferred, the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
        HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
        value: 08:00-09:00, 03:00-04:00.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated backup files. The value ranges from
        **0** to **35**. If this parameter is set to **0**, the automated backup policy is not set. If this parameter is not
        transferred, the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class MongoInstanceDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageEngine":
            suggest = "storage_engine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoInstanceDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoInstanceDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoInstanceDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Specifies the database engine. Only **mongodb** is supported now.
        :param str storage_engine: Specifies the storage engine. Only **rocksDB** is supported now.
        :param str version: Specifies the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the database engine. Only **mongodb** is supported now.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Specifies the storage engine. Only **rocksDB** is supported now.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MongoInstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"
        elif key == "supportReduce":
            suggest = "support_reduce"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MongoInstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MongoInstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MongoInstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 status: Optional[str] = None,
                 support_reduce: Optional[bool] = None):
        """
        :param str id: Indicates the node ID.
        :param str name: Specifies the instance name, which can be the same as an existing instance name. The
               value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
               letters, digits, hyphens (-), and underscores (_).
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce or not.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_reduce is not None:
            pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The
        value must be **4** to **64** characters in length and start with a letter. It is case-sensitive and can contain only
        letters, digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> Optional[bool]:
        """
        Indicates whether the node support reduce or not.
        """
        return pulumi.get(self, "support_reduce")


@pulumi.output_type
class RedisInstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisInstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisInstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisInstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
               HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
               value: 08:00-09:00, 03:00-04:00.
        :param int keep_days: Specifies the number of days to retain the generated backup files. The value ranges from
               0 to 35. If this parameter is set to 0, the automated backup policy is not set. If this parameter is not transferred,
               the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
        HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
        value: 08:00-09:00, 03:00-04:00.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated backup files. The value ranges from
        0 to 35. If this parameter is set to 0, the automated backup policy is not set. If this parameter is not transferred,
        the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class RedisInstanceDatastore(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageEngine":
            suggest = "storage_engine"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisInstanceDatastore. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisInstanceDatastore.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisInstanceDatastore.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Specifies the database engine. Only "redis" is supported now.
        :param str storage_engine: Specifies the storage engine. Only "rocksDB" is supported now.
        :param str version: Specifies the database version. Only "5.0" is supported now.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the database engine. Only "redis" is supported now.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Specifies the storage engine. Only "rocksDB" is supported now.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version. Only "5.0" is supported now.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RedisInstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateIp":
            suggest = "private_ip"
        elif key == "supportReduce":
            suggest = "support_reduce"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RedisInstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RedisInstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RedisInstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 status: Optional[str] = None,
                 support_reduce: Optional[bool] = None):
        """
        :param str id: Indicates the node ID.
        :param str name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_). Chinese characters must be in UTF-8 or Unicode format.
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce or not.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if support_reduce is not None:
            pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The value
        must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
        digits, hyphens (-), and underscores (_). Chinese characters must be in UTF-8 or Unicode format.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> Optional[bool]:
        """
        Indicates whether the node support reduce or not.
        """
        return pulumi.get(self, "support_reduce")


@pulumi.output_type
class GetCassandraFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 az_status: Mapping[str, str],
                 memory: str,
                 name: str,
                 vcpus: str,
                 version: str):
        """
        :param Mapping[str, str] az_status: Indicates the flavor status in each availability zone.
        :param str memory: Specifies the memory size of the flavors.
        :param str name: Indicates the spec code of the flavor.
        :param str vcpus: Specifies the count of vcpus of the flavors.
        :param str version: Specifies the engine version of the flavors.
        """
        pulumi.set(__self__, "az_status", az_status)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="azStatus")
    def az_status(self) -> Mapping[str, str]:
        """
        Indicates the flavor status in each availability zone.
        """
        return pulumi.get(self, "az_status")

    @property
    @pulumi.getter
    def memory(self) -> str:
        """
        Specifies the memory size of the flavors.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Indicates the spec code of the flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vcpus(self) -> str:
        """
        Specifies the count of vcpus of the flavors.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the engine version of the flavors.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCassandraInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetCassandraInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str storage_engine: Indicates the database storage engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Indicates the database storage engine.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCassandraInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 private_ip: str,
                 status: str,
                 support_reduce: bool):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> bool:
        """
        Indicates whether the node support reduce.
        """
        return pulumi.get(self, "support_reduce")


@pulumi.output_type
class GetCassandraInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 backup_strategies: Sequence['outputs.GetCassandraInstancesInstanceBackupStrategyResult'],
                 datastores: Sequence['outputs.GetCassandraInstancesInstanceDatastoreResult'],
                 db_user_name: str,
                 enterprise_project_id: str,
                 flavor: str,
                 id: str,
                 mode: str,
                 name: str,
                 node_num: int,
                 nodes: Sequence['outputs.GetCassandraInstancesInstanceNodeResult'],
                 port: int,
                 private_ips: Sequence[str],
                 region: str,
                 security_group_id: str,
                 status: str,
                 subnet_id: str,
                 tags: Mapping[str, str],
                 volume_size: int,
                 vpc_id: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param Sequence['GetCassandraInstancesInstanceBackupStrategyArgs'] backup_strategies: Indicates the advanced backup policy. Structure is documented below.
        :param Sequence['GetCassandraInstancesInstanceDatastoreArgs'] datastores: Indicates the database information. Structure is documented below.
        :param str db_user_name: Indicates the default username.
        :param str enterprise_project_id: Indicates the enterprise project id.
        :param str flavor: Indicates the instance specifications.
        :param str id: Indicates the node ID.
        :param str mode: Indicates the instance mode.
        :param str name: Specifies the name of the instance.
        :param int node_num: Indicates the count of the nodes.
        :param Sequence['GetCassandraInstancesInstanceNodeArgs'] nodes: Indicates the instance nodes information. Structure is documented below.
        :param int port: Indicates the database port.
        :param Sequence[str] private_ips: Indicates the list of private IP address of the nodes.
        :param str region: The region in which to obtain the instance. If omitted, the provider-level region will
               be used.
        :param str security_group_id: Indicates the security group ID.
        :param str status: Indicates the node status.
        :param str subnet_id: Specifies the network ID of a subnet.
        :param Mapping[str, str] tags: Indicates the key/value tags of the instance.
        :param int volume_size: Indicates the size of the volume.
        :param str vpc_id: Specifies the VPC ID.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "db_user_name", db_user_name)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_num", node_num)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_ips", private_ips)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "volume_size", volume_size)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetCassandraInstancesInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetCassandraInstancesInstanceDatastoreResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Indicates the instance mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> int:
        """
        Indicates the count of the nodes.
        """
        return pulumi.get(self, "node_num")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetCassandraInstancesInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Sequence[str]:
        """
        Indicates the list of private IP address of the nodes.
        """
        return pulumi.get(self, "private_ips")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the instance. If omitted, the provider-level region will
        be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Indicates the key/value tags of the instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> int:
        """
        Indicates the size of the volume.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetCassandraInstancesInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetCassandraInstancesInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str storage_engine: Indicates the database storage engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Indicates the database storage engine.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetCassandraInstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 private_ip: str,
                 status: str,
                 support_reduce: bool):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> bool:
        """
        Indicates whether the node support reduce.
        """
        return pulumi.get(self, "support_reduce")


@pulumi.output_type
class GetNosqlFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[str],
                 engine: str,
                 engine_version: str,
                 memory: str,
                 name: str,
                 vcpus: str):
        """
        :param Sequence[str] availability_zones: All available zones (on sale) for current flavor.
        :param str engine: Specifies the type of the database engine. The valid values are as follows:
               + **cassandra**: The default value and means to query GaussDB (for Cassandra) instance specifications.
               + **redis**: Means to query GaussDB (for Redis) instance specifications.
               + **mongodb**: Means to query GaussDB (for Mongo) instance specifications.
               + **influxdb**: Means to query GaussDB (for Influx) instance specifications.
        :param str engine_version: Specifies the version of the database engine.
        :param str memory: Specifies the memory size in gigabytes (GB).
        :param str name: The spec code of the flavor.
        :param str vcpus: Specifies the number of vCPUs.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        """
        All available zones (on sale) for current flavor.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the type of the database engine. The valid values are as follows:
        + **cassandra**: The default value and means to query GaussDB (for Cassandra) instance specifications.
        + **redis**: Means to query GaussDB (for Redis) instance specifications.
        + **mongodb**: Means to query GaussDB (for Mongo) instance specifications.
        + **influxdb**: Means to query GaussDB (for Influx) instance specifications.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> str:
        """
        Specifies the version of the database engine.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def memory(self) -> str:
        """
        Specifies the memory size in gigabytes (GB).
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The spec code of the flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def vcpus(self) -> str:
        """
        Specifies the number of vCPUs.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetRedisInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetRedisInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 storage_engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str storage_engine: Indicates the database storage engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "storage_engine", storage_engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="storageEngine")
    def storage_engine(self) -> str:
        """
        Indicates the database storage engine.
        """
        return pulumi.get(self, "storage_engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRedisInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 private_ip: str,
                 status: str,
                 support_reduce: bool):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str private_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param bool support_reduce: Indicates whether the node support reduce.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "support_reduce", support_reduce)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="supportReduce")
    def support_reduce(self) -> bool:
        """
        Indicates whether the node support reduce.
        """
        return pulumi.get(self, "support_reduce")


