# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'MysqlInstanceBackupStrategy',
    'MysqlInstanceDatastore',
    'MysqlInstanceNode',
    'GetMysqlFlavorsFlavorResult',
    'GetMysqlInstanceBackupStrategyResult',
    'GetMysqlInstanceDatastoreResult',
    'GetMysqlInstanceNodeResult',
    'GetMysqlInstancesInstanceResult',
    'GetMysqlInstancesInstanceBackupStrategyResult',
    'GetMysqlInstancesInstanceDatastoreResult',
    'GetMysqlInstancesInstanceNodeResult',
]

@pulumi.output_type
class MysqlInstanceBackupStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTime":
            suggest = "start_time"
        elif key == "keepDays":
            suggest = "keep_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlInstanceBackupStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlInstanceBackupStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlInstanceBackupStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_time: str,
                 keep_days: Optional[int] = None):
        """
        :param str start_time: Specifies the backup time window. Automated backups will be triggered during the
               backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
               HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
               value: 08:00-09:00, 03:00-04:00.
        :param int keep_days: Specifies the number of days to retain the generated backup files. The value ranges from
               0 to 35. If this parameter is set to 0, the automated backup policy is not set. If this parameter is not transferred,
               the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        pulumi.set(__self__, "start_time", start_time)
        if keep_days is not None:
            pulumi.set(__self__, "keep_days", keep_days)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Specifies the backup time window. Automated backups will be triggered during the
        backup time window. It must be a valid value in the "hh:mm-HH:MM" format. The current time is in the UTC format. The
        HH value must be 1 greater than the hh value. The values of mm and MM must be the same and must be set to 00. Example
        value: 08:00-09:00, 03:00-04:00.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> Optional[int]:
        """
        Specifies the number of days to retain the generated backup files. The value ranges from
        0 to 35. If this parameter is set to 0, the automated backup policy is not set. If this parameter is not transferred,
        the automated backup policy is enabled by default. Backup files are stored for seven days by default.
        """
        return pulumi.get(self, "keep_days")


@pulumi.output_type
class MysqlInstanceDatastore(dict):
    def __init__(__self__, *,
                 engine: str,
                 version: str):
        """
        :param str engine: Specifies the database engine. Only "gauss-mysql" is supported now.
        :param str version: Specifies the database version. Only "8.0" is supported now.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Specifies the database engine. Only "gauss-mysql" is supported now.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version. Only "8.0" is supported now.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MysqlInstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "privateReadIp":
            suggest = "private_read_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MysqlInstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MysqlInstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MysqlInstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 private_read_ip: Optional[str] = None,
                 status: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the instance name, which can be the same as an existing instance name. The value
               must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
               digits, hyphens (-), and underscores (_).
        :param str private_read_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param str type: Indicates the node type: master or slave.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_read_ip is not None:
            pulumi.set(__self__, "private_read_ip", private_read_ip)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[str]:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies the instance name, which can be the same as an existing instance name. The value
        must be 4 to 64 characters in length and start with a letter. It is case-sensitive and can contain only letters,
        digits, hyphens (-), and underscores (_).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateReadIp")
    def private_read_ip(self) -> Optional[str]:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_read_ip")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Indicates the node type: master or slave.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMysqlFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 az_status: Mapping[str, str],
                 memory: str,
                 mode: str,
                 name: str,
                 type: str,
                 vcpus: str,
                 version: str):
        """
        :param Mapping[str, str] az_status: Indicates the flavor status in each availability zone.
        :param str memory: Indicates the memory size in GB.
        :param str mode: Indicates the database mode.
        :param str name: The name of the gaussdb mysql flavor.
        :param str type: Indicates the arch type of the flavor.
        :param str vcpus: Indicates the CPU size.
        :param str version: Specifies the database version. Only "8.0" is supported now.
        """
        pulumi.set(__self__, "az_status", az_status)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="azStatus")
    def az_status(self) -> Mapping[str, str]:
        """
        Indicates the flavor status in each availability zone.
        """
        return pulumi.get(self, "az_status")

    @property
    @pulumi.getter
    def memory(self) -> str:
        """
        Indicates the memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Indicates the database mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the gaussdb mysql flavor.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the arch type of the flavor.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vcpus(self) -> str:
        """
        Indicates the CPU size.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Specifies the database version. Only "8.0" is supported now.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetMysqlInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetMysqlInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetMysqlInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 private_read_ip: str,
                 status: str,
                 type: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str private_read_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param str type: Indicates the node type: master or slave.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_read_ip", private_read_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateReadIp")
    def private_read_ip(self) -> str:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_read_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the node type: master or slave.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetMysqlInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone_mode: str,
                 backup_strategies: Sequence['outputs.GetMysqlInstancesInstanceBackupStrategyResult'],
                 configuration_id: str,
                 datastores: Sequence['outputs.GetMysqlInstancesInstanceDatastoreResult'],
                 db_user_name: str,
                 enterprise_project_id: str,
                 flavor: str,
                 id: str,
                 master_availability_zone: str,
                 mode: str,
                 name: str,
                 nodes: Sequence['outputs.GetMysqlInstancesInstanceNodeResult'],
                 port: int,
                 private_write_ip: str,
                 read_replicas: int,
                 region: str,
                 security_group_id: str,
                 status: str,
                 subnet_id: str,
                 time_zone: str,
                 vpc_id: str):
        """
        :param str availability_zone_mode: Indicates the availability zone mode: "single" or "multi".
        :param Sequence['GetMysqlInstancesInstanceBackupStrategyArgs'] backup_strategies: Indicates the advanced backup policy. Structure is documented below.
        :param str configuration_id: Indicates the configuration ID.
        :param Sequence['GetMysqlInstancesInstanceDatastoreArgs'] datastores: Indicates the database information. Structure is documented below.
        :param str db_user_name: Indicates the default username.
        :param str enterprise_project_id: Indicates the enterprise project id.
        :param str flavor: Indicates the instance specifications.
        :param str id: Indicates the node ID.
        :param str master_availability_zone: Indicates the availability zone where the master node resides.
        :param str mode: Indicates the instance mode.
        :param str name: Specifies the name of the instance.
        :param Sequence['GetMysqlInstancesInstanceNodeArgs'] nodes: Indicates the instance nodes information. Structure is documented below.
        :param int port: Indicates the database port.
        :param str private_write_ip: Indicates the private IP address of the DB instance.
        :param int read_replicas: Indicates the count of read replicas.
        :param str region: The region in which to obtain the instances. If omitted, the provider-level region will
               be used.
        :param str security_group_id: Indicates the security group ID.
        :param str status: Indicates the node status.
        :param str subnet_id: Specifies the network ID of a subnet.
        :param str time_zone: Indicates the time zone.
        :param str vpc_id: Specifies the VPC ID.
        """
        pulumi.set(__self__, "availability_zone_mode", availability_zone_mode)
        pulumi.set(__self__, "backup_strategies", backup_strategies)
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "datastores", datastores)
        pulumi.set(__self__, "db_user_name", db_user_name)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "master_availability_zone", master_availability_zone)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "private_write_ip", private_write_ip)
        pulumi.set(__self__, "read_replicas", read_replicas)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="availabilityZoneMode")
    def availability_zone_mode(self) -> str:
        """
        Indicates the availability zone mode: "single" or "multi".
        """
        return pulumi.get(self, "availability_zone_mode")

    @property
    @pulumi.getter(name="backupStrategies")
    def backup_strategies(self) -> Sequence['outputs.GetMysqlInstancesInstanceBackupStrategyResult']:
        """
        Indicates the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategies")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> str:
        """
        Indicates the configuration ID.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter
    def datastores(self) -> Sequence['outputs.GetMysqlInstancesInstanceDatastoreResult']:
        """
        Indicates the database information. Structure is documented below.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="dbUserName")
    def db_user_name(self) -> str:
        """
        Indicates the default username.
        """
        return pulumi.get(self, "db_user_name")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Indicates the enterprise project id.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> str:
        """
        Indicates the instance specifications.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="masterAvailabilityZone")
    def master_availability_zone(self) -> str:
        """
        Indicates the availability zone where the master node resides.
        """
        return pulumi.get(self, "master_availability_zone")

    @property
    @pulumi.getter
    def mode(self) -> str:
        """
        Indicates the instance mode.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetMysqlInstancesInstanceNodeResult']:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Indicates the database port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateWriteIp")
    def private_write_ip(self) -> str:
        """
        Indicates the private IP address of the DB instance.
        """
        return pulumi.get(self, "private_write_ip")

    @property
    @pulumi.getter(name="readReplicas")
    def read_replicas(self) -> int:
        """
        Indicates the count of read replicas.
        """
        return pulumi.get(self, "read_replicas")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region in which to obtain the instances. If omitted, the provider-level region will
        be used.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> str:
        """
        Indicates the security group ID.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the network ID of a subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Indicates the time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        Specifies the VPC ID.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetMysqlInstancesInstanceBackupStrategyResult(dict):
    def __init__(__self__, *,
                 keep_days: int,
                 start_time: str):
        """
        :param int keep_days: Indicates the number of days to retain the generated
        :param str start_time: Indicates the backup time window.
        """
        pulumi.set(__self__, "keep_days", keep_days)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="keepDays")
    def keep_days(self) -> int:
        """
        Indicates the number of days to retain the generated
        """
        return pulumi.get(self, "keep_days")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Indicates the backup time window.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetMysqlInstancesInstanceDatastoreResult(dict):
    def __init__(__self__, *,
                 engine: str,
                 version: str):
        """
        :param str engine: Indicates the database engine.
        :param str version: Indicates the database version.
        """
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        Indicates the database engine.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetMysqlInstancesInstanceNodeResult(dict):
    def __init__(__self__, *,
                 availability_zone: str,
                 id: str,
                 name: str,
                 private_read_ip: str,
                 status: str,
                 type: str):
        """
        :param str availability_zone: Indicates the availability zone where the node resides.
        :param str id: Indicates the node ID.
        :param str name: Specifies the name of the instance.
        :param str private_read_ip: Indicates the private IP address of a node.
        :param str status: Indicates the node status.
        :param str type: Indicates the node type: master or slave.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private_read_ip", private_read_ip)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        Indicates the availability zone where the node resides.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Indicates the node ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Specifies the name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateReadIp")
    def private_read_ip(self) -> str:
        """
        Indicates the private IP address of a node.
        """
        return pulumi.get(self, "private_read_ip")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Indicates the node type: master or slave.
        """
        return pulumi.get(self, "type")


