# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TriggerArgs', 'Trigger']

@pulumi.input_type
class TriggerArgs:
    def __init__(__self__, *,
                 function_urn: pulumi.Input[str],
                 type: pulumi.Input[str],
                 apig: Optional[pulumi.Input['TriggerApigArgs']] = None,
                 dis: Optional[pulumi.Input['TriggerDisArgs']] = None,
                 kafka: Optional[pulumi.Input['TriggerKafkaArgs']] = None,
                 lts: Optional[pulumi.Input['TriggerLtsArgs']] = None,
                 obs: Optional[pulumi.Input['TriggerObsArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn: Optional[pulumi.Input['TriggerSmnArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timer: Optional[pulumi.Input['TriggerTimerArgs']] = None):
        """
        The set of arguments for constructing a Trigger resource.
        :param pulumi.Input[str] function_urn: Specifies the Uniform Resource Name (URN) of the function.
               Changing this will create a new trigger resource.
        :param pulumi.Input[str] type: Specifies the type of the function.
               The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
               **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        :param pulumi.Input['TriggerApigArgs'] apig: Specifies the configuration of the shared APIG and dedicated APIG trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerDisArgs'] dis: Specifies the configuration of the DIS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerKafkaArgs'] kafka: Specifies the configuration of the DMS trigger for Kafka.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerLtsArgs'] lts: Specifies the configuration of the LTS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerObsArgs'] obs: Specifies the configuration of the OBS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the trigger resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new trigger resource.
        :param pulumi.Input['TriggerSmnArgs'] smn: Specifies the configuration of the SMN trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] status: Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
               About DMS kafka trigger, the default value is **ACTIVE**.
        :param pulumi.Input['TriggerTimerArgs'] timer: Specifies the configuration of the timing trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "type", type)
        if apig is not None:
            pulumi.set(__self__, "apig", apig)
        if dis is not None:
            pulumi.set(__self__, "dis", dis)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if lts is not None:
            pulumi.set(__self__, "lts", lts)
        if obs is not None:
            pulumi.set(__self__, "obs", obs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn is not None:
            pulumi.set(__self__, "smn", smn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[str]:
        """
        Specifies the Uniform Resource Name (URN) of the function.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[str]):
        pulumi.set(self, "function_urn", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Specifies the type of the function.
        The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
        **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def apig(self) -> Optional[pulumi.Input['TriggerApigArgs']]:
        """
        Specifies the configuration of the shared APIG and dedicated APIG trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "apig")

    @apig.setter
    def apig(self, value: Optional[pulumi.Input['TriggerApigArgs']]):
        pulumi.set(self, "apig", value)

    @property
    @pulumi.getter
    def dis(self) -> Optional[pulumi.Input['TriggerDisArgs']]:
        """
        Specifies the configuration of the DIS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "dis")

    @dis.setter
    def dis(self, value: Optional[pulumi.Input['TriggerDisArgs']]):
        pulumi.set(self, "dis", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input['TriggerKafkaArgs']]:
        """
        Specifies the configuration of the DMS trigger for Kafka.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input['TriggerKafkaArgs']]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter
    def lts(self) -> Optional[pulumi.Input['TriggerLtsArgs']]:
        """
        Specifies the configuration of the LTS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "lts")

    @lts.setter
    def lts(self, value: Optional[pulumi.Input['TriggerLtsArgs']]):
        pulumi.set(self, "lts", value)

    @property
    @pulumi.getter
    def obs(self) -> Optional[pulumi.Input['TriggerObsArgs']]:
        """
        Specifies the configuration of the OBS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "obs")

    @obs.setter
    def obs(self, value: Optional[pulumi.Input['TriggerObsArgs']]):
        pulumi.set(self, "obs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the trigger resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def smn(self) -> Optional[pulumi.Input['TriggerSmnArgs']]:
        """
        Specifies the configuration of the SMN trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "smn")

    @smn.setter
    def smn(self, value: Optional[pulumi.Input['TriggerSmnArgs']]):
        pulumi.set(self, "smn", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
        About DMS kafka trigger, the default value is **ACTIVE**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timer(self) -> Optional[pulumi.Input['TriggerTimerArgs']]:
        """
        Specifies the configuration of the timing trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "timer")

    @timer.setter
    def timer(self, value: Optional[pulumi.Input['TriggerTimerArgs']]):
        pulumi.set(self, "timer", value)


@pulumi.input_type
class _TriggerState:
    def __init__(__self__, *,
                 apig: Optional[pulumi.Input['TriggerApigArgs']] = None,
                 dis: Optional[pulumi.Input['TriggerDisArgs']] = None,
                 function_urn: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input['TriggerKafkaArgs']] = None,
                 lts: Optional[pulumi.Input['TriggerLtsArgs']] = None,
                 obs: Optional[pulumi.Input['TriggerObsArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn: Optional[pulumi.Input['TriggerSmnArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timer: Optional[pulumi.Input['TriggerTimerArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Trigger resources.
        :param pulumi.Input['TriggerApigArgs'] apig: Specifies the configuration of the shared APIG and dedicated APIG trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerDisArgs'] dis: Specifies the configuration of the DIS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] function_urn: Specifies the Uniform Resource Name (URN) of the function.
               Changing this will create a new trigger resource.
        :param pulumi.Input['TriggerKafkaArgs'] kafka: Specifies the configuration of the DMS trigger for Kafka.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerLtsArgs'] lts: Specifies the configuration of the LTS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input['TriggerObsArgs'] obs: Specifies the configuration of the OBS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the trigger resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new trigger resource.
        :param pulumi.Input['TriggerSmnArgs'] smn: Specifies the configuration of the SMN trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] status: Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
               About DMS kafka trigger, the default value is **ACTIVE**.
        :param pulumi.Input['TriggerTimerArgs'] timer: Specifies the configuration of the timing trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of the function.
               The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
               **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        """
        if apig is not None:
            pulumi.set(__self__, "apig", apig)
        if dis is not None:
            pulumi.set(__self__, "dis", dis)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if kafka is not None:
            pulumi.set(__self__, "kafka", kafka)
        if lts is not None:
            pulumi.set(__self__, "lts", lts)
        if obs is not None:
            pulumi.set(__self__, "obs", obs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn is not None:
            pulumi.set(__self__, "smn", smn)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if timer is not None:
            pulumi.set(__self__, "timer", timer)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def apig(self) -> Optional[pulumi.Input['TriggerApigArgs']]:
        """
        Specifies the configuration of the shared APIG and dedicated APIG trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "apig")

    @apig.setter
    def apig(self, value: Optional[pulumi.Input['TriggerApigArgs']]):
        pulumi.set(self, "apig", value)

    @property
    @pulumi.getter
    def dis(self) -> Optional[pulumi.Input['TriggerDisArgs']]:
        """
        Specifies the configuration of the DIS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "dis")

    @dis.setter
    def dis(self, value: Optional[pulumi.Input['TriggerDisArgs']]):
        pulumi.set(self, "dis", value)

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Uniform Resource Name (URN) of the function.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function_urn", value)

    @property
    @pulumi.getter
    def kafka(self) -> Optional[pulumi.Input['TriggerKafkaArgs']]:
        """
        Specifies the configuration of the DMS trigger for Kafka.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "kafka")

    @kafka.setter
    def kafka(self, value: Optional[pulumi.Input['TriggerKafkaArgs']]):
        pulumi.set(self, "kafka", value)

    @property
    @pulumi.getter
    def lts(self) -> Optional[pulumi.Input['TriggerLtsArgs']]:
        """
        Specifies the configuration of the LTS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "lts")

    @lts.setter
    def lts(self, value: Optional[pulumi.Input['TriggerLtsArgs']]):
        pulumi.set(self, "lts", value)

    @property
    @pulumi.getter
    def obs(self) -> Optional[pulumi.Input['TriggerObsArgs']]:
        """
        Specifies the configuration of the OBS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "obs")

    @obs.setter
    def obs(self, value: Optional[pulumi.Input['TriggerObsArgs']]):
        pulumi.set(self, "obs", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the trigger resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def smn(self) -> Optional[pulumi.Input['TriggerSmnArgs']]:
        """
        Specifies the configuration of the SMN trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "smn")

    @smn.setter
    def smn(self, value: Optional[pulumi.Input['TriggerSmnArgs']]):
        pulumi.set(self, "smn", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
        About DMS kafka trigger, the default value is **ACTIVE**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def timer(self) -> Optional[pulumi.Input['TriggerTimerArgs']]:
        """
        Specifies the configuration of the timing trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "timer")

    @timer.setter
    def timer(self, value: Optional[pulumi.Input['TriggerTimerArgs']]):
        pulumi.set(self, "timer", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of the function.
        The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
        **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class Trigger(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apig: Optional[pulumi.Input[pulumi.InputType['TriggerApigArgs']]] = None,
                 dis: Optional[pulumi.Input[pulumi.InputType['TriggerDisArgs']]] = None,
                 function_urn: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input[pulumi.InputType['TriggerKafkaArgs']]] = None,
                 lts: Optional[pulumi.Input[pulumi.InputType['TriggerLtsArgs']]] = None,
                 obs: Optional[pulumi.Input[pulumi.InputType['TriggerObsArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn: Optional[pulumi.Input[pulumi.InputType['TriggerSmnArgs']]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timer: Optional[pulumi.Input[pulumi.InputType['TriggerTimerArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a trigger resource within HuaweiCloud FunctionGraph.

        ## Example Usage
        ### Create a Timing Trigger with rate schedule type

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        trigger_name = config.require_object("triggerName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="TIMER",
            timer=huaweicloud.function_graph.TriggerTimerArgs(
                name=trigger_name,
                schedule_type="Rate",
                schedule="1d",
            ))
        ```
        ### Create a Timing Trigger with cron schedule type

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        trigger_name = config.require_object("triggerName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="TIMER",
            timer=huaweicloud.function_graph.TriggerTimerArgs(
                name=trigger_name,
                schedule_type="Cron",
                schedule="@every 1h30m",
            ))
        ```
        ### Create an OBS trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        bucket_name = config.require_object("bucketName")
        trigger_name = config.require_object("triggerName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="OBS",
            status="ACTIVE",
            obs=huaweicloud.function_graph.TriggerObsArgs(
                bucket_name=bucket_name,
                event_notification_name=trigger_name,
                suffix=".json",
                events=["ObjectCreated"],
            ))
        ```
        ### Create an SMN trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        topic_urn = config.require_object("topicUrn")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="SMN",
            status="ACTIVE",
            smn=huaweicloud.function_graph.TriggerSmnArgs(
                topic_urn=topic_urn,
            ))
        ```
        ### Create a DIS trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        stream_name = config.require_object("streamName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="DIS",
            status="ACTIVE",
            dis=huaweicloud.function_graph.TriggerDisArgs(
                stream_name=stream_name,
                starting_position="TRIM_HORIZON",
                max_fetch_bytes=2097152,
                pull_period=30000,
                serial_enable=True,
            ))
        ```
        ### Create a DMS Kafka trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        kafka_instance_id = config.require_object("kafkaInstanceId")
        kafka_topic_id = config.require_object("kafkaTopicId")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="KAFKA",
            kafka=huaweicloud.function_graph.TriggerKafkaArgs(
                instance_id=kafka_instance_id,
                batch_size=100,
                topic_ids=[kafka_topic_id],
            ))
        ```
        ### Create a Dedicated APIG trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        instance_id = config.require_object("instanceId")
        group_id = config.require_object("groupId")
        api_name = config.require_object("apiName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="DEDICATEDGATEWAY",
            status="ACTIVE",
            apig=huaweicloud.function_graph.TriggerApigArgs(
                instance_id=instance_id,
                group_id=group_id,
                api_name=api_name,
                env_name="RELEASE",
            ))
        ```
        ### Create a Shared APIG trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        group_id = config.require_object("groupId")
        api_name = config.require_object("apiName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="APIG",
            status="ACTIVE",
            apig=huaweicloud.function_graph.TriggerApigArgs(
                group_id=group_id,
                api_name=api_name,
                env_name="RELEASE",
            ))
        ```
        ### Create a LTS trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        log_group_id = config.require_object("logGroupId")
        log_topic_id = config.require_object("logTopicId")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=var["function_urn"],
            type="LTS",
            status="ACTIVE",
            lts=huaweicloud.function_graph.TriggerLtsArgs(
                log_group_id=log_group_id,
                log_topic_id=log_topic_id,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TriggerApigArgs']] apig: Specifies the configuration of the shared APIG and dedicated APIG trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[pulumi.InputType['TriggerDisArgs']] dis: Specifies the configuration of the DIS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] function_urn: Specifies the Uniform Resource Name (URN) of the function.
               Changing this will create a new trigger resource.
        :param pulumi.Input[pulumi.InputType['TriggerKafkaArgs']] kafka: Specifies the configuration of the DMS trigger for Kafka.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[pulumi.InputType['TriggerLtsArgs']] lts: Specifies the configuration of the LTS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[pulumi.InputType['TriggerObsArgs']] obs: Specifies the configuration of the OBS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the trigger resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new trigger resource.
        :param pulumi.Input[pulumi.InputType['TriggerSmnArgs']] smn: Specifies the configuration of the SMN trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] status: Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
               About DMS kafka trigger, the default value is **ACTIVE**.
        :param pulumi.Input[pulumi.InputType['TriggerTimerArgs']] timer: Specifies the configuration of the timing trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of the function.
               The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
               **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TriggerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a trigger resource within HuaweiCloud FunctionGraph.

        ## Example Usage
        ### Create a Timing Trigger with rate schedule type

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        trigger_name = config.require_object("triggerName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="TIMER",
            timer=huaweicloud.function_graph.TriggerTimerArgs(
                name=trigger_name,
                schedule_type="Rate",
                schedule="1d",
            ))
        ```
        ### Create a Timing Trigger with cron schedule type

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        trigger_name = config.require_object("triggerName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="TIMER",
            timer=huaweicloud.function_graph.TriggerTimerArgs(
                name=trigger_name,
                schedule_type="Cron",
                schedule="@every 1h30m",
            ))
        ```
        ### Create an OBS trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        bucket_name = config.require_object("bucketName")
        trigger_name = config.require_object("triggerName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="OBS",
            status="ACTIVE",
            obs=huaweicloud.function_graph.TriggerObsArgs(
                bucket_name=bucket_name,
                event_notification_name=trigger_name,
                suffix=".json",
                events=["ObjectCreated"],
            ))
        ```
        ### Create an SMN trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        topic_urn = config.require_object("topicUrn")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="SMN",
            status="ACTIVE",
            smn=huaweicloud.function_graph.TriggerSmnArgs(
                topic_urn=topic_urn,
            ))
        ```
        ### Create a DIS trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        stream_name = config.require_object("streamName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="DIS",
            status="ACTIVE",
            dis=huaweicloud.function_graph.TriggerDisArgs(
                stream_name=stream_name,
                starting_position="TRIM_HORIZON",
                max_fetch_bytes=2097152,
                pull_period=30000,
                serial_enable=True,
            ))
        ```
        ### Create a DMS Kafka trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        kafka_instance_id = config.require_object("kafkaInstanceId")
        kafka_topic_id = config.require_object("kafkaTopicId")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="KAFKA",
            kafka=huaweicloud.function_graph.TriggerKafkaArgs(
                instance_id=kafka_instance_id,
                batch_size=100,
                topic_ids=[kafka_topic_id],
            ))
        ```
        ### Create a Dedicated APIG trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        instance_id = config.require_object("instanceId")
        group_id = config.require_object("groupId")
        api_name = config.require_object("apiName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="DEDICATEDGATEWAY",
            status="ACTIVE",
            apig=huaweicloud.function_graph.TriggerApigArgs(
                instance_id=instance_id,
                group_id=group_id,
                api_name=api_name,
                env_name="RELEASE",
            ))
        ```
        ### Create a Shared APIG trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        function_urn = config.require_object("functionUrn")
        group_id = config.require_object("groupId")
        api_name = config.require_object("apiName")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=function_urn,
            type="APIG",
            status="ACTIVE",
            apig=huaweicloud.function_graph.TriggerApigArgs(
                group_id=group_id,
                api_name=api_name,
                env_name="RELEASE",
            ))
        ```
        ### Create a LTS trigger

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        log_group_id = config.require_object("logGroupId")
        log_topic_id = config.require_object("logTopicId")
        test = huaweicloud.function_graph.Trigger("test",
            function_urn=var["function_urn"],
            type="LTS",
            status="ACTIVE",
            lts=huaweicloud.function_graph.TriggerLtsArgs(
                log_group_id=log_group_id,
                log_topic_id=log_topic_id,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param TriggerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TriggerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apig: Optional[pulumi.Input[pulumi.InputType['TriggerApigArgs']]] = None,
                 dis: Optional[pulumi.Input[pulumi.InputType['TriggerDisArgs']]] = None,
                 function_urn: Optional[pulumi.Input[str]] = None,
                 kafka: Optional[pulumi.Input[pulumi.InputType['TriggerKafkaArgs']]] = None,
                 lts: Optional[pulumi.Input[pulumi.InputType['TriggerLtsArgs']]] = None,
                 obs: Optional[pulumi.Input[pulumi.InputType['TriggerObsArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn: Optional[pulumi.Input[pulumi.InputType['TriggerSmnArgs']]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 timer: Optional[pulumi.Input[pulumi.InputType['TriggerTimerArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TriggerArgs.__new__(TriggerArgs)

            __props__.__dict__["apig"] = apig
            __props__.__dict__["dis"] = dis
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            __props__.__dict__["kafka"] = kafka
            __props__.__dict__["lts"] = lts
            __props__.__dict__["obs"] = obs
            __props__.__dict__["region"] = region
            __props__.__dict__["smn"] = smn
            __props__.__dict__["status"] = status
            __props__.__dict__["timer"] = timer
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
        super(Trigger, __self__).__init__(
            'huaweicloud:FunctionGraph/trigger:Trigger',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apig: Optional[pulumi.Input[pulumi.InputType['TriggerApigArgs']]] = None,
            dis: Optional[pulumi.Input[pulumi.InputType['TriggerDisArgs']]] = None,
            function_urn: Optional[pulumi.Input[str]] = None,
            kafka: Optional[pulumi.Input[pulumi.InputType['TriggerKafkaArgs']]] = None,
            lts: Optional[pulumi.Input[pulumi.InputType['TriggerLtsArgs']]] = None,
            obs: Optional[pulumi.Input[pulumi.InputType['TriggerObsArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            smn: Optional[pulumi.Input[pulumi.InputType['TriggerSmnArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            timer: Optional[pulumi.Input[pulumi.InputType['TriggerTimerArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'Trigger':
        """
        Get an existing Trigger resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TriggerApigArgs']] apig: Specifies the configuration of the shared APIG and dedicated APIG trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[pulumi.InputType['TriggerDisArgs']] dis: Specifies the configuration of the DIS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] function_urn: Specifies the Uniform Resource Name (URN) of the function.
               Changing this will create a new trigger resource.
        :param pulumi.Input[pulumi.InputType['TriggerKafkaArgs']] kafka: Specifies the configuration of the DMS trigger for Kafka.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[pulumi.InputType['TriggerLtsArgs']] lts: Specifies the configuration of the LTS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[pulumi.InputType['TriggerObsArgs']] obs: Specifies the configuration of the OBS trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the trigger resource.
               If omitted, the provider-level region will be used.
               Changing this will create a new trigger resource.
        :param pulumi.Input[pulumi.InputType['TriggerSmnArgs']] smn: Specifies the configuration of the SMN trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] status: Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
               About DMS kafka trigger, the default value is **ACTIVE**.
        :param pulumi.Input[pulumi.InputType['TriggerTimerArgs']] timer: Specifies the configuration of the timing trigger.
               Changing this will create a new trigger resource.
               The object structure is documented below.
        :param pulumi.Input[str] type: Specifies the type of the function.
               The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
               **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TriggerState.__new__(_TriggerState)

        __props__.__dict__["apig"] = apig
        __props__.__dict__["dis"] = dis
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["kafka"] = kafka
        __props__.__dict__["lts"] = lts
        __props__.__dict__["obs"] = obs
        __props__.__dict__["region"] = region
        __props__.__dict__["smn"] = smn
        __props__.__dict__["status"] = status
        __props__.__dict__["timer"] = timer
        __props__.__dict__["type"] = type
        return Trigger(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def apig(self) -> pulumi.Output[Optional['outputs.TriggerApig']]:
        """
        Specifies the configuration of the shared APIG and dedicated APIG trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "apig")

    @property
    @pulumi.getter
    def dis(self) -> pulumi.Output[Optional['outputs.TriggerDis']]:
        """
        Specifies the configuration of the DIS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "dis")

    @property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[str]:
        """
        Specifies the Uniform Resource Name (URN) of the function.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "function_urn")

    @property
    @pulumi.getter
    def kafka(self) -> pulumi.Output[Optional['outputs.TriggerKafka']]:
        """
        Specifies the configuration of the DMS trigger for Kafka.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "kafka")

    @property
    @pulumi.getter
    def lts(self) -> pulumi.Output[Optional['outputs.TriggerLts']]:
        """
        Specifies the configuration of the LTS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "lts")

    @property
    @pulumi.getter
    def obs(self) -> pulumi.Output[Optional['outputs.TriggerObs']]:
        """
        Specifies the configuration of the OBS trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "obs")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the trigger resource.
        If omitted, the provider-level region will be used.
        Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def smn(self) -> pulumi.Output[Optional['outputs.TriggerSmn']]:
        """
        Specifies the configuration of the SMN trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "smn")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Specifies whether trigger is enabled. The valid values are **ACTIVE** and **DISABLED**.
        About DMS kafka trigger, the default value is **ACTIVE**.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timer(self) -> pulumi.Output[Optional['outputs.TriggerTimer']]:
        """
        Specifies the configuration of the timing trigger.
        Changing this will create a new trigger resource.
        The object structure is documented below.
        """
        return pulumi.get(self, "timer")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Specifies the type of the function.
        The valid values currently only support **TIMER**, **OBS**, **SMN**, **DIS**, **KAFKA**, **APIG**, **LTS**, and
        **DEDICATEDGATEWAY**. Changing this will create a new trigger resource.
        """
        return pulumi.get(self, "type")

