# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, created_at=None, description=None, id=None, name=None, status=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if status and not isinstance(status, int):
            raise TypeError("Expected argument 'status' to be a int")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Specifies the time (UTC) when the enterprise project was created. Example: 2018-05-18T06:49:06Z
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Provides supplementary information about the enterprise project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> int:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Specifies the time (UTC) when the enterprise project was modified. Example: 2018-05-28T02:21:36Z
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            created_at=self.created_at,
            description=self.description,
            id=self.id,
            name=self.name,
            status=self.status,
            updated_at=self.updated_at)


def get_project(id: Optional[str] = None,
                name: Optional[str] = None,
                status: Optional[int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Use this data source to get an enterprise project from HuaweiCloud

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Eps.get_project(name="test")
    ```
    ## Resources Supported Currently

    <!-- markdownlint-disable MD033 -->
    Service Name | Resource Name | Sub Resource Name
    ---- | --- | ---
    AS  | As.Group |
    BCS | Bcs.Instance |
    BMS | Bms.Instance |
    CBR | Cbr.Vault |
    CCE | Cce.Cluster | huaweicloud_cce_node<br>huaweicloud_cce_node_pool<br>huaweicloud_cce_addon
    CDM | Cdm.Cluster |
    CDN | Cdn.Domain |
    CES | Cse.Alarmrule |
    DCS | Dcs.Instance |
    DDS | Dds.Instance |
    DMS | huaweicloud_dms_kafka_instance<br>huaweicloud_dms_rabbitmq_instance |
    DNS | huaweicloud_dns_ptrrecord<br>huaweicloud_dns_zone |
    ECS | Ecs.Instance |
    EIP | huaweicloud_vpc_eip<br>huaweicloud_vpc_bandwidth |
    ELB | Elb.Loadbalancer |
    Dedicated ELB | huaweicloud_elb_certificate<br>huaweicloud_elb_ipgroup<br>huaweicloud_elb_loadbalancer |
    EVS | Evs.Volume |
    FGS | FunctionGraph.Function |
    GaussDB | huaweicloud_gaussdb_cassandra_instance<br>huaweicloud_gaussdb_mysql_instance<br>huaweicloud_gaussdb_opengauss_instance |
    IMS | Ims.Image |
    KMS | Dew.Key |
    NAT | Nat.Gateway | huaweicloud_nat_snat_rule<br>huaweicloud_nat_dnat_rule
    OBS | Obs.Bucket | huaweicloud_obs_bucket_object<br>huaweicloud_obs_bucket_policy
    RDS | huaweicloud_rds_instance<br>huaweicloud_rds_read_replica_instance |
    SFS | huaweicloud_sfs_file_system<br>huaweicloud_sfs_turbo | Sfs.AccessRule
    SMN | Smn.Topic |
    VPC | huaweicloud_vpc<br>huaweicloud_networking_secgroup | huaweicloud_vpc_subnet<br>huaweicloud_vpc_route<br>huaweicloud_networking_secgroup_rule
    <!-- markdownlint-enable MD033 -->


    :param str id: Specifies the ID of an enterprise project. The value 0 indicates enterprise project default.
    :param str name: Specifies the enterprise project name. Fuzzy search is supported.
    :param int status: Specifies the status of an enterprise project.
           + 1 indicates Enabled.
           + 2 indicates Disabled.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['name'] = name
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Eps/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        created_at=__ret__.created_at,
        description=__ret__.description,
        id=__ret__.id,
        name=__ret__.name,
        status=__ret__.status,
        updated_at=__ret__.updated_at)


@_utilities.lift_output_func(get_project)
def get_project_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       status: Optional[pulumi.Input[Optional[int]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    Use this data source to get an enterprise project from HuaweiCloud

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    test = huaweicloud.Eps.get_project(name="test")
    ```
    ## Resources Supported Currently

    <!-- markdownlint-disable MD033 -->
    Service Name | Resource Name | Sub Resource Name
    ---- | --- | ---
    AS  | As.Group |
    BCS | Bcs.Instance |
    BMS | Bms.Instance |
    CBR | Cbr.Vault |
    CCE | Cce.Cluster | huaweicloud_cce_node<br>huaweicloud_cce_node_pool<br>huaweicloud_cce_addon
    CDM | Cdm.Cluster |
    CDN | Cdn.Domain |
    CES | Cse.Alarmrule |
    DCS | Dcs.Instance |
    DDS | Dds.Instance |
    DMS | huaweicloud_dms_kafka_instance<br>huaweicloud_dms_rabbitmq_instance |
    DNS | huaweicloud_dns_ptrrecord<br>huaweicloud_dns_zone |
    ECS | Ecs.Instance |
    EIP | huaweicloud_vpc_eip<br>huaweicloud_vpc_bandwidth |
    ELB | Elb.Loadbalancer |
    Dedicated ELB | huaweicloud_elb_certificate<br>huaweicloud_elb_ipgroup<br>huaweicloud_elb_loadbalancer |
    EVS | Evs.Volume |
    FGS | FunctionGraph.Function |
    GaussDB | huaweicloud_gaussdb_cassandra_instance<br>huaweicloud_gaussdb_mysql_instance<br>huaweicloud_gaussdb_opengauss_instance |
    IMS | Ims.Image |
    KMS | Dew.Key |
    NAT | Nat.Gateway | huaweicloud_nat_snat_rule<br>huaweicloud_nat_dnat_rule
    OBS | Obs.Bucket | huaweicloud_obs_bucket_object<br>huaweicloud_obs_bucket_policy
    RDS | huaweicloud_rds_instance<br>huaweicloud_rds_read_replica_instance |
    SFS | huaweicloud_sfs_file_system<br>huaweicloud_sfs_turbo | Sfs.AccessRule
    SMN | Smn.Topic |
    VPC | huaweicloud_vpc<br>huaweicloud_networking_secgroup | huaweicloud_vpc_subnet<br>huaweicloud_vpc_route<br>huaweicloud_networking_secgroup_rule
    <!-- markdownlint-enable MD033 -->


    :param str id: Specifies the ID of an enterprise project. The value 0 indicates enterprise project default.
    :param str name: Specifies the enterprise project name. Fuzzy search is supported.
    :param int status: Specifies the status of an enterprise project.
           + 1 indicates Enabled.
           + 2 indicates Disabled.
    """
    ...
