# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LoadbalancerArgs', 'Loadbalancer']

@pulumi.input_type
class LoadbalancerArgs:
    def __init__(__self__, *,
                 vip_subnet_id: pulumi.Input[str],
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Loadbalancer resource.
        :param pulumi.Input[str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        """
        pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> pulumi.Input[str]:
        """
        The network on which to allocate the loadbalancer's address. A tenant
        can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
        shared). Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vip_subnet_id", value)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the loadbalancer. A valid value is true (UP) or
        false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the loadbalancer. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the load balancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_address", value)


@pulumi.input_type
class _LoadbalancerState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_port_id: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Loadbalancer resources.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] vip_port_id: The Port ID of the Load Balancer IP.
        :param pulumi.Input[str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
            pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)
        if vip_port_id is not None:
            pulumi.set(__self__, "vip_port_id", vip_port_id)
        if vip_subnet_id is not None:
            pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the loadbalancer. A valid value is true (UP) or
        false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the loadbalancer. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the load balancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_address", value)

    @property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Port ID of the Load Balancer IP.
        """
        return pulumi.get(self, "vip_port_id")

    @vip_port_id.setter
    def vip_port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_port_id", value)

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network on which to allocate the loadbalancer's address. A tenant
        can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
        shared). Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_subnet_id", value)


class Loadbalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an ELB loadbalancer resource within HuaweiCloud.

        ## Example Usage
        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        lb1 = huaweicloud.elb.Loadbalancer("lb1",
            tags={
                "key": "value",
            },
            vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```
        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        lb1 = huaweicloud.elb.Loadbalancer("lb1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        eip1 = huaweicloud.vpc.EipAssociate("eip1",
            public_ip="1.2.3.4",
            port_id=lb1.vip_port_id)
        ```

        ## Import

        Load balancers can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Elb/loadbalancer:Loadbalancer test 3e3632db-36c6-4b28-a92e-e72e6562daa6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadbalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an ELB loadbalancer resource within HuaweiCloud.

        ## Example Usage
        ### Basic Loadbalancer

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        lb1 = huaweicloud.elb.Loadbalancer("lb1",
            tags={
                "key": "value",
            },
            vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```
        ### Loadbalancer With EIP

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        lb1 = huaweicloud.elb.Loadbalancer("lb1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        eip1 = huaweicloud.vpc.EipAssociate("eip1",
            public_ip="1.2.3.4",
            port_id=lb1.vip_port_id)
        ```

        ## Import

        Load balancers can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Elb/loadbalancer:Loadbalancer test 3e3632db-36c6-4b28-a92e-e72e6562daa6
        ```

        :param str resource_name: The name of the resource.
        :param LoadbalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadbalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadbalancerArgs.__new__(LoadbalancerArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["tags"] = tags
            if tenant_id is not None and not opts.urn:
                warnings.warn("""tenant_id is deprecated""", DeprecationWarning)
                pulumi.log.warn("""tenant_id is deprecated: tenant_id is deprecated""")
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["vip_address"] = vip_address
            if vip_subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'vip_subnet_id'")
            __props__.__dict__["vip_subnet_id"] = vip_subnet_id
            __props__.__dict__["vip_port_id"] = None
        super(Loadbalancer, __self__).__init__(
            'huaweicloud:Elb/loadbalancer:Loadbalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            loadbalancer_provider: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            vip_address: Optional[pulumi.Input[str]] = None,
            vip_port_id: Optional[pulumi.Input[str]] = None,
            vip_subnet_id: Optional[pulumi.Input[str]] = None) -> 'Loadbalancer':
        """
        Get an existing Loadbalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the loadbalancer. A valid value is true (UP) or
               false (DOWN).
        :param pulumi.Input[str] description: Human-readable description for the loadbalancer.
        :param pulumi.Input[str] enterprise_project_id: The enterprise project id of the loadbalancer. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the loadbalancer. Does not have to be unique.
        :param pulumi.Input[str] region: The region in which to create the loadbalancer resource. If omitted, the
               provider-level region will be used. Changing this creates a new loadbalancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] vip_port_id: The Port ID of the Load Balancer IP.
        :param pulumi.Input[str] vip_subnet_id: The network on which to allocate the loadbalancer's address. A tenant
               can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
               shared). Changing this creates a new loadbalancer.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadbalancerState.__new__(_LoadbalancerState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vip_address"] = vip_address
        __props__.__dict__["vip_port_id"] = vip_port_id
        __props__.__dict__["vip_subnet_id"] = vip_subnet_id
        return Loadbalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[bool]]:
        """
        The administrative state of the loadbalancer. A valid value is true (UP) or
        false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the loadbalancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        The enterprise project id of the loadbalancer. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> pulumi.Output[str]:
        return pulumi.get(self, "loadbalancer_provider")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the loadbalancer. Does not have to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the loadbalancer resource. If omitted, the
        provider-level region will be used. Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the loadbalancer.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> pulumi.Output[str]:
        """
        The ip address of the load balancer. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> pulumi.Output[str]:
        """
        The Port ID of the Load Balancer IP.
        """
        return pulumi.get(self, "vip_port_id")

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> pulumi.Output[str]:
        """
        The network on which to allocate the loadbalancer's address. A tenant
        can only create Loadbalancers on networks authorized by policy (e.g. networks that belong to them or networks that are
        shared). Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_subnet_id")

